/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.velocity;

import co.aikar.commands.CommandManager;
import co.aikar.commands.VelocityCommandManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.simplix.cirrus.player.CirrusPlayerWrapper;
import gg.modl.minecraft.api.AbstractPlayer;
import gg.modl.minecraft.core.Platform;
import gg.modl.minecraft.core.util.WebPlayer;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class VelocityPlatform
implements Platform {
    private final ProxyServer server;
    private final VelocityCommandManager commandManager;

    private static Component get(String string) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(string);
    }

    @Override
    public void broadcast(String string) {
        this.server.getAllPlayers().forEach(player -> player.sendMessage(VelocityPlatform.get(string)));
    }

    @Override
    public void staffBroadcast(String string) {
        this.server.getAllPlayers().forEach(player -> {
            if (player.hasPermission("modl.staff")) {
                player.sendMessage(VelocityPlatform.get(string));
            }
        });
    }

    @Override
    public void disconnect(UUID uuid, String message) {
        this.server.getPlayer(uuid).ifPresent(player -> player.disconnect(VelocityPlatform.get(message)));
    }

    @Override
    public void sendMessage(UUID uuid, String message) {
        String formattedMessage = message.replace("\\n", "\n").replace("\\\\n", "\n");
        ((Player)this.server.getPlayer(uuid).orElseThrow()).sendMessage(VelocityPlatform.get(formattedMessage));
    }

    @Override
    public void sendJsonMessage(UUID uuid, String jsonMessage) {
        this.server.getPlayer(uuid).ifPresent(player -> {
            try {
                System.out.println("Velocity JSON: " + jsonMessage);
                Component component = GsonComponentSerializer.gson().deserialize((Object)jsonMessage);
                player.sendMessage(component);
            }
            catch (Exception e) {
                System.err.println("Failed to parse JSON message on Velocity: " + e.getMessage());
                e.printStackTrace();
                player.sendMessage((Component)Component.text((String)("Notification: " + jsonMessage)));
            }
        });
    }

    @Override
    public boolean isOnline(UUID uuid) {
        return this.server.getPlayer(uuid).isPresent();
    }

    @Override
    public CommandManager<?, ?, ?, ?, ?, ?> getCommandManager() {
        return this.commandManager;
    }

    private Player getOnlinePlayer(String username) {
        return this.server.getPlayer(username).isPresent() ? (Player)this.server.getPlayer(username).get() : null;
    }

    private Player getOnlinePlayer(UUID uuid) {
        return this.server.getPlayer(uuid).isPresent() ? (Player)this.server.getPlayer(uuid).get() : null;
    }

    @Override
    public AbstractPlayer getAbstractPlayer(UUID uuid, boolean queryMojang) {
        WebPlayer webPlayer;
        Player player = this.getOnlinePlayer(uuid);
        if (player != null) {
            return new AbstractPlayer(player.getUniqueId(), player.getUsername(), true, player.getRemoteAddress().getAddress().getHostAddress());
        }
        if (!queryMojang) {
            return null;
        }
        try {
            webPlayer = WebPlayer.getSync(uuid);
        }
        catch (Exception ignored) {
            return null;
        }
        if (webPlayer == null) {
            return null;
        }
        return new AbstractPlayer(webPlayer.uuid(), webPlayer.name(), false, null);
    }

    @Override
    public AbstractPlayer getAbstractPlayer(String username, boolean queryMojang) {
        WebPlayer webPlayer;
        Player player = this.getOnlinePlayer(username);
        if (player != null) {
            return new AbstractPlayer(player.getUniqueId(), player.getUsername(), true, player.getRemoteAddress().getAddress().getHostAddress());
        }
        if (!queryMojang) {
            return null;
        }
        try {
            webPlayer = WebPlayer.getSync(username);
        }
        catch (Exception ignored) {
            return null;
        }
        if (webPlayer == null) {
            return null;
        }
        return new AbstractPlayer(webPlayer.uuid(), webPlayer.name(), false, null);
    }

    @Override
    public CirrusPlayerWrapper getPlayerWrapper(UUID uuid) {
        return null;
    }

    @Override
    public Collection<AbstractPlayer> getOnlinePlayers() {
        return this.server.getAllPlayers().stream().map(player -> new AbstractPlayer(player.getUniqueId(), player.getUsername(), true, player.getRemoteAddress().getAddress().getHostAddress())).collect(Collectors.toList());
    }

    @Override
    public AbstractPlayer getPlayer(UUID uuid) {
        Player player = this.server.getPlayer(uuid).orElse(null);
        if (player == null) {
            return null;
        }
        return new AbstractPlayer(player.getUniqueId(), player.getUsername(), true, player.getRemoteAddress().getAddress().getHostAddress());
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getConfiguration().getShowMaxPlayers();
    }

    @Override
    public String getServerVersion() {
        return this.server.getVersion().getVersion();
    }

    @Override
    public void runOnMainThread(Runnable task) {
        task.run();
    }

    @Override
    public void kickPlayer(AbstractPlayer player, String reason) {
        Player velocityPlayer = this.server.getPlayer(player.getUuid()).orElse(null);
        if (velocityPlayer != null) {
            String formattedReason = reason.replace("\\n", "\n").replace("\\\\n", "\n");
            velocityPlayer.disconnect(VelocityPlatform.get(formattedReason));
        }
    }

    @Override
    public String getServerName() {
        return "velocity-proxy";
    }

    @Generated
    public VelocityPlatform(ProxyServer server, VelocityCommandManager commandManager) {
        this.server = server;
        this.commandManager = commandManager;
    }
}

