/*
 * Decompiled with CFR 0.152.
 */
package gg.modl.minecraft.velocity;

import co.aikar.commands.VelocityCommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import gg.modl.minecraft.core.HttpManager;
import gg.modl.minecraft.core.PluginLoader;
import gg.modl.minecraft.core.service.ChatMessageCache;
import gg.modl.minecraft.velocity.ChatListener;
import gg.modl.minecraft.velocity.JoinListener;
import gg.modl.minecraft.velocity.VelocityCommandRegister;
import gg.modl.minecraft.velocity.VelocityPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Plugin(id="modl", name="modl", version="1.0.3", authors={"tigerbong, byteful"}, description="First-class moderation and support systems", url="https://github.com/modl-gg/minecraft")
public final class VelocityPlugin {
    private final PluginContainer plugin;
    private final ProxyServer server;
    private final Path folder;
    private final Logger logger;
    private Map<String, Object> configuration;
    private PluginLoader pluginLoader;

    @Inject
    public VelocityPlugin(PluginContainer plugin, ProxyServer server, @DataDirectory Path folder, Logger logger) {
        this.plugin = plugin;
        this.server = server;
        this.folder = folder;
        this.logger = logger;
    }

    @Subscribe
    public synchronized void onProxyInitialize(ProxyInitializeEvent evt) {
        this.loadConfig();
        this.createLocaleFiles();
        this.loadConfig();
        String apiUrl = this.getConfigString("api.url", "https://yourserver.modl.gg");
        if ("https://yourserver.modl.gg".equals(apiUrl)) {
            this.logger.error("===============================================");
            this.logger.error("MODL CONFIGURATION ERROR");
            this.logger.error("===============================================");
            this.logger.error("You must configure your API URL in config.yml!");
            this.logger.error("Please set 'api.url' to your actual MODL panel URL.");
            this.logger.error("Example: https://yourserver.modl.gg");
            this.logger.error("Plugin initialization stopped due to invalid configuration.");
            this.logger.error("===============================================");
            return;
        }
        VelocityCommandManager commandManager = new VelocityCommandManager(this.server, this);
        HttpManager httpManager = new HttpManager(this.getConfigString("api.key", "your-api-key-here"), apiUrl, (Boolean)this.getNestedConfig("api.debug", false));
        VelocityPlatform platform = new VelocityPlatform(this.server, commandManager);
        ChatMessageCache chatMessageCache = new ChatMessageCache();
        int syncPollingRate = Math.max(1, this.getConfigInt("sync.polling_rate", 2));
        this.pluginLoader = new PluginLoader(platform, new VelocityCommandRegister(commandManager), this.folder, chatMessageCache, httpManager, syncPollingRate);
        this.server.getEventManager().register((Object)this, (Object)new JoinListener(this.pluginLoader.getHttpClient(), this.pluginLoader.getCache(), this.logger, chatMessageCache, platform, this.pluginLoader.getSyncService(), httpManager.getPanelUrl(), this.pluginLoader.getLocaleManager()));
        this.server.getEventManager().register((Object)this, (Object)new ChatListener(platform, this.pluginLoader.getCache(), chatMessageCache, this.pluginLoader.getLocaleManager()));
    }

    @Subscribe
    public synchronized void onProxyShutdown(ProxyShutdownEvent evt) {
        if (this.pluginLoader != null) {
            this.pluginLoader.shutdown();
        }
    }

    private void loadConfig() {
        try {
            Path configFile;
            if (!Files.exists(this.folder, new LinkOption[0])) {
                Files.createDirectories(this.folder, new FileAttribute[0]);
            }
            if (!Files.exists(configFile = this.folder.resolve("config.yml"), new LinkOption[0])) {
                this.createDefaultConfig(configFile);
            }
            try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
                Yaml yaml = new Yaml();
                this.configuration = (Map)yaml.load(inputStream);
                if (this.configuration == null) {
                    this.logger.warn("Configuration file is empty, using defaults");
                    this.configuration = Map.of();
                }
            }
            this.logger.info("Configuration loaded successfully");
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration", (Throwable)e);
            this.configuration = Map.of();
        }
    }

    private void createDefaultConfig(Path configFile) throws IOException {
        String defaultConfig = "# MODL Minecraft Plugin Configuration\n#\n# API Configuration - Get these values from your MODL panel\napi:\n  # Your API key from the panel\n  key: \"your-api-key-here\"\n  # Your panel's base URL (e.g., https://yourserver.modl.gg)\n  url: \"https://yourserver.modl.gg\"\n  # Enable debug HTTP logging (default: false)\n  debug: false\n\n# Server Configuration\nserver:\n  # Name of this server (used for identification in the panel)\n  name: \"Server 1\"\n  # Allow querying Mojang API for unknown players (default: false)\n  query_mojang: false\n\n# Sync Configuration\nsync:\n  # How often to sync with the panel (in seconds)\n  # Default: 2 seconds. Minimum: 1 second\n  polling_rate: 2\n";
        Files.writeString(configFile, (CharSequence)defaultConfig, new OpenOption[0]);
        this.logger.info("Created default configuration file at: " + String.valueOf(configFile));
    }

    private String getConfigString(String path, String defaultValue) {
        if (this.configuration == null) {
            return defaultValue;
        }
        String[] keys = path.split("\\.");
        Object current = this.configuration;
        for (String key : keys) {
            if (!(current instanceof Map)) {
                return defaultValue;
            }
            current = current.get(key);
        }
        return current instanceof String ? (String)current : defaultValue;
    }

    private Object getNestedConfig(String path, Object defaultValue) {
        if (this.configuration == null) {
            return defaultValue;
        }
        String[] keys = path.split("\\.");
        Object current = this.configuration;
        for (String key : keys) {
            if (!(current instanceof Map)) {
                return defaultValue;
            }
            current = current.get(key);
        }
        return current != null ? current : defaultValue;
    }

    private int getConfigInt(String path, int defaultValue) {
        Object value = this.getNestedConfig(path, defaultValue);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    private void createLocaleFiles() {
        block11: {
            try {
                Path enUsFile;
                Path localeDir = this.folder.resolve("locale");
                if (!Files.exists(localeDir, new LinkOption[0])) {
                    Files.createDirectories(localeDir, new FileAttribute[0]);
                    this.logger.info("Created locale directory at: " + String.valueOf(localeDir));
                }
                if (Files.exists(enUsFile = localeDir.resolve("en_US.yml"), new LinkOption[0])) break block11;
                try (InputStream defaultLocale = this.getClass().getResourceAsStream("/locale/en_US.yml");){
                    if (defaultLocale != null) {
                        Files.copy(defaultLocale, enUsFile, new CopyOption[0]);
                        this.logger.info("Created default locale file at: " + String.valueOf(enUsFile));
                    } else {
                        this.logger.warn("Default locale resource not found in JAR");
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to create locale files", (Throwable)e);
            }
        }
    }
}

