/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncConverterMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.ConverterPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class ConverterPocketCubeBlockEntity
extends class_2621
implements class_1278,
ExtendedScreenHandlerFactory<class_2338> {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_2487 villagerData = new class_2487();
    private ConversionStage conversionStage = ConversionStage.IDLE;
    private int conversionProgress = 0;
    private int conversionTickCounter = 0;
    private boolean weaknessApplied = false;
    private boolean goldenAppleApplied = false;
    private int discountCount = 0;
    private class_2487 originalOffers = new class_2487();

    public ConverterPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.CONVERTER_POCKET_CUBE, position, state);
    }

    public boolean hasVillager() {
        return this.villagerData != null && !this.villagerData.method_33133();
    }

    public ConversionStage getConversionStage() {
        return this.conversionStage;
    }

    public void setConversionStage(ConversionStage s) {
        this.conversionStage = s == null ? ConversionStage.IDLE : s;
        this.method_5431();
    }

    public int getConversionProgress() {
        return this.conversionProgress;
    }

    public void setConversionProgress(int p) {
        this.conversionProgress = Math.max(0, Math.min(100, p));
        this.method_5431();
    }

    public boolean isWeaknessApplied() {
        return this.weaknessApplied;
    }

    public void setWeaknessApplied(boolean v) {
        this.weaknessApplied = v;
        this.method_5431();
    }

    public boolean isGoldenAppleApplied() {
        return this.goldenAppleApplied;
    }

    public void setGoldenAppleApplied(boolean v) {
        this.goldenAppleApplied = v;
        this.method_5431();
    }

    public int getDiscountCount() {
        return this.discountCount;
    }

    public void setDiscountCount(int c) {
        this.discountCount = Math.max(0, Math.min(5, c));
        this.method_5431();
    }

    public class_2487 getOriginalOffers() {
        return this.originalOffers;
    }

    public void setOriginalOffers(class_2487 t) {
        this.originalOffers = t == null ? new class_2487() : t.method_10553();
        this.method_5431();
    }

    public void setVillagerData(class_2487 data) {
        PocketVillagersMod.LOGGER.debug("[DEBUG] ConverterPocketCubeBlockEntity.setVillagerData called with data empty={}", (Object)(data == null || data.method_33133() ? 1 : 0));
        this.villagerData = data != null ? data : new class_2487();
        this.method_5431();
        try {
            if (this.villagerData == null || this.villagerData.method_33133()) {
                PocketVillagersMod.LOGGER.debug("[DEBUG] ConverterPocketCubeBlockEntity: Clearing villager - resetting conversion state");
                this.conversionStage = ConversionStage.IDLE;
                this.conversionProgress = 0;
                this.conversionTickCounter = 0;
                this.weaknessApplied = false;
                this.goldenAppleApplied = false;
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    for (class_3222 p : serverLevel.method_18456()) {
                        try {
                            if (!(p instanceof class_3222)) continue;
                            class_3222 sp = p;
                            class_1703 menu = sp.field_7512;
                            if (!(menu instanceof ConverterPocketCubeGUIMenu)) continue;
                            ConverterPocketCubeGUIMenu cm = (ConverterPocketCubeGUIMenu)menu;
                            if (cm.x != this.field_11867.method_10263() || cm.y != this.field_11867.method_10264() || cm.z != this.field_11867.method_10260()) continue;
                            try {
                                SyncConverterMenuPayload.send(sp, this.field_11867, this.conversionStage.ordinal(), this.conversionProgress, this.discountCount, "");
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable sp) {}
                    }
                }
            } else if (this.conversionStage == ConversionStage.IDLE) {
                this.conversionStage = ConversionStage.ZOMBIFYING;
                this.conversionProgress = 0;
                this.conversionTickCounter = 0;
                this.weaknessApplied = false;
                this.goldenAppleApplied = false;
                PocketVillagersMod.LOGGER.debug("ConverterPocketCubeBlockEntity: Started conversion process for new villager");
                class_1937 class_19373 = this.field_11863;
                if (class_19373 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19373;
                    for (class_3222 p : serverLevel.method_18456()) {
                        try {
                            if (!(p instanceof class_3222)) continue;
                            class_3222 sp = p;
                            class_1703 menu = sp.field_7512;
                            if (!(menu instanceof ConverterPocketCubeGUIMenu)) continue;
                            ConverterPocketCubeGUIMenu cm = (ConverterPocketCubeGUIMenu)menu;
                            if (cm.x != this.field_11867.method_10263() || cm.y != this.field_11867.method_10264() || cm.z != this.field_11867.method_10260()) continue;
                            try {
                                SyncConverterMenuPayload.send(sp, this.field_11867, this.conversionStage.ordinal(), this.conversionProgress, this.discountCount, this.villagerData.toString());
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_5431() {
        super.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void serverTick(class_1937 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        if (!this.hasVillager()) {
            return;
        }
        switch (this.conversionStage.ordinal()) {
            case 1: {
                int ZOMBIFY_TICKS = Math.max(1, PocketVillagersConfigCache.getConverterZombifyTime());
                ++this.conversionTickCounter;
                int pct = (int)Math.min(100.0, Math.floor((double)this.conversionTickCounter * 100.0 / (double)Math.max(1, ZOMBIFY_TICKS)));
                if (pct != this.conversionProgress) {
                    this.conversionProgress = pct;
                    if (pct % 5 == 0) {
                        this.syncToClients();
                        this.notifyOpenMenus(level);
                    }
                }
                if (this.conversionTickCounter < ZOMBIFY_TICKS && this.conversionProgress < 100) break;
                this.conversionStage = ConversionStage.CURING;
                this.conversionTickCounter = 0;
                this.conversionProgress = 0;
                this.method_5431();
                this.syncToClients();
                this.notifyOpenMenus(level);
                break;
            }
            case 2: {
                int CURING_TICKS = Math.max(1, PocketVillagersConfigCache.getConverterCureTime());
                ++this.conversionTickCounter;
                int pct = (int)Math.min(100.0, Math.floor((double)this.conversionTickCounter * 100.0 / (double)Math.max(1, CURING_TICKS)));
                if (pct != this.conversionProgress) {
                    this.conversionProgress = pct;
                    if (pct % 5 == 0) {
                        this.syncToClients();
                        this.notifyOpenMenus(level);
                    }
                }
                if (this.conversionTickCounter < CURING_TICKS && this.conversionProgress < 100) break;
                this.conversionStage = ConversionStage.CURED;
                this.conversionTickCounter = 0;
                this.conversionProgress = 100;
                try {
                    this.discountCount = Math.max(0, Math.min(5, this.discountCount + 1));
                    if (this.villagerData == null) {
                        this.villagerData = new class_2487();
                    }
                    this.villagerData.method_10569("PocketVillagers.Conversions", this.discountCount);
                    int conversionTime = (int)(level.method_8510() / 20L);
                    this.villagerData.method_10569("ConversionTime", conversionTime);
                    PocketVillagersMod.LOGGER.debug("ConverterPocketCubeBlockEntity: Set PocketVillagers.Conversions={} and ConversionTime={} on cured villager", (Object)this.discountCount, (Object)conversionTime);
                }
                catch (Throwable ignored) {
                    PocketVillagersMod.LOGGER.warn("ConverterPocketCubeBlockEntity: Failed to set conversion data: {}", (Object)ignored.getMessage());
                }
                this.method_5431();
                this.syncToClients();
                this.notifyOpenMenus(level);
                break;
            }
        }
    }

    public void syncToClients() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            try {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void notifyOpenMenus(class_1937 level) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        for (class_3222 p : serverLevel.method_18456()) {
            try {
                if (!(p instanceof class_3222)) continue;
                class_3222 sp = p;
                class_1703 menu = sp.field_7512;
                if (!(menu instanceof ConverterPocketCubeGUIMenu)) continue;
                ConverterPocketCubeGUIMenu cm = (ConverterPocketCubeGUIMenu)menu;
                if (cm.x != this.field_11867.method_10263() || cm.y != this.field_11867.method_10264() || cm.z != this.field_11867.method_10260()) continue;
                try {
                    SyncConverterMenuPayload.send(sp, this.field_11867, this.conversionStage == null ? 0 : this.conversionStage.ordinal(), this.conversionProgress, this.discountCount, this.villagerData == null ? "" : this.villagerData.toString());
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public class_2487 getVillagerData() {
        return this.villagerData;
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        valueInput.method_71426("VillagerData", class_2487.field_25128).ifPresent(tag -> {
            this.villagerData = tag.method_10553();
        });
        try {
            if (this.villagerData != null && this.villagerData.method_10545("PocketVillagers.Conversions")) {
                this.discountCount = this.villagerData.method_10550("PocketVillagers.Conversions").orElse(this.discountCount);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Optional maybeState = valueInput.method_71426("ConverterState", class_2487.field_25128);
        if (maybeState.isPresent()) {
            class_2487 tag2 = (class_2487)maybeState.get();
            try {
                String sname = tag2.method_10558("Stage").orElse(ConversionStage.IDLE.name());
                this.conversionStage = ConversionStage.valueOf(sname);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.conversionProgress = tag2.method_10550("Progress").orElse(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.weaknessApplied = tag2.method_10577("Weakness").orElse(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.goldenAppleApplied = tag2.method_10577("GoldenApple").orElse(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.discountCount = tag2.method_10550("DiscountCount").orElse(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                tag2.method_10562("OriginalOffers").ifPresent(c -> {
                    this.originalOffers = c.method_10553();
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.conversionTickCounter = tag2.method_10550("TickCounter").orElse(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.method_54871(valueInput)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_11368)valueInput, this.stacks);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.villagerData.method_33133()) {
            valueOutput.method_71468("VillagerData", class_2487.field_25128, (Object)this.villagerData.method_10553());
        }
        class_2487 state = new class_2487();
        try {
            state.method_10582("Stage", this.conversionStage == null ? ConversionStage.IDLE.name() : this.conversionStage.name());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("Progress", this.conversionProgress);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10556("Weakness", this.weaknessApplied);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10556("GoldenApple", this.goldenAppleApplied);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("DiscountCount", this.discountCount);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("TickCounter", this.conversionTickCounter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.villagerData.method_33133()) {
                this.villagerData.method_10569("PocketVillagers.Conversions", this.discountCount);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.originalOffers != null && !this.originalOffers.method_33133()) {
                state.method_10566("OriginalOffers", (class_2520)this.originalOffers.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!state.method_33133()) {
            valueOutput.method_71468("ConverterState", class_2487.field_25128, (Object)state);
        }
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.stacks);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10566("VillagerData", (class_2520)(this.villagerData != null ? this.villagerData.method_10553() : new class_2487()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_2487 state = new class_2487();
        try {
            state.method_10582("Stage", this.conversionStage == null ? ConversionStage.IDLE.name() : this.conversionStage.name());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("Progress", this.conversionProgress);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10556("Weakness", this.weaknessApplied);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10556("GoldenApple", this.goldenAppleApplied);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("DiscountCount", this.discountCount);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            state.method_10569("TickCounter", this.conversionTickCounter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.originalOffers != null && !this.originalOffers.method_33133()) {
                state.method_10566("OriginalOffers", (class_2520)this.originalOffers.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!state.method_33133()) {
            try {
                tag.method_10566("ConverterState", (class_2520)state);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return tag;
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"converter_pocket_cube");
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new ConverterPocketCubeGUIMenu(id, inventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Converter Pocket Cube");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemstack);
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return true;
    }

    public static enum ConversionStage {
        IDLE,
        ZOMBIFYING,
        CURING,
        CURED;

    }
}

