/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class VillagerRenderManager {
    private static final Map<class_2338, class_1309> villagerCache = new HashMap<class_2338, class_1309>();

    private VillagerRenderManager() {
    }

    public static class_1309 getOrCreateVillager(class_1937 level, class_2338 blockPos, class_2487 villagerData) {
        if (level == null || blockPos == null) {
            return null;
        }
        if (villagerCache.containsKey(blockPos)) {
            return villagerCache.get(blockPos);
        }
        class_1309 villager = VillagerRenderManager.createVillagerEntity(level, villagerData);
        if (villager == null) {
            PocketVillagersMod.LOGGER.warn("Failed to create villager for rendering at {}", (Object)blockPos);
            return null;
        }
        villagerCache.put(blockPos, villager);
        return villager;
    }

    public static class_1309 getVillager(class_2338 blockPos) {
        return villagerCache.get(blockPos);
    }

    public static void removeVillager(class_2338 blockPos) {
        villagerCache.remove(blockPos);
    }

    public static void clearCache() {
        villagerCache.clear();
    }

    private static class_1309 createVillagerEntity(class_1937 level, class_2487 villagerData) {
        if (level == null) {
            return null;
        }
        class_1309 villager = (class_1309)class_1299.field_6077.method_5883(level, class_3730.field_16467);
        if (villager == null) {
            return null;
        }
        villager.method_5773();
        villager.method_5814(0.0, 0.0, 0.0);
        villager.method_18799(class_243.field_1353);
        villager.field_6038 = 0.0;
        villager.field_5971 = 0.0;
        villager.field_5989 = 0.0;
        villager.method_24830(true);
        villager.field_28627 = 0.0f;
        villager.method_5773();
        float randomYaw = level.field_9229.method_43057() * 360.0f;
        villager.method_5847(randomYaw);
        villager.method_5636(randomYaw);
        villager.field_6004 = villager.method_36455();
        villager.field_5982 = villager.method_36454();
        if (villagerData != null && !villagerData.method_33133()) {
            try {
                class_11368 valueInput = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)level.method_30349(), (class_2487)villagerData);
                villager.method_5651(valueInput);
            }
            catch (Exception e) {
                PocketVillagersMod.LOGGER.error("Failed to load villager NBT data", (Throwable)e);
            }
        }
        villager.method_5773();
        villager.field_5960 = true;
        if (villager instanceof class_1314) {
            class_1314 pathfinderMob = (class_1314)villager;
            pathfinderMob.method_5977(true);
            pathfinderMob.method_5803(true);
        }
        return villager;
    }
}

