/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.client.EntityGuiRenderHelper;
import net.mcreator.pocketvillagers.client.HologramToggle;
import net.mcreator.pocketvillagers.client.VillagerRendererManager;
import net.mcreator.pocketvillagers.client.gui.TerminalTabHelper;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModMenus;
import net.mcreator.pocketvillagers.init.PocketVillagersModScreens;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.world.inventory.MiningPocketCubeGUIMenu;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_8710;

public class MiningPocketCubeScreen
extends class_465<MiningPocketCubeGUIMenu>
implements PocketVillagersModScreens.FabricScreenAccessor {
    private final class_1937 world;
    private final int x;
    private final int y;
    private final int z;
    private MiningPocketCubeBlockEntity blockEntity;
    private int clientProgressTimer;
    private int clientProgressInterval;
    private long clientProgressLastUpdateMs;
    private boolean clientCanAutomate;
    private boolean prevLocalCanAutomate;
    private class_4185 releaseButton;
    private int releaseX;
    private int releaseY;
    private int releaseW;
    private int releaseH;
    private static final class_2960 texture = class_2960.method_60654((String)"pocket_villagers:textures/screens/mining_pocket_cube_gui.png");

    public MiningPocketCubeScreen(MiningPocketCubeGUIMenu container, class_1661 inventory, class_2561 component) {
        block12: {
            class_2586 be;
            super((class_1703)container, inventory, component);
            this.clientProgressTimer = 0;
            this.clientProgressInterval = 0;
            this.clientProgressLastUpdateMs = 0L;
            this.clientCanAutomate = false;
            this.prevLocalCanAutomate = false;
            this.world = container.world;
            this.x = container.x;
            this.y = container.y;
            this.z = container.z;
            this.field_2792 = 176;
            this.field_2779 = 211;
            if (this.world != null && (be = this.world.method_8321(new class_2338(this.x, this.y, this.z))) instanceof MiningPocketCubeBlockEntity) {
                this.blockEntity = (MiningPocketCubeBlockEntity)be;
            }
            try {
                if (this.blockEntity == null) break block12;
                class_2487 tag = this.blockEntity.method_16887(null);
                try {
                    int ticks = tag.method_10550("ProgressTicks").orElse(0);
                    int needed = tag.method_10550("ProgressNeeded").orElse(0);
                    if (needed > 0) {
                        this.clientProgressInterval = needed;
                        this.clientProgressTimer = Math.max(0, ticks);
                        this.clientProgressLastUpdateMs = System.currentTimeMillis();
                    }
                }
                catch (Throwable ticks) {}
            }
            catch (Throwable tag) {
                // empty catch block
            }
        }
        try {
            MiningPocketCubeGUIMenu ma;
            Map<String, Object> menuState;
            if (container instanceof PocketVillagersModMenus.MenuAccessor && (menuState = (ma = container).getMenuState()) != null) {
                Object canAutomateObj;
                Object timerObj;
                Object intervalObj = menuState.get("2:progressInterval");
                if (intervalObj instanceof Number) {
                    Number n = (Number)intervalObj;
                    this.clientProgressInterval = n.intValue();
                }
                if ((timerObj = menuState.get("2:progressTimer")) instanceof Number) {
                    Number n = (Number)timerObj;
                    this.clientProgressTimer = n.intValue();
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
                if ((canAutomateObj = menuState.get("1:canAutomate")) instanceof Boolean) {
                    Boolean b = (Boolean)canAutomateObj;
                    this.clientCanAutomate = b;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderVillagerModel(class_332 guiGraphics, class_2487 villagerData, int centerX, int centerY, float scale, int slot, float partialTicks) {
        try {
            class_4587 pose;
            block26: {
                if (villagerData == null || villagerData.method_33133()) {
                    return;
                }
                class_310 mc = class_310.method_1551();
                class_638 level = mc.field_1687;
                if (level == null) {
                    return;
                }
                class_2338 pos = this.blockEntity != null ? this.blockEntity.method_11016() : new class_2338(this.x, this.y, this.z);
                class_1297 entity = VillagerRendererManager.getOrCreate((class_1937)level, pos, slot, villagerData == null ? new class_2487() : villagerData);
                if (entity == null) {
                    return;
                }
                try {
                    entity.method_5648(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                pose = new class_4587();
                pose.method_22903();
                double zDepth = 100.0;
                pose.method_22904((double)centerX, (double)centerY, zDepth);
                float scaleFactor = 0.22f;
                pose.method_22905(scaleFactor, scaleFactor, scaleFactor);
                float yaw = 45.0f;
                try {
                    if (entity instanceof CubeVillager) {
                        CubeVillager cv = (CubeVillager)entity;
                        try {
                            cv.reloadDataFromNBT(villagerData);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            cv.setPocketCubePos(pos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (entity instanceof class_1309) {
                        class_1309 le = (class_1309)entity;
                        le.method_36456(yaw);
                        le.method_5847(yaw);
                    }
                }
                catch (Throwable le) {
                    // empty catch block
                }
                try {
                    mc.method_22940().method_23000().method_37104();
                    if (!(entity instanceof class_1309)) break block26;
                    class_1309 living = (class_1309)entity;
                    int areaLeft = centerX - 16;
                    int areaTop = centerY - 40;
                    int areaRight = centerX + 16;
                    int areaBottom = centerY + 40;
                    int scaledSize = Math.max(16, Math.round(scale));
                    float entityHeight = living.method_17682();
                    float yOffset = entityHeight < 1.5f ? 0.05f : 0.0625f;
                    try {
                        boolean drawn = EntityGuiRenderHelper.tryRenderWithQuaternion(guiGraphics, (areaLeft + areaRight) / 2, (areaTop + areaBottom) / 2, scaledSize, (float)Math.toRadians(45.0), living);
                        if (!drawn) {
                            class_490.method_2486((class_332)guiGraphics, (int)areaLeft, (int)areaTop, (int)areaRight, (int)areaBottom, (int)scaledSize, (float)yOffset, (float)(centerX + 40), (float)centerY, (class_1309)living);
                        }
                    }
                    catch (Throwable drawn) {
                        // empty catch block
                    }
                    mc.method_22940().method_23000().method_37104();
                    try {
                        boolean holoOn = true;
                        try {
                            holoOn = HologramToggle.HOLOGRAM_ENABLED;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (holoOn) {
                            long t = System.currentTimeMillis();
                            int baseAlpha = 40 + (int)((Math.sin((double)t * 0.006) + 1.0) * 20.0);
                            int baseColor = baseAlpha << 24 | 0xD0FF;
                            int halfW = 20;
                            int halfH = 36;
                            int leftOv = Math.max(areaLeft, centerX - halfW);
                            int rightOv = Math.min(areaRight, centerX + halfW);
                            int topOv = Math.max(areaTop, centerY - halfH) - 1;
                            int bottomOv = Math.min(areaBottom, centerY + halfH) - 2;
                            guiGraphics.method_25294(leftOv, topOv, rightOv, bottomOv, baseColor);
                            for (int yy = topOv; yy < bottomOv; yy += 3) {
                                double phase = Math.sin((double)t * 0.01 + (double)yy * 0.2);
                                int alpha = (int)(8.0 + (phase + 1.0) * 12.0);
                                int col = alpha << 24 | 0xD0FF;
                                guiGraphics.method_25294(leftOv, yy, rightOv, yy + 1, col);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            pose.method_22909();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        try {
            if (elementType == 2 && "progressTimer".equals(name) && elementState instanceof Number) {
                Number n = (Number)elementState;
                this.clientProgressTimer = (int)Math.round(n.doubleValue());
                this.clientProgressLastUpdateMs = System.currentTimeMillis();
            } else if (elementType == 2 && "progressInterval".equals(name) && elementState instanceof Number) {
                Number n2 = (Number)elementState;
                this.clientProgressInterval = (int)Math.round(n2.doubleValue());
                if (this.clientProgressLastUpdateMs == 0L) {
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
            } else if (elementType == 2 && "remainingTicks".equals(name) && elementState instanceof Number) {
                Number n3 = (Number)elementState;
                try {
                    int rem = (int)Math.round(n3.doubleValue());
                    if (this.clientProgressInterval > 0) {
                        this.clientProgressTimer = Math.max(0, this.clientProgressInterval - rem);
                    }
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
                catch (Throwable rem) {}
            } else if (elementType == 1 && "canAutomate".equals(name)) {
                try {
                    Boolean b;
                    this.clientCanAutomate = Boolean.TRUE.equals(elementState) || elementState instanceof Boolean && (b = (Boolean)elementState) != false;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        try {
            class_2487 vd;
            int modelX = this.field_2776 + 34;
            int modelY = this.field_2800 + 80;
            class_2487 class_24872 = vd = this.blockEntity == null ? null : this.blockEntity.getVillagerData();
            if (vd != null && !vd.method_33133()) {
                this.renderVillagerModel(guiGraphics, vd, modelX, modelY, 32.0f, 1, partialTicks);
            }
        }
        catch (Throwable modelX) {
            // empty catch block
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
        try {
            class_1735 slot;
            int toolX = this.field_2776 + 72;
            int toolY = this.field_2800 + 71;
            int slotW = 16;
            int slotH = 16;
            if (mouseX >= toolX && mouseX < toolX + slotW && mouseY >= toolY && mouseY < toolY + slotH && ((slot = ((MiningPocketCubeGUIMenu)this.field_2797).method_7611(0)) == null || slot.method_7677().method_7960())) {
                this.drawCyanTooltip(guiGraphics, "Insert Pickaxe", mouseX, mouseY);
            }
        }
        catch (Throwable toolX) {
            // empty catch block
        }
        try {
            if (this.releaseButton != null) {
                String tooltipText = "Release Villager";
                int rx = this.releaseX;
                int ry = this.releaseY;
                int rw = this.releaseW;
                int rh = this.releaseH;
                if (mouseX >= rx && mouseX < rx + rw && mouseY >= ry && mouseY < ry + rh) {
                    this.drawCyanTooltip(guiGraphics, tooltipText, mouseX, mouseY);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void drawCyanTooltip(class_332 guiGraphics, String text, int mouseX, int mouseY) {
        try {
            int pad = 6;
            int lineW = this.field_22793.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > this.field_22789 - 4) {
                x = this.field_22789 - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
            int textX = x + pad;
            int textY = y + pad - 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), textX, textY, -1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.method_25290(class_10799.field_56883, texture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            if (this.world != null) {
                this.blockEntity = (MiningPocketCubeBlockEntity)this.world.method_8321(new class_2338(this.x, this.y, this.z));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.blockEntity == null) {
            guiGraphics.method_51433(this.field_22793, "No villager stored", 8, 8, -12829636, false);
            return;
        }
        try {
            String title = "Mining Pocket Cube";
            int titleW = this.field_22793.method_1727(title);
            int titleX = (this.field_2792 - titleW) / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), titleX, 8, -12829636, false);
        }
        catch (Throwable title) {
            // empty catch block
        }
        try {
            Object label;
            int barBase;
            int centerX = this.field_2792 / 2;
            int barWidth = 52;
            int barHeight = 6;
            int barX = centerX - barWidth / 2 - 8;
            int barY = barBase = 102;
            int cyan = -1442775041;
            int bg = 0x66000000;
            int outline = -1996488705;
            double pct = 0.0;
            if (this.clientProgressInterval > 0) {
                int predicted = this.clientProgressTimer;
                try {
                    if (this.clientProgressLastUpdateMs > 0L) {
                        long elapsedMs = Math.max(0L, System.currentTimeMillis() - this.clientProgressLastUpdateMs);
                        int elapsedTicks = (int)(elapsedMs / 50L);
                        predicted = Math.min(this.clientProgressInterval, this.clientProgressTimer + elapsedTicks);
                    }
                }
                catch (Throwable elapsedMs) {
                    // empty catch block
                }
                pct = Math.max(0.0, Math.min(1.0, (double)predicted / (double)Math.max(1, this.clientProgressInterval)));
            }
            boolean localCanAutomate = this.clientCanAutomate;
            try {
                class_1735 s = ((MiningPocketCubeGUIMenu)this.field_2797).method_7611(0);
                if (s == null || s.method_7677().method_7960()) {
                    localCanAutomate = false;
                }
            }
            catch (Throwable s) {
                // empty catch block
            }
            try {
                boolean justBecameAutomatable;
                boolean bl = justBecameAutomatable = !this.prevLocalCanAutomate && localCanAutomate;
                if (justBecameAutomatable) {
                    this.clientProgressTimer = 0;
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
            }
            catch (Throwable justBecameAutomatable) {
                // empty catch block
            }
            if (!localCanAutomate) {
                pct = 0.0;
                try {
                    this.clientProgressTimer = 0;
                    this.clientProgressLastUpdateMs = 0L;
                }
                catch (Throwable justBecameAutomatable) {
                    // empty catch block
                }
            }
            guiGraphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, bg);
            int filled = (int)Math.round((double)barWidth * pct);
            if (filled > 0) {
                guiGraphics.method_25294(barX, barY, barX + filled, barY + barHeight, cyan);
            }
            guiGraphics.method_25294(barX, barY - 1, barX + barWidth, barY, outline);
            guiGraphics.method_25294(barX, barY + barHeight, barX + barWidth, barY + barHeight + 1, outline);
            guiGraphics.method_25294(barX - 1, barY, barX, barY + barHeight, outline);
            guiGraphics.method_25294(barX + barWidth, barY, barX + barWidth + 1, barY + barHeight, outline);
            if (!localCanAutomate) {
                label = "Status: N/A";
            } else {
                int remainingTicks = this.clientProgressInterval <= 0 ? 0 : Math.max(0, (int)Math.round((double)this.clientProgressInterval - pct * (double)this.clientProgressInterval));
                int seconds = (int)Math.ceil((double)remainingTicks / 20.0);
                label = "Mining... " + seconds + "s";
            }
            int lblX = centerX - 8 - this.field_22793.method_1727((String)label) / 2;
            if (lblX < 4) {
                lblX = 4;
            }
            Objects.requireNonNull(this.field_22793);
            int lblY = barY - 9 - 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)label), lblX, lblY, -1, false);
            try {
                this.prevLocalCanAutomate = localCanAutomate;
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.execute(() -> this.field_22787.execute(() -> {
            if (this.field_22787.field_1755 == null && TerminalTabHelper.isViewingFromTerminal()) {
                TerminalTabHelper.clearViewingFromTerminal();
            }
        }));
    }

    public void method_25426() {
        super.method_25426();
        PocketVillagersMod.LOGGER.info("MiningPocketCubeScreen.init() - terminal flag is: {}", TerminalTabHelper.isViewingFromTerminal() ? TerminalTabHelper.getTerminalPosition() : "not set");
        try {
            int btnW = 56;
            int btnH = 13;
            int modelX = this.field_2776 + 34;
            int modelY = this.field_2800 + 80;
            int btnX = modelX - 28 + 1;
            int btnY = modelY + 35;
            String buttonLabel = "Release";
            this.releaseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), btn -> {
                try {
                    class_2338 p = new class_2338(this.x, this.y, this.z);
                    ClientPlayNetworking.send((class_8710)new ReleaseStorageVillagerPacket(p, 1));
                    btn.method_25350(0.8f);
                    try {
                        if (this.world != null) {
                            VillagerRendererManager.remove(this.world, new class_2338(this.x, this.y, this.z), 1);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (this.blockEntity != null) {
                            this.blockEntity.setVillagerData(new class_2487());
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).method_46434(btnX, btnY, 56, 13).method_46431();
            this.releaseX = btnX;
            this.releaseY = btnY;
            this.releaseW = 56;
            this.releaseH = 13;
            try {
                boolean hasVillagerInit;
                this.releaseButton.field_22763 = hasVillagerInit = this.blockEntity != null && this.blockEntity.hasVillager();
                try {
                    this.releaseButton.method_25350(1.0f);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.method_37063((class_364)this.releaseButton);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return TerminalTabHelper.handleTerminalTabClick(this.field_22787, this.field_2776, this.field_2800, (int)mouseX, (int)mouseY);
    }
}

