/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.client.gui.TerminalTabHelper;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.init.PocketVillagersModScreens;
import net.mcreator.pocketvillagers.network.OpenRemoteCubePayload;
import net.mcreator.pocketvillagers.network.SyncNearbyCubesPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerPayload;
import net.mcreator.pocketvillagers.world.inventory.PocketTerminalGUIMenu;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_8710;

public class PocketTerminalScreen
extends class_465<PocketTerminalGUIMenu>
implements PocketVillagersModScreens.FabricScreenAccessor {
    private static final class_2960 texture = class_2960.method_60654((String)"pocket_villagers:textures/screens/pocket_terminal_gui.png");
    private List<SyncNearbyCubesPayload.CubeInfo> nearbyCubes = new ArrayList<SyncNearbyCubesPayload.CubeInfo>();
    private List<class_4185> cubeButtons = new ArrayList<class_4185>();
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_CUBES = 7;
    private List<SyncTerminalVillagersPayload.CubeVillagerData> cubeVillagers = new ArrayList<SyncTerminalVillagersPayload.CubeVillagerData>();
    private int villagerScrollOffset = 0;
    private List<class_4185> villagerTransferButtons = new ArrayList<class_4185>();
    private List<VillagerEntry> flatVillagerList = new ArrayList<VillagerEntry>();
    private List<VillagerEntry> villagerButtonEntries = new ArrayList<VillagerEntry>();
    private int fuelTimer = 0;
    private int maxFuelTimer = 200;
    private boolean terminalPowered = false;
    private boolean selectingTransferTarget = false;
    private VillagerEntry transferringVillager = null;
    private List<SyncNearbyCubesPayload.CubeInfo> availableCubes = null;
    private int selectionScrollOffset = 0;
    private List<class_4185> selectionButtons = new ArrayList<class_4185>();
    private int popupX = 0;
    private int popupY = 0;
    private List<class_364> removedWidgets = new ArrayList<class_364>();
    private boolean villagerListCollapsed = false;
    private class_4185 collapseButton;

    public PocketTerminalScreen(PocketTerminalGUIMenu container, class_1661 inventory, class_2561 component) {
        super((class_1703)container, inventory, component);
        this.field_2792 = 176;
        this.field_2779 = 211;
        this.field_25270 = this.field_2779 - 94 + 8;
    }

    protected void method_25426() {
        List<SyncTerminalVillagersPayload.CubeVillagerData> cachedVillagers;
        List<SyncNearbyCubesPayload.CubeInfo> cachedCubes;
        super.method_25426();
        this.selectingTransferTarget = false;
        this.transferringVillager = null;
        this.availableCubes = null;
        this.selectionScrollOffset = 0;
        if (this.selectionButtons != null) {
            this.selectionButtons.clear();
        }
        if (!(cachedCubes = SyncNearbyCubesPayload.getCachedCubes()).isEmpty() && this.nearbyCubes.isEmpty()) {
            this.nearbyCubes = new ArrayList<SyncNearbyCubesPayload.CubeInfo>(cachedCubes);
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL GUI] Loaded {} cubes from cache", (Object)cachedCubes.size());
        }
        if (!(cachedVillagers = SyncTerminalVillagersPayload.getCachedVillagers()).isEmpty() && this.cubeVillagers.isEmpty()) {
            this.cubeVillagers = new ArrayList<SyncTerminalVillagersPayload.CubeVillagerData>(cachedVillagers);
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL GUI] Loaded {} villager groups from cache", (Object)cachedVillagers.size());
            this.rebuildVillagerList();
        }
        int btnX = this.field_2776 + this.field_2792;
        int btnY = this.field_2800 + 5;
        this.collapseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.villagerListCollapsed ? "\u25bc" : "\u25b2")), button -> {
            this.villagerListCollapsed = !this.villagerListCollapsed;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.villagerListCollapsed ? "\u25bc" : "\u25b2")));
            this.villagerScrollOffset = 0;
        }).method_46434(btnX, btnY, 12, 12).method_46431();
        this.method_37063((class_364)this.collapseButton);
        this.rebuildCubeButtons();
    }

    private void rebuildCubeButtons() {
        for (class_4185 btn : this.cubeButtons) {
            this.method_37066((class_364)btn);
        }
        this.cubeButtons.clear();
        int startIndex = this.scrollOffset;
        int endIndex = Math.min(startIndex + 7, this.nearbyCubes.size());
        for (int i = startIndex; i < endIndex; ++i) {
            SyncNearbyCubesPayload.CubeInfo cube = this.nearbyCubes.get(i);
            int buttonIndex = i - startIndex;
            int tabX = this.field_2776 - 29;
            int tabY = this.field_2800 + 0 + buttonIndex * 30;
            int tabWidth = 28;
            int tabHeight = 28;
            class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), button -> {
                if (this.terminalPowered) {
                    ClientPlayNetworking.send((class_8710)new OpenRemoteCubePayload(cube.pos));
                } else if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cAdd emeralds to the fuel slot to power the terminal!"), true);
                }
            }).method_46434(tabX, tabY, tabWidth, tabHeight).method_46431();
            this.method_37063((class_364)btn);
            this.cubeButtons.add(btn);
        }
        if (this.nearbyCubes.size() > 7) {
            int scrollButtonY = this.field_2800 + 210;
            if (this.scrollOffset > 0) {
                class_4185 scrollUp = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), button -> {
                    this.scrollOffset = Math.max(0, this.scrollOffset - 1);
                    this.rebuildCubeButtons();
                }).method_46434(this.field_2776 - 29, scrollButtonY, 28, 15).method_46431();
                this.method_37063((class_364)scrollUp);
                this.cubeButtons.add(scrollUp);
            }
            if (this.scrollOffset + 7 < this.nearbyCubes.size()) {
                class_4185 scrollDown = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), button -> {
                    this.scrollOffset = Math.min(this.nearbyCubes.size() - 7, this.scrollOffset + 1);
                    this.rebuildCubeButtons();
                }).method_46434(this.field_2776 - 29, scrollButtonY + 16, 28, 15).method_46431();
                this.method_37063((class_364)scrollDown);
                this.cubeButtons.add(scrollDown);
            }
        }
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.field_6012 % 100 == 0) {
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL GUI] render: nearbyCubes={}, cubeVillagers={}", (Object)this.nearbyCubes.size(), (Object)this.cubeVillagers.size());
        }
        int startIndex = this.scrollOffset;
        int endIndex = Math.min(startIndex + 7, this.nearbyCubes.size());
        for (i = startIndex; i < endIndex; ++i) {
            SyncNearbyCubesPayload.CubeInfo cube = this.nearbyCubes.get(i);
            int buttonIndex = i - startIndex;
            int tabX = this.field_2776 - 29;
            int tabY = this.field_2800 + 0 + buttonIndex * 30;
            int bgColor = -16109761;
            int borderColor = -16711681;
            guiGraphics.method_25294(tabX, tabY, tabX + 28, tabY + 28, bgColor);
            guiGraphics.method_25294(tabX, tabY, tabX + 28, tabY + 1, borderColor);
            guiGraphics.method_25294(tabX, tabY + 27, tabX + 28, tabY + 28, borderColor);
            guiGraphics.method_25294(tabX, tabY, tabX + 1, tabY + 28, borderColor);
            guiGraphics.method_25294(tabX + 27, tabY, tabX + 28, tabY + 28, borderColor);
            class_1799 cubeItem = this.getCubeItemStack(cube.type);
            if (cubeItem.method_7960()) continue;
            int iconX = tabX + 6;
            int iconY = tabY + 6;
            guiGraphics.method_51427(cubeItem, iconX, iconY);
        }
        for (i = 0; i < this.cubeButtons.size(); ++i) {
            int cubeIndex;
            class_4185 btn = this.cubeButtons.get(i);
            if (btn == null || !btn.method_25367() || (cubeIndex = this.scrollOffset + i) >= this.nearbyCubes.size()) continue;
            SyncNearbyCubesPayload.CubeInfo cube = this.nearbyCubes.get(cubeIndex);
            String displayName = cube.displayName != null && !cube.displayName.isEmpty() ? cube.displayName : "Unknown Cube";
            this.drawCyanTooltip(guiGraphics, displayName, mouseX, mouseY);
            break;
        }
        try {
            int fuelSlotX = this.field_2776 + 149;
            int fuelSlotY = this.field_2800 + 105;
            String fuelTip = "Insert emerald to power the terminal";
            if (mouseX >= fuelSlotX && mouseX < fuelSlotX + 16 && mouseY >= fuelSlotY && mouseY < fuelSlotY + 16 && (this.field_2787 == null || this.field_2787.method_7677().method_7960())) {
                this.drawCyanTooltip(guiGraphics, fuelTip, mouseX, mouseY);
            }
        }
        catch (Throwable fuelSlotX) {
            // empty catch block
        }
        if (this.selectingTransferTarget && this.availableCubes != null) {
            boolean cancelHovering;
            PocketVillagersMod.LOGGER.debug("[RENDER] Drawing selection popup. availableCubes size: {}", (Object)this.availableCubes.size());
            int popupWidth = 160;
            int lineHeight = 12;
            int padding = 6;
            int titleHeight = lineHeight + 4;
            int maxVisibleCubes = Math.min(5, this.availableCubes.size());
            int cubesHeight = maxVisibleCubes * lineHeight;
            int cancelBtnHeight = 16;
            int popupHeight = padding + titleHeight + cubesHeight + cancelBtnHeight + padding;
            int popupX = this.popupX;
            int popupY = this.popupY;
            PocketVillagersMod.LOGGER.debug("[RENDER] Popup position: ({}, {}), size: {}x{}", (Object)popupX, (Object)popupY, (Object)popupWidth, (Object)popupHeight);
            int bg = -435540161;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(popupX + 2, popupY + 2, popupX + popupWidth + 2, popupY + popupHeight + 2, shadow);
            guiGraphics.method_25294(popupX, popupY, popupX + popupWidth, popupY + popupHeight, bg);
            guiGraphics.method_25294(popupX, popupY, popupX + popupWidth, popupY + 1, border);
            guiGraphics.method_25294(popupX, popupY + popupHeight - 1, popupX + popupWidth, popupY + popupHeight, border);
            guiGraphics.method_25294(popupX, popupY, popupX + 1, popupY + popupHeight, border);
            guiGraphics.method_25294(popupX + popupWidth - 1, popupY, popupX + popupWidth, popupY + popupHeight, border);
            String title = "Select Destination";
            int titleX = popupX + popupWidth / 2 - this.field_22793.method_1727(title) / 2;
            int titleY = popupY + padding;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), titleX, titleY, -16711681, false);
            PocketVillagersMod.LOGGER.debug("[RENDER] Drew title at ({}, {})", (Object)titleX, (Object)titleY);
            int startY = popupY + padding + titleHeight;
            int cubeStartIndex = this.selectionScrollOffset;
            int cubeEndIndex = Math.min(cubeStartIndex + maxVisibleCubes, this.availableCubes.size());
            PocketVillagersMod.LOGGER.debug("[RENDER] Drawing {} cube lines starting at index {}", (Object)(cubeEndIndex - cubeStartIndex), (Object)cubeStartIndex);
            for (int i2 = cubeStartIndex; i2 < cubeEndIndex; ++i2) {
                boolean hovering;
                int lineIndex = i2 - cubeStartIndex;
                int lineY = startY + lineIndex * lineHeight;
                SyncNearbyCubesPayload.CubeInfo cube = this.availableCubes.get(i2);
                boolean bl = hovering = mouseX >= popupX && mouseX <= popupX + popupWidth && mouseY >= lineY && mouseY < lineY + lineHeight;
                if (hovering) {
                    guiGraphics.method_25294(popupX + 1, lineY, popupX + popupWidth - 1, lineY + lineHeight, 0x4000FFFF);
                }
                String displayName = cube.displayName != null && !cube.displayName.isEmpty() ? cube.displayName : cube.type;
                int textX = popupX + padding + 2;
                guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)displayName), textX, lineY + 2, -1, false);
                PocketVillagersMod.LOGGER.debug("[RENDER] Drew cube line {}: '{}' at ({}, {})", (Object)i2, (Object)displayName, (Object)textX, (Object)(lineY + 2));
            }
            if (this.availableCubes.size() > maxVisibleCubes) {
                int scrollbarX = popupX + popupWidth - 5;
                int scrollbarWidth = 3;
                int scrollbarTrackY = startY;
                int scrollbarTrackHeight = cubesHeight;
                guiGraphics.method_25294(scrollbarX, scrollbarTrackY, scrollbarX + scrollbarWidth, scrollbarTrackY + scrollbarTrackHeight, Integer.MIN_VALUE);
                float scrollPercent = (float)cubeStartIndex / (float)(this.availableCubes.size() - maxVisibleCubes);
                float thumbHeightRatio = (float)maxVisibleCubes / (float)this.availableCubes.size();
                int thumbHeight = Math.max(8, (int)((float)scrollbarTrackHeight * thumbHeightRatio));
                int thumbY = scrollbarTrackY + (int)((float)(scrollbarTrackHeight - thumbHeight) * scrollPercent);
                guiGraphics.method_25294(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -16711681);
            }
            int cancelY = popupY + popupHeight - padding - cancelBtnHeight;
            String cancelText = "Cancel (ESC)";
            int cancelTextX = popupX + popupWidth / 2 - this.field_22793.method_1727(cancelText) / 2;
            boolean bl = cancelHovering = mouseX >= popupX && mouseX <= popupX + popupWidth && mouseY >= cancelY && mouseY < cancelY + cancelBtnHeight;
            if (cancelHovering) {
                guiGraphics.method_25294(popupX + 1, cancelY, popupX + popupWidth - 1, cancelY + cancelBtnHeight, 0x40FF0000);
            }
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cancelText), cancelTextX, cancelY + 4, cancelHovering ? -30584 : -5592406, false);
        }
    }

    private void drawCyanTooltip(class_332 guiGraphics, String text, int mouseX, int mouseY) {
        try {
            int pad = 6;
            int lineW = this.field_22793.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > this.field_22789 - 4) {
                x = this.field_22789 - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
            int textX = x + pad;
            int textY = y + pad - 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), textX, textY, -1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class_1799 getCubeItemStack(String type) {
        return switch (type) {
            case "breeder" -> new class_1799((class_1935)PocketVillagersModBlocks.BREEDER_POCKET_CUBE);
            case "converter" -> new class_1799((class_1935)PocketVillagersModBlocks.CONVERTER_POCKET_CUBE);
            case "auto_trader" -> new class_1799((class_1935)PocketVillagersModBlocks.AUTO_TRADER_POCKET_CUBE);
            case "iron_farm" -> new class_1799((class_1935)PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE);
            case "storage" -> new class_1799((class_1935)PocketVillagersModBlocks.STORAGE_POCKET_CUBE);
            case "farming" -> new class_1799((class_1935)PocketVillagersModBlocks.FARMING_POCKET_CUBE);
            case "mining" -> new class_1799((class_1935)PocketVillagersModBlocks.MINING_POCKET_CUBE);
            case "fishing" -> new class_1799((class_1935)PocketVillagersModBlocks.FISHING_POCKET_CUBE);
            default -> new class_1799((class_1935)PocketVillagersModBlocks.POCKET_CUBE);
        };
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.method_25290(class_10799.field_56883, texture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        try {
            int fuelPercent = 0;
            if (this.maxFuelTimer > 0 && this.terminalPowered) {
                fuelPercent = (int)Math.round(100.0 * (1.0 - (double)this.fuelTimer / (double)this.maxFuelTimer));
            }
            if (fuelPercent < 0) {
                fuelPercent = 0;
            }
            if (fuelPercent > 100) {
                fuelPercent = 100;
            }
            int barWidth = 40;
            int barHeight = 6;
            int barX = this.field_2776 + 103;
            int barY = this.field_2800 + 113;
            guiGraphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, 0x66000000);
            int filled = (int)Math.round((double)barWidth * ((double)fuelPercent / 100.0));
            int cyan = -1442775041;
            if (filled > 0) {
                guiGraphics.method_25294(barX, barY, barX + filled, barY + barHeight, cyan);
            }
            int outline = -1996488705;
            guiGraphics.method_25294(barX, barY - 1, barX + barWidth, barY, outline);
            guiGraphics.method_25294(barX, barY + barHeight, barX + barWidth, barY + barHeight + 1, outline);
            guiGraphics.method_25294(barX - 1, barY, barX, barY + barHeight, outline);
            guiGraphics.method_25294(barX + barWidth, barY, barX + barWidth + 1, barY + barHeight, outline);
            if (!this.terminalPowered) {
                String noFuelText = "\u00a7cNo Fuel";
                int textX = barX + barWidth / 2 - this.field_22793.method_1727(noFuelText) / 2;
                Objects.requireNonNull(this.field_22793);
                int textY = barY - 9 - 2;
                guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)noFuelText), textX, textY, 0xFFFFFF, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        if (!this.nearbyCubes.isEmpty()) {
            if (!this.cubeVillagers.isEmpty() || !this.nearbyCubes.isEmpty()) {
                this.renderVillagerList(guiGraphics);
            }
        } else {
            String info = "\u00a77No pocket cubes found";
            int infoX = this.field_2792 / 2 - this.field_22793.method_1727(info) / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)info), infoX, 40, -7829368, false);
        }
    }

    private void renderVillagerList(class_332 guiGraphics) {
        int i;
        int startY = 15;
        int lineHeight = 11;
        int maxLines = 8;
        int textLeftMargin = 11;
        LinkedHashMap<String, List> groupedByCube = new LinkedHashMap<String, List>();
        for (VillagerEntry entry : this.flatVillagerList) {
            Iterator<SyncNearbyCubesPayload.CubeInfo> key = entry.cubePos.method_23854();
            groupedByCube.computeIfAbsent((String)((Object)key), k -> new ArrayList()).add(entry);
        }
        ArrayList<DisplayLine> allLines = new ArrayList<DisplayLine>();
        HashSet<String> shownCubes = new HashSet<String>();
        for (SyncTerminalVillagersPayload.CubeVillagerData cubeData : this.cubeVillagers) {
            String cubeKey;
            List cubeVillagers;
            shownCubes.add(cubeData.cubePos.method_23854());
            String cubeHeader = "\u00a76" + cubeData.cubeName + " \u00a77(" + cubeData.villagers.size() + ")";
            allLines.add(new DisplayLine(cubeHeader, null, true));
            if (this.villagerListCollapsed || (cubeVillagers = (List)groupedByCube.get(cubeKey = cubeData.cubePos.method_23854())) == null) continue;
            for (VillagerEntry entry : cubeVillagers) {
                String villagerName = this.getVillagerDisplayName(entry.villagerData);
                allLines.add(new DisplayLine("  \u00a7f" + villagerName, entry, false));
            }
        }
        for (SyncNearbyCubesPayload.CubeInfo cube : this.nearbyCubes) {
            String cubeKey = cube.pos.method_23854();
            if (shownCubes.contains(cubeKey)) continue;
            String cubeName = cube.displayName != null && !cube.displayName.isEmpty() ? cube.displayName : cube.type;
            String cubeHeader = "\u00a76" + cubeName + " \u00a77(0)";
            allLines.add(new DisplayLine(cubeHeader, null, true));
        }
        int startIndex = this.villagerScrollOffset;
        int endIndex = Math.min(startIndex + maxLines, allLines.size());
        this.villagerButtonEntries.clear();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            DisplayLine line = (DisplayLine)allLines.get(i2);
            if (line.isHeader || line.entry == null || this.villagerListCollapsed) continue;
            this.villagerButtonEntries.add(line.entry);
        }
        this.ensureButtonsForVisibleVillagers(this.villagerButtonEntries.size());
        int buttonIndex = 0;
        for (i = startIndex; i < endIndex; ++i) {
            DisplayLine line = (DisplayLine)allLines.get(i);
            int y = startY + (i - startIndex) * lineHeight;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)line.text), textLeftMargin, y, -7829368, false);
            if (line.isHeader || line.entry == null || this.villagerListCollapsed || buttonIndex >= this.villagerTransferButtons.size()) continue;
            class_4185 btn = this.villagerTransferButtons.get(buttonIndex);
            btn.method_46421(this.field_2776 + this.field_2792 - 43);
            btn.method_46419(this.field_2800 + y - 1);
            btn.field_22764 = true;
            ++buttonIndex;
        }
        for (i = buttonIndex; i < this.villagerTransferButtons.size(); ++i) {
            this.villagerTransferButtons.get((int)i).field_22764 = false;
        }
        if (allLines.size() > maxLines) {
            int scrollbarX = this.field_2792 - 6;
            int scrollbarWidth = 3;
            int scrollbarTrackY = startY;
            int scrollbarTrackHeight = maxLines * lineHeight;
            guiGraphics.method_25294(scrollbarX, scrollbarTrackY, scrollbarX + scrollbarWidth, scrollbarTrackY + scrollbarTrackHeight, Integer.MIN_VALUE);
            float scrollPercent = (float)startIndex / (float)(allLines.size() - maxLines);
            float thumbHeightRatio = (float)maxLines / (float)allLines.size();
            int thumbHeight = Math.max(8, (int)((float)scrollbarTrackHeight * thumbHeightRatio));
            int thumbY = scrollbarTrackY + (int)((float)(scrollbarTrackHeight - thumbHeight) * scrollPercent);
            guiGraphics.method_25294(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, -16711681);
        }
    }

    private String getVillagerDisplayName(class_2487 villagerData) {
        try {
            Optional customNameOpt;
            if (villagerData.method_10545("CustomName") && (customNameOpt = villagerData.method_10558("CustomName")).isPresent()) {
                return (String)customNameOpt.get();
            }
            Object profession = "None";
            if (villagerData.method_10545("VillagerData.profession")) {
                profession = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                if (((String)profession).contains(":")) {
                    profession = ((String)profession).split(":")[1];
                }
                if (((String)profession).length() > 0) {
                    profession = ((String)profession).substring(0, 1).toUpperCase() + ((String)profession).substring(1);
                }
            }
            int level = 1;
            if (villagerData.method_10545("VillagerData.level")) {
                level = villagerData.method_10550("VillagerData.level").orElse(1);
            }
            Object type = "Plains";
            if (villagerData.method_10545("VillagerData.type")) {
                type = villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                if (((String)type).contains(":")) {
                    type = ((String)type).split(":")[1];
                }
                type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1);
            }
            boolean isConverted = false;
            if (villagerData.method_10545("PocketVillagers.Conversions")) {
                int conversions = villagerData.method_10550("PocketVillagers.Conversions").orElse(0);
                isConverted = conversions > 0;
            }
            String conversionTag = isConverted ? "\u00a7c(C)\u00a7f" : "";
            return (String)profession + conversionTag + " Lv" + level + " (" + (String)type + ")";
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public boolean keyPressed(int key, int b, int c) {
        if (this.selectingTransferTarget && key == 256) {
            this.exitSelectionMode();
            return true;
        }
        if (key == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 event, boolean isRepeat) {
        double mouseX = event.comp_4798();
        double mouseY = event.comp_4799();
        PocketVillagersMod.LOGGER.debug("[MOUSE] Click at ({}, {}) in selection mode: {}", (Object)mouseX, (Object)mouseY, (Object)this.selectingTransferTarget);
        if (this.selectingTransferTarget && this.availableCubes != null) {
            int adjustedMouseX = (int)mouseX;
            int adjustedMouseY = (int)mouseY;
            PocketVillagersMod.LOGGER.debug("[MOUSE] Adjusted coords: ({}, {})", (Object)adjustedMouseX, (Object)adjustedMouseY);
            int popupWidth = 160;
            int lineHeight = 12;
            int padding = 6;
            int titleHeight = lineHeight + 4;
            int maxVisibleCubes = Math.min(5, this.availableCubes.size());
            int cubesHeight = maxVisibleCubes * lineHeight;
            int cancelBtnHeight = 16;
            int popupHeight = padding + titleHeight + cubesHeight + cancelBtnHeight + padding;
            int popupX = this.popupX;
            int popupY = this.popupY;
            PocketVillagersMod.LOGGER.debug("[MOUSE] Popup bounds: ({}, {}) to ({}, {})", (Object)popupX, (Object)popupY, (Object)(popupX + popupWidth), (Object)(popupY + popupHeight));
            int startY = popupY + padding + titleHeight;
            int cubeStartIndex = this.selectionScrollOffset;
            int cubeEndIndex = Math.min(cubeStartIndex + maxVisibleCubes, this.availableCubes.size());
            for (int i = cubeStartIndex; i < cubeEndIndex; ++i) {
                int lineIndex = i - cubeStartIndex;
                int lineY = startY + lineIndex * lineHeight;
                PocketVillagersMod.LOGGER.debug("[MOUSE] Checking cube {} at line Y: {} (range {}-{})", (Object)i, (Object)lineY, (Object)lineY, (Object)(lineY + lineHeight));
                if (adjustedMouseX < popupX || adjustedMouseX > popupX + popupWidth || adjustedMouseY < lineY || adjustedMouseY >= lineY + lineHeight) continue;
                PocketVillagersMod.LOGGER.debug("[MOUSE] Clicked on cube {}", (Object)i);
                SyncNearbyCubesPayload.CubeInfo cube = this.availableCubes.get(i);
                if (this.transferringVillager != null) {
                    this.sendTransferPacket(this.transferringVillager.cubePos, this.transferringVillager.slotIndex, cube.pos);
                }
                this.exitSelectionMode();
                return true;
            }
            int cancelY = popupY + popupHeight - padding - cancelBtnHeight;
            PocketVillagersMod.LOGGER.debug("[MOUSE] Cancel button Y: {} (range {}-{})", (Object)cancelY, (Object)cancelY, (Object)(cancelY + cancelBtnHeight));
            if (adjustedMouseX >= popupX && adjustedMouseX <= popupX + popupWidth && adjustedMouseY >= cancelY && adjustedMouseY < cancelY + cancelBtnHeight) {
                PocketVillagersMod.LOGGER.debug("[MOUSE] Clicked cancel");
                this.exitSelectionMode();
                return true;
            }
            if (adjustedMouseX < popupX || adjustedMouseX > popupX + popupWidth || adjustedMouseY < popupY || adjustedMouseY > popupY + popupHeight) {
                PocketVillagersMod.LOGGER.debug("[MOUSE] Clicked outside popup");
                this.exitSelectionMode();
                return true;
            }
            PocketVillagersMod.LOGGER.debug("[MOUSE] Click inside popup but not on interactive element");
            return true;
        }
        PocketVillagersMod.LOGGER.debug("[MOUSE] Not in selection mode, calling super");
        return super.method_25402(event, isRepeat);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean mouseOverTabs;
        if (this.selectingTransferTarget && this.availableCubes != null) {
            int maxVisibleCubes = Math.min(5, this.availableCubes.size());
            if (this.availableCubes.size() > maxVisibleCubes) {
                if (scrollY > 0.0) {
                    this.selectionScrollOffset = Math.max(0, this.selectionScrollOffset - 1);
                } else if (scrollY < 0.0) {
                    this.selectionScrollOffset = Math.min(this.availableCubes.size() - maxVisibleCubes, this.selectionScrollOffset + 1);
                }
                return true;
            }
            return true;
        }
        int tabsLeft = this.field_2776 - 29;
        int tabsRight = this.field_2776;
        int tabsTop = this.field_2800;
        int tabsBottom = this.field_2800 + 210;
        boolean bl = mouseOverTabs = mouseX >= (double)tabsLeft && mouseX <= (double)tabsRight && mouseY >= (double)tabsTop && mouseY <= (double)tabsBottom;
        if (mouseOverTabs && this.nearbyCubes.size() > 7) {
            if (scrollY > 0.0) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
                this.rebuildCubeButtons();
            } else if (scrollY < 0.0) {
                this.scrollOffset = Math.min(this.nearbyCubes.size() - 7, this.scrollOffset + 1);
                this.rebuildCubeButtons();
            }
            return true;
        }
        if (!this.cubeVillagers.isEmpty() || !this.nearbyCubes.isEmpty()) {
            int totalLines = 0;
            HashSet<String> countedCubes = new HashSet<String>();
            for (SyncTerminalVillagersPayload.CubeVillagerData cubeData : this.cubeVillagers) {
                countedCubes.add(cubeData.cubePos.method_23854());
                ++totalLines;
                if (this.villagerListCollapsed) continue;
                totalLines += cubeData.villagers.size();
            }
            for (SyncNearbyCubesPayload.CubeInfo cube : this.nearbyCubes) {
                if (countedCubes.contains(cube.pos.method_23854())) continue;
                ++totalLines;
            }
            int maxLines = 8;
            if (totalLines > maxLines) {
                if (scrollY > 0.0) {
                    this.villagerScrollOffset = Math.max(0, this.villagerScrollOffset - 1);
                } else if (scrollY < 0.0) {
                    this.villagerScrollOffset = Math.min(totalLines - maxLines, this.villagerScrollOffset + 1);
                }
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.execute(() -> {
            if (this.field_22787.field_1755 == null && TerminalTabHelper.isViewingFromTerminal()) {
                TerminalTabHelper.clearViewingFromTerminal();
            }
        });
        SyncNearbyCubesPayload.clearCache();
        SyncTerminalVillagersPayload.clearCache();
    }

    public void updateVillagerList(List<SyncTerminalVillagersPayload.CubeVillagerData> villagers) {
        this.cubeVillagers = villagers;
        this.villagerScrollOffset = 0;
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL GUI] Updated villager list: {} cubes with villagers", (Object)villagers.size());
        this.rebuildVillagerList();
    }

    private void rebuildVillagerList() {
        this.flatVillagerList.clear();
        for (SyncTerminalVillagersPayload.CubeVillagerData cubeData : this.cubeVillagers) {
            for (SyncTerminalVillagersPayload.VillagerSlot villager : cubeData.villagers) {
                this.flatVillagerList.add(new VillagerEntry(cubeData.cubePos, cubeData.cubeType, villager.slotIndex, villager.villagerData));
            }
        }
    }

    private void ensureButtonsForVisibleVillagers(int neededCount) {
        while (this.villagerTransferButtons.size() > neededCount) {
            class_4185 btn = this.villagerTransferButtons.remove(this.villagerTransferButtons.size() - 1);
            this.method_37066((class_364)btn);
        }
        while (this.villagerTransferButtons.size() < neededCount) {
            int buttonIndex = this.villagerTransferButtons.size();
            class_4185 transferBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Move"), button -> {
                if (buttonIndex < this.villagerButtonEntries.size()) {
                    VillagerEntry entry = this.villagerButtonEntries.get(buttonIndex);
                    this.onTransferButtonClick(entry);
                }
            }).method_46434(0, 0, 34, 10).method_46431();
            this.method_37063((class_364)transferBtn);
            this.villagerTransferButtons.add(transferBtn);
        }
    }

    private void onTransferButtonClick(VillagerEntry entry) {
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Transfer button clicked for villager at {} slot {} cubeType={}", (Object)entry.cubePos, (Object)entry.slotIndex, (Object)entry.cubeType);
        if (entry.cubeType.equals("storage")) {
            this.showTransferSelectionGUI(entry);
        } else {
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Searching for storage cube with space. Total cubes: {}", (Object)this.nearbyCubes.size());
            class_2338 targetStorage = null;
            for (SyncNearbyCubesPayload.CubeInfo cube : this.nearbyCubes) {
                if (!cube.type.equals("storage") || !cube.hasSpace()) continue;
                targetStorage = cube.pos;
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Found storage with space: {} ({}/{})", (Object)cube.pos, (Object)cube.storageCount, (Object)cube.storageCapacity);
                break;
            }
            if (targetStorage != null) {
                ClientPlayNetworking.send((class_8710)new TransferVillagerPayload(entry.cubePos, entry.slotIndex, targetStorage, false));
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Sent transfer packet: {} slot {} -> {}", (Object)entry.cubePos, (Object)entry.slotIndex, (Object)targetStorage);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aTransferring villager to storage..."), true);
                }
            } else if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                boolean hasStorage = this.nearbyCubes.stream().anyMatch(c -> c.type.equals("storage"));
                if (hasStorage) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cAll storage cubes are full!"), true);
                } else {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo storage cube found nearby!"), true);
                }
            }
        }
    }

    private void showTransferSelectionGUI(VillagerEntry villagerEntry) {
        PocketVillagersMod.LOGGER.debug("[SELECTION] showTransferSelectionGUI called. nearbyCubes size: {}", (Object)this.nearbyCubes.size());
        ArrayList<SyncNearbyCubesPayload.CubeInfo> activeCubes = new ArrayList<SyncNearbyCubesPayload.CubeInfo>();
        for (SyncNearbyCubesPayload.CubeInfo cube : this.nearbyCubes) {
            PocketVillagersMod.LOGGER.debug("[SELECTION] Checking cube: {} at {}", (Object)cube.type, (Object)cube.pos);
            if (cube.pos.equals((Object)villagerEntry.cubePos)) {
                PocketVillagersMod.LOGGER.debug("[SELECTION] Skipping source cube");
                continue;
            }
            if (cube.type.equals("storage")) {
                PocketVillagersMod.LOGGER.debug("[SELECTION] Skipping storage cube");
                continue;
            }
            PocketVillagersMod.LOGGER.debug("[SELECTION] Adding active cube: {}", (Object)cube.type);
            activeCubes.add(cube);
        }
        PocketVillagersMod.LOGGER.debug("[SELECTION] Found {} active cubes", (Object)activeCubes.size());
        if (activeCubes.isEmpty()) {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo active cubes found nearby!"), true);
            }
            return;
        }
        if (activeCubes.size() == 1) {
            this.sendTransferPacket(villagerEntry.cubePos, villagerEntry.slotIndex, ((SyncNearbyCubesPayload.CubeInfo)activeCubes.get((int)0)).pos);
            return;
        }
        int popupWidth = 160;
        int lineHeight = 12;
        int padding = 6;
        int titleHeight = lineHeight + 4;
        int maxVisibleCubes = Math.min(5, activeCubes.size());
        int cubesHeight = maxVisibleCubes * lineHeight;
        int cancelBtnHeight = 16;
        int popupHeight = padding + titleHeight + cubesHeight + cancelBtnHeight + padding;
        this.popupX = (this.field_22789 - popupWidth) / 2 + 50;
        this.popupY = (this.field_22790 - popupHeight) / 2;
        if (this.popupX + popupWidth > this.field_22789 - 4) {
            this.popupX = this.field_22789 - popupWidth - 4;
        }
        if (this.popupY < 4) {
            this.popupY = 4;
        }
        if (this.popupY + popupHeight > this.field_22790 - 4) {
            this.popupY = this.field_22790 - popupHeight - 4;
        }
        this.selectingTransferTarget = true;
        this.transferringVillager = villagerEntry;
        this.availableCubes = activeCubes;
        this.selectionScrollOffset = 0;
        PocketVillagersMod.LOGGER.debug("[SELECTION] Entering selection mode with {} cubes at position ({},{})", (Object)activeCubes.size(), (Object)this.popupX, (Object)this.popupY);
        this.removedWidgets.clear();
        for (class_364 widget : new ArrayList(this.method_25396())) {
            if (widget == this) continue;
            this.removedWidgets.add(widget);
            this.method_37066(widget);
        }
        this.rebuildSelectionButtons();
    }

    private void rebuildSelectionButtons() {
        PocketVillagersMod.LOGGER.debug("[SELECTION] rebuildSelectionButtons called. availableCubes: {}", this.availableCubes != null ? Integer.valueOf(this.availableCubes.size()) : "null");
        if (this.availableCubes == null) {
            PocketVillagersMod.LOGGER.debug("[SELECTION] availableCubes is null");
        } else {
            PocketVillagersMod.LOGGER.debug("[SELECTION] Selection popup ready with {} cubes", (Object)this.availableCubes.size());
        }
    }

    private void sendTransferPacket(class_2338 fromPos, int slotIndex, class_2338 toPos) {
        ClientPlayNetworking.send((class_8710)new TransferVillagerPayload(fromPos, slotIndex, toPos, false));
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aTransferring villager..."), true);
        }
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Sent transfer packet: {} slot {} -> {}", (Object)fromPos, (Object)slotIndex, (Object)toPos);
    }

    private void exitSelectionMode() {
        PocketVillagersMod.LOGGER.debug("[SELECTION] Exiting selection mode");
        for (class_364 widget : this.removedWidgets) {
            if (!(widget instanceof class_4185)) continue;
            this.method_37063((class_364)((class_4185)widget));
        }
        this.removedWidgets.clear();
        this.selectingTransferTarget = false;
        this.transferringVillager = null;
        this.availableCubes = null;
        this.selectionScrollOffset = 0;
        for (class_4185 btn : this.selectionButtons) {
            this.method_37066((class_364)btn);
        }
        this.selectionButtons.clear();
        this.rebuildCubeButtons();
        this.rebuildVillagerList();
    }

    public void updateNearbyCubes(List<SyncNearbyCubesPayload.CubeInfo> cubes) {
        this.nearbyCubes = cubes;
        this.scrollOffset = 0;
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL GUI] Updated nearby cubes: {} cubes", (Object)cubes.size());
        this.rebuildCubeButtons();
    }

    private static class VillagerEntry {
        final class_2338 cubePos;
        final String cubeType;
        final int slotIndex;
        final class_2487 villagerData;

        VillagerEntry(class_2338 cubePos, String cubeType, int slotIndex, class_2487 villagerData) {
            this.cubePos = cubePos;
            this.cubeType = cubeType;
            this.slotIndex = slotIndex;
            this.villagerData = villagerData;
        }
    }

    private static class DisplayLine {
        final String text;
        final VillagerEntry entry;
        final boolean isHeader;

        DisplayLine(String text, VillagerEntry entry, boolean isHeader) {
            this.text = text;
            this.entry = entry;
            this.isHeader = isHeader;
        }
    }
}

