/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.Optional;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1324;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class CubeVillager
extends class_1646 {
    private class_2338 pocketCubePos = null;
    private class_1916 cachedOffers = null;
    private class_1657 tradingPlayer = null;
    private boolean frozen = false;
    private int conversionCount = 0;
    private int conversionTime = 0;

    public CubeVillager(class_1937 level) {
        super(class_1299.field_6077, level);
        try {
            class_1324 scaleAttr = this.method_5996(class_5134.field_47760);
            if (scaleAttr != null) {
                scaleAttr.method_6192(0.01);
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("Failed to set villager scale: {}", (Object)t.getMessage());
        }
    }

    public void setPocketCubePos(class_2338 pos) {
        this.pocketCubePos = pos;
    }

    public class_2338 getPocketCubePos() {
        return this.pocketCubePos;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void method_5697(class_1297 entity) {
        try {
            if (this.pocketCubePos != null) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.method_5697(entity);
    }

    public void setConversionCount(int count) {
        this.conversionCount = Math.max(0, Math.min(5, count));
    }

    public int getConversionCount() {
        return this.conversionCount;
    }

    public void setConversionTime(int time) {
        this.conversionTime = time;
    }

    public int getConversionTime() {
        return this.conversionTime;
    }

    public void method_19625(int xp) {
        if (this.frozen) {
            return;
        }
        super.method_19625(xp);
    }

    public void reloadDataFromNBT(class_2487 villagerNBT) {
        if (villagerNBT == null) {
            PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: villagerNBT is null!");
            return;
        }
        if (!villagerNBT.method_10545("VillagerData.profession")) {
            PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: VillagerData.profession not found in NBT");
            return;
        }
        class_3850 currentVD = this.method_7231();
        String profStr = villagerNBT.method_10558("VillagerData.profession").orElse("");
        String typeStr = villagerNBT.method_10558("VillagerData.type").orElse("");
        int levelVal = villagerNBT.method_10550("VillagerData.level").orElse(1);
        int xpVal = villagerNBT.method_10550("Xp").orElse(0);
        boolean isFrozen = villagerNBT.method_10577("Frozen").orElse(false);
        int conversionsVal = villagerNBT.method_10550("PocketVillagers.Conversions").orElse(0);
        int conversionTimeVal = villagerNBT.method_10550("ConversionTime").orElse(0);
        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: before setVillagerData - profession from NBT={} current profession on entity={} xp={} frozen={} conversions={} conversionTime={}", (Object)(profStr.isEmpty() ? "NONE" : profStr), (Object)((class_5321)currentVD.comp_3521().method_40230().orElseThrow()).method_29177().toString(), (Object)xpVal, (Object)isFrozen, (Object)conversionsVal, (Object)conversionTimeVal);
        try {
            if (!profStr.isEmpty() && !typeStr.isEmpty() && levelVal > 0) {
                String profession = profStr;
                String type = typeStr;
                int level = levelVal;
                class_2960 profRL = class_2960.method_60654((String)profession);
                Optional profOpt = class_7923.field_41195.method_10223(profRL);
                class_2960 typeRL = class_2960.method_60654((String)type);
                Optional typeOpt = class_7923.field_41194.method_10223(typeRL);
                if (profOpt.isPresent() && typeOpt.isPresent()) {
                    class_3850 reloadedVD;
                    this.method_7195(currentVD.method_16921((class_6880)profOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(level));
                    this.setFrozen(isFrozen);
                    if (conversionsVal > 0) {
                        this.setConversionCount(conversionsVal);
                        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: Applied conversion count: {}", (Object)conversionsVal);
                    }
                    if (conversionTimeVal > 0) {
                        this.setConversionTime(conversionTimeVal);
                        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: Applied ConversionTime: {}", (Object)conversionTimeVal);
                    }
                    if ("minecraft:none".equals(((class_5321)(reloadedVD = this.method_7231()).comp_3521().method_40230().orElseThrow()).method_29177().toString())) {
                        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: DETECTED PROFESSION RESET TO NONE RIGHT AFTER SETTING - retrying");
                        this.method_7195(reloadedVD.method_16921((class_6880)profOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(level));
                    }
                    PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: after setVillagerData - profession now={} xp now={}", (Object)((class_5321)this.method_7231().comp_3521().method_40230().orElseThrow()).method_29177().toString(), (Object)this.method_19269());
                }
            }
        }
        catch (Throwable e) {
            PocketVillagersMod.LOGGER.error("reloadDataFromNBT: Error loading villager data: {}", (Object)e.getMessage(), (Object)e);
        }
        if (villagerNBT.method_10545("Offers")) {
            try {
                class_2520 offersTag = villagerNBT.method_10580("Offers");
                if (offersTag != null && this.method_73183() != null) {
                    class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_73183().method_30349());
                    DataResult result = class_1916.field_48850.parse((DynamicOps)registryOps, (Object)offersTag);
                    if (result.result().isPresent()) {
                        class_1916 restored = (class_1916)result.result().get();
                        this.method_8261(restored);
                        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: Restored {} offers from NBT", (Object)restored.size());
                    } else {
                        PocketVillagersMod.LOGGER.debug("reloadDataFromNBT: Failed to parse Offers from NBT");
                    }
                }
            }
            catch (Throwable e) {
                PocketVillagersMod.LOGGER.error("reloadDataFromNBT: Error restoring offers: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public class_1916 method_8264() {
        class_1916 full;
        if (this.cachedOffers != null) {
            full = this.cachedOffers;
            PocketVillagersMod.LOGGER.debug("getOffers: Using cached offers, count={}", (Object)full.size());
        } else {
            full = super.method_8264();
            PocketVillagersMod.LOGGER.debug("getOffers: Using super.getOffers(), count={}", (Object)(full == null ? 0 : full.size()));
        }
        if (this.conversionCount > 0 && full != null) {
            PocketVillagersMod.LOGGER.debug("getOffers: Applying 90% discount - conversionCount={}", (Object)this.conversionCount);
            for (class_1914 offer : full) {
                try {
                    int baseCost = offer.method_8246().method_7947();
                    int discountAmount = (int)Math.floor((double)baseCost * 0.9);
                    int targetDiscount = -discountAmount;
                    int currentDiff = offer.method_19277();
                    if (currentDiff != targetDiscount) {
                        offer.method_19276();
                        offer.method_8245(targetDiscount);
                        PocketVillagersMod.LOGGER.debug("getOffers: Applied 90% discount to offer - baseCost: {}, discount: {}, was: {}, now: {}", (Object)baseCost, (Object)discountAmount, (Object)currentDiff, (Object)offer.method_19277());
                        continue;
                    }
                    PocketVillagersMod.LOGGER.debug("getOffers: Discount already applied - specialPriceDiff: {}", (Object)currentDiff);
                }
                catch (Throwable baseCost) {}
            }
        } else {
            PocketVillagersMod.LOGGER.debug("getOffers: NOT applying discounts - conversionCount={}, full null? {}", (Object)this.conversionCount, (Object)(full == null ? 1 : 0));
        }
        int currentLevel = this.method_7231().comp_3522();
        int maxTradesForLevel = Math.min(2 * currentLevel, 10);
        if (full != null && full.size() > maxTradesForLevel) {
            class_1916 trimmed = new class_1916();
            for (int i = 0; i < maxTradesForLevel && i < full.size(); ++i) {
                trimmed.add((Object)((class_1914)full.get(i)));
            }
            return trimmed;
        }
        return full;
    }

    public void method_16917(class_1916 offers) {
        if (this.conversionCount > 0 && offers != null) {
            PocketVillagersMod.LOGGER.debug("setOffers: Applying 90% discount - conversionCount={}, offers count={}", (Object)this.conversionCount, (Object)offers.size());
            for (class_1914 offer : offers) {
                try {
                    int baseCost = offer.method_8246().method_7947();
                    int discountAmount = (int)Math.floor((double)baseCost * 0.9);
                    int targetDiscount = -discountAmount;
                    int currentDiff = offer.method_19277();
                    if (currentDiff != targetDiscount) {
                        offer.method_19276();
                        offer.method_8245(targetDiscount);
                        PocketVillagersMod.LOGGER.debug("setOffers: Applied 90% discount to offer - baseCost: {}, discount: {}, was: {}, now: {}", (Object)baseCost, (Object)discountAmount, (Object)currentDiff, (Object)offer.method_19277());
                        continue;
                    }
                    PocketVillagersMod.LOGGER.debug("setOffers: Discount already applied to offer - specialPriceDiff: {}", (Object)currentDiff);
                }
                catch (Throwable throwable) {}
            }
        } else {
            PocketVillagersMod.LOGGER.debug("setOffers: NOT applying discounts - conversionCount={}, offers null? {}", (Object)this.conversionCount, (Object)(offers == null ? 1 : 0));
        }
        this.cachedOffers = offers;
        super.method_16917(offers);
    }

    public void method_8261(class_1916 offers) {
        this.method_16917(offers);
    }

    public void method_8259(class_1657 player) {
        this.tradingPlayer = player;
        super.method_8259(player);
    }

    public class_1657 method_8257() {
        if (this.tradingPlayer != null) {
            return this.tradingPlayer;
        }
        return super.method_8257();
    }

    public void method_8262(class_1914 offer) {
        class_3850 vd;
        int xpNeededForNextLevel;
        class_3850 villagerDataAfter;
        Field usesField;
        try {
            PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade BEFORE: XP={} level={} profession={} offer_xp={} frozen={}", (Object)this.method_19269(), (Object)this.method_7231().comp_3522(), (Object)((class_5321)this.method_7231().comp_3521().method_40230().orElseThrow()).method_29177(), offer == null ? "null" : Integer.valueOf(offer.method_19279()), (Object)this.frozen);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (offer != null) {
            try {
                Field usesField2 = class_1914.class.getDeclaredField("uses");
                usesField2.setAccessible(true);
                usesField2.setInt(offer, 0);
                Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
                maxUsesField.setAccessible(true);
                maxUsesField.setInt(offer, Integer.MAX_VALUE);
                PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade: Pre-trade exhaustion prevention applied - uses=0, maxUses=MAX");
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to prevent trade exhaustion (pre-trade): {}", (Object)t.getMessage());
            }
        }
        if (this.frozen) {
            PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade: Frozen villager - skipping XP gain");
            return;
        }
        class_6880 professionBefore = this.method_7231().comp_3521();
        class_6880 typeBefore = this.method_7231().comp_3520();
        int levelBefore = this.method_7231().comp_3522();
        super.method_8262(offer);
        if (offer != null) {
            try {
                usesField = class_1914.class.getDeclaredField("uses");
                usesField.setAccessible(true);
                usesField.setInt(offer, 0);
                PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade: Post-trade exhaustion reset - uses=0");
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to prevent trade exhaustion (post-trade): {}", (Object)t.getMessage());
            }
        }
        if (offer != null) {
            try {
                usesField = class_1914.class.getDeclaredField("uses");
                usesField.setAccessible(true);
                usesField.setInt(offer, 0);
                Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
                maxUsesField.setAccessible(true);
                maxUsesField.setInt(offer, Integer.MAX_VALUE);
                PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade: Reset trade exhaustion (uses=0, maxUses=MAX)");
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to reset trade exhaustion: {}", (Object)t.getMessage());
            }
        }
        if (!(villagerDataAfter = this.method_7231()).comp_3521().equals((Object)professionBefore)) {
            PocketVillagersMod.LOGGER.warn("CubeVillager.notifyTrade: profession was reset by vanilla! Restoring from {} to {}", (Object)villagerDataAfter.comp_3521(), (Object)professionBefore);
            this.method_7195(villagerDataAfter.method_16921(professionBefore).method_16922(typeBefore).method_16920(levelBefore));
        }
        try {
            PocketVillagersMod.LOGGER.debug("CubeVillager.notifyTrade AFTER: XP={} level={} profession={}", (Object)this.method_19269(), (Object)this.method_7231().comp_3522(), (Object)((class_5321)this.method_7231().comp_3521().method_40230().orElseThrow()).method_29177());
        }
        catch (Throwable maxUsesField) {
            // empty catch block
        }
        int currentXp = this.method_19269();
        int currentLevel = this.method_7231().comp_3522();
        switch (currentLevel) {
            case 1: {
                int n = 10;
                break;
            }
            case 2: {
                int n = 70;
                break;
            }
            case 3: {
                int n = 150;
                break;
            }
            case 4: {
                int n = 250;
                break;
            }
            case 5: {
                int n = Integer.MAX_VALUE;
                break;
            }
            default: {
                int n = xpNeededForNextLevel = Integer.MAX_VALUE;
            }
        }
        if (!this.frozen && currentLevel < 5 && currentXp >= xpNeededForNextLevel) {
            int newLevel = currentLevel + 1;
            PocketVillagersMod.LOGGER.debug("CubeVillager: XP threshold reached! currentXp={} >= needed={} for level {}. Forcing level up from {} to {}", (Object)currentXp, (Object)xpNeededForNextLevel, (Object)currentLevel, (Object)currentLevel, (Object)newLevel);
            class_3850 currentData = this.method_7231();
            class_6880 profToPreserve = currentData.comp_3521();
            class_6880 typeToPreserve = currentData.comp_3520();
            this.method_7195(currentData.method_16920(newLevel).method_16921(profToPreserve).method_16922(typeToPreserve));
            this.method_19625(0);
            this.method_7237();
            PocketVillagersMod.LOGGER.debug("CubeVillager: Level up complete! New level={} New XP={} New offers={}", (Object)newLevel, (Object)this.method_19269(), (Object)(this.method_8264() == null ? 0 : this.method_8264().size()));
            if (!this.method_73183().method_8608()) {
                try {
                    class_1657 tradingPlayer = this.method_8257();
                    if (tradingPlayer instanceof class_3222) {
                        class_3222 sp = (class_3222)tradingPlayer;
                        class_5250 message = class_2561.method_43470((String)("\u00a76[Villager] \u00a7eLevel Up! \u00a7fVillager advanced to level " + newLevel + ". \u00a77Close and reopen the GUI to see new trades."));
                        sp.method_7353((class_2561)message, false);
                        PocketVillagersMod.LOGGER.debug("CubeVillager: Notified player of level-up: level={}", (Object)newLevel);
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("CubeVillager: Failed to notify player: {}", (Object)t.getMessage());
                }
            }
        }
        if (this.method_7231().comp_3522() == 5 && "minecraft:none".equals(((class_5321)(vd = this.method_7231()).comp_3521().method_40230().orElseThrow()).method_29177().toString())) {
            PocketVillagersMod.LOGGER.warn("CubeVillager.notifyTrade: LEVEL 5 SAFETY CHECK - profession is none! This shouldn't happen!");
        }
        if (this.pocketCubePos != null && !this.method_73183().method_8608()) {
            try {
                VillagerDataHandler.saveVillagerDataToCube(this.method_73183(), this.pocketCubePos, this);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to save villager data after trade: {}", (Object)t.getMessage());
            }
        }
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_65125(class_1657 player) {
        return true;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (reason != class_1297.class_5529.field_26999 && this.pocketCubePos != null && !this.method_73183().method_8608()) {
            try {
                VillagerDataHandler.saveVillagerDataToCube(this.method_73183(), this.pocketCubePos, this);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to save villager data on remove: {}", (Object)t.getMessage());
            }
        }
        super.method_5650(reason);
    }

    public void forceSaveToCube() {
        if (this.pocketCubePos != null && !this.method_73183().method_8608()) {
            try {
                VillagerDataHandler.saveVillagerDataToCube(this.method_73183(), this.pocketCubePos, this);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("forceSaveToCube: Failed to save: {}", (Object)t.getMessage());
            }
        }
    }

    public int getUnlockedTradeCount() {
        class_1916 offers = this.method_8264();
        return offers != null ? offers.size() : 0;
    }

    public void setUnlockedTradeCount(int count) {
    }

    public void updateCachedUnlockedCount(int count) {
    }

    public void generateAllFutureOffers() {
    }
}

