/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.handler;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.mcreator.pocketvillagers.util.VillagerWorkstationResolver;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3966;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class VillagerCaptureHandler {
    public static void register() {
        UseEntityCallback.EVENT.register(VillagerCaptureHandler::onEntityInteract);
    }

    private static class_1269 onEntityInteract(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        boolean canCapture;
        class_1799 heldItem;
        class_1646 villager;
        block44: {
            PocketVillagersMod.LOGGER.info("VillagerCaptureHandler: onEntityInteract called for entity={} hand={}", (Object)entity, (Object)hand);
            if (!(entity instanceof class_1646)) {
                return class_1269.field_5811;
            }
            villager = (class_1646)entity;
            if (entity instanceof CubeVillager) {
                PocketVillagersMod.LOGGER.debug("Skipping capture of CubeVillager entity");
                return class_1269.field_5811;
            }
            heldItem = player.method_5998(hand);
            if (!villager.method_6109()) {
                try {
                    int villagerXp;
                    class_1747 blockItem;
                    class_2248 block;
                    String professionId;
                    class_1792 item;
                    class_3850 villagerData = villager.method_7231();
                    class_6880 professionHolder = villagerData.comp_3521();
                    class_3852 profession = (class_3852)professionHolder.comp_349();
                    class_2960 professionRl = class_7923.field_41195.method_10221((Object)profession);
                    boolean isUnemployed = professionRl != null && "minecraft:none".equals(professionRl.toString());
                    boolean isManuallyJobbed = villager.method_5752().contains("PocketVillagers.ManuallyJobbed");
                    if (!isUnemployed && !isManuallyJobbed || heldItem.method_7960() || !((item = heldItem.method_7909()) instanceof class_1747) || (professionId = VillagerWorkstationResolver.getProfessionForWorkstation(block = (blockItem = (class_1747)item).method_7711())) == null || professionId.isEmpty() || "minecraft:none".equals(professionId)) break block44;
                    if (!level.method_8608() && (villagerXp = villager.method_19269()) > 0) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot change profession - this villager has been traded with!"), true);
                        return class_1269.field_21466;
                    }
                    if (!level.method_8608()) {
                        class_2960 newProfessionRl = class_2960.method_60654((String)professionId);
                        Optional newProfessionOpt = class_7923.field_41195.method_10223(newProfessionRl);
                        if (!newProfessionOpt.isPresent()) break block44;
                        class_6880.class_6883 newProfessionHolder = (class_6880.class_6883)newProfessionOpt.get();
                        villager.method_7195(villagerData.method_16921((class_6880)newProfessionHolder).method_16920(1));
                        villager.method_5780("PocketVillagers.ManuallyJobbed");
                        try {
                            class_4095 brain = villager.method_18868();
                            class_4140 memoryModuleType = class_4140.field_18439;
                            class_4208 globalPos = class_4208.method_19443((class_5321)level.method_27983(), (class_2338)villager.method_24515());
                            brain.method_24525(memoryModuleType, (Object)globalPos, 999999999L);
                        }
                        catch (Throwable t) {
                            PocketVillagersMod.LOGGER.warn("Failed to set job site memory: {}", (Object)t.getMessage());
                        }
                        level.method_8396(null, villager.method_24515(), class_3417.field_14815, class_3419.field_15254, 1.0f, 1.0f);
                        if (!player.method_68878()) {
                            heldItem.method_7934(1);
                        }
                        String profName = professionId.replace("minecraft:", "").replace("_", " ");
                        String message = isManuallyJobbed ? "\u00a7aVillager changed to " + profName + "!" : "\u00a7aVillager is now a " + profName + "!";
                        player.method_7353((class_2561)class_2561.method_43470((String)message), true);
                        return class_1269.field_5812;
                    }
                    return class_1269.field_5812;
                }
                catch (Throwable t) {
                    try {
                        PocketVillagersMod.LOGGER.warn("Error in workstation jobbing: {}", (Object)t.getMessage());
                    }
                    catch (Throwable professionHolder) {
                        // empty catch block
                    }
                }
            }
        }
        if (villager.method_6109()) {
            try {
                if (level.method_8608()) {
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot capture baby villagers"), true);
                return class_1269.field_5812;
            }
            catch (Throwable t) {
                return class_1269.field_5812;
            }
        }
        try {
            PocketVillagersMod.LOGGER.debug("onEntityInteract: player={}, hand={}, held={}, levelClient={}", (Object)(player == null ? "<null>" : player.method_5477().getString()), (Object)hand, (Object)(heldItem == null ? "<null>" : heldItem.method_7909().toString()), (Object)level.method_8608());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            class_1792 item = heldItem.method_7909();
            if (item != PocketVillagersModBlocks.POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.AUTO_TRADER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.STORAGE_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.CONVERTER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.BREEDER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE.method_8389()) {
                try {
                    PocketVillagersMod.LOGGER.debug("Not holding pocket cube: held={}", (Object)item);
                }
                catch (Throwable professionHolder) {
                    // empty catch block
                }
                return class_1269.field_5811;
            }
            try {
                if (item == PocketVillagersModBlocks.CONVERTER_POCKET_CUBE.method_8389() && VillagerDataHandler.isConvertedEntity(villager)) {
                    if (level.method_8608()) {
                        return class_1269.field_5812;
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis villager has already been converted and cannot be captured."), true);
                    return class_1269.field_5814;
                }
            }
            catch (Throwable professionHolder) {
                // empty catch block
            }
            if (item == PocketVillagersModBlocks.STORAGE_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleStorageCubeCapture(player, level, villager, heldItem);
            }
            if (item == PocketVillagersModBlocks.BREEDER_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleBreederCubeCapture(player, level, villager, heldItem);
            }
            if (item == PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleIronFarmCubeCapture(player, level, villager, heldItem);
            }
            if (item == PocketVillagersModBlocks.AUTO_TRADER_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleAutoTraderCubeCapture(player, level, villager, heldItem);
            }
        }
        catch (Throwable t) {
            try {
                PocketVillagersMod.LOGGER.warn("Error comparing held item to pocket cube: {}", (Object)t.getMessage());
            }
            catch (Throwable professionHolder) {
                // empty catch block
            }
            return class_1269.field_5811;
        }
        boolean bl = canCapture = !VillagerDataHandler.hasVillager(heldItem);
        if (level.method_8608()) {
            try {
                PocketVillagersMod.LOGGER.debug("client-side: handled (would capture on server)");
            }
            catch (Throwable professionHolder) {
                // empty catch block
            }
            return class_1269.field_5812;
        }
        if (!canCapture) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This Pocket Cube already contains a villager!"), true);
            return class_1269.field_5812;
        }
        try {
            class_1792 item = heldItem.method_7909();
            if (item == PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389()) {
                String professionStr = villager.method_7231().comp_3521().method_40230().map(k -> k.method_29177().toString()).orElse("minecraft:none");
                if ("minecraft:none".equals(professionStr) || professionStr.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Unemployed villagers cannot be used for automation"), true);
                    return class_1269.field_5814;
                }
                if (item == PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() && !"minecraft:armorer".equals(professionStr)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Armorer villagers!"), true);
                    return class_1269.field_5814;
                }
                if (item == PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() && !"minecraft:fisherman".equals(professionStr)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Fisherman villagers!"), true);
                    return class_1269.field_5814;
                }
                if (item == PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389() && !"minecraft:farmer".equals(professionStr)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Farmer villagers!"), true);
                    return class_1269.field_5814;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PocketVillagersMod.LOGGER.info("About to call storeVillagerInItem for villager={} heldItem={}", (Object)villager, (Object)heldItem);
        VillagerDataHandler.storeVillagerInItem(heldItem, villager, level);
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7bVillager Captured!"), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleStorageCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        class_2487 villagerData;
        int villagerCount;
        class_2487 tag;
        block14: {
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            class_9279 customData = (class_9279)heldItem.method_58694(class_9334.field_49628);
            tag = customData != null ? customData.method_57461() : new class_2487();
            villagerCount = 0;
            for (int i = 0; i < 10; ++i) {
                if (!tag.method_10545("Villager" + i)) continue;
                ++villagerCount;
            }
            if (villagerCount >= 10) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 10 villagers"), true);
                return class_1269.field_5814;
            }
            villagerData = new class_2487();
            villagerData.method_10582("id", "minecraft:villager");
            class_3850 villagerDataObj = villager.method_7231();
            String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
            String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
            int villagerLevel = villagerDataObj.comp_3522();
            villagerData.method_10582("VillagerData.profession", professionStr);
            villagerData.method_10582("VillagerData.type", typeStr);
            villagerData.method_10569("VillagerData.level", villagerLevel);
            villagerData.method_10569("Xp", villager.method_19269());
            class_1916 offers = villager.method_8264();
            if (offers != null && !offers.isEmpty()) {
                try {
                    class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                    DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)offers);
                    if (result.result().isPresent()) {
                        villagerData.method_10566("Offers", (class_2520)result.result().get());
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("Failed to encode offers: {}", (Object)t.getMessage());
                }
            }
            if (villager.method_16914()) {
                villagerData.method_10582("CustomName", villager.method_5797().getString());
            }
            try {
                Set tags = villager.method_5752();
                if (tags == null) break block14;
                for (String t : tags) {
                    try {
                        if (t == null || !t.startsWith("PocketVillagers.Conversions=")) continue;
                        int conversions = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                        villagerData.method_10569("PocketVillagers.Conversions", conversions);
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable tags) {
                // empty catch block
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (tag.method_10545("Villager" + i)) continue;
            tag.method_10566("Villager" + i, (class_2520)villagerData);
            break;
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/10)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleBreederCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        try {
            String prof = villager.method_7231().comp_3521().method_40230().map(k -> k.method_29177().toString()).orElse("minecraft:none");
            if (!"minecraft:none".equals(prof) && !prof.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBreeder pocket cube can only capture unemployed villagers!"), true);
                return class_1269.field_5814;
            }
        }
        catch (Throwable prof) {
            // empty catch block
        }
        class_9279 customData = (class_9279)heldItem.method_58694(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        int villagerCount = 0;
        for (int i = 0; i < 2; ++i) {
            if (!tag.method_10545("Villager" + i)) continue;
            ++villagerCount;
        }
        if (villagerCount >= 2) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 2 villagers"), true);
            return class_1269.field_5814;
        }
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        class_3850 villagerDataObj = villager.method_7231();
        String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
        String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
        int villagerLevel = villagerDataObj.comp_3522();
        villagerData.method_10582("VillagerData.profession", professionStr);
        villagerData.method_10582("VillagerData.type", typeStr);
        villagerData.method_10569("VillagerData.level", villagerLevel);
        villagerData.method_10569("Xp", villager.method_19269());
        class_1916 offers = villager.method_8264();
        if (offers != null && !offers.isEmpty()) {
            try {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)offers);
                if (result.result().isPresent()) {
                    villagerData.method_10566("Offers", (class_2520)result.result().get());
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to encode offers: {}", (Object)t.getMessage());
            }
        }
        if (villager.method_16914()) {
            villagerData.method_10582("CustomName", villager.method_5797().getString());
        }
        for (int i = 0; i < 2; ++i) {
            if (tag.method_10545("Villager" + i)) continue;
            tag.method_10566("Villager" + i, (class_2520)villagerData);
            break;
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/2)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleIronFarmCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        try {
            String prof = villager.method_7231().comp_3521().method_40230().map(k -> k.method_29177().toString()).orElse("minecraft:none");
            if (!"minecraft:none".equals(prof) && !prof.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cIron Farm pocket cube can only capture unemployed villagers!"), true);
                return class_1269.field_5814;
            }
        }
        catch (Throwable prof) {
            // empty catch block
        }
        class_9279 customData = (class_9279)heldItem.method_58694(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        int villagerCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (!tag.method_10545("Villager" + i)) continue;
            ++villagerCount;
        }
        if (villagerCount >= 3) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 3 villagers"), true);
            return class_1269.field_5814;
        }
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        class_3850 villagerDataObj = villager.method_7231();
        String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
        String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
        int villagerLevel = villagerDataObj.comp_3522();
        villagerData.method_10582("VillagerData.profession", professionStr);
        villagerData.method_10582("VillagerData.type", typeStr);
        villagerData.method_10569("VillagerData.level", villagerLevel);
        villagerData.method_10569("Xp", villager.method_19269());
        class_1916 offers = villager.method_8264();
        if (offers != null && !offers.isEmpty()) {
            try {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)offers);
                if (result.result().isPresent()) {
                    villagerData.method_10566("Offers", (class_2520)result.result().get());
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to encode offers: {}", (Object)t.getMessage());
            }
        }
        if (villager.method_16914()) {
            villagerData.method_10582("CustomName", villager.method_5797().getString());
        }
        for (int i = 0; i < 3; ++i) {
            if (tag.method_10545("Villager" + i)) continue;
            tag.method_10566("Villager" + i, (class_2520)villagerData);
            break;
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/3)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleAutoTraderCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        class_9279 customData;
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_3850 villagerDataObj = villager.method_7231();
        String professionStr = villagerDataObj.comp_3521().method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:none");
        if ("minecraft:none".equals(professionStr) || professionStr.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cAuto Trader requires a villager with a profession!"), true);
            return class_1269.field_5814;
        }
        if (VillagerDataHandler.hasVillager(heldItem)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis Auto Trader already contains a villager!"), true);
            return class_1269.field_5814;
        }
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
        int villagerLevel = villagerDataObj.comp_3522();
        villagerData.method_10582("VillagerData.profession", professionStr);
        villagerData.method_10582("VillagerData.type", typeStr);
        villagerData.method_10569("VillagerData.level", villagerLevel);
        villagerData.method_10569("Xp", villager.method_19269());
        villagerData.method_10556("Frozen", true);
        class_1916 offers = villager.method_8264();
        if (offers != null && !offers.isEmpty()) {
            try {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)offers);
                if (result.result().isPresent()) {
                    villagerData.method_10566("Offers", (class_2520)result.result().get());
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("Failed to encode offers: {}", (Object)t.getMessage());
            }
        }
        if (villager.method_16914()) {
            villagerData.method_10582("CustomName", villager.method_5797().getString());
        }
        class_2487 tag = (customData = (class_9279)heldItem.method_58694(class_9334.field_49628)) != null ? customData.method_57461() : new class_2487();
        tag.method_10566("Villager0", (class_2520)villagerData);
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b" + ((class_5321)villager.method_7231().comp_3521().method_40230().orElseThrow()).method_29177().method_12832() + " captured!")), true);
        return class_1269.field_5812;
    }
}

