/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Method;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.PocketCubeBlock;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RefreshTradesPacket(class_2338 pos, boolean silent, int desiredCount) implements class_8710
{
    public static final class_9139<class_2540, RefreshTradesPacket> CODEC = class_9139.method_56436((class_9139)class_2338.field_48404, RefreshTradesPacket::pos, (class_9139)class_9135.field_48547, RefreshTradesPacket::silent, (class_9139)class_9135.field_49675, RefreshTradesPacket::desiredCount, RefreshTradesPacket::new);
    public static final class_8710.class_9154<RefreshTradesPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"refresh_trades"));

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(TYPE, (packet, context) -> {
            class_3222 player = context.player();
            class_2338 pos = packet.pos();
            context.server().execute(() -> {
                class_3218 world = player.method_51469();
                if (world == null) {
                    return;
                }
                class_2586 be = world.method_8321(pos);
                if (!(be instanceof PocketCubeBlockEntity)) {
                    return;
                }
                PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
                if (!cube.hasVillager()) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"No villager data to refresh"));
                    return;
                }
                try {
                    PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: received refresh request from {} for pos={}", (Object)player.method_5477().getString(), (Object)pos);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                class_2487 vd = cube.getVillagerData();
                int xp = 0;
                int lvl = 1;
                int conversions = 0;
                try {
                    if (vd != null && vd.method_10545("Xp")) {
                        xp = vd.method_10550("Xp").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (vd != null && vd.method_10545("VillagerData.level")) {
                        lvl = vd.method_10550("VillagerData.level").orElse(1);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (vd != null && vd.method_10545("PocketVillagers.Conversions")) {
                        conversions = vd.method_10550("PocketVillagers.Conversions").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: villager XP={} level={} conversions={}", (Object)xp, (Object)lvl, (Object)conversions);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (xp > 0 || lvl > 1) {
                    try {
                        PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: rejecting refresh because villager progressed");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    player.method_64398((class_2561)class_2561.method_43470((String)"Cannot refresh trades: villager has already progressed."));
                    return;
                }
                try {
                    class_1916 offers;
                    PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: attempting to refresh trades at pos={}", (Object)pos);
                    class_2487 freshVillagerData = cube.getVillagerData().method_10553();
                    int conversionTime = 0;
                    if (freshVillagerData.method_10545("PocketVillagers.Conversions")) {
                        conversions = freshVillagerData.method_10550("PocketVillagers.Conversions").orElse(0);
                    }
                    if (freshVillagerData.method_10545("ConversionTime")) {
                        conversionTime = freshVillagerData.method_10550("ConversionTime").orElse(0);
                    }
                    freshVillagerData.method_10551("Offers");
                    CubeVillager refreshedVillager = VillagerDataHandler.regenerateBaseOffers(player.method_51469(), pos, freshVillagerData, 10);
                    if (refreshedVillager == null) {
                        try {
                            PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: regeneration failed for pos={}", (Object)pos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        player.method_64398((class_2561)class_2561.method_43470((String)"Failed to refresh trades."));
                        return;
                    }
                    if (conversions > 0 && refreshedVillager instanceof CubeVillager) {
                        CubeVillager cubeVillager = refreshedVillager;
                        cubeVillager.setConversionCount(conversions);
                        if (conversionTime > 0) {
                            cubeVillager.setConversionTime(conversionTime);
                        }
                        try {
                            PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: restored conversion discount - conversions={} conversionTime={}", (Object)conversions, (Object)conversionTime);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if ((offers = refreshedVillager.method_8264()) == null || offers.isEmpty()) {
                        try {
                            PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: no offers after refresh for pos={}", (Object)pos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        player.method_64398((class_2561)class_2561.method_43470((String)"No trades available."));
                        return;
                    }
                    try {
                        PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: regenerated {} base offers", (Object)offers.size());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        PocketCubeBlock.saveVillagerDataToCube((class_1937)player.method_51469(), pos, refreshedVillager);
                        cube.method_5431();
                        try {
                            PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: saved refreshed villager data back to cube");
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable t) {
                        try {
                            PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: failed to save villager data: {}", (Object)t.getMessage());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    int levelNum = refreshedVillager.method_7231().comp_3522();
                    int xpNow = refreshedVillager.method_19269();
                    class_1916 offersToSend = offers;
                    try {
                        Class<?> villagerDuckClass = Class.forName("net.ramixin.visibletraders.ducks.VillagerDuck");
                        if (villagerDuckClass.isInstance((Object)refreshedVillager)) {
                            Method regenerateMethod = villagerDuckClass.getMethod("visibleTrades$regenerateTrades", new Class[0]);
                            regenerateMethod.invoke((Object)refreshedVillager, new Object[0]);
                            Method getCombinedMethod = villagerDuckClass.getMethod("visibleTraders$getCombinedOffers", new Class[0]);
                            Object combined = getCombinedMethod.invoke((Object)refreshedVillager, new Object[0]);
                            if (combined instanceof class_1916) {
                                offersToSend = (class_1916)combined;
                                try {
                                    PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: using combined offers from Visible Traders (base + locked): {} total", (Object)offersToSend.size());
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                    catch (ClassNotFoundException villagerDuckClass) {
                    }
                    catch (Throwable t) {
                        try {
                            PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: failed to get Visible Traders combined offers: {}", (Object)t.getMessage());
                        }
                        catch (Throwable regenerateMethod) {
                            // empty catch block
                        }
                    }
                    int unlockedToSet = 0;
                    try {
                        PocketCubeBlockEntity cubeBe;
                        class_2586 be2 = world.method_8321(pos);
                        if (be2 instanceof PocketCubeBlockEntity && (cubeBe = (PocketCubeBlockEntity)be2).hasWorkstation()) {
                            int lvl2 = Math.max(1, levelNum);
                            int levelBased = switch (lvl2) {
                                case 1 -> 2;
                                case 2 -> 4;
                                case 3 -> 6;
                                case 4 -> 8;
                                case 5 -> 10;
                                default -> 2;
                            };
                            int offersSz = offersToSend == null ? 0 : offersToSend.size();
                            unlockedToSet = Math.min(levelBased, offersSz);
                        } else {
                            unlockedToSet = 0;
                        }
                    }
                    catch (Throwable be2) {
                        // empty catch block
                    }
                    try {
                        int containerId = -1;
                        if (player.field_7512 != null) {
                            containerId = player.field_7512.field_7763;
                        }
                        int packedLevel = (unlockedToSet & 0xFF) << 8 | levelNum & 0xFF;
                        try {
                            PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: sending offers packet containerId={} offers={} level={} xp={} unlockedCount={} packedLevel={}", (Object)containerId, (Object)(offersToSend == null ? 0 : offersToSend.size()), (Object)levelNum, (Object)xpNow, (Object)unlockedToSet, (Object)packedLevel);
                        }
                        catch (Throwable lvl2) {
                            // empty catch block
                        }
                        try {
                            boolean hasWorkstation = false;
                            try {
                                class_2586 be2 = world.method_8321(pos);
                                if (be2 instanceof PocketCubeBlockEntity) {
                                    PocketCubeBlockEntity cubeBe = (PocketCubeBlockEntity)be2;
                                    hasWorkstation = cubeBe.hasWorkstation();
                                }
                            }
                            catch (Throwable be2) {
                                // empty catch block
                            }
                            try {
                                SyncPocketCubePayload.send(player, pos, hasWorkstation, levelNum, xpNow);
                            }
                            catch (Throwable be2) {}
                        }
                        catch (Throwable hasWorkstation) {
                            // empty catch block
                        }
                        player.method_17354(containerId, offersToSend, packedLevel, xpNow, true, false);
                        try {
                            PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: sent offers via player.sendMerchantOffers() with packed level={}", (Object)packedLevel);
                        }
                        catch (Throwable hasWorkstation) {
                            // empty catch block
                        }
                        try {
                            int resultSlot = 2;
                            try {
                                class_2371 slots = player.field_7512.field_7761;
                                for (int si = 0; si < slots.size(); ++si) {
                                    Object sObj = slots.get(si);
                                    if (sObj == null) continue;
                                    String fqcn = sObj.getClass().getName();
                                    String simple = sObj.getClass().getSimpleName().toLowerCase();
                                    if (!fqcn.equals("net.minecraft.world.inventory.MerchantResultSlot") && !simple.contains("merchantresultslot") && !simple.contains("resultslot") && !simple.contains("merchantresult")) continue;
                                    resultSlot = si;
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                player.field_7512.method_34245(resultSlot, class_1799.field_8037);
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable pkt) {
                        try {
                            PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: failed to send offers packet: {}", (Object)pkt.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        if (!packet.silent()) {
                            player.method_64398((class_2561)class_2561.method_43470((String)"Trades refreshed."));
                        }
                    }
                    catch (Throwable ignoredNotify) {
                        try {
                            player.method_64398((class_2561)class_2561.method_43470((String)"Trades refreshed."));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        PocketVillagersMod.LOGGER.debug("RefreshTradesPacket: regeneration successful for pos={}", (Object)pos);
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    try {
                        PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: regeneration failed: {}", (Object)t.toString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    player.method_64398((class_2561)class_2561.method_43470((String)"Failed to regenerate trades."));
                }
            });
        });
    }
}

