/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.AutoTraderPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record TransferVillagerBetweenCubesPayload(class_2338 fromCube, int fromSlot, class_2338 toCube) implements class_8710
{
    public static final class_8710.class_9154<TransferVillagerBetweenCubesPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"transfer_villager_between_cubes"));
    public static final class_9139<class_2540, TransferVillagerBetweenCubesPayload> CODEC = class_9139.method_56437((buf, payload) -> {
        buf.method_10807(payload.fromCube);
        buf.method_53002(payload.fromSlot);
        buf.method_10807(payload.toCube);
    }, buf -> {
        class_2338 fromCube = buf.method_10811();
        int fromSlot = buf.readInt();
        class_2338 toCube = buf.method_10811();
        return new TransferVillagerBetweenCubesPayload(fromCube, fromSlot, toCube);
    });

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> {
                try {
                    class_3218 level = player.method_51469();
                    class_2586 fromBE = level.method_8321(payload.fromCube);
                    if (fromBE == null) {
                        return;
                    }
                    class_2586 toBE = level.method_8321(payload.toCube);
                    if (toBE == null) {
                        return;
                    }
                    class_2487 villagerData = TransferVillagerBetweenCubesPayload.getVillagerDataFromCube(fromBE, payload.fromSlot);
                    if (villagerData == null || villagerData.method_33133()) {
                        return;
                    }
                    if (toBE instanceof StoragePocketCubeBlockEntity) {
                        StoragePocketCubeBlockEntity storageBE = (StoragePocketCubeBlockEntity)toBE;
                        boolean success = storageBE.addVillager(villagerData);
                        if (success) {
                            TransferVillagerBetweenCubesPayload.removeVillagerFromCube(fromBE, payload.fromSlot);
                            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aVillager transferred to storage!"), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cStorage cube is full!"), true);
                        }
                    }
                }
                catch (Exception e) {
                    PocketVillagersMod.LOGGER.error("Failed to transfer villager: " + e.getMessage());
                }
            });
        });
    }

    private static class_2487 getVillagerDataFromCube(class_2586 be, int slot) {
        if (be instanceof StoragePocketCubeBlockEntity) {
            StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)be;
            return storage.getVillager(slot);
        }
        if (be instanceof BreederPocketCubeBlockEntity) {
            BreederPocketCubeBlockEntity breeder = (BreederPocketCubeBlockEntity)be;
            return breeder.getVillagerData(slot);
        }
        if (be instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converter = (ConverterPocketCubeBlockEntity)be;
            return converter.getVillagerData();
        }
        if (be instanceof AutoTraderPocketCubeBlockEntity) {
            AutoTraderPocketCubeBlockEntity trader = (AutoTraderPocketCubeBlockEntity)be;
            return trader.getVillagerData();
        }
        if (be instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarm = (IronFarmPocketCubeBlockEntity)be;
            return ironFarm.getVillagerData(slot);
        }
        if (be instanceof FarmingPocketCubeBlockEntity) {
            FarmingPocketCubeBlockEntity farming = (FarmingPocketCubeBlockEntity)be;
            return farming.getVillagerData();
        }
        if (be instanceof MiningPocketCubeBlockEntity) {
            MiningPocketCubeBlockEntity mining = (MiningPocketCubeBlockEntity)be;
            return mining.getVillagerData();
        }
        if (be instanceof FishingPocketCubeBlockEntity) {
            FishingPocketCubeBlockEntity fishing = (FishingPocketCubeBlockEntity)be;
            return fishing.getVillagerData();
        }
        if (be instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity pocketCube = (PocketCubeBlockEntity)be;
            return pocketCube.getVillagerData();
        }
        return new class_2487();
    }

    private static void removeVillagerFromCube(class_2586 be, int slot) {
        class_2487 empty = new class_2487();
        if (be instanceof StoragePocketCubeBlockEntity) {
            StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)be;
            storage.removeVillager(slot);
        } else if (be instanceof BreederPocketCubeBlockEntity) {
            BreederPocketCubeBlockEntity breeder = (BreederPocketCubeBlockEntity)be;
            breeder.setVillagerData(slot, empty);
            breeder.method_5431();
        } else if (be instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converter = (ConverterPocketCubeBlockEntity)be;
            converter.setVillagerData(empty);
            converter.method_5431();
        } else if (be instanceof AutoTraderPocketCubeBlockEntity) {
            AutoTraderPocketCubeBlockEntity trader = (AutoTraderPocketCubeBlockEntity)be;
            trader.setVillagerData(empty);
            trader.method_5431();
        } else if (be instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarm = (IronFarmPocketCubeBlockEntity)be;
            ironFarm.setVillagerData(slot, empty);
            ironFarm.method_5431();
        } else if (be instanceof FarmingPocketCubeBlockEntity) {
            FarmingPocketCubeBlockEntity farming = (FarmingPocketCubeBlockEntity)be;
            farming.setVillagerData(empty);
            farming.method_5431();
        } else if (be instanceof MiningPocketCubeBlockEntity) {
            MiningPocketCubeBlockEntity mining = (MiningPocketCubeBlockEntity)be;
            mining.setVillagerData(empty);
            mining.method_5431();
        } else if (be instanceof FishingPocketCubeBlockEntity) {
            FishingPocketCubeBlockEntity fishing = (FishingPocketCubeBlockEntity)be;
            fishing.setVillagerData(empty);
            fishing.method_5431();
        } else if (be instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity pocketCube = (PocketCubeBlockEntity)be;
            pocketCube.setVillagerData(empty);
            pocketCube.method_5431();
        }
    }
}

