/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class VillagerWorkstationResolver {
    private static final Map<String, class_1799> CACHE = new ConcurrentHashMap<String, class_1799>();
    private static final Map<String, String> VANILLA_WORKSTATIONS = new ConcurrentHashMap<String, String>();

    public static class_1799 getWorkstationForProfession(class_1937 level, String professionId) {
        block42: {
            try {
                class_7922 profReg;
                if (professionId == null || professionId.isEmpty() || "minecraft:none".equals(professionId)) {
                    return class_1799.field_8037;
                }
                class_1799 cached = CACHE.get(professionId);
                if (cached != null) {
                    return cached;
                }
                try {
                    for (Map.Entry<String, String> e : PocketVillagersMod.COMPAT_WORKSTATION_PROFESSION.entrySet()) {
                        try {
                            if (!professionId.equals(e.getValue())) continue;
                            class_2960 blockRl = class_2960.method_60654((String)e.getKey());
                            try {
                                class_2248 blk;
                                block41: {
                                    Optional optHolder = class_7923.field_41175.method_17966(blockRl);
                                    if (!optHolder.isPresent()) continue;
                                    Object candidate = optHolder.get();
                                    blk = null;
                                    try {
                                        if (candidate instanceof class_6880) {
                                            try {
                                                Object val = ((class_6880)candidate).comp_349();
                                                if (val instanceof class_2248) {
                                                    blk = (class_2248)val;
                                                }
                                                break block41;
                                            }
                                            catch (Throwable val) {}
                                            break block41;
                                        }
                                        if (candidate instanceof class_2248) {
                                            blk = (class_2248)candidate;
                                        }
                                    }
                                    catch (Throwable val) {
                                        // empty catch block
                                    }
                                }
                                if (blk == null) continue;
                                try {
                                    class_1792 item = blk.method_8389();
                                    if (item == null) continue;
                                    class_1799 res = new class_1799((class_1935)item);
                                    CACHE.put(professionId, res);
                                    return res;
                                }
                                catch (Throwable item) {
                                }
                            }
                            catch (Throwable optHolder) {
                            }
                        }
                        catch (Throwable blockRl) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((profReg = class_7923.field_41195) == null) {
                    return class_1799.field_8037;
                }
                for (Map.Entry entry : profReg.method_29722()) {
                    try {
                        Collection states;
                        block44: {
                            class_5321 key = (class_5321)entry.getKey();
                            if (key == null) continue;
                            class_2960 rl = null;
                            try {
                                rl = key.method_29177();
                            }
                            catch (Throwable blk) {
                                // empty catch block
                            }
                            if (rl == null || !professionId.equals(rl.toString())) continue;
                            class_3852 profObj = (class_3852)entry.getValue();
                            if (profObj == null) break block42;
                            Object profPoi = null;
                            try {
                                try {
                                    Method m = profObj.getClass().getMethod("pointOfInterest", new Class[0]);
                                    profPoi = m.invoke((Object)profObj, new Object[0]);
                                }
                                catch (Throwable t1) {
                                    try {
                                        Method m2 = profObj.getClass().getMethod("getPointOfInterest", new Class[0]);
                                        profPoi = m2.invoke((Object)profObj, new Object[0]);
                                    }
                                    catch (Throwable m2) {}
                                }
                            }
                            catch (Throwable t1) {
                                // empty catch block
                            }
                            if (profPoi == null) break block42;
                            states = null;
                            try {
                                Method[] methods;
                                for (Method m : methods = profPoi.getClass().getMethods()) {
                                    Object ret;
                                    String name = m.getName();
                                    if (!name.equals("matchingStates") && !name.equals("getMatchingStates") && !name.equals("validStates") && !name.equals("getValidStates") || !Collection.class.isAssignableFrom(m.getReturnType()) || !((ret = m.invoke(profPoi, new Object[0])) instanceof Collection)) continue;
                                    states = (Collection)ret;
                                    break;
                                }
                                if (states != null) break block44;
                                try {
                                    Field field = profPoi.getClass().getDeclaredField("matchingStates");
                                    field.setAccessible(true);
                                    Object val = field.get(profPoi);
                                    if (val instanceof Collection) {
                                        states = (Collection)val;
                                    }
                                }
                                catch (NoSuchFieldException field) {}
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (states == null) continue;
                        for (Object o : states) {
                            try {
                                class_1792 item;
                                class_2680 bs;
                                class_2248 block;
                                if (!(o instanceof class_2680) || (block = (bs = (class_2680)o).method_26204()) == null || (item = block.method_8389()) == null) continue;
                                class_1799 result = new class_1799((class_1935)item);
                                CACHE.put(professionId, result);
                                return result;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        CACHE.put(professionId, class_1799.field_8037);
        return class_1799.field_8037;
    }

    public static String getProfessionForWorkstation(class_2248 block) {
        try {
            String profId;
            if (block == null) {
                return null;
            }
            class_2960 blockRl = class_7923.field_41175.method_10221((Object)block);
            String blockId = blockRl != null ? blockRl.toString() : "unknown";
            PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Looking up profession for block: {}", (Object)blockId);
            try {
                if (blockRl != null && (profId = VANILLA_WORKSTATIONS.get(blockId)) != null && !profId.isEmpty()) {
                    PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Found in vanilla workstations map: {} -> {}", (Object)blockId, (Object)profId);
                    return profId;
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("getProfessionForWorkstation: Error checking vanilla workstations: {}", (Object)t.getMessage());
            }
            try {
                if (blockRl != null && (profId = PocketVillagersMod.COMPAT_WORKSTATION_PROFESSION.get(blockId)) != null && !profId.isEmpty()) {
                    PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Found in compat config: {} -> {}", (Object)blockId, (Object)profId);
                    return profId;
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("getProfessionForWorkstation: Error checking compat config: {}", (Object)t.getMessage());
            }
            class_7922 profReg = class_7923.field_41195;
            if (profReg == null) {
                PocketVillagersMod.LOGGER.warn("getProfessionForWorkstation: Profession registry is null");
                return null;
            }
            int checkedProfessions = 0;
            for (Map.Entry entry : profReg.method_29722()) {
                try {
                    Collection states;
                    class_2960 profRl;
                    block33: {
                        class_5321 key = (class_5321)entry.getKey();
                        if (key == null) continue;
                        profRl = null;
                        try {
                            profRl = key.method_29177();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        class_3852 profObj = (class_3852)entry.getValue();
                        if (profObj == null) continue;
                        ++checkedProfessions;
                        Object profPoi = null;
                        try {
                            try {
                                Method m = profObj.getClass().getMethod("pointOfInterest", new Class[0]);
                                profPoi = m.invoke((Object)profObj, new Object[0]);
                            }
                            catch (Throwable t1) {
                                try {
                                    Method[] m2 = profObj.getClass().getMethod("getPointOfInterest", new Class[0]);
                                    profPoi = m2.invoke((Object)profObj, new Object[0]);
                                }
                                catch (Throwable m2) {}
                            }
                        }
                        catch (Throwable t) {
                            PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Failed to get POI for profession {}: {}", (Object)profRl, (Object)t.getMessage());
                        }
                        if (profPoi == null) continue;
                        states = null;
                        try {
                            Method[] methods;
                            if (checkedProfessions <= 5) {
                                PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: POI class for {}: {}", (Object)profRl, (Object)profPoi.getClass().getName());
                                PocketVillagersMod.LOGGER.debug("  Available methods:");
                                for (Method m : profPoi.getClass().getMethods()) {
                                    if (m.getName().startsWith("wait") || m.getName().startsWith("notify") || m.getName().equals("hashCode") || m.getName().equals("equals") || m.getName().equals("toString") || m.getName().equals("getClass")) continue;
                                    PocketVillagersMod.LOGGER.debug("    - {}: returns {}", (Object)m.getName(), (Object)m.getReturnType().getSimpleName());
                                }
                            }
                            for (Method m : methods = profPoi.getClass().getMethods()) {
                                Object ret;
                                String name = m.getName();
                                if (!name.equals("matchingStates") && !name.equals("getMatchingStates") && !name.equals("validStates") && !name.equals("getValidStates") || !Collection.class.isAssignableFrom(m.getReturnType()) || !((ret = m.invoke(profPoi, new Object[0])) instanceof Collection)) continue;
                                states = (Collection)ret;
                                PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Found states via method {} for profession {}", (Object)name, (Object)profRl);
                                break;
                            }
                            if (states != null) break block33;
                            try {
                                Field field = profPoi.getClass().getDeclaredField("matchingStates");
                                field.setAccessible(true);
                                Object val = field.get(profPoi);
                                if (val instanceof Collection) {
                                    states = (Collection)val;
                                    PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Found states via field for profession {}", (Object)profRl);
                                }
                            }
                            catch (NoSuchFieldException field) {}
                        }
                        catch (Throwable t) {
                            PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Failed to get matchingStates for profession {}: {}", (Object)profRl, (Object)t.getMessage());
                        }
                    }
                    if (states == null) continue;
                    for (Object o : states) {
                        try {
                            class_2680 bs;
                            if (!(o instanceof class_2680) || (bs = (class_2680)o).method_26204() != block || profRl == null) continue;
                            PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: Found match! {} -> {}", (Object)blockId, (Object)profRl);
                            return profRl.toString();
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("getProfessionForWorkstation: Error checking profession entry: {}", (Object)t.getMessage());
                }
            }
            PocketVillagersMod.LOGGER.debug("getProfessionForWorkstation: No profession found for block {} (checked {} professions)", (Object)blockId, (Object)checkedProfessions);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("getProfessionForWorkstation: Unexpected error", t);
        }
        return null;
    }

    static {
        VANILLA_WORKSTATIONS.put("minecraft:lectern", "minecraft:librarian");
        VANILLA_WORKSTATIONS.put("minecraft:composter", "minecraft:farmer");
        VANILLA_WORKSTATIONS.put("minecraft:brewing_stand", "minecraft:cleric");
        VANILLA_WORKSTATIONS.put("minecraft:fletching_table", "minecraft:fletcher");
        VANILLA_WORKSTATIONS.put("minecraft:barrel", "minecraft:fisherman");
        VANILLA_WORKSTATIONS.put("minecraft:stonecutter", "minecraft:mason");
        VANILLA_WORKSTATIONS.put("minecraft:blast_furnace", "minecraft:armorer");
        VANILLA_WORKSTATIONS.put("minecraft:smoker", "minecraft:butcher");
        VANILLA_WORKSTATIONS.put("minecraft:cauldron", "minecraft:leatherworker");
        VANILLA_WORKSTATIONS.put("minecraft:smithing_table", "minecraft:toolsmith");
        VANILLA_WORKSTATIONS.put("minecraft:grindstone", "minecraft:weaponsmith");
        VANILLA_WORKSTATIONS.put("minecraft:cartography_table", "minecraft:cartographer");
    }
}

