/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncBreederMenuPayload;
import net.mcreator.pocketvillagers.util.NbtUtil;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.mcreator.pocketvillagers.world.inventory.BreederPocketCubeGUIMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class BreederPocketCubeBlockEntity
extends class_2586
implements class_1278,
ExtendedScreenHandlerFactory<class_2338> {
    private class_2487 villager1Data = new class_2487();
    private class_2487 villager2Data = new class_2487();
    private final class_2487[] babyData = new class_2487[]{new class_2487(), new class_2487(), new class_2487()};
    private final int[] babyRemainingGrowTicks = new int[]{0, 0, 0};
    private int breedingIntervalTimer = 0;
    private int lastKnownBabyGrowthConfig = PocketVillagersConfig.getInstance().getBreederBabyGrowthTime();
    private class_2371<class_1799> foodSlots = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private class_2371<class_1799> bedSlots = class_2371.method_10213((int)3, (Object)class_1799.field_8037);

    private static int getBabyGrowTicks() {
        return PocketVillagersConfig.getInstance().getBreederBabyGrowthTime();
    }

    private static int getBreedingCooldownTicks() {
        return PocketVillagersConfig.getInstance().getBreederBreedingCooldown();
    }

    public BreederPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.BREEDER_POCKET_CUBE, position, state);
        boolean empty = true;
        for (class_1799 s : this.bedSlots) {
            if (s == null || s.method_7960()) continue;
            empty = false;
            break;
        }
        if (empty) {
            this.bedSlots = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
            this.bedSlots.set(0, (Object)new class_1799((class_1935)class_1802.field_8258, 1));
            this.bedSlots.set(1, (Object)new class_1799((class_1935)class_1802.field_8258, 1));
            this.bedSlots.set(2, (Object)new class_1799((class_1935)class_1802.field_8258, 1));
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        PocketVillagersMod.LOGGER.debug("BreederPocketCube: loadAdditional - tag contains Villager1Data={}, Villager2Data={}", (Object)tag.method_10545("Villager1Data"), (Object)tag.method_10545("Villager2Data"));
        try {
            this.villager1Data = tag.method_10545("Villager1Data") ? tag.method_10562("Villager1Data") : new class_2487();
            PocketVillagersMod.LOGGER.debug("BreederPocketCube: Loaded villager1Data - isEmpty={}, size={}", (Object)this.villager1Data.method_33133(), (Object)this.villager1Data.method_10546());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.villager2Data = tag.method_10545("Villager2Data") ? tag.method_10562("Villager2Data") : new class_2487();
            PocketVillagersMod.LOGGER.debug("BreederPocketCube: Loaded villager2Data - isEmpty={}, size={}", (Object)this.villager2Data.method_33133(), (Object)this.villager2Data.method_10546());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            try {
                this.babyData[i] = tag.method_10545("Baby" + i) ? tag.method_10562("Baby" + i) : new class_2487();
            }
            catch (Throwable ignored) {
                this.babyRemainingGrowTicks[i] = 0;
            }
            try {
                if (!tag.method_10545("BabyRemainingGrowTicks" + i)) continue;
                class_2487 ct = tag.method_10562("BabyRemainingGrowTicks" + i);
                this.babyRemainingGrowTicks[i] = ct != null ? ct.method_10550("t") : tag.method_10550("BabyRemainingGrowTicks" + i);
                continue;
            }
            catch (Throwable ignored) {
                this.babyRemainingGrowTicks[i] = 0;
            }
        }
        try {
            class_2487 ct;
            this.breedingIntervalTimer = tag.method_10545("BreederTimer") ? ((ct = tag.method_10562("BreederTimer")) != null ? ct.method_10550("t") : tag.method_10550("BreederTimer")) : tag.method_10550("BreederTimer");
        }
        catch (Throwable ct) {
            // empty catch block
        }
        try {
            if (tag.method_10545("BreedingCooldownTimer")) {
                int cooldownValue;
                class_2487 ct2 = tag.method_10562("BreedingCooldownTimer");
                int n = cooldownValue = ct2 != null ? ct2.method_10550("t") : tag.method_10550("BreedingCooldownTimer");
                if (cooldownValue > 0) {
                    this.breedingIntervalTimer = 0;
                }
            }
        }
        catch (Throwable ct2) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Items")) {
                boolean hasBedData;
                class_2371 combined = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)tag, (class_2371)combined, (class_7225.class_7874)registries);
                this.foodSlots = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
                this.foodSlots.set(0, (Object)((class_1799)combined.get(0)));
                boolean bl = hasBedData = !((class_1799)combined.get(1)).method_7960() || !((class_1799)combined.get(2)).method_7960() || !((class_1799)combined.get(3)).method_7960();
                if (hasBedData) {
                    this.bedSlots = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
                    for (int i = 0; i < 3; ++i) {
                        this.bedSlots.set(i, (Object)((class_1799)combined.get(1 + i)));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        try {
            if (this.villager1Data != null && !this.villager1Data.method_33133()) {
                tag.method_10566("Villager1Data", (class_2520)this.villager1Data.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.villager2Data != null && !this.villager2Data.method_33133()) {
                tag.method_10566("Villager2Data", (class_2520)this.villager2Data.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            try {
                if (this.babyData[i] == null || this.babyData[i].method_33133()) continue;
                tag.method_10566("Baby" + i, (class_2520)this.babyData[i].method_10553());
                class_2487 t = new class_2487();
                t.method_10569("t", this.babyRemainingGrowTicks[i]);
                tag.method_10566("BabyRemainingGrowTicks" + i, (class_2520)t);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            class_2487 t = new class_2487();
            t.method_10569("t", this.breedingIntervalTimer);
            tag.method_10566("BreederTimer", (class_2520)t);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            class_2371 combined = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
            if (this.foodSlots != null && this.foodSlots.size() > 0) {
                combined.set(0, (Object)((class_1799)this.foodSlots.get(0)));
            }
            if (this.bedSlots != null) {
                for (int i = 0; i < Math.min(3, this.bedSlots.size()); ++i) {
                    combined.set(1 + i, (Object)((class_1799)this.bedSlots.get(i)));
                }
            }
            class_1262.method_5426((class_2487)tag, (class_2371)combined, (class_7225.class_7874)registries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        return this.method_38242(lookupProvider);
    }

    public boolean hasVillager(int index) {
        if (index == 1) {
            return !this.villager1Data.method_33133();
        }
        if (index == 2) {
            return !this.villager2Data.method_33133();
        }
        return false;
    }

    public boolean hasBaby(int index) {
        if (index < 0 || index >= 3) {
            return false;
        }
        return this.babyData[index] != null && !this.babyData[index].method_33133();
    }

    public int method_5439() {
        return 4;
    }

    public class_1799 method_5438(int slot) {
        if (slot == 0) {
            return (class_1799)this.foodSlots.get(0);
        }
        if (slot >= 1 && slot <= 3) {
            return (class_1799)this.bedSlots.get(slot - 1);
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0) {
            this.foodSlots.set(0, (Object)stack);
        } else if (slot >= 1 && slot <= 3) {
            this.bedSlots.set(slot - 1, (Object)stack);
        }
        this.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            return true;
        }
        if (slot >= 1 && slot <= 3) {
            if (stack == null || stack.method_7960()) {
                return true;
            }
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof class_1747)) {
                return false;
            }
            class_1747 bi = (class_1747)class_17922;
            return bi.method_7711() instanceof class_2244;
        }
        return false;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack;
        if (slot == 0) {
            class_1799 stack2 = (class_1799)this.foodSlots.get(0);
            if (!stack2.method_7960()) {
                class_1799 taken = stack2.method_7971(amount);
                if (stack2.method_7960()) {
                    this.foodSlots.set(0, (Object)class_1799.field_8037);
                }
                this.method_5431();
                return taken;
            }
        } else if (slot >= 1 && slot <= 3 && !(stack = (class_1799)this.bedSlots.get(slot - 1)).method_7960()) {
            class_1799 taken = stack.method_7971(amount);
            if (stack.method_7960()) {
                this.bedSlots.set(slot - 1, (Object)class_1799.field_8037);
            }
            this.method_5431();
            return taken;
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack;
        if (slot == 0) {
            class_1799 stack2 = (class_1799)this.foodSlots.get(0);
            if (!stack2.method_7960()) {
                this.foodSlots.set(0, (Object)class_1799.field_8037);
                this.method_5431();
                return stack2;
            }
        } else if (slot >= 1 && slot <= 3 && !(stack = (class_1799)this.bedSlots.get(slot - 1)).method_7960()) {
            this.bedSlots.set(slot - 1, (Object)class_1799.field_8037);
            this.method_5431();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_5448() {
        this.foodSlots.clear();
    }

    public int getBedContainerSize() {
        return 3;
    }

    public class_1799 getBedItem(int slot) {
        if (slot >= 0 && slot < 3) {
            return (class_1799)this.bedSlots.get(slot);
        }
        return class_1799.field_8037;
    }

    public class_1799 removeBedItem(int slot, int amount) {
        class_1799 stack;
        if (slot >= 0 && slot < 3 && !(stack = (class_1799)this.bedSlots.get(slot)).method_7960()) {
            class_1799 taken = stack.method_7971(amount);
            if (stack.method_7960()) {
                this.bedSlots.set(slot, (Object)class_1799.field_8037);
            }
            this.method_5431();
            return taken;
        }
        return class_1799.field_8037;
    }

    public class_1799 removeBedItemNoUpdate(int slot) {
        class_1799 stack;
        if (slot >= 0 && slot < 3 && !(stack = (class_1799)this.bedSlots.get(slot)).method_7960()) {
            this.bedSlots.set(slot, (Object)class_1799.field_8037);
            this.method_5431();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void setBedItem(int slot, class_1799 stack) {
        if (slot >= 0 && slot < 3) {
            this.bedSlots.set(slot, (Object)stack);
            this.method_5431();
        }
    }

    public boolean canPlaceBedItem(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 3) {
            return false;
        }
        if (stack == null || stack.method_7960()) {
            return true;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 bi = (class_1747)class_17922;
        return bi.method_7711() instanceof class_2244;
    }

    public boolean isFull() {
        return this.hasVillager(1) && this.hasVillager(2);
    }

    public class_2487 getVillagerData(int index) {
        class_2487 data = index == 1 ? this.villager1Data : (index == 2 ? this.villager2Data : new class_2487());
        return data;
    }

    public void setVillagerData(int index, class_2487 data) {
        if (index == 1) {
            this.villager1Data = data;
        } else if (index == 2) {
            this.villager2Data = data;
        }
        this.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getFirstEmptySlot() {
        if (!this.hasVillager(1)) {
            return 1;
        }
        if (!this.hasVillager(2)) {
            return 2;
        }
        return -1;
    }

    public int getFirstEmptyBabySlot() {
        for (int i = 0; i < 3; ++i) {
            if (this.hasBaby(i)) continue;
            return i;
        }
        return -1;
    }

    public void setBabyData(int index, class_2487 data) {
        if (index < 0 || index >= 3) {
            return;
        }
        class_2487 class_24872 = this.babyData[index] = data == null ? new class_2487() : data;
        if (!this.hasBaby(index)) {
            this.babyRemainingGrowTicks[index] = 0;
        }
        this.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBabyDataWithRemaining(int index, class_2487 data, int remainingTicks) {
        if (index < 0 || index >= 3) {
            return;
        }
        this.babyData[index] = data == null ? new class_2487() : data;
        this.babyRemainingGrowTicks[index] = Math.max(0, remainingTicks);
        this.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendMenuStateUpdateToViewers() {
        try {
            if (this.field_11863 == null || this.field_11863.field_9236) {
                return;
            }
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            int fp = 0;
            for (int i = 0; i < Math.min(1, this.foodSlots.size()); ++i) {
                class_1799 s = (class_1799)this.foodSlots.get(i);
                if (s == null || s.method_7960()) continue;
                fp += class_1646.field_18526.getOrDefault(s.method_7909(), 0) * s.method_7947();
            }
            int bedCount = this.getBedCount();
            int bt = this.getBreedTimer();
            int bi = this.getBreedIntervalTicks();
            for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                try {
                    if (p.method_37908() != serverLevel || !(p.field_7512 instanceof BreederPocketCubeGUIMenu)) continue;
                    BreederPocketCubeGUIMenu menu = (BreederPocketCubeGUIMenu)p.field_7512;
                    if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
                    try {
                        int remaining = Math.max(0, bi - bt);
                        SyncBreederMenuPayload.send(p, this.field_11867, fp, bedCount, remaining, bi, this.hasVillager(1), this.hasVillager(2), this.hasBaby(0), this.hasBaby(1), this.hasBaby(2), this.getBabyGrowthPercent(0), this.getBabyGrowthPercent(1), this.getBabyGrowthPercent(2));
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getBedCount() {
        int c = 0;
        for (int i = 0; i < this.bedSlots.size(); ++i) {
            class_1799 s = (class_1799)this.bedSlots.get(i);
            if (s == null || s.method_7960()) continue;
            ++c;
        }
        return c;
    }

    public int getFirstEmptyBedSlot() {
        for (int i = 0; i < this.bedSlots.size(); ++i) {
            class_1799 s = (class_1799)this.bedSlots.get(i);
            if (s != null && !s.method_7960()) continue;
            return i;
        }
        return -1;
    }

    public int insertBedItem(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return -1;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return -1;
        }
        class_1747 bi = (class_1747)class_17922;
        if (!(bi.method_7711() instanceof class_2244)) {
            return -1;
        }
        int slot = this.getFirstEmptyBedSlot();
        if (slot == -1) {
            return -1;
        }
        this.bedSlots.set(slot, (Object)new class_1799((class_1935)stack.method_7909(), 1));
        this.method_5431();
        return slot;
    }

    public class_2487 getBabyData(int index) {
        if (index < 0 || index >= 3) {
            return new class_2487();
        }
        return this.babyData[index];
    }

    public int getBabyGrowthPercent(int index) {
        if (!this.hasBaby(index)) {
            return 0;
        }
        int remaining = this.babyRemainingGrowTicks[index];
        int total = BreederPocketCubeBlockEntity.getBabyGrowTicks();
        int percent = (int)Math.round(100.0 * (1.0 - (double)remaining / (double)total));
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        return percent;
    }

    public boolean releaseGrownBabyToWorld(class_1937 level, class_2338 pos, int babyIndex) {
        if (level == null || pos == null) {
            return false;
        }
        if (!this.hasBaby(babyIndex)) {
            return false;
        }
        if (this.babyRemainingGrowTicks[babyIndex] > 0) {
            return false;
        }
        class_2487 tag = this.babyData[babyIndex];
        try {
            if (tag.method_10545("Age")) {
                tag.method_10551("Age");
            }
            VillagerDataHandler.spawnVillagerFromData(level, pos, tag);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("Failed to release grown baby: {}", (Object)t.getMessage());
            return false;
        }
        this.babyData[babyIndex] = new class_2487();
        this.babyRemainingGrowTicks[babyIndex] = 0;
        this.method_5431();
        try {
            level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.sendMenuStateUpdateToViewers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void serverTick(class_1937 level) {
        int i;
        if (level == null || level.field_9236) {
            return;
        }
        int currentConfig = BreederPocketCubeBlockEntity.getBabyGrowTicks();
        if (this.lastKnownBabyGrowthConfig != -1 && this.lastKnownBabyGrowthConfig != currentConfig) {
            double ratio = (double)currentConfig / (double)this.lastKnownBabyGrowthConfig;
            for (i = 0; i < 3; ++i) {
                if (!this.hasBaby(i) || this.babyRemainingGrowTicks[i] <= 0) continue;
                this.babyRemainingGrowTicks[i] = Math.max(1, (int)Math.round((double)this.babyRemainingGrowTicks[i] * ratio));
            }
            PocketVillagersMod.LOGGER.debug("Breeder: rescaled baby growth times due to config change from {} to {}", (Object)this.lastKnownBabyGrowthConfig, (Object)currentConfig);
        }
        this.lastKnownBabyGrowthConfig = currentConfig;
        boolean hasParents = this.hasVillager(1) && this.hasVillager(2);
        boolean changed = false;
        for (i = 0; i < 3; ++i) {
            if (!this.hasBaby(i) || this.babyRemainingGrowTicks[i] <= 0) continue;
            this.babyRemainingGrowTicks[i] = Math.max(0, this.babyRemainingGrowTicks[i] - 1);
            changed = true;
        }
        for (i = 0; i < 3; ++i) {
            if (!this.hasBaby(i) || this.babyRemainingGrowTicks[i] > 0) continue;
            boolean deposited = false;
            for (class_2350 direction : class_2350.values()) {
                StoragePocketCubeBlockEntity storageCube;
                class_2338 adjacentPos = this.field_11867.method_10093(direction);
                class_2586 class_25862 = level.method_8321(adjacentPos);
                if (!(class_25862 instanceof StoragePocketCubeBlockEntity) || (storageCube = (StoragePocketCubeBlockEntity)class_25862).isFull()) continue;
                class_2487 babyData = this.babyData[i].method_10553();
                babyData.method_10569("Age", 0);
                if (!storageCube.addVillager(babyData)) continue;
                this.babyData[i] = new class_2487();
                this.babyRemainingGrowTicks[i] = 0;
                changed = true;
                deposited = true;
                PocketVillagersMod.LOGGER.debug("Breeder: auto-deposited fully grown baby from slot {} to storage cube at {}", (Object)i, (Object)adjacentPos);
                this.method_5431();
                try {
                    level.method_8413(this.field_11867, level.method_8320(this.field_11867), level.method_8320(this.field_11867), 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PocketVillagersMod.LOGGER.debug("Breeder: sent immediate menu updates for baby transfer at {}", (Object)this.field_11867);
                break;
            }
            if (deposited) continue;
            PocketVillagersMod.LOGGER.debug("Breeder: could not deposit fully grown baby from slot {} - no adjacent storage space available", (Object)i);
        }
        if (this.getFirstEmptyBabySlot() == -1) {
            if (this.breedingIntervalTimer != 0) {
                this.breedingIntervalTimer = 0;
                changed = true;
            }
        } else if (hasParents && this.hasNearbyBed(level, this.field_11867) && this.hasRequiredFood()) {
            int slot;
            ++this.breedingIntervalTimer;
            if (this.breedingIntervalTimer >= BreederPocketCubeBlockEntity.getBreedingCooldownTicks() && (slot = this.getFirstEmptyBabySlot()) != -1) {
                class_2487 parent;
                if (!this.hasRequiredFood()) {
                    this.breedingIntervalTimer = 0;
                    return;
                }
                this.removeBreedingItems();
                class_2487 class_24872 = parent = this.villager1Data != null && !this.villager1Data.method_33133() ? this.villager1Data.method_10553() : this.villager2Data.method_10553();
                if (parent == null) {
                    parent = new class_2487();
                }
                int growthTime = BreederPocketCubeBlockEntity.getBabyGrowTicks();
                parent.method_10569("Age", -growthTime);
                String babyVariant = this.randomizeBabyVariant(level);
                parent.method_10582("VillagerData.type", babyVariant);
                this.babyData[slot] = parent;
                this.babyRemainingGrowTicks[slot] = growthTime;
                this.breedingIntervalTimer = 0;
                changed = true;
                PocketVillagersMod.LOGGER.debug("Breeder: new baby created in slot {} at {} with variant {}, next breeding in {} ticks", (Object)slot, (Object)this.field_11867, (Object)babyVariant, (Object)BreederPocketCubeBlockEntity.getBreedingCooldownTicks());
                this.method_5431();
                try {
                    level.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PocketVillagersMod.LOGGER.debug("Breeder: sent immediate menu updates for baby spawn at {}", (Object)this.field_11867);
            }
        } else if (this.breedingIntervalTimer > 0) {
            this.breedingIntervalTimer = 0;
            changed = true;
        }
        if (changed) {
            this.method_5431();
            try {
                level.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (changed || this.breedingIntervalTimer > 0 && this.breedingIntervalTimer % 20 == 0) {
                this.sendMenuStateUpdateToViewers();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getBreedTimer() {
        try {
            return this.breedingIntervalTimer;
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    public int getBreedIntervalTicks() {
        try {
            return BreederPocketCubeBlockEntity.getBreedingCooldownTicks();
        }
        catch (Throwable ignored) {
            return 6000;
        }
    }

    public boolean hasEnoughFoodForBreeding() {
        try {
            return this.hasRequiredFood();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private boolean hasNearbyBed(class_1937 level, class_2338 pos) {
        try {
            int radius = 5;
            int vRadius = 2;
            int count = 0;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    for (int dy = -vRadius; dy <= vRadius; ++dy) {
                        class_2338 p = pos.method_10069(dx, dy, dz);
                        if (!(level.method_8320(p).method_26204() instanceof class_2244) || ++count < 3) continue;
                        return true;
                    }
                }
            }
            if (this.bedSlots != null) {
                for (int i = 0; i < this.bedSlots.size(); ++i) {
                    class_1799 s = (class_1799)this.bedSlots.get(i);
                    if (s == null || s.method_7960() || ++count < 3) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean hasRequiredFood() {
        try {
            int value = 0;
            for (int i = 0; i < this.foodSlots.size(); ++i) {
                class_1799 stack = (class_1799)this.foodSlots.get(i);
                if (stack == null || stack.method_7960()) continue;
                value += class_1646.field_18526.getOrDefault(stack.method_7909(), 0) * stack.method_7947();
            }
            return value >= 24;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void removeBreedingItems() {
        try {
            int requiredPoints = 24;
            int slots = Math.max(1, this.foodSlots.size());
            int idx = 0;
            while (requiredPoints > 0) {
                boolean consumedThisPass = false;
                for (int pass = 0; pass < slots && requiredPoints > 0; ++pass) {
                    int perItem;
                    class_1799 stack = (class_1799)this.foodSlots.get(idx);
                    idx = (idx + 1) % slots;
                    if (stack == null || stack.method_7960() || (perItem = class_1646.field_18526.getOrDefault(stack.method_7909(), 0).intValue()) <= 0 || perItem > requiredPoints) continue;
                    stack.method_7934(1);
                    requiredPoints -= perItem;
                    consumedThisPass = true;
                    if (!stack.method_7960()) continue;
                    this.foodSlots.set((idx + slots - 1) % slots, (Object)class_1799.field_8037);
                }
                if (consumedThisPass) continue;
                break;
            }
            this.method_5431();
            try {
                if (this.field_11863 != null) {
                    this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.sendMenuStateUpdateToViewers();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.field_11863 != null && !this.field_11863.field_9236) {
                    for (class_1657 p : this.field_11863.method_18456()) {
                        try {
                            if (p.method_37908() != this.field_11863 || !(p.field_7512 instanceof BreederPocketCubeGUIMenu)) continue;
                            BreederPocketCubeGUIMenu menu = (BreederPocketCubeGUIMenu)p.field_7512;
                            if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
                            try {
                                Map<Integer, class_1735> menuSlots = menu.getSlots();
                                for (int i = 0; i < this.method_5439(); ++i) {
                                    class_1735 slot = menuSlots.get(i);
                                    if (slot == null) continue;
                                    slot.method_7673(this.method_5438(i) == null ? class_1799.field_8037 : this.method_5438(i).method_7972());
                                }
                                try {
                                    menu.method_7623();
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Breeder Pocket Cube");
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new BreederPocketCubeGUIMenu(id, inventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public boolean method_5442() {
        try {
            for (class_1799 s : this.foodSlots) {
                if (s == null || s.method_7960()) continue;
                return false;
            }
            for (class_1799 s : this.bedSlots) {
                if (s == null || s.method_7960()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    public boolean method_5443(class_1657 player) {
        try {
            double dz;
            double dy;
            if (this.field_11863 == null) {
                return false;
            }
            if (player == null) {
                return false;
            }
            if (player.method_37908() != this.field_11863) {
                return false;
            }
            double dx = player.method_23317() - ((double)this.field_11867.method_10263() + 0.5);
            return dx * dx + (dy = player.method_23318() - ((double)this.field_11867.method_10264() + 0.5)) * dy + (dz = player.method_23321() - ((double)this.field_11867.method_10260() + 0.5)) * dz <= 64.0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int index, class_1799 stack, class_2350 direction) {
        if (index != 0) {
            return false;
        }
        try {
            return this.method_5437(index, stack);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    private String randomizeBabyVariant(class_1937 level) {
        String biomeType;
        String parent2Type;
        String parent1Type;
        block39: {
            if (level == null) {
                return "minecraft:plains";
            }
            parent1Type = "minecraft:plains";
            parent2Type = "minecraft:plains";
            if (this.villager1Data != null && !this.villager1Data.method_33133()) {
                parent1Type = NbtUtil.getStringSafe(this.villager1Data, "VillagerData.type", "minecraft:plains");
            }
            if (this.villager2Data != null && !this.villager2Data.method_33133()) {
                parent2Type = NbtUtil.getStringSafe(this.villager2Data, "VillagerData.type", "minecraft:plains");
            }
            biomeType = "minecraft:plains";
            try {
                Object biomeKey;
                block38: {
                    class_6880 biome = level.method_23753(this.field_11867);
                    biomeKey = null;
                    try {
                        Optional maybeKey = null;
                        try {
                            maybeKey = biome.method_40230();
                        }
                        catch (Throwable _u) {
                            maybeKey = null;
                        }
                        if (maybeKey instanceof Optional) {
                            try {
                                Optional opt = maybeKey;
                                if (opt.isPresent()) {
                                    biomeKey = opt.get();
                                }
                                break block38;
                            }
                            catch (Throwable opt) {}
                            break block38;
                        }
                        biomeKey = maybeKey;
                    }
                    catch (Throwable maybeKey) {
                        // empty catch block
                    }
                }
                if (biomeKey == null) break block39;
                try {
                    Method loc = biomeKey.getClass().getMethod("location", new Class[0]);
                    Object locRes = loc.invoke(biomeKey, new Object[0]);
                    if (locRes instanceof class_2960) {
                        String biomeName;
                        class_2960 rl = (class_2960)locRes;
                        switch (biomeName = rl.method_12832()) {
                            case "desert": {
                                biomeType = "minecraft:desert";
                                break;
                            }
                            case "savanna": 
                            case "savanna_plateau": 
                            case "windswept_savanna": {
                                biomeType = "minecraft:savanna";
                                break;
                            }
                            case "taiga": 
                            case "snowy_taiga": 
                            case "old_growth_pine_taiga": 
                            case "old_growth_spruce_taiga": {
                                biomeType = "minecraft:taiga";
                                break;
                            }
                            case "jungle": 
                            case "bamboo_jungle": 
                            case "sparse_jungle": {
                                biomeType = "minecraft:jungle";
                                break;
                            }
                            case "swamp": {
                                biomeType = "minecraft:swamp";
                                break;
                            }
                            default: {
                                biomeType = "minecraft:plains";
                            }
                        }
                    }
                }
                catch (Throwable loc) {}
            }
            catch (Throwable biome) {
                // empty catch block
            }
        }
        HashSet<String> possibleVariants = new HashSet<String>();
        possibleVariants.add(parent1Type);
        possibleVariants.add(parent2Type);
        possibleVariants.add(biomeType);
        ArrayList variantsList = new ArrayList(possibleVariants);
        if (!variantsList.isEmpty()) {
            int randomIndex = level.field_9229.method_43048(variantsList.size());
            return (String)variantsList.get(randomIndex);
        }
        return "minecraft:plains";
    }
}

