/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncFarmingMenuPayload;
import net.mcreator.pocketvillagers.util.NbtUtil;
import net.mcreator.pocketvillagers.world.inventory.FarmingPocketCubeGUIMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FarmingPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 15;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public FarmingPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.FARMING_POCKET_CUBE, position, state);
        this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)15, (Object)class_1799.field_8037));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.progressTicks = tag.method_10550("ProgressTicks");
        this.progressNeeded = tag.method_10550("ProgressNeeded");
        if (registries != null) {
            try {
                class_2371 items = class_2371.method_10213((int)15, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)tag, (class_2371)items, (class_7225.class_7874)registries);
                this.method_11281((class_2371<class_1799>)items);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.error("Error loading Farming Cube inventory", t);
            }
        }
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        if (registries != null) {
            try {
                class_1262.method_5426((class_2487)tag, this.method_11282(), (class_7225.class_7874)registries);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.error("Error saving Farming Cube inventory", t);
            }
        }
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        tag.method_10556("CanAutomate", this.isAutomationReady());
        class_1262.method_5426((class_2487)tag, this.method_11282(), (class_7225.class_7874)lookupProvider);
        return tag;
    }

    @Override
    public void handleUpdateTag(class_2487 tag) {
        super.handleUpdateTag(tag);
        if (tag == null) {
            return;
        }
        if (tag.method_10545("ProgressTicks")) {
            this.progressTicks = tag.method_10550("ProgressTicks");
        }
        if (tag.method_10545("ProgressNeeded")) {
            this.progressNeeded = tag.method_10550("ProgressNeeded");
        }
        if (tag.method_10573("Items", 9) && this.field_11863 != null) {
            class_2371 newItems = class_2371.method_10213((int)15, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag, (class_2371)newItems, (class_7225.class_7874)this.field_11863.method_30349());
            this.method_11281((class_2371<class_1799>)newItems);
        }
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 old;
        class_1799 toSet;
        class_1799 class_17992 = toSet = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (index == 2 && !toSet.method_7960() && toSet.method_7947() > 1) {
            toSet.method_7939(1);
        }
        if (index <= 2 && !class_1799.method_7973((class_1799)(old = this.method_5438(index)), (class_1799)toSet)) {
            this.progressTicks = 0;
        }
        super.method_5447(index, toSet);
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            this.method_5431();
        }
    }

    public class_1799 method_5434(int index, int count) {
        class_1799 result = super.method_5434(index, count);
        if (index <= 2) {
            this.progressTicks = 0;
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int index) {
        class_1799 result = super.method_5441(index);
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        return result;
    }

    public void serverTick(class_1937 level) {
        class_1799 activeTool;
        if (level == null || level.field_9236) {
            return;
        }
        if (!this.hasValidFarmer()) {
            if (this.progressTicks % 100 == 0) {
                PocketVillagersMod.LOGGER.debug("Farming Logic: No valid farmer found.");
            }
            return;
        }
        class_2371<class_1799> items = this.method_11282();
        if (items.size() < 15) {
            return;
        }
        class_1799 hoe = (class_1799)items.get(0);
        class_1799 axe = (class_1799)items.get(1);
        class_1799 input = (class_1799)items.get(2);
        if (input.method_7960()) {
            if (this.progressTicks > 0) {
                this.progressTicks = 0;
                this.method_5431();
            }
            return;
        }
        boolean isSapling = this.isItemSapling(input);
        class_1799 class_17992 = activeTool = isSapling ? axe : hoe;
        if (activeTool.method_7960()) {
            if (this.progressTicks % 60 == 0) {
                PocketVillagersMod.LOGGER.debug("Farming Logic: Missing Tool. InputIsSapling={}, NeedsAxe={}, NeedsHoe={}", (Object)isSapling, (Object)isSapling, (Object)(!isSapling ? 1 : 0));
            }
            return;
        }
        int baseTicks = PocketVillagersConfigCache.getFarmingTickInterval();
        double multiplier = this.getToolMultiplier(activeTool);
        this.progressNeeded = Math.max(1, (int)Math.round((double)baseTicks * multiplier));
        ++this.progressTicks;
        if (this.progressTicks % 20 == 0) {
            this.method_5431();
        }
        if (this.progressTicks % 5 == 0) {
            this.sendMenuStateUpdateToViewers();
        }
        if (this.progressTicks >= this.progressNeeded) {
            this.progressTicks = 0;
            this.generateLoot(level, input);
        }
    }

    private boolean hasValidFarmer() {
        if (!this.hasVillager()) {
            return false;
        }
        try {
            class_2487 vd = this.getVillagerData();
            String prof = null;
            if (vd.method_10545("VillagerData")) {
                class_2487 nested = vd.method_10562("VillagerData");
                prof = nested.method_10558("profession");
            } else if (vd.method_10545("profession")) {
                prof = vd.method_10558("profession");
            }
            if (prof == null) {
                prof = NbtUtil.getStringSafe(vd, "VillagerData.profession", "");
            }
            return prof != null && prof.contains("farmer");
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private void generateLoot(class_1937 level, class_1799 input) {
        List<class_1799> drops = this.sampleFarmingDropsFromInput(level.method_8409(), input);
        if (drops.isEmpty()) {
            drops.add(this.sampleFarmingDrop(level.method_8409()));
        }
        boolean allInserted = true;
        for (class_1799 drop : drops) {
            if (this.insertIntoOutputs(drop)) continue;
            allInserted = false;
            break;
        }
        if (allInserted) {
            if (input.method_7947() != 1) {
                input.method_7939(1);
                this.method_11282().set(2, (Object)input);
            }
            this.method_5431();
            this.syncToClient();
            this.sendMenuStateUpdateToViewers();
        }
    }

    public boolean isAutomationReady() {
        if (!this.hasValidFarmer()) {
            return false;
        }
        class_1799 hoe = this.method_5438(0);
        class_1799 axe = this.method_5438(1);
        class_1799 input = this.method_5438(2);
        if (input.method_7960()) {
            return false;
        }
        boolean isSapling = this.isItemSapling(input);
        return isSapling ? !axe.method_7960() : !hoe.method_7960();
    }

    private boolean isItemSapling(class_1799 stack) {
        class_1747 bi;
        if (stack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() instanceof class_2473) {
            return true;
        }
        class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return key != null && key.method_12832().contains("sapling");
    }

    private double getToolMultiplier(class_1799 tool) {
        if (tool.method_7960()) {
            return 1.0;
        }
        class_1792 it = tool.method_7909();
        double mult = 1.0;
        if (it == class_1802.field_22026 || it == class_1802.field_22025) {
            mult = 0.4;
        } else if (it == class_1802.field_8527 || it == class_1802.field_8556) {
            mult = 0.5;
        } else if (it == class_1802.field_8609 || it == class_1802.field_8475) {
            mult = 0.75;
        } else if (it == class_1802.field_8431 || it == class_1802.field_8062) {
            mult = 1.0;
        } else if (it == class_1802.field_8167 || it == class_1802.field_8303 || it == class_1802.field_8406 || it == class_1802.field_8825) {
            mult = 1.5;
        }
        try {
            class_5321 effKey;
            class_7225.class_7226 registry;
            class_6880.class_6883 effHolder;
            int effLevel;
            if (PocketVillagersConfigCache.getEnableEfficiency() && (effLevel = class_1890.method_8225((class_6880)(effHolder = (registry = this.field_11863.method_30349().method_46762(class_7924.field_41265)).method_46747(effKey = class_1893.field_9131)), (class_1799)tool)) > 0) {
                double bonus = PocketVillagersConfigCache.getEfficiencySpeedBonus();
                mult *= Math.pow(1.0 - bonus, effLevel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mult;
    }

    private List<class_1799> sampleFarmingDropsFromInput(class_5819 rand, class_1799 input) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (input.method_7960()) {
            return drops;
        }
        class_1792 item = input.method_7909();
        if (item == class_1802.field_8317) {
            drops.add(rand.method_43048(100) < 70 ? new class_1799((class_1935)class_1802.field_8861) : new class_1799((class_1935)class_1802.field_8317));
        } else if (item == class_1802.field_46250) {
            drops.add(new class_1799((class_1935)class_1802.field_8497));
        } else if (item == class_1802.field_46249) {
            drops.add(new class_1799((class_1935)class_1802.field_17518));
        } else if (item == class_1802.field_8309) {
            drops.add(new class_1799((class_1935)class_1802.field_8186));
        } else if (item == class_1802.field_8179) {
            drops.add(new class_1799((class_1935)class_1802.field_8179));
        } else if (item == class_1802.field_8567) {
            drops.add(new class_1799((class_1935)(rand.method_43048(40) == 0 ? class_1802.field_8635 : class_1802.field_8567)));
        } else if (item == class_1802.field_16998) {
            drops.add(new class_1799((class_1935)class_1802.field_16998));
        } else if (item == class_1802.field_8790) {
            drops.add(new class_1799((class_1935)class_1802.field_8790));
        } else if (this.isItemSapling(input)) {
            drops.add(new class_1799((class_1935)this.getLogForSapling(item), rand.method_43048(2) + 1));
            if (rand.method_43056()) {
                drops.add(new class_1799((class_1935)class_1802.field_8600, rand.method_43048(2) + 1));
            }
            if (rand.method_43048(10) == 0) {
                drops.add(new class_1799((class_1935)item));
            }
            if (item == class_1802.field_17535 && rand.method_43048(20) == 0) {
                drops.add(new class_1799((class_1935)class_1802.field_8279));
            }
        } else {
            drops.add(new class_1799((class_1935)item));
        }
        return drops;
    }

    private class_1792 getLogForSapling(class_1792 sapling) {
        if (sapling == class_1802.field_17535) {
            return class_1802.field_8583;
        }
        if (sapling == class_1802.field_17536) {
            return class_1802.field_8684;
        }
        if (sapling == class_1802.field_17537) {
            return class_1802.field_8170;
        }
        if (sapling == class_1802.field_17538) {
            return class_1802.field_8125;
        }
        if (sapling == class_1802.field_17539) {
            return class_1802.field_8820;
        }
        if (sapling == class_1802.field_17540) {
            return class_1802.field_8652;
        }
        if (sapling == class_1802.field_42688) {
            return class_1802.field_42692;
        }
        if (sapling == class_1802.field_37508) {
            return class_1802.field_37512;
        }
        return class_1802.field_8583;
    }

    private class_1799 sampleFarmingDrop(class_5819 rand) {
        return new class_1799((class_1935)class_1802.field_8861);
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        class_2371<class_1799> items = this.method_11282();
        for (int i = 3; i < 15; ++i) {
            int space;
            class_1799 slot = (class_1799)items.get(i);
            if (slot.method_7960()) {
                items.set(i, (Object)drop.method_7972());
                return true;
            }
            if (class_1799.method_31577((class_1799)slot, (class_1799)drop) && slot.method_7947() + drop.method_7947() <= slot.method_7914()) {
                slot.method_7933(drop.method_7947());
                return true;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)drop) || (space = slot.method_7914() - slot.method_7947()) <= 0) continue;
            slot.method_7933(space);
            drop.method_7934(space);
            if (!drop.method_7960()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return IntStream.range(2, 15).toArray();
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (index != 2) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8317 || item == class_1802.field_8309 || item == class_1802.field_46250 || item == class_1802.field_46249 || item == class_1802.field_8179 || item == class_1802.field_8567 || item == class_1802.field_16998 || item == class_1802.field_8790) {
            return true;
        }
        return this.isItemSapling(stack);
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return index >= 3;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public void sendMenuStateUpdateToViewers() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        int rem = Math.max(0, this.progressNeeded - this.progressTicks);
        boolean can = this.isAutomationReady();
        for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
            class_1703 class_17032 = p.field_7512;
            if (!(class_17032 instanceof FarmingPocketCubeGUIMenu)) continue;
            FarmingPocketCubeGUIMenu menu = (FarmingPocketCubeGUIMenu)class_17032;
            if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
            try {
                SyncFarmingMenuPayload.send(p, this.field_11867, rem, this.progressNeeded, can);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"farming_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int i, class_1661 inv) {
        return class_1707.method_19248((int)i, (class_1661)inv);
    }

    public class_1703 createMenu(int id, class_1661 inv, class_1657 p) {
        return new FarmingPocketCubeGUIMenu(id, inv, this);
    }

    public class_2338 getScreenOpeningData(class_3222 p) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Farming Pocket Cube");
    }
}

