/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncFishingMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.FishingPocketCubeGUIMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FishingPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 13;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public FishingPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.FISHING_POCKET_CUBE, position, state);
        this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.progressTicks = tag.method_10550("ProgressTicks");
        this.progressNeeded = tag.method_10550("ProgressNeeded");
        class_2371 items = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, (class_2371)items, (class_7225.class_7874)registries);
        this.method_11281((class_2371<class_1799>)items);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        class_1262.method_5426((class_2487)tag, this.method_11282(), (class_7225.class_7874)registries);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        tag.method_10556("CanAutomate", this.isAutomationReady());
        return tag;
    }

    @Override
    public void handleUpdateTag(class_2487 tag) {
        if (tag != null) {
            if (tag.method_10545("ProgressTicks")) {
                this.progressTicks = tag.method_10550("ProgressTicks");
            }
            if (tag.method_10545("ProgressNeeded")) {
                this.progressNeeded = tag.method_10550("ProgressNeeded");
            }
        }
    }

    public void serverTick(class_1937 level) {
        int needed;
        if (level == null || level.field_9236) {
            return;
        }
        if (!this.hasVillager()) {
            return;
        }
        class_2371<class_1799> items = this.method_11282();
        if (items.size() < 13) {
            return;
        }
        class_1799 tool = (class_1799)items.get(0);
        if (tool.method_7960()) {
            return;
        }
        int baseTicks = PocketVillagersConfig.getInstance().getFishingTickInterval();
        int lureLevel = this.getEnchantmentLevel(tool, "lure");
        int lureReduction = lureLevel * 200;
        this.progressNeeded = needed = Math.max(20, baseTicks - lureReduction);
        ++this.progressTicks;
        if (this.progressTicks % 5 == 0) {
            this.sendMenuStateUpdateToViewers();
        }
        if (this.progressTicks >= this.progressNeeded) {
            this.progressTicks = 0;
            class_1799 drop = this.sampleFishingDrop(level, level.method_8409(), tool);
            if (drop != null && !drop.method_7960() && this.insertIntoOutputs(drop)) {
                this.method_5431();
                this.syncToClient();
                this.sendMenuStateUpdateToViewers();
            }
        }
    }

    private int getEnchantmentLevel(class_1799 tool, String enchantName) {
        try {
            class_7225.class_7226 reg = this.field_11863.method_30349().method_46762(class_7924.field_41265);
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60654((String)enchantName));
            if (!enchantName.contains(":")) {
                key = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60654((String)("minecraft:" + enchantName)));
            }
            class_6880.class_6883 holder = reg.method_46747(key);
            return class_1890.method_8225((class_6880)holder, (class_1799)tool);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private class_1799 sampleFishingDrop(class_1937 level, class_5819 rand, class_1799 fishingRod) {
        int luckLevel = this.getEnchantmentLevel(fishingRod, "luck_of_the_sea");
        int treasureBonus = luckLevel * 25;
        int junkReduction = luckLevel * 15;
        int junkThreshold = 100 - junkReduction;
        int treasureThreshold = junkThreshold + 50 + treasureBonus;
        int roll = rand.method_43048(1000);
        if (roll < junkThreshold) {
            int r = rand.method_43048(100);
            if (r < 20) {
                return new class_1799((class_1935)class_1802.field_17524);
            }
            if (r < 40) {
                return new class_1799((class_1935)class_1802.field_8428);
            }
            if (r < 60) {
                return new class_1799((class_1935)class_1802.field_8370);
            }
            if (r < 80) {
                return new class_1799((class_1935)class_1802.field_8600);
            }
            return new class_1799((class_1935)class_1802.field_8276);
        }
        if (roll < treasureThreshold) {
            int r = rand.method_43048(100);
            if (r < 25) {
                return new class_1799((class_1935)class_1802.field_8448);
            }
            if (r < 50) {
                return new class_1799((class_1935)class_1802.field_8175);
            }
            if (r < 65) {
                return new class_1799((class_1935)class_1802.field_8102);
            }
            if (r < 80) {
                return new class_1799((class_1935)class_1802.field_8378);
            }
            if (r < 95) {
                return new class_1799((class_1935)class_1802.field_8864);
            }
            return new class_1799((class_1935)class_1802.field_8598);
        }
        int r = rand.method_43048(100);
        if (r < 40) {
            return new class_1799((class_1935)class_1802.field_8429);
        }
        if (r < 70) {
            return new class_1799((class_1935)class_1802.field_8209);
        }
        if (r < 85) {
            return new class_1799((class_1935)class_1802.field_8846);
        }
        return new class_1799((class_1935)class_1802.field_8323);
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public boolean isAutomationReady() {
        if (!this.hasVillager()) {
            return false;
        }
        return !this.method_5438(0).method_7960();
    }

    public void resetProgressTicks() {
        this.progressTicks = 0;
        this.method_5431();
        try {
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recomputeProgressNeededFromCurrentTool() {
        class_1799 rod = this.method_5438(0);
        if (rod != null && !rod.method_7960()) {
            int needed;
            int baseTicks = PocketVillagersConfig.getInstance().getFishingTickInterval();
            int lureLevel = this.getEnchantmentLevel(rod, "lure");
            int lureReduction = lureLevel * 200;
            this.progressNeeded = needed = Math.max(20, baseTicks - lureReduction);
            this.method_5431();
        }
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        class_2371<class_1799> items = this.method_11282();
        for (int i = 1; i < 13; ++i) {
            int space;
            class_1799 slot = (class_1799)items.get(i);
            if (slot.method_7960()) {
                items.set(i, (Object)drop.method_7972());
                return true;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)drop) || (space = slot.method_7914() - slot.method_7947()) <= 0) continue;
            int add = Math.min(space, drop.method_7947());
            slot.method_7933(add);
            drop.method_7934(add);
            if (!drop.method_7960()) continue;
            return true;
        }
        return false;
    }

    private void sendMenuStateUpdateToViewers() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sl = (class_3218)class_19372;
        int rem = Math.max(0, this.progressNeeded - this.progressTicks);
        for (class_3222 p : sl.method_8503().method_3760().method_14571()) {
            class_1703 class_17032 = p.field_7512;
            if (!(class_17032 instanceof FishingPocketCubeGUIMenu)) continue;
            FishingPocketCubeGUIMenu menu = (FishingPocketCubeGUIMenu)class_17032;
            if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
            try {
                SyncFishingMenuPayload.send(p, this.field_11867, rem, this.progressNeeded, this.isAutomationReady());
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public int method_5439() {
        return this.method_11282().size();
    }

    @Override
    public boolean method_5442() {
        return super.method_5442();
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"fishing_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new FishingPocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Fishing Pocket Cube");
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 toSet;
        class_1799 class_17992 = toSet = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (index >= 0 && index < this.method_11282().size()) {
            this.method_11282().set(index, (Object)toSet);
            this.method_5431();
        }
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return IntStream.range(1, 13).toArray();
    }

    @Override
    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return index >= 1;
    }
}

