/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncMiningMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.MiningPocketCubeGUIMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class MiningPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 13;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public MiningPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.MINING_POCKET_CUBE, position, state);
        this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.progressTicks = tag.method_10550("ProgressTicks");
        this.progressNeeded = tag.method_10550("ProgressNeeded");
        try {
            class_2371 items = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag, (class_2371)items, (class_7225.class_7874)registries);
            this.method_11281((class_2371<class_1799>)items);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        try {
            class_1262.method_5426((class_2487)tag, this.method_11282(), (class_7225.class_7874)registries);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        tag.method_10569("ProgressTicks", this.progressTicks);
        tag.method_10569("ProgressNeeded", this.progressNeeded);
        tag.method_10556("CanAutomate", this.isAutomationReady());
        return tag;
    }

    @Override
    public void handleUpdateTag(class_2487 tag) {
        if (tag != null) {
            if (tag.method_10545("ProgressTicks")) {
                this.progressTicks = tag.method_10550("ProgressTicks");
            }
            if (tag.method_10545("ProgressNeeded")) {
                this.progressNeeded = tag.method_10550("ProgressNeeded");
            }
        }
    }

    public void serverTick(class_1937 level) {
        if (level == null || level.field_9236) {
            return;
        }
        if (!this.hasVillager()) {
            return;
        }
        class_2371<class_1799> items = this.method_11282();
        if (items.size() < 13) {
            return;
        }
        class_1799 tool = (class_1799)items.get(0);
        if (tool.method_7960()) {
            return;
        }
        int baseTicks = PocketVillagersConfigCache.getMiningTickInterval();
        double mult = this.getToolMultiplier(tool);
        this.progressNeeded = Math.max(1, (int)Math.round((double)baseTicks * mult));
        ++this.progressTicks;
        if (this.progressTicks % 5 == 0) {
            this.sendMenuStateUpdateToViewers();
        }
        if (this.progressTicks >= this.progressNeeded) {
            this.progressTicks = 0;
            class_1799 drop = this.sampleMiningDrop(level.method_8409(), tool);
            if (drop != null && !drop.method_7960() && this.insertIntoOutputs(drop)) {
                this.method_5431();
                this.syncToClient();
                this.sendMenuStateUpdateToViewers();
            }
        }
    }

    private double getToolMultiplier(class_1799 tool) {
        if (tool.method_7960()) {
            return 1.0;
        }
        class_1792 it = tool.method_7909();
        double mult = 1.0;
        if (it == class_1802.field_22024) {
            mult = 0.4;
        } else if (it == class_1802.field_8377) {
            mult = 0.5;
        } else if (it == class_1802.field_8403) {
            mult = 0.75;
        } else if (it == class_1802.field_8387) {
            mult = 1.0;
        } else if (it == class_1802.field_8647 || it == class_1802.field_8335) {
            mult = 1.5;
        }
        try {
            class_7225.class_7226 reg;
            class_6880.class_6883 eff;
            int level;
            if (PocketVillagersConfigCache.getEnableEfficiency() && (level = class_1890.method_8225((class_6880)(eff = (reg = this.field_11863.method_30349().method_46762(class_7924.field_41265)).method_46747(class_1893.field_9131)), (class_1799)tool)) > 0) {
                double bonus = PocketVillagersConfigCache.getEfficiencySpeedBonus();
                mult *= Math.pow(1.0 - bonus, level);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mult;
    }

    private class_1799 sampleMiningDrop(class_5819 rand, class_1799 tool) {
        if (tool.method_7909() == class_1802.field_22024 && rand.method_43048(100) < 5) {
            int r = rand.method_43048(100);
            if (r < 50) {
                return new class_1799((class_1935)class_1802.field_22021);
            }
            if (r < 80) {
                return new class_1799((class_1935)class_1802.field_8155);
            }
            return new class_1799((class_1935)class_1802.field_8397);
        }
        int r = rand.method_43048(100);
        class_1799 drop = r < 30 ? new class_1799((class_1935)class_1802.field_8713) : (r < 53 ? new class_1799((class_1935)class_1802.field_33401) : (r < 72 ? new class_1799((class_1935)class_1802.field_33400) : (r < 84 ? new class_1799((class_1935)class_1802.field_33402) : (r < 90 ? new class_1799((class_1935)class_1802.field_8725) : (r < 95 ? new class_1799((class_1935)class_1802.field_8759) : (r < 98 ? new class_1799((class_1935)class_1802.field_8687) : new class_1799((class_1935)class_1802.field_8477)))))));
        try {
            class_7225.class_7226 reg;
            class_6880.class_6883 fort;
            int lvl;
            class_1792 i;
            if (PocketVillagersConfigCache.getEnableFortune() && ((i = drop.method_7909()) == class_1802.field_8713 || i == class_1802.field_8725 || i == class_1802.field_8759 || i == class_1802.field_8477 || i == class_1802.field_8687 || i == class_1802.field_8155) && (lvl = class_1890.method_8225((class_6880)(fort = (reg = this.field_11863.method_30349().method_46762(class_7924.field_41265)).method_46747(class_1893.field_9130)), (class_1799)tool)) > 0) {
                drop.method_7933(rand.method_43048(lvl + 1));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return drop;
    }

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public boolean isAutomationReady() {
        if (!this.hasVillager()) {
            return false;
        }
        return !this.method_5438(0).method_7960();
    }

    public void resetProgressTicks() {
        this.progressTicks = 0;
        this.method_5431();
        try {
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recomputeProgressNeededFromCurrentTool() {
        class_1799 tool = this.method_5438(0);
        if (tool != null && !tool.method_7960()) {
            int baseTicks = PocketVillagersConfigCache.getMiningTickInterval();
            double mult = this.getToolMultiplier(tool);
            this.progressNeeded = Math.max(1, (int)Math.round((double)baseTicks * mult));
            this.method_5431();
        }
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        class_2371<class_1799> items = this.method_11282();
        for (int i = 1; i < 13; ++i) {
            int space;
            class_1799 slot = (class_1799)items.get(i);
            if (slot.method_7960()) {
                items.set(i, (Object)drop.method_7972());
                return true;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)drop) || (space = slot.method_7914() - slot.method_7947()) <= 0) continue;
            int add = Math.min(space, drop.method_7947());
            slot.method_7933(add);
            drop.method_7934(add);
            if (!drop.method_7960()) continue;
            return true;
        }
        return false;
    }

    private void sendMenuStateUpdateToViewers() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sl = (class_3218)class_19372;
        int rem = Math.max(0, this.progressNeeded - this.progressTicks);
        for (class_3222 p : sl.method_8503().method_3760().method_14571()) {
            class_1703 class_17032 = p.field_7512;
            if (!(class_17032 instanceof MiningPocketCubeGUIMenu)) continue;
            MiningPocketCubeGUIMenu menu = (MiningPocketCubeGUIMenu)class_17032;
            if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
            try {
                SyncMiningMenuPayload.send(p, this.field_11867, rem, this.progressNeeded, this.isAutomationReady());
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public int method_5439() {
        return this.method_11282().size();
    }

    @Override
    public boolean method_5442() {
        return super.method_5442();
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"mining_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new MiningPocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Mining Pocket Cube");
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 toSet;
        class_1799 class_17992 = toSet = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (index >= 0 && index < this.method_11282().size()) {
            this.method_11282().set(index, (Object)toSet);
            this.method_5431();
        }
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return IntStream.range(1, 13).toArray();
    }

    @Override
    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return index >= 1;
    }
}

