/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.stream.IntStream;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PocketCubeBlockEntity
extends class_2621
implements class_1278 {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_2487 villagerData = new class_2487();
    private boolean hasVillager = false;
    private float facingYaw = 0.0f;
    private class_1799 workstation = class_1799.field_8037;
    private boolean workstationPersisted = false;
    private transient CubeVillager cachedVillager = null;
    private transient CubeVillager realVillager = null;

    public PocketCubeBlockEntity(class_2338 position, class_2680 state) {
        this(PocketVillagersModBlockEntities.POCKET_CUBE, position, state);
    }

    protected PocketCubeBlockEntity(class_2591<?> type, class_2338 position, class_2680 state) {
        super(type, position, state);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (tag.method_10545("Items")) {
            class_2499 itemsList = tag.method_10554("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_2487 itemTag = itemsList.method_10602(i);
                int slot = itemTag.method_10571("Slot") & 0xFF;
                if (slot < 0 || slot >= this.stacks.size()) continue;
                class_7225.class_7874 lookup = registries != null ? registries : (class_7225.class_7874)class_7923.field_41178.method_46771();
                this.stacks.set(slot, (Object)class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)itemTag));
            }
        }
        this.hasVillager = tag.method_10577("HasVillager");
        if (this.hasVillager && tag.method_10545("VillagerData")) {
            this.villagerData = tag.method_10562("VillagerData");
        }
        if (tag.method_10545("WorkstationItemId")) {
            try {
                String id = tag.method_10558("WorkstationItemId");
                int cnt = tag.method_10545("WorkstationCount") ? tag.method_10550("WorkstationCount") : 1;
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id));
                this.workstation = new class_1799((class_1935)item, cnt);
            }
            catch (Exception e) {
                this.workstation = class_1799.field_8037;
            }
        } else {
            this.workstation = class_1799.field_8037;
        }
        if (tag.method_10545("FacingYaw")) {
            this.facingYaw = tag.method_10583("FacingYaw");
        }
        if (tag.method_10545("WorkstationPersisted")) {
            this.workstationPersisted = tag.method_10577("WorkstationPersisted");
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        class_2960 key;
        super.method_11007(tag, registries);
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 st = (class_1799)this.stacks.get(i);
            if (st.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10567("Slot", (byte)i);
            st.method_57376(registries, (class_2520)itemTag);
            itemsList.add((Object)itemTag);
        }
        tag.method_10566("Items", (class_2520)itemsList);
        if (this.hasVillager && !this.villagerData.method_33133()) {
            tag.method_10566("VillagerData", (class_2520)this.villagerData.method_10553());
            tag.method_10556("HasVillager", true);
        }
        if (!this.workstation.method_7960() && (key = class_7923.field_41178.method_10221((Object)this.workstation.method_7909())) != null) {
            tag.method_10582("WorkstationItemId", key.toString());
            tag.method_10569("WorkstationCount", this.workstation.method_7947());
        }
        tag.method_10548("FacingYaw", this.facingYaw);
        tag.method_10556("WorkstationPersisted", this.workstationPersisted);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        tag.method_10556("HasVillager", this.hasVillager);
        if (this.hasVillager && !this.villagerData.method_33133()) {
            tag.method_10566("VillagerData", (class_2520)this.villagerData.method_10553());
        }
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void syncToClient() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.method_5431();
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public CubeVillager getOrCreateCachedVillager() {
        try {
            if (this.field_11863 == null || this.field_11863.field_9236) {
                return null;
            }
            if (this.realVillager != null && !this.realVillager.method_31481()) {
                try {
                    PocketVillagersMod.LOGGER.debug("Returning EXISTING cached villager with {} offers", (Object)(this.realVillager.method_8264() != null ? this.realVillager.method_8264().size() : 0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return this.realVillager;
            }
            PocketVillagersMod.LOGGER.debug("Creating NEW cached villager from NBT");
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2487 vd = this.villagerData != null ? this.villagerData : new class_2487();
                try {
                    PocketVillagersMod.LOGGER.debug("  - NBT XP: {}", (Object)vd.method_10550("Xp"));
                    PocketVillagersMod.LOGGER.debug("  - NBT Level: {}", (Object)vd.method_10550("VillagerData.level"));
                    PocketVillagersMod.LOGGER.debug("  - NBT Has Offers: {}", (Object)vd.method_10545("Offers"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.realVillager = VillagerDataHandler.createTradingVillager((class_1937)serverLevel, this.method_11016(), vd);
                if (this.realVillager != null) {
                    try {
                        PocketVillagersMod.LOGGER.debug("  - Created villager with {} offers", (Object)(this.realVillager.method_8264() != null ? this.realVillager.method_8264().size() : 0));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return this.realVillager;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("Error in getOrCreateCachedVillager", t);
            return null;
        }
    }

    public CubeVillager getRealVillager() {
        return this.realVillager;
    }

    public void clearCachedVillager() {
        if (this.realVillager != null && !this.realVillager.method_31481()) {
            this.realVillager.method_5650(class_1297.class_5529.field_26999);
        }
        this.realVillager = null;
        this.cachedVillager = null;
    }

    public void setVillagerData(class_2487 data) {
        this.villagerData = data != null ? data : new class_2487();
        boolean bl = this.hasVillager = data != null && !data.method_33133();
        if (this.realVillager != null && !this.realVillager.method_31481()) {
            try {
                this.realVillager.reloadDataFromNBT(this.villagerData);
            }
            catch (Throwable ignored) {
                this.clearCachedVillager();
            }
        }
        this.method_5431();
        this.syncToClient();
    }

    public class_2487 getVillagerData() {
        return this.villagerData;
    }

    public boolean hasVillager() {
        return this.hasVillager;
    }

    public void clearVillager() {
        this.hasVillager = false;
        this.clearCachedVillager();
        this.method_5431();
        this.syncToClient();
    }

    public boolean hasWorkstation() {
        return !this.workstation.method_7960();
    }

    public class_1799 getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(class_1799 stack) {
        class_1799 class_17992 = this.workstation = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.workstationPersisted = !this.workstation.method_7960();
        }
        this.method_5431();
        this.syncToClient();
    }

    public void clearWorkstation() {
        this.workstation = class_1799.field_8037;
        try {
            int xp;
            int n = xp = this.villagerData != null && this.villagerData.method_10545("Xp") ? this.villagerData.method_10550("Xp") : 0;
            if (xp <= 0) {
                class_2487 reset = new class_2487();
                reset.method_10582("VillagerData.profession", "minecraft:none");
                String type = "minecraft:plains";
                if (this.villagerData != null && this.villagerData.method_10545("VillagerData.type")) {
                    type = this.villagerData.method_10558("VillagerData.type");
                }
                reset.method_10582("VillagerData.type", type);
                reset.method_10569("VillagerData.level", 1);
                reset.method_10569("Xp", 0);
                this.setVillagerData(reset);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_5431();
        this.syncToClient();
    }

    public float getFacingYaw() {
        return this.facingYaw;
    }

    public void setFacingYaw(float yaw) {
        this.facingYaw = yaw;
        this.method_5431();
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 s : this.stacks) {
            if (s.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"pocket_cube");
    }

    public class_1703 method_5465(int id, class_1661 inv) {
        return class_1707.method_19248((int)id, (class_1661)inv);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Pocket Cube");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return true;
    }

    public void method_11012() {
        this.clearCachedVillager();
        super.method_11012();
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.method_11016();
        return new class_238((double)(pos.method_10263() - 2), (double)(pos.method_10264() - 2), (double)(pos.method_10260() - 2), (double)(pos.method_10263() + 3), (double)(pos.method_10264() + 3), (double)(pos.method_10260() + 3));
    }

    public void handleUpdateTag(class_2487 tag) {
        throw new UnsupportedOperationException("Unimplemented method 'handleUpdateTag'");
    }
}

