/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.client.HologramToggle;
import net.mcreator.pocketvillagers.client.VillagerRendererManager;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModMenus;
import net.mcreator.pocketvillagers.init.PocketVillagersModScreens;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.world.inventory.FarmingPocketCubeGUIMenu;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class FarmingPocketCubeScreen
extends class_465<FarmingPocketCubeGUIMenu>
implements PocketVillagersModScreens.FabricScreenAccessor {
    private static final class_2960 TEXTURE = class_2960.method_60654((String)"pocket_villagers:textures/screens/farming_pocket_cube_gui.png");
    private final class_1937 world;
    private final int x;
    private final int y;
    private final int z;
    private FarmingPocketCubeBlockEntity blockEntity;
    private boolean clientCanAutomate = false;
    private boolean prevLocalCanAutomate = false;
    private int clientProgressTimer = 0;
    private int clientProgressInterval = 0;
    private long clientProgressLastUpdateMs = 0L;
    private class_4185 releaseButton;
    private int releaseX;
    private int releaseY;
    private int releaseW;
    private int releaseH;

    public FarmingPocketCubeScreen(FarmingPocketCubeGUIMenu container, class_1661 inventory, class_2561 component) {
        super((class_1703)container, inventory, component);
        class_2586 be;
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.field_2792 = 176;
        this.field_2779 = 211;
        if (this.world != null && (be = this.world.method_8321(new class_2338(this.x, this.y, this.z))) instanceof FarmingPocketCubeBlockEntity) {
            this.blockEntity = (FarmingPocketCubeBlockEntity)be;
        }
        try {
            if (this.blockEntity != null) {
                boolean canAutomate;
                class_2487 tag = this.blockEntity.method_16887(null);
                int ticks = tag.method_10545("ProgressTicks") ? tag.method_10550("ProgressTicks") : 0;
                int needed = tag.method_10545("ProgressNeeded") ? tag.method_10550("ProgressNeeded") : 0;
                boolean bl = canAutomate = tag.method_10545("CanAutomate") ? tag.method_10577("CanAutomate") : false;
                if (needed > 0) {
                    this.clientProgressInterval = needed;
                    this.clientProgressTimer = Math.max(0, ticks);
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
                this.clientCanAutomate = canAutomate;
                this.prevLocalCanAutomate = canAutomate;
            }
        }
        catch (Throwable tag) {
            // empty catch block
        }
        try {
            FarmingPocketCubeGUIMenu ma;
            Map<String, Object> menuState;
            if (container instanceof PocketVillagersModMenus.MenuAccessor && (menuState = (ma = container).getMenuState()) != null) {
                Object object = menuState.get("2:progressInterval");
                if (object instanceof Number) {
                    Number n = (Number)object;
                    this.clientProgressInterval = n.intValue();
                }
                if ((object = menuState.get("2:progressTimer")) instanceof Number) {
                    Number n = (Number)object;
                    this.clientProgressTimer = n.intValue();
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
                if ((object = menuState.get("1:canAutomate")) instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    this.clientCanAutomate = b;
                    this.prevLocalCanAutomate = b;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_25426() {
        super.method_25426();
        PocketVillagersMod.LOGGER.debug("FarmingPocketCubeScreen.init() called");
        int btnW = 56;
        int btnH = 13;
        int modelX = this.field_2776 + 34;
        int modelY = this.field_2800 + 80;
        int btnX = modelX - 28 + 1;
        int btnY = modelY + 35;
        this.releaseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Release"), btn -> {
            try {
                class_2338 p = new class_2338(this.x, this.y, this.z);
                ClientPlayNetworking.send((class_8710)new ReleaseStorageVillagerPacket(p, 1));
                btn.method_25350(0.8f);
                if (this.world != null) {
                    VillagerRendererManager.remove(this.world, p, 1);
                }
                if (this.blockEntity != null) {
                    this.blockEntity.setVillagerData(new class_2487());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }).method_46434(btnX, btnY, 56, 13).method_46431();
        this.releaseX = btnX;
        this.releaseY = btnY;
        this.releaseW = 56;
        this.releaseH = 13;
        try {
            boolean hasVillagerInit;
            this.releaseButton.field_22763 = hasVillagerInit = this.blockEntity != null && this.blockEntity.hasVillager();
            this.releaseButton.method_25350(1.0f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_37063((class_364)this.releaseButton);
    }

    public void method_25432() {
        super.method_25432();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        try {
            class_2487 vd;
            int modelX = this.field_2776 + 34;
            int modelY = this.field_2800 + 80;
            class_2487 class_24872 = vd = this.blockEntity == null ? null : this.blockEntity.getVillagerData();
            if (vd != null && !vd.method_33133()) {
                this.renderVillagerModel(guiGraphics, vd, modelX, modelY, 32.0f, 1, partialTicks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
        this.renderToolSlotTooltips(guiGraphics, mouseX, mouseY);
        this.renderReleaseButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        try {
            guiGraphics.method_25290(TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            if (this.world != null) {
                this.blockEntity = (FarmingPocketCubeBlockEntity)this.world.method_8321(new class_2338(this.x, this.y, this.z));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.blockEntity == null) {
            guiGraphics.method_51433(this.field_22793, "No villager stored", 8, 8, -12829636, false);
            return;
        }
        String title = "Farming Pocket Cube";
        int titleX = (this.field_2792 - this.field_22793.method_1727(title)) / 2;
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), titleX, 8, -12829636, false);
        this.renderProgressBar(guiGraphics);
    }

    private void renderProgressBar(class_332 guiGraphics) {
        try {
            int centerX = this.field_2792 / 2;
            int barWidth = 52;
            int barHeight = 6;
            int barX = centerX - barWidth / 2 - 8;
            int barY = 102;
            int cyan = -1442775041;
            int bg = 0x66000000;
            int outline = -1996488705;
            double pct = 0.0;
            if (this.clientProgressInterval > 0) {
                int predicted = this.clientProgressTimer;
                if (this.clientProgressLastUpdateMs > 0L) {
                    long elapsedMs = Math.max(0L, System.currentTimeMillis() - this.clientProgressLastUpdateMs);
                    int elapsedTicks = (int)(elapsedMs / 50L);
                    predicted = Math.min(this.clientProgressInterval, this.clientProgressTimer + elapsedTicks);
                }
                pct = Math.max(0.0, Math.min(1.0, (double)predicted / (double)Math.max(1, this.clientProgressInterval)));
            }
            boolean localCanAutomate = this.clientCanAutomate;
            try {
                class_1735 hoe = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(0);
                class_1735 axe = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(1);
                class_1735 input = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(2);
                if (input == null || input.method_7677().method_7960()) {
                    localCanAutomate = false;
                } else {
                    class_2960 key;
                    class_1747 bi;
                    boolean isSapling = false;
                    class_1799 is = input.method_7677();
                    class_1792 class_17922 = is.method_7909();
                    if (class_17922 instanceof class_1747 && (bi = (class_1747)class_17922).method_7711() instanceof class_2473) {
                        isSapling = true;
                    }
                    if (!isSapling && (key = class_7923.field_41178.method_10221((Object)is.method_7909())) != null && key.method_12832().contains("sapling")) {
                        isSapling = true;
                    }
                    if (isSapling) {
                        if (axe == null || axe.method_7677().method_7960()) {
                            localCanAutomate = false;
                        }
                    } else if (hoe == null || hoe.method_7677().method_7960()) {
                        localCanAutomate = false;
                    }
                }
            }
            catch (Throwable hoe) {
                // empty catch block
            }
            if (!this.prevLocalCanAutomate && localCanAutomate) {
                this.clientProgressTimer = 0;
                this.clientProgressLastUpdateMs = System.currentTimeMillis();
            }
            if (!localCanAutomate) {
                pct = 0.0;
                this.clientProgressTimer = 0;
                this.clientProgressLastUpdateMs = 0L;
            }
            guiGraphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, bg);
            int filled = (int)Math.round((double)barWidth * pct);
            if (filled > 0) {
                guiGraphics.method_25294(barX, barY, barX + filled, barY + barHeight, cyan);
            }
            guiGraphics.method_25294(barX, barY - 1, barX + barWidth, barY, outline);
            guiGraphics.method_25294(barX, barY + barHeight, barX + barWidth, barY + barHeight + 1, outline);
            guiGraphics.method_25294(barX - 1, barY, barX, barY + barHeight, outline);
            guiGraphics.method_25294(barX + barWidth, barY, barX + barWidth + 1, barY + barHeight, outline);
            String label = !localCanAutomate ? "Status: N/A" : "Farming... " + (int)Math.ceil(Math.max(0.0, (double)this.clientProgressInterval - pct * (double)this.clientProgressInterval) / 20.0) + "s";
            int lblX = Math.max(4, centerX - 8 - this.field_22793.method_1727(label) / 2);
            Objects.requireNonNull(this.field_22793);
            int lblY = barY - 9 - 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)label), lblX, lblY, -1, false);
            this.prevLocalCanAutomate = localCanAutomate;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        try {
            if (elementType == 2 && "progressTimer".equals(name) && elementState instanceof Number) {
                Number n = (Number)elementState;
                this.clientProgressTimer = (int)Math.round(n.doubleValue());
                this.clientProgressLastUpdateMs = System.currentTimeMillis();
            } else if (elementType == 2 && "progressInterval".equals(name) && elementState instanceof Number) {
                Number n2 = (Number)elementState;
                this.clientProgressInterval = (int)Math.round(n2.doubleValue());
                if (this.clientProgressLastUpdateMs == 0L) {
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
            } else if (elementType == 2 && "remainingTicks".equals(name) && elementState instanceof Number) {
                Number n3 = (Number)elementState;
                try {
                    int rem = (int)Math.round(n3.doubleValue());
                    if (this.clientProgressInterval > 0) {
                        this.clientProgressTimer = Math.max(0, this.clientProgressInterval - rem);
                    }
                    this.clientProgressLastUpdateMs = System.currentTimeMillis();
                }
                catch (Throwable rem) {}
            } else if (elementType == 1 && "canAutomate".equals(name)) {
                Boolean b;
                this.prevLocalCanAutomate = this.clientCanAutomate = Boolean.TRUE.equals(elementState) || elementState instanceof Boolean && (b = (Boolean)elementState) != false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean method_25404(int key, int b, int c) {
        if (key == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return super.method_25404(key, b, c);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    private void renderToolSlotTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            class_1735 s;
            int hoeX = this.field_2776 + 60;
            int hoeY = this.field_2800 + 71;
            int axeX = this.field_2776 + 85;
            int axeY = this.field_2800 + 71;
            int inputX = this.field_2776 + 72;
            int inputY = this.field_2800 + 51;
            int w = 16;
            int h = 16;
            if (this.isHovering(hoeX, hoeY, w, h, mouseX, mouseY) && ((s = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(0)) == null || s.method_7677().method_7960())) {
                this.drawCyanTooltip(guiGraphics, "Insert Hoe", mouseX, mouseY);
            }
            if (this.isHovering(axeX, axeY, w, h, mouseX, mouseY) && ((s = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(1)) == null || s.method_7677().method_7960())) {
                this.drawCyanTooltip(guiGraphics, "Insert Axe", mouseX, mouseY);
            }
            if (this.isHovering(inputX, inputY, w, h, mouseX, mouseY) && ((s = ((FarmingPocketCubeGUIMenu)this.field_2797).method_7611(2)) == null || s.method_7677().method_7960())) {
                this.drawCyanTooltip(guiGraphics, "Insert Seeds/Saplings", mouseX, mouseY);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderReleaseButtonTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            if (this.releaseButton != null && this.releaseButton.field_22764 && this.releaseButton.method_49606()) {
                this.drawCyanTooltip(guiGraphics, "Release Villager", mouseX, mouseY);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isHovering(int x, int y, int w, int h, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
    }

    private void drawCyanTooltip(class_332 guiGraphics, String text, int mouseX, int mouseY) {
        try {
            int pad = 6;
            int lineW = this.field_22793.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > this.field_22789 - 4) {
                x = this.field_22789 - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), x + pad, y + pad - 2, -1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderVillagerModel(class_332 guiGraphics, class_2487 villagerData, int centerX, int centerY, float scale, int slot, float partialTicks) {
        try {
            class_310 mc = class_310.method_1551();
            class_638 level = mc.field_1687;
            if (level == null) {
                return;
            }
            class_2338 pos = this.blockEntity != null ? this.blockEntity.method_11016() : new class_2338(this.x, this.y, this.z);
            class_1297 entity = VillagerRendererManager.getOrCreate((class_1937)level, pos, slot, villagerData);
            if (entity == null) {
                return;
            }
            entity.method_5648(false);
            class_4587 pose = new class_4587();
            pose.method_22903();
            pose.method_22904((double)centerX, (double)centerY, 100.0);
            pose.method_22905(0.22f, 0.22f, 0.22f);
            float yaw = 30.0f;
            if (entity instanceof CubeVillager) {
                CubeVillager cv = (CubeVillager)entity;
                try {
                    cv.reloadDataFromNBT(villagerData);
                    cv.setPocketCubePos(pos);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                le.method_36457(0.0f);
                le.method_36456(yaw);
                le.method_5847(yaw);
            }
            mc.method_22940().method_23000().method_37104();
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                int areaLeft = centerX - 16;
                int areaRight = centerX + 16;
                int areaTop = centerY - 40;
                int areaBottom = centerY + 40;
                class_490.method_2486((class_332)guiGraphics, (int)areaLeft, (int)areaTop, (int)areaRight, (int)areaBottom, (int)Math.max(16, Math.round(scale)), (float)(living.method_17682() < 1.5f ? 0.05f : 0.0625f), (float)((areaLeft + areaRight) / 2), (float)((areaTop + areaBottom) / 2), (class_1309)living);
                mc.method_22940().method_23000().method_37104();
                if (HologramToggle.isHologramEnabled()) {
                    this.renderHologramEffect(guiGraphics, centerX, centerY, areaLeft, areaRight, areaTop, areaBottom);
                }
            }
            pose.method_22909();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderHologramEffect(class_332 guiGraphics, int centerX, int centerY, int left, int right, int top, int bottom) {
        try {
            long t = System.currentTimeMillis();
            int baseAlpha = 40 + (int)((Math.sin((double)t * 0.006) + 1.0) * 20.0);
            int baseColor = baseAlpha << 24 | 0xD0FF;
            int halfW = 20;
            int halfH = 36;
            int l = Math.max(left, centerX - halfW);
            int r = Math.min(right, centerX + halfW);
            int u = Math.max(top, centerY - halfH) - 1;
            int d = Math.min(bottom, centerY + halfH) - 2;
            guiGraphics.method_25294(l, u, r, d, baseColor);
            for (int yy = u; yy < d; yy += 3) {
                double phase = Math.sin((double)t * 0.01 + (double)yy * 0.2);
                int alpha = (int)(8.0 + (phase + 1.0) * 12.0);
                guiGraphics.method_25294(l, yy, r, yy + 1, alpha << 24 | 0xD0FF);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

