/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.init.PocketVillagersModScreens;
import net.mcreator.pocketvillagers.network.MenuStateUpdateC2SPacket;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.world.inventory.StoragePocketCubeGUIMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_8710;

public class StoragePocketCubeGUIScreen
extends class_465<StoragePocketCubeGUIMenu>
implements PocketVillagersModScreens.FabricScreenAccessor {
    private final class_1937 world;
    private final int x;
    private final int y;
    private final int z;
    private StoragePocketCubeBlockEntity blockEntity;
    private int currentPage = 0;
    private static final int VILLAGERS_PER_PAGE = 5;
    private class_4185[] releaseButtons;
    private class_4185 hologramToggleButton;
    private boolean hologramLocal = true;
    private static final class_2960 texture = class_2960.method_60654((String)"pocket_villagers:textures/screens/storage_pocket_cube_gui.png");

    public StoragePocketCubeGUIScreen(StoragePocketCubeGUIMenu container, class_1661 inventory, class_2561 text) {
        super((class_1703)container, inventory, text);
        class_2586 be;
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.field_2792 = 262;
        this.field_2779 = 190;
        if (this.world != null && (be = this.world.method_8321(new class_2338(this.x, this.y, this.z))) instanceof StoragePocketCubeBlockEntity) {
            this.blockEntity = (StoragePocketCubeBlockEntity)be;
        }
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.releaseButtons != null) {
            for (class_4185 btn : this.releaseButtons) {
                if (btn == null) continue;
                btn.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }
        this.renderButtonTooltips(guiGraphics, mouseX, mouseY);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    private void renderButtonTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.releaseButtons == null) {
            return;
        }
        for (class_4185 btn : this.releaseButtons) {
            if (btn == null || !btn.method_25367() || !btn.field_22763) continue;
            this.drawCyanTooltip(guiGraphics, "Release Villager", mouseX, mouseY);
            break;
        }
    }

    private void drawCyanTooltip(class_332 guiGraphics, String text, int mouseX, int mouseY) {
        try {
            int pad = 6;
            int lineW = this.field_22793.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > this.field_22789 - 4) {
                x = this.field_22789 - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, -2147467184);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, -871747777);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, -16711681);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, -16711681);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), x + pad, y + pad - 2, -1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        try {
            guiGraphics.method_25290(texture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void renderVillagerHead(class_332 guiGraphics, int x, int y, int size, class_2487 villagerData) {
        guiGraphics.method_25294(x, y, x + size, y + size, -7631989);
        try {
            guiGraphics.method_25290(class_2960.method_60654((String)"pocket_villagers:textures/screens/villagerface.png"), x, y, 0.0f, 0.0f, size, size, size, size);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.releaseButtons != null) {
            for (class_4185 btn : this.releaseButtons) {
                if (btn == null || !btn.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int key, int b, int c) {
        if (key == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return super.method_25404(key, b, c);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.pocket_villagers.storage_pocket_cube_gui.label_storage_cube"), 81, 8, -12829636, false);
        int villagerCount = this.blockEntity != null ? this.blockEntity.getVillagerCount() : 0;
        int maxVillagers = this.blockEntity != null ? this.blockEntity.getMaxVillagers() : 10;
        guiGraphics.method_51433(this.field_22793, "Stored: " + villagerCount + "/" + maxVillagers, 8, 23, -12829636, false);
        int listStartX = 7;
        int listStartY = 37;
        int listEndX = this.field_2792 - 8;
        int listEndY = 155;
        guiGraphics.method_25294(listStartX, listStartY, listEndX, listEndY, -16711681);
        guiGraphics.method_25294(listStartX, listStartY, listEndX, listEndY, 0x2200FFFF);
        guiGraphics.method_49601(listStartX, listStartY, listEndX - listStartX, listEndY - listStartY, -1);
        if (this.blockEntity != null && villagerCount > 0) {
            int startIndex = this.currentPage * 5;
            int endIndex = Math.min(startIndex + 5, villagerCount);
            int yOffset = 42;
            int entryHeight = 23;
            for (int i = startIndex; i < endIndex; ++i) {
                class_2487 villagerData = this.blockEntity.getVillager(i);
                if (villagerData == null) continue;
                String rawProf = "minecraft:none";
                int level = 1;
                String rawType = "minecraft:plains";
                if (villagerData.method_10573("VillagerData", 10)) {
                    class_2487 nested = villagerData.method_10562("VillagerData");
                    if (nested.method_10545("profession")) {
                        rawProf = nested.method_10558("profession");
                    }
                    if (nested.method_10545("level")) {
                        level = nested.method_10550("level");
                    }
                    if (nested.method_10545("type")) {
                        rawType = nested.method_10558("type");
                    }
                } else {
                    if (villagerData.method_10545("profession")) {
                        rawProf = villagerData.method_10558("profession");
                    }
                    if (villagerData.method_10545("level")) {
                        level = villagerData.method_10550("level");
                    }
                    if (villagerData.method_10545("type")) {
                        rawType = villagerData.method_10558("type");
                    }
                }
                if (rawProf.contains(":")) {
                    rawProf = rawProf.split(":")[1];
                }
                Object profession = rawProf.equals("none") ? "Unemployed" : (rawProf.equals("nitwit") ? "Nitwit" : rawProf.substring(0, 1).toUpperCase() + rawProf.substring(1));
                if (rawType.contains(":")) {
                    rawType = rawType.split(":")[1];
                }
                String type = rawType.substring(0, 1).toUpperCase() + rawType.substring(1);
                boolean isConverted = false;
                if (villagerData.method_10545("PocketVillagers.Conversions")) {
                    isConverted = villagerData.method_10550("PocketVillagers.Conversions") > 0;
                }
                int entryBgY = yOffset - 3;
                int entryEndX = listEndX - 2;
                int entryWidth = entryEndX - 10;
                guiGraphics.method_25294(10, entryBgY, entryEndX, entryBgY + 20, -9737365);
                guiGraphics.method_49601(10, entryBgY, entryWidth, 20, -11908534);
                this.renderVillagerHead(guiGraphics, 12, entryBgY + 3, 14, villagerData);
                String conversionTag = isConverted ? "\u00a7c(C)\u00a7f" : "";
                String villagerText = String.format("[%d] %s%s Lv%d (%s)", i + 1, profession, conversionTag, level, type);
                guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)villagerText), 30, yOffset + 4, -1, false);
                if (i < endIndex - 1) {
                    guiGraphics.method_25294(11, yOffset + 17, entryEndX, yOffset + 18, -11908534);
                }
                yOffset += entryHeight;
            }
            int totalPages = (villagerCount + 5 - 1) / 5;
            if (totalPages > 1) {
                String pageText = "Page " + (this.currentPage + 1) + "/" + totalPages;
                int pageX = this.field_2792 / 2 - 20;
                guiGraphics.method_51433(this.field_22793, pageText, pageX, 160, -12829636, false);
            }
        } else {
            guiGraphics.method_51433(this.field_22793, "No villagers stored", 9, 85, -12829636, false);
        }
    }

    public void method_25426() {
        super.method_25426();
        int villagerCount = this.blockEntity != null ? this.blockEntity.getVillagerCount() : 0;
        int startIndex = this.currentPage * 5;
        int endIndex = Math.min(startIndex + 5, villagerCount);
        this.releaseButtons = new class_4185[5];
        for (int i = startIndex; i < endIndex; ++i) {
            int buttonRow = i - startIndex;
            int yPos = this.field_2800 + 42 + buttonRow * 23;
            int villagerIndex = i;
            class_4185 actionBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Release"), e -> {
                if (this.blockEntity != null) {
                    class_2338 blockPos = new class_2338(this.x, this.y, this.z);
                    ClientPlayNetworking.send((class_8710)new ReleaseStorageVillagerPacket(blockPos, villagerIndex));
                }
            }).method_46434(this.field_2776 + this.field_2792 - 60, yPos, 48, 14).method_46431();
            boolean hasVillager = false;
            try {
                if (this.blockEntity != null) {
                    class_2487 vt = this.blockEntity.getVillager(villagerIndex);
                    hasVillager = vt != null && !vt.method_33133();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            actionBtn.field_22763 = hasVillager;
            this.releaseButtons[buttonRow] = actionBtn;
        }
        int totalPages = (villagerCount + 5 - 1) / 5;
        if (totalPages > 1) {
            class_4185 prevButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), e -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                }
                this.method_25426();
            }).method_46434(this.field_2776 + 4, this.field_2800 + 160, 20, 20).method_46431();
            this.method_37063((class_364)prevButton);
            class_4185 nextButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), e -> {
                if (this.currentPage < totalPages - 1) {
                    ++this.currentPage;
                }
                this.method_25426();
            }).method_46434(this.field_2776 + this.field_2792 - 24, this.field_2800 + 160, 20, 20).method_46431();
            this.method_37063((class_364)nextButton);
        }
        try {
            boolean initial = true;
            try {
                if (this.blockEntity != null) {
                    initial = this.blockEntity.isHologramEnabled();
                }
            }
            catch (Throwable nextButton) {
                // empty catch block
            }
            this.hologramLocal = initial;
            String label = this.hologramLocal ? "Holo: ON" : "Holo: OFF";
            this.hologramToggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)label), e -> {
                this.hologramLocal = !this.hologramLocal;
                e.method_25355((class_2561)class_2561.method_43470((String)(this.hologramLocal ? "Holo: ON" : "Holo: OFF")));
                try {
                    ClientPlayNetworking.send((class_8710)new MenuStateUpdateC2SPacket(0, "storage_hologram_enabled", 0, this.hologramLocal ? "true" : "false"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).method_46434(this.field_2776 + this.field_2792 - 53, this.field_2800 + 6, 48, 14).method_46431();
            this.method_37063((class_364)this.hologramToggleButton);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

