/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.config;

import net.mcreator.pocketvillagers.config.PocketVillagersConfig;

public final class PocketVillagersConfigCache {
    private static volatile int ironFarmTickInterval = 6000;
    private static volatile int miningTickInterval = 6000;
    private static volatile int farmingTickInterval = 6000;
    private static volatile int fishingTickInterval = 3600;
    private static volatile int converterZombifyTime = 6000;
    private static volatile int converterCureTime = 6000;
    private static volatile int fuelDurationTicks = 6000;
    private static volatile boolean enableEfficiency = true;
    private static volatile double efficiencySpeedBonus = 0.1;
    private static volatile boolean enableFortune = true;
    private static volatile boolean enableVillagerHolograms = true;
    private static volatile double villagerRenderDistance = 64.0;
    private static volatile boolean requireFuelSlot = true;
    private static volatile int terminalTabTimeout = 300000;
    private static volatile int terminalMaxRange = 64;

    private PocketVillagersConfigCache() {
    }

    public static void updateFromConfig() {
        try {
            PocketVillagersConfig cfg = PocketVillagersConfig.getInstance();
            if (cfg != null) {
                ironFarmTickInterval = Math.max(1, cfg.getIronFarmTickInterval());
                miningTickInterval = Math.max(1, cfg.getMiningTickInterval());
                farmingTickInterval = Math.max(1, cfg.getFarmingTickInterval());
                fishingTickInterval = Math.max(1, cfg.getFishingTickInterval());
                converterZombifyTime = Math.max(1, cfg.getConverterZombifyTime());
                converterCureTime = Math.max(1, cfg.getConverterCureTime());
                fuelDurationTicks = Math.max(1, cfg.getFuelDurationTicks());
                enableEfficiency = cfg.enableEfficiency;
                efficiencySpeedBonus = Math.max(0.0, Math.min(0.99, cfg.efficiencySpeedBonus));
                enableFortune = cfg.enableFortune;
                enableVillagerHolograms = cfg.enableVillagerHolograms;
                villagerRenderDistance = Math.max(0.0, cfg.villagerRenderDistance);
                requireFuelSlot = cfg.requireFuelSlot;
                terminalTabTimeout = Math.max(0, cfg.terminalTabTimeout);
                terminalMaxRange = Math.max(0, cfg.terminalMaxRange);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getIronFarmTickInterval() {
        return ironFarmTickInterval;
    }

    public static int getMiningTickInterval() {
        return miningTickInterval;
    }

    public static int getFarmingTickInterval() {
        return farmingTickInterval;
    }

    public static int getFishingTickInterval() {
        return fishingTickInterval;
    }

    public static int getConverterZombifyTime() {
        return converterZombifyTime;
    }

    public static int getConverterCureTime() {
        return converterCureTime;
    }

    public static int getFuelDurationTicks() {
        return fuelDurationTicks;
    }

    public static boolean getEnableEfficiency() {
        return enableEfficiency;
    }

    public static double getEfficiencySpeedBonus() {
        return efficiencySpeedBonus;
    }

    public static boolean getEnableFortune() {
        return enableFortune;
    }

    public static boolean getEnableVillagerHolograms() {
        return enableVillagerHolograms;
    }

    public static double getVillagerRenderDistance() {
        return villagerRenderDistance;
    }

    public static boolean getRequireFuelSlot() {
        return requireFuelSlot;
    }

    public static int getTerminalTabTimeout() {
        return terminalTabTimeout;
    }

    public static int getTerminalMaxRange() {
        return terminalMaxRange;
    }

    public static void refresh() {
        PocketVillagersConfigCache.updateFromConfig();
    }
}

