/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.Collection;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class CubeVillager
extends class_1646 {
    private class_2338 pocketCubePos = null;
    private class_1916 cachedOffers = null;
    private class_1657 tradingPlayer = null;
    private boolean frozen = false;
    private int conversionCount = 0;
    private int conversionTime = 0;
    private class_3852 lastValidProfession = null;
    private static final String NBT_SAVED_PROFESSION = "PocketVillagers.SavedProfession";
    private boolean loadingFromNBT = false;

    public CubeVillager(class_1937 level) {
        super(class_1299.field_6077, level);
        try {
            this.method_5996(class_5134.field_23716);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!level.field_9236) {
            this.method_5977(true);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (!this.method_5987()) {
                this.method_5977(true);
            }
            if (this.lastValidProfession != null && this.lastValidProfession != class_3852.field_17051 && this.method_7231().method_16924() == class_3852.field_17051) {
                this.method_7195(this.method_7231().method_16921(this.lastValidProfession));
            }
            if (this.method_19269() > 0 && this.canLevelUp()) {
                int currentLevel = this.method_7231().method_16925();
                int nextLevelXp = this.getXpForLevel(currentLevel);
                if (this.method_19269() >= nextLevelXp) {
                    this.checkManualLevelUp();
                }
            }
        }
    }

    public void method_7195(class_3850 data) {
        class_3852 oldProf = this.method_7231().method_16924();
        class_3852 newProf = data.method_16924();
        if (newProf != class_3852.field_17051 && newProf != class_3852.field_17062) {
            this.lastValidProfession = newProf;
        }
        if (newProf == class_3852.field_17051 && this.lastValidProfession != null) {
            data = data.method_16921(this.lastValidProfession);
            newProf = this.lastValidProfession;
        }
        super.method_7195(data);
        if (oldProf == class_3852.field_17051 && newProf != class_3852.field_17051 && !this.loadingFromNBT) {
            try {
                class_2960 pk = class_7923.field_41195.method_10221((Object)newProf);
                if (pk != null && !"minecraft:none".equals(pk.toString())) {
                    PocketVillagersMod.LOGGER.debug("CubeVillager: Job assigned ({}). Generating initial random trades.", (Object)pk);
                    this.method_7237();
                    this.forceSaveToCube();
                }
            }
            catch (Throwable pk) {}
        } else if (this.loadingFromNBT) {
            try {
                class_2960 pk = class_7923.field_41195.method_10221((Object)newProf);
                PocketVillagersMod.LOGGER.debug("CubeVillager: Skipping trade generation during NBT load for {}", (Object)pk);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void method_8262(class_1914 offer) {
        this.field_6191 = -this.method_5970();
        if (!this.frozen) {
            int xp = offer.method_19279();
            this.method_19625(this.method_19269() + xp);
        }
        if (this.canLevelUp()) {
            int currentLevel = this.method_7231().method_16925();
            int nextLevelXp = this.getXpForLevel(currentLevel);
            if (this.method_19269() >= nextLevelXp) {
                this.checkManualLevelUp();
            }
        }
        try {
            Field usesField = class_1914.class.getDeclaredField("uses");
            usesField.setAccessible(true);
            usesField.setInt(offer, 0);
            Field maxUsesField = class_1914.class.getDeclaredField("maxUses");
            maxUsesField.setAccessible(true);
            maxUsesField.setInt(offer, Integer.MAX_VALUE);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("Failed to reset trade uses in notifyTrade: {}", (Object)t.getMessage());
        }
        this.forceSaveToCube();
    }

    private void checkManualLevelUp() {
        int currentLevel = this.method_7231().method_16925();
        int newLevel = currentLevel + 1;
        this.method_7195(this.method_7231().method_16920(newLevel));
        this.method_19625(0);
        try {
            class_3852 prof = this.method_7231().method_16924();
            class_2960 pk = class_7923.field_41195.method_10221((Object)prof);
            if (pk != null && !"minecraft:none".equals(pk.toString())) {
                class_2487 data = new class_2487();
                data.method_10582("VillagerData.profession", pk.toString());
                data.method_10569("VillagerData.level", newLevel);
                class_1916 newOffers = VillagerDataHandler.generateOffers(this.method_37908(), data, this.method_24515());
                if (newOffers != null && !newOffers.isEmpty()) {
                    if (this.method_8264() == null) {
                        this.method_16917(new class_1916());
                    }
                    this.method_8264().addAll((Collection)newOffers);
                    PocketVillagersMod.LOGGER.debug("Added {} new trades for level {}", (Object)newOffers.size(), (Object)newLevel);
                }
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("Error generating level-up trades", t);
        }
        if (!this.method_37908().method_8608()) {
            try {
                class_1657 tradingPlayer = this.method_8257();
                if (tradingPlayer instanceof class_3222) {
                    class_3222 sp = (class_3222)tradingPlayer;
                    class_5250 message = class_2561.method_43470((String)("\u00a76[Villager] \u00a7eLevel Up! \u00a7fVillager advanced to level " + newLevel + ". \u00a77Close and reopen the GUI to see new trades."));
                    sp.method_7353((class_2561)message, false);
                    PocketVillagersMod.LOGGER.debug("CubeVillager: Notified player of level-up: level={}", (Object)newLevel);
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("CubeVillager: Failed to notify player: {}", (Object)t.getMessage());
            }
        }
    }

    public void method_7237() {
        if (this.method_7231().method_16924() == class_3852.field_17051 && this.lastValidProfession != null) {
            this.method_7195(this.method_7231().method_16921(this.lastValidProfession));
        }
        try {
            class_3852 prof = this.method_7231().method_16924();
            class_2960 pk = class_7923.field_41195.method_10221((Object)prof);
            if (pk != null) {
                if (this.method_8264() == null || this.method_8264().isEmpty()) {
                    class_2487 data = new class_2487();
                    data.method_10582("VillagerData.profession", pk.toString());
                    data.method_10569("VillagerData.level", this.method_7231().method_16925());
                    class_1916 newOffers = VillagerDataHandler.generateOffers(this.method_37908(), data, this.method_24515());
                    if (newOffers != null && !newOffers.isEmpty()) {
                        this.method_16917(newOffers);
                        PocketVillagersMod.LOGGER.debug("Generated {} initial trades for {}", (Object)newOffers.size(), (Object)pk);
                    }
                } else {
                    PocketVillagersMod.LOGGER.debug("Skipping trade generation - villager already has {} offers", (Object)this.method_8264().size());
                }
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("CubeVillager: Trade Gen Error", t);
        }
    }

    public class_3852 getHardenedProfession() {
        if (this.lastValidProfession != null && this.lastValidProfession != class_3852.field_17051) {
            return this.lastValidProfession;
        }
        return this.method_7231().method_16924();
    }

    public boolean canLevelUp() {
        return this.method_7231().method_16925() < 5;
    }

    private int getXpForLevel(int level) {
        return switch (level) {
            case 1 -> 10;
            case 2 -> 70;
            case 3 -> 150;
            case 4 -> 250;
            default -> Integer.MAX_VALUE;
        };
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.lastValidProfession != null && this.lastValidProfession != class_3852.field_17051) {
            try {
                class_2960 pk = class_7923.field_41195.method_10221((Object)this.lastValidProfession);
                if (pk != null) {
                    compound.method_10582(NBT_SAVED_PROFESSION, pk.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        compound.method_10556("NoAI", true);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.restoreProfessionFromCustomTag(compound);
        if (!this.method_37908().field_9236) {
            this.method_5977(true);
        }
    }

    public void reloadDataFromNBT(class_2487 villagerNBT) {
        class_2487 vd;
        if (villagerNBT == null) {
            return;
        }
        this.loadingFromNBT = true;
        try {
            this.method_5749(villagerNBT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.restoreProfessionFromCustomTag(villagerNBT);
        class_3854 restoredType = null;
        if (villagerNBT.method_10545("VillagerData.type")) {
            try {
                String typeStr = villagerNBT.method_10558("VillagerData.type");
                if (typeStr != null && !typeStr.isEmpty()) {
                    restoredType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)typeStr));
                }
            }
            catch (Throwable typeStr) {
                // empty catch block
            }
        }
        if (restoredType == null && villagerNBT.method_10573("VillagerData", 10) && (vd = villagerNBT.method_10562("VillagerData")).method_10545("type")) {
            try {
                restoredType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)vd.method_10558("type")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (restoredType != null) {
            try {
                class_3850 currentData = this.method_7231();
                if (currentData.method_16919() != restoredType) {
                    this.method_7195(currentData.method_16922(restoredType));
                }
            }
            catch (Throwable currentData) {
                // empty catch block
            }
        }
        if (this.lastValidProfession == null && villagerNBT.method_10573("VillagerData", 10) && (vd = villagerNBT.method_10562("VillagerData")).method_10545("profession")) {
            try {
                class_3852 prof = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)vd.method_10558("profession")));
                if (prof != null && prof != class_3852.field_17051) {
                    this.lastValidProfession = prof;
                }
            }
            catch (Throwable prof) {
                // empty catch block
            }
        }
        if (this.lastValidProfession == null && villagerNBT.method_10545("VillagerData.profession")) {
            try {
                class_3852 prof = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)villagerNBT.method_10558("VillagerData.profession")));
                if (prof != null && prof != class_3852.field_17051) {
                    this.lastValidProfession = prof;
                }
            }
            catch (Throwable prof) {
                // empty catch block
            }
        }
        if (villagerNBT.method_10573("Offers", 10)) {
            try {
                PocketVillagersMod.LOGGER.debug("  - Parsing Offers from NBT...");
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_37908().method_30349());
                DataResult result = class_1916.field_48850.parse((DynamicOps)ops, (Object)villagerNBT.method_10580("Offers"));
                if (result.result().isPresent()) {
                    class_1916 parsed = (class_1916)result.result().get();
                    PocketVillagersMod.LOGGER.debug("  - Parsed {} offers from NBT", (Object)parsed.size());
                    this.method_8261(parsed);
                    PocketVillagersMod.LOGGER.debug("  - After overrideOffers, getOffers() has {} offers", (Object)(this.method_8264() != null ? this.method_8264().size() : 0));
                } else if (result.error().isPresent()) {
                    PocketVillagersMod.LOGGER.warn("  - Failed to parse Offers: {}", (Object)((DataResult.Error)result.error().get()).message());
                }
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.error("  - Exception parsing Offers: {}", (Object)t.getMessage());
            }
        } else {
            PocketVillagersMod.LOGGER.debug("  - No Offers tag in NBT (contains check returned false)");
            try {
                PocketVillagersMod.LOGGER.debug("  - NBT keys present: {}", (Object)villagerNBT.method_10541());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (villagerNBT.method_10545("Frozen")) {
            this.setFrozen(villagerNBT.method_10577("Frozen"));
        }
        if (villagerNBT.method_10545("PocketVillagers.Conversions")) {
            this.setConversionCount(villagerNBT.method_10550("PocketVillagers.Conversions"));
        }
        if (this.lastValidProfession != null && this.method_7231().method_16924() == class_3852.field_17051) {
            this.method_7195(this.method_7231().method_16921(this.lastValidProfession));
        }
        this.loadingFromNBT = false;
    }

    private void restoreProfessionFromCustomTag(class_2487 compound) {
        if (compound.method_10545(NBT_SAVED_PROFESSION)) {
            try {
                String key = compound.method_10558(NBT_SAVED_PROFESSION);
                class_3852 prof = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)key));
                if (prof != null && prof != class_3852.field_17051) {
                    this.lastValidProfession = prof;
                    if (this.method_7231().method_16924() == class_3852.field_17051) {
                        this.method_7195(this.method_7231().method_16921(prof));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void forceSaveToCube() {
        if (this.pocketCubePos != null && !this.method_37908().method_8608()) {
            VillagerDataHandler.saveVillagerDataToCube(this.method_37908(), this.pocketCubePos, this);
        }
    }

    public class_2338 getPocketCubePos() {
        return this.pocketCubePos;
    }

    public void setPocketCubePos(class_2338 pos) {
        this.pocketCubePos = pos;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setConversionCount(int count) {
        this.conversionCount = count;
    }

    public int getConversionCount() {
        return this.conversionCount;
    }

    public void setConversionTime(int time) {
        this.conversionTime = time;
    }

    public int getConversionTime() {
        return this.conversionTime;
    }

    public void method_19625(int xp) {
        if (!this.frozen) {
            super.method_19625(xp);
        }
    }

    public class_1916 method_8264() {
        class_1916 offers;
        class_1916 class_19162 = offers = this.cachedOffers != null ? this.cachedOffers : super.method_8264();
        if (offers != null && this.conversionCount > 0) {
            for (class_1914 o : offers) {
                int baseCost = o.method_8246().method_7947();
                int discount = (int)Math.floor((double)baseCost * 0.9);
                if (discount <= 0) continue;
                o.method_8245(-discount);
            }
        }
        return offers;
    }

    public void method_16917(class_1916 offers) {
        this.cachedOffers = offers;
        super.method_16917(offers);
    }

    public void method_8261(class_1916 offers) {
        this.method_16917(offers);
    }

    public boolean method_5863() {
        return false;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (reason != class_1297.class_5529.field_26999) {
            this.forceSaveToCube();
        }
        super.method_5650(reason);
    }
}

