/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.handler;

import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.util.CandidateToKeyString;
import net.mcreator.pocketvillagers.util.VillagerDataCompat;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.mcreator.pocketvillagers.util.VillagerWorkstationResolver;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3966;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class VillagerCaptureHandler {
    public static void register() {
        UseEntityCallback.EVENT.register(VillagerCaptureHandler::onEntityInteract);
    }

    private static class_1269 onEntityInteract(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_1792 item;
        class_1799 heldItem;
        class_1646 villager;
        block42: {
            try {
                if (level.method_8608()) {
                    PocketVillagersMod.LOGGER.debug("VillagerCaptureHandler (client): onEntityInteract called for entity={} hand={}", (Object)entity, (Object)hand);
                } else {
                    PocketVillagersMod.LOGGER.debug("VillagerCaptureHandler: onEntityInteract called for entity={} hand={}", (Object)entity, (Object)hand);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!(entity instanceof class_1646)) {
                return class_1269.field_5811;
            }
            villager = (class_1646)entity;
            if (entity instanceof CubeVillager) {
                return class_1269.field_5811;
            }
            heldItem = player.method_5998(hand);
            if (!villager.method_6109()) {
                try {
                    class_1747 blockItem;
                    class_2248 block;
                    String professionId;
                    class_1792 item2;
                    class_3850 villagerData = villager.method_7231();
                    Object professionObj = VillagerDataCompat.getProfessionObject(villagerData);
                    String professionIdStr = CandidateToKeyString.toRegistryKeyString(professionObj);
                    boolean isUnemployed = "minecraft:none".equals(professionIdStr);
                    boolean isManuallyJobbed = villager.method_5752().contains("PocketVillagers.ManuallyJobbed");
                    if (!isUnemployed && !isManuallyJobbed || heldItem.method_7960() || !((item2 = heldItem.method_7909()) instanceof class_1747) || (professionId = VillagerWorkstationResolver.getProfessionForWorkstation(block = (blockItem = (class_1747)item2).method_7711())) == null || professionId.isEmpty() || "minecraft:none".equals(professionId)) break block42;
                    if (!level.method_8608()) {
                        int villagerXp = villager.method_19269();
                        if (villagerXp > 0) {
                            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot change profession - this villager has been traded with!"), true);
                            return class_1269.field_21466;
                        }
                        class_2960 newProfessionRl = class_2960.method_60654((String)professionId);
                        class_3852 newProfessionOpt = (class_3852)class_7923.field_41195.method_10223(newProfessionRl);
                        if (newProfessionOpt == null) break block42;
                        class_3850 currentVillagerData = villager.method_7231();
                        class_3850 newVillagerData = currentVillagerData.method_16921(newProfessionOpt);
                        villager.method_7195(newVillagerData);
                        villager.method_5780("PocketVillagers.ManuallyJobbed");
                        try {
                            class_4095 brain = villager.method_18868();
                            class_4140 memoryModuleType = class_4140.field_18439;
                            class_4208 globalPos = class_4208.method_19443((class_5321)level.method_27983(), (class_2338)villager.method_24515());
                            brain.method_24525(memoryModuleType, (Object)globalPos, 999999999L);
                        }
                        catch (Throwable brain) {
                            // empty catch block
                        }
                        level.method_8396(null, villager.method_24515(), class_3417.field_14815, class_3419.field_15254, 1.0f, 1.0f);
                        if (!player.method_7337()) {
                            heldItem.method_7934(1);
                        }
                        String profName = professionId.replace("minecraft:", "").replace("_", " ");
                        String message = isManuallyJobbed ? "\u00a7aVillager changed to " + profName + "!" : "\u00a7aVillager is now a " + profName + "!";
                        player.method_7353((class_2561)class_2561.method_43470((String)message), true);
                        return class_1269.field_5812;
                    }
                    return class_1269.field_5812;
                }
                catch (Throwable villagerData) {
                    // empty catch block
                }
            }
        }
        if (villager.method_6109()) {
            item = heldItem.method_7909();
            if (item == PocketVillagersModBlocks.POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.STORAGE_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.BREEDER_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE.method_8389()) {
                if (!level.method_8608()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCannot capture baby villagers"), true);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        try {
            boolean canCapture;
            item = heldItem.method_7909();
            if (item != PocketVillagersModBlocks.POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.AUTO_TRADER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.STORAGE_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.CONVERTER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.BREEDER_POCKET_CUBE.method_8389() && item != PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE.method_8389()) {
                return class_1269.field_5811;
            }
            if (item == PocketVillagersModBlocks.CONVERTER_POCKET_CUBE.method_8389() && VillagerDataHandler.isConvertedEntity(villager)) {
                if (level.method_8608()) {
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis villager has already been converted and cannot be captured."), true);
                return class_1269.field_5814;
            }
            if (item == PocketVillagersModBlocks.STORAGE_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleStorageCubeCapture(player, level, villager, heldItem, hand);
            }
            if (item == PocketVillagersModBlocks.BREEDER_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleBreederCubeCapture(player, level, villager, heldItem);
            }
            if (item == PocketVillagersModBlocks.IRON_FARM_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleIronFarmCubeCapture(player, level, villager, heldItem);
            }
            if (item == PocketVillagersModBlocks.AUTO_TRADER_POCKET_CUBE.method_8389()) {
                return VillagerCaptureHandler.handleAutoTraderCubeCapture(player, level, villager, heldItem);
            }
            boolean bl = canCapture = !VillagerDataHandler.hasVillager(heldItem);
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            if (!canCapture) {
                player.method_7353((class_2561)class_2561.method_43470((String)"This Pocket Cube already contains a villager!"), true);
                return class_1269.field_5812;
            }
            if (item == PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389() || item == PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389()) {
                class_2960 profResourceKey = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924());
                String professionStr = profResourceKey != null ? profResourceKey.toString() : "minecraft:none";
                PocketVillagersMod.LOGGER.debug("Automation Capture: Item={} ActualRegistryProfession={}", (Object)item, (Object)professionStr);
                if (item == PocketVillagersModBlocks.MINING_POCKET_CUBE.method_8389()) {
                    if (!"minecraft:armorer".equals(professionStr)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Armorer villagers!"), true);
                        return class_1269.field_5814;
                    }
                } else if (item == PocketVillagersModBlocks.FISHING_POCKET_CUBE.method_8389()) {
                    if (!"minecraft:fisherman".equals(professionStr)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Fisherman villagers!"), true);
                        return class_1269.field_5814;
                    }
                } else if (item == PocketVillagersModBlocks.FARMING_POCKET_CUBE.method_8389() && !"minecraft:farmer".equals(professionStr)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This pocket cube only accepts Farmer villagers!"), true);
                    return class_1269.field_5814;
                }
            }
            try {
                class_3854 plainsType;
                class_3850 vd = villager.method_7231();
                class_3854 currentType = vd.method_16919();
                if (currentType == null && (plainsType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)"minecraft:plains"))) != null) {
                    villager.method_7195(vd.method_16922(plainsType));
                }
            }
            catch (Throwable vd) {
                // empty catch block
            }
            VillagerDataHandler.storeVillagerInItem(heldItem, villager, level);
            villager.method_5650(class_1297.class_5529.field_26999);
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            try {
                Object profPath;
                class_2960 pk = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924());
                Object object = profPath = pk != null && !"minecraft:none".equals(pk.toString()) ? pk.method_12832() : "Villager";
                if (((String)profPath).length() > 0) {
                    profPath = ((String)profPath).substring(0, 1).toUpperCase() + ((String)profPath).substring(1);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7b" + (String)profPath + " Captured!")), true);
            }
            catch (Throwable ignored) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7bVillager Captured!"), true);
            }
            return class_1269.field_5812;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("Error in capture handler", t);
            return class_1269.field_5811;
        }
    }

    private static class_1269 handleStorageCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem, class_1268 hand) {
        class_2487 tempTag;
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_9279 customData = (class_9279)heldItem.method_57824(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        int villagerCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (!tag.method_10545("Villager" + i)) continue;
            ++villagerCount;
        }
        if (villagerCount >= 10) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 10 villagers"), true);
            return class_1269.field_5814;
        }
        class_1799 tempStack = new class_1799((class_1935)heldItem.method_7909());
        VillagerDataHandler.storeVillagerInItem(tempStack, villager, level);
        class_9279 tempData = (class_9279)tempStack.method_57824(class_9334.field_49628);
        if (tempData != null && (tempTag = tempData.method_57461()).method_10545("VillagerData")) {
            class_2487 villagerData = tempTag.method_10562("VillagerData");
            PocketVillagersMod.LOGGER.debug("[DEBUG] handleStorageCubeCapture: Stored villager data:");
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has Offers: {}", (Object)villagerData.method_10545("Offers"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has VillagerData: {}", (Object)villagerData.method_10545("VillagerData"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Xp: {}", (Object)villagerData.method_10550("Xp"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Top-level keys: {}", (Object)villagerData.method_10541());
            for (int i = 0; i < 10; ++i) {
                if (tag.method_10545("Villager" + i)) continue;
                tag.method_10566("Villager" + i, (class_2520)villagerData);
                break;
            }
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/10)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleBreederCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        class_2487 tempTag;
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        try {
            String prof;
            class_2960 pk = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924());
            String string = prof = pk != null ? pk.toString() : "minecraft:none";
            if (!"minecraft:none".equals(prof) && !"minecraft:nitwit".equals(prof)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBreeder pocket cube can only capture unemployed villagers!"), true);
                return class_1269.field_5814;
            }
        }
        catch (Throwable pk) {
            // empty catch block
        }
        class_9279 customData = (class_9279)heldItem.method_57824(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        int villagerCount = 0;
        for (int i = 0; i < 2; ++i) {
            if (!tag.method_10545("Villager" + i)) continue;
            ++villagerCount;
        }
        if (villagerCount >= 2) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 2 villagers"), true);
            return class_1269.field_5814;
        }
        class_1799 tempStack = new class_1799((class_1935)heldItem.method_7909());
        VillagerDataHandler.storeVillagerInItem(tempStack, villager, level);
        class_9279 tempData = (class_9279)tempStack.method_57824(class_9334.field_49628);
        if (tempData != null && (tempTag = tempData.method_57461()).method_10545("VillagerData")) {
            class_2487 villagerData = tempTag.method_10562("VillagerData");
            for (int i = 0; i < 2; ++i) {
                if (tag.method_10545("Villager" + i)) continue;
                tag.method_10566("Villager" + i, (class_2520)villagerData);
                break;
            }
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/2)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleIronFarmCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        class_2487 tempTag;
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        try {
            String prof;
            class_2960 pk = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924());
            String string = prof = pk != null ? pk.toString() : "minecraft:none";
            if (!"minecraft:none".equals(prof) && !"minecraft:nitwit".equals(prof)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cIron Farm pocket cube can only capture unemployed villagers!"), true);
                return class_1269.field_5814;
            }
        }
        catch (Throwable pk) {
            // empty catch block
        }
        class_9279 customData = (class_9279)heldItem.method_57824(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        int villagerCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (!tag.method_10545("Villager" + i)) continue;
            ++villagerCount;
        }
        if (villagerCount >= 3) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax capacity - already contains 3 villagers"), true);
            return class_1269.field_5814;
        }
        class_1799 tempStack = new class_1799((class_1935)heldItem.method_7909());
        VillagerDataHandler.storeVillagerInItem(tempStack, villager, level);
        class_9279 tempData = (class_9279)tempStack.method_57824(class_9334.field_49628);
        if (tempData != null && (tempTag = tempData.method_57461()).method_10545("VillagerData")) {
            class_2487 villagerData = tempTag.method_10562("VillagerData");
            for (int i = 0; i < 3; ++i) {
                if (tag.method_10545("Villager" + i)) continue;
                tag.method_10566("Villager" + i, (class_2520)villagerData);
                break;
            }
        }
        heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7bVillager Captured! (" + (villagerCount + 1) + "/3)")), true);
        return class_1269.field_5812;
    }

    private static class_1269 handleAutoTraderCubeCapture(class_1657 player, class_1937 level, class_1646 villager, class_1799 heldItem) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        try {
            String professionStr;
            class_2960 pk = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924());
            String string = professionStr = pk != null ? pk.toString() : "minecraft:none";
            if ("minecraft:none".equals(professionStr)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cAuto Trader requires a villager with a profession!"), true);
                return class_1269.field_5814;
            }
        }
        catch (Throwable t) {
            return class_1269.field_5814;
        }
        if (VillagerDataHandler.hasVillager(heldItem)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis Auto Trader already contains a villager!"), true);
            return class_1269.field_5814;
        }
        VillagerDataHandler.storeVillagerInItem(heldItem, villager, level);
        try {
            class_9279 customData = (class_9279)heldItem.method_57824(class_9334.field_49628);
            if (customData != null) {
                class_2487 tag = customData.method_57461();
                tag.method_10556("Frozen", true);
                heldItem.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        villager.method_5650(class_1297.class_5529.field_26999);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7bVillager Captured!"), true);
        return class_1269.field_5812;
    }
}

