/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1916;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class FishingPocketCubeItem
extends class_1747 {
    public FishingPocketCubeItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> components, class_1836 flag) {
        super.method_7851(stack, context, components, flag);
        this.buildTooltip(stack, components::add);
    }

    private void buildTooltip(class_1799 stack, Consumer<class_2561> adder) {
        if (VillagerDataHandler.hasVillager(stack)) {
            class_2487 villagerData = VillagerDataHandler.getVillagerData(stack);
            adder.accept((class_2561)class_2561.method_43470((String)""));
            adder.accept((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l\u2728 Captured Villager \u2728"));
            adder.accept((class_2561)class_2561.method_43470((String)""));
            if (villagerData.method_10545("CustomName")) {
                String customName = villagerData.method_10545("CustomName") ? villagerData.method_10558("CustomName") : "Unnamed";
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Name: \u00a7e" + customName)));
            }
            if (villagerData.method_10545("VillagerData.profession")) {
                String profession;
                String string = profession = villagerData.method_10545("VillagerData.profession") ? villagerData.method_10558("VillagerData.profession") : "minecraft:none";
                if (!profession.isEmpty() && !"minecraft:none".equals(profession)) {
                    adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Profession: \u00a7a" + this.formatProfession(profession))));
                } else {
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Profession: \u00a77Unemployed"));
                }
            } else {
                adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Profession: \u00a77Unemployed"));
            }
            if (villagerData.method_10545("VillagerData.level")) {
                int level = villagerData.method_10545("VillagerData.level") ? villagerData.method_10550("VillagerData.level") : 1;
                String levelName = this.getLevelName(level);
                String stars = this.getLevelStars(level);
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Level: \u00a7b" + levelName + " " + stars)));
            }
            if (villagerData.method_10545("Xp")) {
                int xp = villagerData.method_10545("Xp") ? villagerData.method_10550("Xp") : 0;
                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Experience: \u00a73" + xp + " XP")));
                if (xp > 0) {
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Status: \u00a7aLocked Profession"));
                }
            }
            if (villagerData.method_10545("Offers")) {
                class_2487 offersTag;
                class_2487 class_24872 = offersTag = villagerData.method_10545("Offers") ? villagerData.method_10562("Offers") : null;
                if (offersTag != null) {
                    try {
                        DataResult result = class_1916.field_48850.parse((DynamicOps)class_2509.field_11560, (Object)offersTag);
                        if (result.result().isPresent()) {
                            int unlockedCount;
                            class_1916 offers = (class_1916)result.result().get();
                            int totalOffers = offers.size();
                            int n = unlockedCount = villagerData.method_10545("UnlockedCount") ? villagerData.method_10550("UnlockedCount") : totalOffers;
                            if (unlockedCount < totalOffers) {
                                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Trades: \u00a7e" + unlockedCount + "\u00a77/\u00a76" + totalOffers + " \u00a77unlocked")));
                            } else {
                                adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Trades: \u00a7e" + totalOffers + " \u00a77available")));
                            }
                        }
                    }
                    catch (Exception e) {
                        adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Trades: \u00a7cError loading"));
                    }
                }
            }
            adder.accept((class_2561)class_2561.method_43470((String)""));
            adder.accept((class_2561)class_2561.method_43470((String)"\u00a78Right-click to place"));
        } else {
            try {
                class_9279 cd;
                class_2487 root = null;
                try {
                    Method m = class_1799.class.getMethod("getOrCreateTag", new Class[0]);
                    Object r = m.invoke((Object)stack, new Object[0]);
                    if (r instanceof class_2487) {
                        class_2487 rtag = (class_2487)r;
                        root = rtag.method_10545("BlockEntityTag") ? rtag.method_10562("BlockEntityTag") : null;
                    }
                }
                catch (Throwable m) {
                    // empty catch block
                }
                if (root == null && (cd = (class_9279)stack.method_57824(class_9334.field_49628)) != null) {
                    class_2487 ctag = cd.method_57461();
                    class_2487 class_24873 = root = ctag.method_10545("BlockEntityTag") ? ctag.method_10562("BlockEntityTag") : null;
                }
                if (root != null) {
                    boolean can = root.method_10545("CanAutomate") ? root.method_10577("CanAutomate") : false;
                    int ticks = root.method_10545("ProgressTicks") ? root.method_10550("ProgressTicks") : 0;
                    int needed = root.method_10545("ProgressNeeded") ? root.method_10550("ProgressNeeded") : 0;
                    adder.accept((class_2561)class_2561.method_43470((String)""));
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a76\u00a7lFishing Automation"));
                    adder.accept((class_2561)class_2561.method_43470((String)""));
                    adder.accept((class_2561)class_2561.method_43470((String)"\u00a77Requires: \u00a7eRod"));
                    adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Can automate: " + (can ? "\u00a7aYes" : "\u00a7cNo"))));
                    if (needed > 0) {
                        int rem = Math.max(0, needed - ticks);
                        adder.accept((class_2561)class_2561.method_43470((String)("\u00a77Progress: \u00a7e" + rem + "\u00a77/\u00a7b" + needed + " ticks")));
                    }
                    adder.accept((class_2561)class_2561.method_43470((String)""));
                    adder.accept((class_2561)class_2561.method_43471((String)"tooltip.pocket_villagers.fishing_pocket_cube"));
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            adder.accept((class_2561)class_2561.method_43471((String)"tooltip.pocket_villagers.fishing_pocket_cube"));
        }
    }

    private String getLevelName(int level) {
        return switch (level) {
            case 1 -> "Novice";
            case 2 -> "Apprentice";
            case 3 -> "Journeyman";
            case 4 -> "Expert";
            case 5 -> "Master";
            default -> "Unknown";
        };
    }

    private String getLevelStars(int level) {
        return switch (level) {
            case 1 -> "\u00a7e\u2605\u00a78\u2605\u2605\u2605\u2605";
            case 2 -> "\u00a7e\u2605\u2605\u00a78\u2605\u2605\u2605";
            case 3 -> "\u00a7e\u2605\u2605\u2605\u00a78\u2605\u2605";
            case 4 -> "\u00a7e\u2605\u2605\u2605\u2605\u00a78\u2605";
            case 5 -> "\u00a7e\u2605\u2605\u2605\u2605\u2605";
            default -> "\u00a78\u2605\u2605\u2605\u2605\u2605";
        };
    }

    private String formatProfession(String professionId) {
        String[] parts = professionId.split(":");
        String name = parts.length > 1 ? parts[1] : parts[0];
        String[] words = name.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }
}

