/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.client.gui.PocketTerminalScreen;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record SyncStorageContentsPayload(class_2338 storagePos, List<VillagerSlotData> villagers) implements class_8710
{
    public static final class_8710.class_9154<SyncStorageContentsPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"sync_storage_contents"));
    public static final class_9139<class_2540, SyncStorageContentsPayload> CODEC = class_9139.method_56437((buf, payload) -> {
        buf.method_10807(payload.storagePos);
        buf.method_53002(payload.villagers.size());
        for (VillagerSlotData slot : payload.villagers) {
            buf.method_53002(slot.slotIndex);
            buf.method_52964(slot.isEmpty);
            if (slot.isEmpty) continue;
            buf.method_10814(slot.profession);
            buf.method_10814(slot.displayName);
            buf.method_53002(slot.level);
            buf.method_53002(slot.xp);
            buf.method_53002(slot.conversionCount);
            buf.method_10794((class_2520)slot.fullNBT);
        }
    }, buf -> {
        class_2338 pos = buf.method_10811();
        int size = buf.readInt();
        ArrayList<VillagerSlotData> villagers = new ArrayList<VillagerSlotData>();
        for (int i = 0; i < size; ++i) {
            int slotIndex = buf.readInt();
            boolean isEmpty = buf.readBoolean();
            if (isEmpty) {
                villagers.add(new VillagerSlotData(slotIndex, true, "", "", 0, 0, 0, null));
                continue;
            }
            String profession = buf.method_19772();
            String displayName = buf.method_19772();
            int level = buf.readInt();
            int xp = buf.readInt();
            int conversionCount = buf.readInt();
            class_2487 nbt = buf.method_10798();
            villagers.add(new VillagerSlotData(slotIndex, false, profession, displayName, level, xp, conversionCount, nbt));
        }
        return new SyncStorageContentsPayload(pos, villagers);
    });

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void sendToPlayer(class_3222 player, class_2338 storagePos, List<VillagerSlotData> villagers) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncStorageContentsPayload(storagePos, villagers));
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.client().execute(() -> {
            class_437 patt0$temp = context.client().field_1755;
            if (patt0$temp instanceof PocketTerminalScreen) {
                PocketTerminalScreen terminalScreen = (PocketTerminalScreen)patt0$temp;
                try {
                    Method method = terminalScreen.getClass().getDeclaredMethod("onStorageContentsReceived", class_2338.class, List.class);
                    method.setAccessible(true);
                    method.invoke((Object)terminalScreen, payload.storagePos(), payload.villagers());
                }
                catch (Exception e) {
                    PocketVillagersMod.LOGGER.error("[POCKET TERMINAL] Failed to update storage contents", (Throwable)e);
                }
            }
        }));
    }

    public static class VillagerSlotData {
        public final int slotIndex;
        public final boolean isEmpty;
        public final String profession;
        public final String displayName;
        public final int level;
        public final int xp;
        public final int conversionCount;
        public final class_2487 fullNBT;

        public VillagerSlotData(int slotIndex, boolean isEmpty, String profession, String displayName, int level, int xp, int conversionCount, class_2487 fullNBT) {
            this.slotIndex = slotIndex;
            this.isEmpty = isEmpty;
            this.profession = profession;
            this.displayName = displayName;
            this.level = level;
            this.xp = xp;
            this.conversionCount = conversionCount;
            this.fullNBT = fullNBT;
        }
    }
}

