/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.network.SyncFacingYawPayload;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_11515;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class PocketCubeBlock
extends class_2383
implements class_2343 {
    private static final MapCodec<PocketCubeBlock> CODEC = MapCodec.unit(() -> new PocketCubeBlock(class_4970.class_2251.method_9637()));
    private static final ThreadLocal<class_2487> breakingVillagerData = new ThreadLocal();
    private static final Map<String, Set<class_2960>> PROFESSION_WORKSTATIONS = new HashMap<String, Set<class_2960>>();
    private static final Map<String, String> POI_TO_PROFESSION_CACHE;

    public MapCodec<PocketCubeBlock> method_53969() {
        return CODEC;
    }

    public PocketCubeBlock(class_4970.class_2251 properties) {
        super(properties.method_9626(class_2498.field_11533).method_9629(0.5f, 290.0f).method_9631(s -> 15).method_50012(class_3619.field_15975));
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 facing = context.method_8042().method_10153();
        try {
            PocketVillagersMod.LOGGER.debug("[DEBUG POCKET CUBE] getStateForPlacement called. Player facing: {} , Block will face: {}", (Object)context.method_8042(), (Object)facing);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing);
    }

    private static String workstationToProfession(class_1799 workstation, class_1937 level) {
        block102: {
            class_1792 profReg;
            class_1792 heldKey;
            class_2960 provisionalPoi;
            block101: {
                block97: {
                    block96: {
                        if (workstation == null || workstation.method_7960()) {
                            return null;
                        }
                        provisionalPoi = null;
                        try {
                            String mapped;
                            class_1747 bitem2;
                            class_1792 class_17922 = workstation.method_7909();
                            if (!(class_17922 instanceof class_1747) || (heldKey = class_7923.field_41175.method_10221((Object)(bitem2 = (class_1747)class_17922).method_7711())) == null || (mapped = PocketVillagersMod.COMPAT_WORKSTATION_PROFESSION.get(heldKey.toString())) == null) break block96;
                            try {
                                PocketVillagersMod.LOGGER.debug("workstationToProfession: config mapping used for {} -> {}", (Object)heldKey, (Object)mapped);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return mapped;
                        }
                        catch (Throwable bitem2) {
                            // empty catch block
                        }
                    }
                    try {
                        heldKey = workstation.method_7909();
                        if (!(heldKey instanceof class_1747)) break block97;
                        class_1747 bitem3 = (class_1747)heldKey;
                        class_2248 block = bitem3.method_7711();
                        class_2680 heldState = block.method_9564();
                        class_2378 class_23782 = class_7923.field_41128;
                        if (class_23782 == null) break block97;
                        for (Map.Entry entry : class_23782.method_29722()) {
                            try {
                                Collection states;
                                Object poiType;
                                block98: {
                                    poiType = entry.getValue();
                                    states = null;
                                    try {
                                        Method[] methods = poiType.getClass().getMethods();
                                        for (Method method : methods) {
                                            Object ret;
                                            String name = method.getName();
                                            if (!name.equals("matchingStates") && !name.equals("getMatchingStates") && !name.equals("validStates") && !name.equals("getValidStates") || !Collection.class.isAssignableFrom(method.getReturnType()) || !((ret = method.invoke(poiType, new Object[0])) instanceof Collection)) continue;
                                            states = (Collection)ret;
                                            break;
                                        }
                                        if (states != null) break block98;
                                        try {
                                            Field field = poiType.getClass().getDeclaredField("matchingStates");
                                            field.setAccessible(true);
                                            Object val = field.get(poiType);
                                            if (val instanceof Collection) {
                                                states = (Collection)val;
                                            }
                                        }
                                        catch (NoSuchFieldException field) {}
                                    }
                                    catch (Throwable methods) {
                                        // empty catch block
                                    }
                                }
                                if (states == null) continue;
                                for (Object o : states) {
                                    try {
                                        class_7922 profReg2;
                                        class_2680 bs;
                                        if (!(o instanceof class_2680) || !(bs = (class_2680)o).equals((Object)heldState)) continue;
                                        try {
                                            provisionalPoi = ((class_5321)entry.getKey()).method_29177();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        try {
                                            PocketVillagersMod.LOGGER.debug("workstationToProfession: matched POI {} for block {}", (Object)((class_5321)entry.getKey()).method_29177(), (Object)class_7923.field_41175.method_10221((Object)block));
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        if ((profReg2 = class_7923.field_41195) == null) continue;
                                        for (Map.Entry pentry : profReg2.method_29722()) {
                                            try {
                                                Object rl;
                                                Object rk;
                                                Object profPoi;
                                                block100: {
                                                    block99: {
                                                        class_3852 profObj = (class_3852)pentry.getValue();
                                                        profPoi = null;
                                                        try {
                                                            Method m2 = profObj.getClass().getMethod("pointOfInterest", new Class[0]);
                                                            profPoi = m2.invoke((Object)profObj, new Object[0]);
                                                        }
                                                        catch (Throwable t1) {
                                                            try {
                                                                Method m2 = profObj.getClass().getMethod("getPointOfInterest", new Class[0]);
                                                                profPoi = m2.invoke((Object)profObj, new Object[0]);
                                                            }
                                                            catch (Throwable m2) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        try {
                                                            PocketVillagersMod.LOGGER.debug("workstationToProfession: inspecting profession {} profPoi={}", (Object)((class_5321)pentry.getKey()).method_29177(), (Object)(profPoi == null ? "<null>" : profPoi.getClass().getName()));
                                                            if (profPoi == null) break block99;
                                                            try {
                                                                Optional maybe2;
                                                                Object opt2;
                                                                Method unwrapKeyM2 = null;
                                                                try {
                                                                    unwrapKeyM2 = profPoi.getClass().getMethod("unwrapKey", new Class[0]);
                                                                }
                                                                catch (Throwable m2) {
                                                                    // empty catch block
                                                                }
                                                                if (unwrapKeyM2 != null && (opt2 = unwrapKeyM2.invoke(profPoi, new Object[0])) instanceof Optional && (maybe2 = (Optional)opt2).isPresent()) {
                                                                    rk = maybe2.get();
                                                                    try {
                                                                        Method locM2 = rk.getClass().getMethod("location", new Class[0]);
                                                                        rl = locM2.invoke(rk, new Object[0]);
                                                                        PocketVillagersMod.LOGGER.debug("workstationToProfession: profession {} unwrapKey -> {}", (Object)((class_5321)pentry.getKey()).method_29177(), (Object)(rl == null ? "<null>" : rl.toString()));
                                                                    }
                                                                    catch (Throwable locM2) {}
                                                                }
                                                            }
                                                            catch (Throwable unwrapKeyM2) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                PocketVillagersMod.LOGGER.debug("workstationToProfession: profession {} profPoi.toString()={}", (Object)((class_5321)pentry.getKey()).method_29177(), (Object)profPoi.toString());
                                                            }
                                                            catch (Throwable unwrapKeyM2) {}
                                                        }
                                                        catch (Throwable unwrapKeyM2) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (profPoi == null) continue;
                                                    try {
                                                        String poiKeyStr = ((class_5321)entry.getKey()).method_29177().toString();
                                                        if (profPoi == poiType || profPoi.equals(poiType)) {
                                                            try {
                                                                PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} via direct POI equality", (Object)((class_5321)pentry.getKey()).method_29177());
                                                            }
                                                            catch (Throwable opt2) {
                                                                // empty catch block
                                                            }
                                                            return ((class_5321)pentry.getKey()).method_29177().toString();
                                                        }
                                                        try {
                                                            String profPoiStr = profPoi.toString();
                                                            if (profPoiStr == null || !profPoiStr.contains(poiKeyStr)) break block100;
                                                            try {
                                                                PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} via POI string compare", (Object)((class_5321)pentry.getKey()).method_29177());
                                                            }
                                                            catch (Throwable maybe2) {
                                                                // empty catch block
                                                            }
                                                            return ((class_5321)pentry.getKey()).method_29177().toString();
                                                        }
                                                        catch (Throwable profPoiStr) {}
                                                    }
                                                    catch (Throwable poiKeyStr) {
                                                        // empty catch block
                                                    }
                                                }
                                                try {
                                                    Optional maybe;
                                                    Object opt;
                                                    Method unwrapKeyM3 = null;
                                                    try {
                                                        unwrapKeyM3 = profPoi.getClass().getMethod("unwrapKey", new Class[0]);
                                                    }
                                                    catch (Throwable profPoiStr) {
                                                        // empty catch block
                                                    }
                                                    if (unwrapKeyM3 == null || !((opt = unwrapKeyM3.invoke(profPoi, new Object[0])) instanceof Optional) || !(maybe = (Optional)opt).isPresent()) continue;
                                                    rk = maybe.get();
                                                    try {
                                                        class_2960 target;
                                                        Method locM = rk.getClass().getMethod("location", new Class[0]);
                                                        rl = locM.invoke(rk, new Object[0]);
                                                        if (!(rl instanceof class_2960) || !((class_2960)rl).equals((Object)(target = ((class_5321)entry.getKey()).method_29177()))) continue;
                                                        try {
                                                            PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} via Holder.unwrapKey", (Object)((class_5321)pentry.getKey()).method_29177());
                                                        }
                                                        catch (Throwable throwable) {
                                                            // empty catch block
                                                        }
                                                        return ((class_5321)pentry.getKey()).method_29177().toString();
                                                    }
                                                    catch (Throwable throwable) {
                                                    }
                                                }
                                                catch (Throwable unwrapKeyM3) {
                                                }
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                    }
                                    catch (Throwable bs) {
                                    }
                                }
                            }
                            catch (Throwable poiType) {
                            }
                        }
                    }
                    catch (Throwable bitem3) {
                        // empty catch block
                    }
                }
                try {
                    class_2680 heldState = null;
                    try {
                        Object object;
                        if (workstation != null && (object = workstation.method_7909()) instanceof class_1747) {
                            class_1747 bitem2 = (class_1747)object;
                            heldState = bitem2.method_7711().method_9564();
                        }
                    }
                    catch (Throwable bitem2) {
                        // empty catch block
                    }
                    profReg = class_7923.field_41195;
                    if (profReg == null) break block101;
                    for (Map.Entry entry : profReg.method_29722()) {
                        try {
                            class_3852 profObj = (class_3852)entry.getValue();
                            Object profPoi = null;
                            try {
                                Method m = profObj.getClass().getMethod("pointOfInterest", new Class[0]);
                                profPoi = m.invoke((Object)profObj, new Object[0]);
                            }
                            catch (Throwable t1) {
                                try {
                                    Method[] m2 = profObj.getClass().getMethod("getPointOfInterest", new Class[0]);
                                    profPoi = m2.invoke((Object)profObj, new Object[0]);
                                }
                                catch (Throwable m2) {
                                    // empty catch block
                                }
                            }
                            if (profPoi == null) continue;
                            try {
                                Method[] methods;
                                for (Method m : methods = profPoi.getClass().getMethods()) {
                                    Object object;
                                    String name = m.getName();
                                    if (!name.equals("matchingStates") && !name.equals("getMatchingStates") && !name.equals("validStates") && !name.equals("getValidStates") || !Collection.class.isAssignableFrom(m.getReturnType()) || !((object = m.invoke(profPoi, new Object[0])) instanceof Collection)) continue;
                                    Collection col = (Collection)object;
                                    for (Object o : col) {
                                        try {
                                            class_2680 bs;
                                            if (o instanceof class_2680 && (bs = (class_2680)o).equals((Object)heldState)) {
                                                try {
                                                    PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} by inspecting profession->POI matchingStates", (Object)((class_5321)entry.getKey()).method_29177());
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                return ((class_5321)entry.getKey()).method_29177().toString();
                                            }
                                            if (o == null || heldState == null || !o.toString().contains(class_7923.field_41175.method_10221((Object)heldState.method_26204()).toString())) continue;
                                            try {
                                                PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} via profession->POI string compare", (Object)((class_5321)entry.getKey()).method_29177());
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            return ((class_5321)entry.getKey()).method_29177().toString();
                                        }
                                        catch (Throwable throwable) {
                                        }
                                    }
                                }
                                try {
                                    Field field = profPoi.getClass().getDeclaredField("matchingStates");
                                    field.setAccessible(true);
                                    Object val = field.get(profPoi);
                                    if (!(val instanceof Collection)) continue;
                                    for (Object o : (Collection)val) {
                                        class_2680 bs;
                                        if (!(o instanceof class_2680) || !(bs = (class_2680)o).equals((Object)heldState)) continue;
                                        try {
                                            PocketVillagersMod.LOGGER.debug("workstationToProfession: matched profession {} via profession->POI matchingStates field", (Object)((class_5321)entry.getKey()).method_29177());
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        return ((class_5321)entry.getKey()).method_29177().toString();
                                    }
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                }
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable profObj) {}
                    }
                }
                catch (Throwable heldState) {
                    // empty catch block
                }
            }
            try {
                class_1747 bitem;
                profReg = workstation.method_7909();
                if (profReg instanceof class_1747 && (heldKey = class_7923.field_41175.method_10221((Object)(bitem = (class_1747)profReg).method_7711())) != null) {
                    for (Map.Entry entry : PROFESSION_WORKSTATIONS.entrySet()) {
                        try {
                            Set set = (Set)entry.getValue();
                            if (set == null || !set.contains(heldKey)) continue;
                            return (String)entry.getKey();
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (provisionalPoi == null) break block102;
                try {
                    PocketVillagersMod.LOGGER.debug("workstationToProfession: no explicit profession found; using provisional POI-id fallback {}", (Object)provisionalPoi.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return provisionalPoi.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static void loadPoiCache(Map<String, String> discovered) {
        if (discovered == null || discovered.isEmpty()) {
            return;
        }
        try {
            POI_TO_PROFESSION_CACHE.putAll(discovered);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerRenderLayer() {
        BlockRenderLayerMap.putBlock((class_2248)PocketVillagersModBlocks.POCKET_CUBE, (class_11515)class_11515.field_60926);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return PocketCubeBlock.method_9541((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public class_3908 method_17454(class_2680 state, class_1937 worldIn, class_2338 pos) {
        class_3908 menuProvider;
        class_2586 tileEntity = worldIn.method_8321(pos);
        return tileEntity instanceof class_3908 ? (menuProvider = (class_3908)tileEntity) : null;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PocketCubeBlockEntity(pos, state);
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int eventID, int eventParam) {
        super.method_9592(state, world, pos, eventID, eventParam);
        class_2586 blockEntity = world.method_8321(pos);
        return blockEntity != null && blockEntity.method_11004(eventID, eventParam);
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, level, pos, oldState, isMoving);
        breakingVillagerData.remove();
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        class_2586 blockEntity;
        block29: {
            super.method_9567(level, pos, state, placer, stack);
            try {
                if (level.method_8608() || state == null || !state.method_28498((class_2769)class_2383.field_11177)) break block29;
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
                class_2586 be = level.method_8321(pos);
                if (!(be instanceof PocketCubeBlockEntity)) break block29;
                PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)be;
                float bodyYaw = 0.0f;
                if (facing != null && facing.method_10166().method_10179()) {
                    if (facing == class_2350.field_11043) {
                        bodyYaw = 180.0f;
                    } else if (facing == class_2350.field_11035) {
                        bodyYaw = 0.0f;
                    } else if (facing == class_2350.field_11039) {
                        bodyYaw = 90.0f;
                    } else if (facing == class_2350.field_11034) {
                        bodyYaw = -90.0f;
                    }
                }
                cubeEntity.setFacingYaw(bodyYaw);
                try {
                    level.method_8413(pos, state, state, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    cubeEntity.syncToClient();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (placer instanceof class_3222) {
                        class_3222 sp = (class_3222)placer;
                        int yawInt = Math.round(bodyYaw);
                        SyncFacingYawPayload.send(sp, pos, yawInt);
                    }
                }
                catch (Throwable sp) {
                    // empty catch block
                }
                try {
                    PocketVillagersMod.LOGGER.debug("PocketCubeBlock.setPlacedBy: pos={} facing={} bodyYaw={}", (Object)pos, (Object)facing, (Object)Float.valueOf(bodyYaw));
                }
                catch (Throwable sp) {}
            }
            catch (Throwable facing) {
                // empty catch block
            }
        }
        if (!level.method_8608() && VillagerDataHandler.hasVillager(stack) && (blockEntity = level.method_8321(pos)) instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity cubeEntity;
            block30: {
                class_2487 fallback;
                cubeEntity = (PocketCubeBlockEntity)blockEntity;
                class_2487 villagerData = VillagerDataHandler.getVillagerData(stack);
                if ((villagerData == null || villagerData.method_33133()) && (fallback = breakingVillagerData.get()) != null) {
                    villagerData = fallback.method_10553();
                }
                if (villagerData != null && !villagerData.method_33133()) {
                    cubeEntity.setVillagerData(villagerData);
                    VillagerDataHandler.clearVillagerData(stack);
                }
                try {
                    class_9279 cd = (class_9279)stack.method_58694(class_9334.field_49628);
                    if (cd == null) break block30;
                    class_2487 itemCustom = cd.method_57461();
                    boolean itemHasVillager = false;
                    try {
                        itemHasVillager = itemCustom.method_10577("HasVillager").orElse(false) != false || itemCustom.method_10545("VillagerData");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (itemHasVillager || !itemCustom.method_10545("WorkstationItemId")) break block30;
                    try {
                        String id = itemCustom.method_10558("WorkstationItemId").orElse("");
                        int cnt = itemCustom.method_10550("WorkstationCount").orElse(1);
                        class_2960 rl = class_2960.method_60654((String)id);
                        Optional itemRef = class_7923.field_41178.method_10223(rl);
                        if (itemRef != null && itemRef.isPresent()) {
                            class_6880.class_6883 holder = (class_6880.class_6883)itemRef.get();
                            cubeEntity.setWorkstation(new class_1799((class_6880)holder, cnt));
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            cubeEntity.method_5431();
            level.method_8413(pos, state, state, 3);
        }
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        block17: {
            class_2586 blockEntity;
            if (!level.method_8608() && (blockEntity = level.method_8321(pos)) instanceof PocketCubeBlockEntity) {
                PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)blockEntity;
                try {
                    class_2487 beTag = new class_2487();
                    try {
                        if (cubeEntity.hasVillager()) {
                            beTag.method_10566("VillagerData", (class_2520)cubeEntity.getVillagerData().method_10553());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        class_2960 key;
                        class_1799 ws;
                        if (cubeEntity.hasWorkstation() && (ws = cubeEntity.getWorkstation()) != null && !ws.method_7960() && (key = class_7923.field_41178.method_10221((Object)ws.method_7909())) != null) {
                            beTag.method_10582("WorkstationItemId", key.toString());
                            beTag.method_10569("WorkstationCount", ws.method_7947());
                        }
                    }
                    catch (Throwable ws) {
                        // empty catch block
                    }
                    try {
                        beTag.method_10548("FacingYaw", cubeEntity.getFacingYaw());
                    }
                    catch (Throwable ws) {
                        // empty catch block
                    }
                    try {
                        beTag.method_10556("HasVillager", cubeEntity.hasVillager());
                    }
                    catch (Throwable ws) {
                        // empty catch block
                    }
                    class_1799 drop = new class_1799((class_1935)PocketVillagersModBlocks.POCKET_CUBE.method_8389());
                    try {
                        drop.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)beTag.method_10553()));
                    }
                    catch (Throwable key) {
                        // empty catch block
                    }
                    try {
                        Method rootTagM = class_1799.class.getMethod("getOrCreateTag", new Class[0]);
                        class_2487 root = (class_2487)rootTagM.invoke((Object)drop, new Object[0]);
                        root.method_10566("BlockEntityTag", (class_2520)beTag.method_10553());
                        Method setTag = class_1799.class.getMethod("setTag", class_2487.class);
                        setTag.invoke((Object)drop, root);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)drop);
                    level.method_8650(pos, false);
                    return class_2246.field_10124.method_9564();
                }
                catch (Throwable ignored) {
                    if (!cubeEntity.hasVillager()) break block17;
                    breakingVillagerData.set(cubeEntity.getVillagerData());
                }
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        return this.use(state, level, pos, player, class_1268.field_5808, hit);
    }

    public class_1269 use(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean holdingBlockItem;
        class_2586 blockEntity;
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 held = player.method_5998(hand);
        if (!level.method_8608()) {
            try {
                PocketVillagersMod.LOGGER.debug("=== POCKET CUBE USE (SERVER) ===");
                PocketVillagersMod.LOGGER.debug("Player: {}, Hand: {}, Held: {}", (Object)player.method_5477().getString(), (Object)hand, (Object)held);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!((blockEntity = level.method_8321(pos)) instanceof PocketCubeBlockEntity)) {
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("BlockEntity is not PocketCubeBlockEntity!");
            }
            return class_1269.field_5811;
        }
        PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)blockEntity;
        boolean bl = holdingBlockItem = held != null && !held.method_7960() && held.method_7909() instanceof class_1747;
        if (!level.method_8608()) {
            PocketVillagersMod.LOGGER.debug("Cube state - hasVillager: {}, hasWorkstation: {}, holdingBlockItem: {}", (Object)cubeEntity.hasVillager(), (Object)cubeEntity.hasWorkstation(), (Object)holdingBlockItem);
        }
        if (cubeEntity.hasWorkstation()) {
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("CASE 1: Opening GUI (has workstation)");
                if (cubeEntity.hasVillager() && player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    CubeVillager cubeVillager = cubeEntity.getOrCreateCachedVillager();
                    if (cubeVillager != null) {
                        cubeVillager.setPocketCubePos(pos);
                        int villagerLevel = cubeVillager.method_7231().comp_3522();
                        int villagerXp = cubeVillager.method_19269();
                        SyncPocketCubePayload.send(serverPlayer, pos, true, villagerLevel, villagerXp);
                        cubeVillager.method_8259((class_1657)serverPlayer);
                        cubeVillager.method_17449((class_1657)serverPlayer, (class_2561)class_2561.method_43470((String)"Pocket Cube"), villagerLevel);
                    }
                }
            }
            return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
        }
        if (holdingBlockItem && cubeEntity.hasVillager() && !cubeEntity.hasWorkstation()) {
            boolean villagerIsJobbed;
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("CASE 2: Attempting workstation insertion");
            }
            if (!PocketCubeBlock.isWorkstationCandidate(held, level)) {
                if (!level.method_8608()) {
                    PocketVillagersMod.LOGGER.debug("Not a valid workstation candidate");
                    player.method_7353((class_2561)class_2561.method_43470((String)"This block is not a valid workstation"), true);
                }
                return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
            }
            class_2487 villagerData = cubeEntity.getVillagerData();
            String profession = "minecraft:none";
            if (villagerData != null && villagerData.method_10545("VillagerData.profession")) {
                profession = villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
            }
            boolean bl2 = villagerIsJobbed = !"minecraft:none".equals(profession) && !profession.isEmpty();
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("Villager profession: {}, isJobbed: {}", (Object)profession, (Object)villagerIsJobbed);
            }
            if (villagerIsJobbed && !PocketCubeBlock.workstationMatchesProfession(held, level, profession)) {
                if (!level.method_8608()) {
                    PocketVillagersMod.LOGGER.debug("Workstation does not match profession!");
                    try {
                        String heldKey = "<unknown>";
                        class_1792 class_17922 = held.method_7909();
                        if (class_17922 instanceof class_1747) {
                            class_1747 b = (class_1747)class_17922;
                            class_2960 k2 = class_7923.field_41175.method_10221((Object)b.method_7711());
                            heldKey = k2 == null ? "<unknown>" : k2.toString();
                        }
                        player.method_7353((class_2561)class_2561.method_43470((String)"Cannot insert: workstation does not match profession."), true);
                        player.method_7353((class_2561)class_2561.method_43470((String)("Profession: " + PocketCubeBlock.prettifyProfession(profession) + ", Held: " + heldKey)), true);
                    }
                    catch (Throwable t) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"Cannot insert: workstation mismatch."), true);
                    }
                }
                return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
            }
            if (!level.method_8608() && player instanceof class_3222) {
                block70: {
                    PocketVillagersMod.LOGGER.debug("=== PERFORMING SERVER-SIDE INSERTION ===");
                    class_1799 toInsert = held.method_7972();
                    toInsert.method_7939(1);
                    cubeEntity.setWorkstation(toInsert);
                    if (!villagerIsJobbed) {
                        try {
                            String newProf;
                            block67: {
                                newProf = PocketCubeBlock.workstationToProfession(toInsert, level);
                                PocketVillagersMod.LOGGER.debug("Assigning profession: {}", (Object)newProf);
                                if (newProf == null) {
                                    try {
                                        class_2378 poiRegistry = class_7923.field_41128;
                                        if (poiRegistry == null) break block67;
                                        for (Map.Entry entry : poiRegistry.method_29722()) {
                                            try {
                                                Object v2;
                                                Object poiType = entry.getValue();
                                                Collection states = null;
                                                try {
                                                    for (Method m : poiType.getClass().getMethods()) {
                                                        Class<?> rt;
                                                        if (m.getParameterCount() > 0 || !Collection.class.isAssignableFrom(rt = m.getReturnType())) continue;
                                                        try {
                                                            Object r = m.invoke(poiType, new Object[0]);
                                                            if (r instanceof Collection) {
                                                                states = (Collection)r;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            // empty catch block
                                                        }
                                                        if (states == null) {
                                                            continue;
                                                        }
                                                        break;
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    // empty catch block
                                                }
                                                if (states == null) {
                                                    try {
                                                        for (Field f : poiType.getClass().getDeclaredFields()) {
                                                            try {
                                                                f.setAccessible(true);
                                                                v2 = f.get(poiType);
                                                                if (!(v2 instanceof Collection)) continue;
                                                                states = (Collection)v2;
                                                                break;
                                                            }
                                                            catch (Throwable v2) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (states != null && !states.isEmpty()) {
                                                    for (Object o : states) {
                                                        try {
                                                            String poiKeyStr;
                                                            class_1747 bitem;
                                                            if (!(o instanceof class_2680)) continue;
                                                            class_2680 bs = (class_2680)o;
                                                            v2 = toInsert.method_7909();
                                                            if (!(v2 instanceof class_1747) || !bs.equals((Object)(bitem = (class_1747)v2).method_7711().method_9564())) continue;
                                                            newProf = poiKeyStr = ((class_5321)entry.getKey()).method_29177().toString();
                                                            POI_TO_PROFESSION_CACHE.putIfAbsent(poiKeyStr, newProf);
                                                            try {
                                                                PROFESSION_WORKSTATIONS.computeIfAbsent(newProf, k -> new HashSet()).add(class_7923.field_41175.method_10221((Object)((class_1747)toInsert.method_7909()).method_7711()));
                                                            }
                                                            catch (Throwable throwable) {
                                                                // empty catch block
                                                            }
                                                            try {
                                                                PocketVillagersMod.saveDiscoveredPoiMapping(poiKeyStr, newProf);
                                                            }
                                                            catch (Throwable throwable) {
                                                                // empty catch block
                                                            }
                                                            PocketVillagersMod.LOGGER.debug("workstation insertion: using POI fallback for profession {} (poi={})", (Object)newProf, (Object)poiKeyStr);
                                                            break;
                                                        }
                                                        catch (Throwable throwable) {
                                                        }
                                                    }
                                                }
                                                if (newProf == null) continue;
                                                break;
                                            }
                                            catch (Throwable throwable) {
                                            }
                                        }
                                    }
                                    catch (Throwable t) {
                                        PocketVillagersMod.LOGGER.warn("workstation insertion: POI fallback scan failed", t);
                                    }
                                }
                            }
                            if (newProf == null) break block70;
                            class_2487 updated = villagerData != null ? villagerData.method_10553() : new class_2487();
                            updated.method_10582("VillagerData.profession", newProf);
                            if (!updated.method_10545("VillagerData.type")) {
                                updated.method_10582("VillagerData.type", "minecraft:plains");
                            }
                            updated.method_10569("VillagerData.level", 1);
                            cubeEntity.setVillagerData(updated);
                            CubeVillager generated = VillagerDataHandler.createTradingVillager(level, pos, updated);
                            if (generated == null) break block70;
                            PocketCubeBlock.saveVillagerDataToCube(level, pos, generated);
                            try {
                                if (cubeEntity != null) {
                                    cubeEntity.clearCachedVillager();
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                cubeEntity.syncToClient();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            PocketVillagersMod.LOGGER.debug("Generated {} offers", (Object)(generated.method_8264() == null ? 0 : generated.method_8264().size()));
                        }
                        catch (Throwable t) {
                            PocketVillagersMod.LOGGER.error("Failed to assign profession", t);
                        }
                    }
                }
                cubeEntity.method_5431();
                try {
                    level.method_8413(pos, state, state, 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!player.method_68878()) {
                    held.method_7934(1);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"Workstation inserted into Pocket Cube!"), true);
                PocketVillagersMod.LOGGER.debug("=== INSERTION COMPLETE ===");
            }
            return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
        }
        if (!cubeEntity.hasVillager()) {
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("CASE 3: No villager - showing message");
                player.method_7353((class_2561)class_2561.method_43470((String)"Capture a villager first!"), true);
            }
            return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
        }
        if (!cubeEntity.hasWorkstation() && !holdingBlockItem) {
            if (!level.method_8608()) {
                PocketVillagersMod.LOGGER.debug("CASE 4: Need workstation - showing message");
                player.method_7353((class_2561)class_2561.method_43470((String)"Insert a workstation to begin trading"), true);
            }
            return class_1269.field_21466;
        }
        if (!level.method_8608()) {
            PocketVillagersMod.LOGGER.debug("CASE 5: Fallback PASS");
        }
        return class_1269.field_5811;
    }

    public static void saveVillagerDataToCube(class_1937 level, class_2338 pos, CubeVillager villager) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)blockEntity;
            class_2487 newVillagerData = new class_2487();
            newVillagerData.method_10582("id", "minecraft:villager");
            class_3850 villagerDataObj = villager.method_7231();
            String professionStr = ((class_5321)villagerDataObj.comp_3521().method_40230().orElseThrow()).method_29177().toString();
            String typeStr = ((class_5321)villagerDataObj.comp_3520().method_40230().orElseThrow()).method_29177().toString();
            int villagerLevel = villagerDataObj.comp_3522();
            newVillagerData.method_10569("Xp", villager.method_19269());
            newVillagerData.method_10582("VillagerData.profession", professionStr);
            newVillagerData.method_10582("VillagerData.type", typeStr);
            newVillagerData.method_10569("VillagerData.level", villagerLevel);
            boolean professionLocked = villager.method_19269() > 0;
            newVillagerData.method_10556("ProfessionLocked", professionLocked);
            if (villager.getConversionCount() > 0) {
                newVillagerData.method_10569("PocketVillagers.Conversions", villager.getConversionCount());
                try {
                    PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: saved conversion count={}", (Object)villager.getConversionCount());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (villager.getConversionTime() > 0) {
                newVillagerData.method_10569("ConversionTime", villager.getConversionTime());
            }
            try {
                class_6903 registryOps;
                DataResult result;
                if (villager.method_8264() != null && !villager.method_8264().isEmpty() && (result = class_1916.field_48850.encodeStart((DynamicOps)(registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_3218)level).method_30349())), (Object)villager.method_8264())).result().isPresent()) {
                    class_2520 encodedTag = (class_2520)result.result().get();
                    newVillagerData.method_10566("Offers", encodedTag);
                    try {
                        PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: saved offers count={}", (Object)villager.method_8264().size());
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            cubeEntity.setVillagerData(newVillagerData);
            cubeEntity.method_5431();
            try {
                level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void method_66388(class_2680 blockstate, class_3218 world, class_2338 blockpos, boolean flag) {
    }

    private static boolean isWorkstationCandidate(class_1799 stack, class_1937 level) {
        if (stack == null || stack.method_7960()) {
            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: stack is null or empty");
            return false;
        }
        if (!(stack.method_7909() instanceof class_1747)) {
            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: item is not a BlockItem");
            return false;
        }
        class_1747 bitem = (class_1747)stack.method_7909();
        class_2248 block = bitem.method_7711();
        class_2680 state = block.method_9564();
        class_2960 heldKey = class_7923.field_41175.method_10221((Object)block);
        PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: checking block {}", (Object)heldKey);
        try {
            String mapped;
            if (heldKey != null && (mapped = PocketVillagersMod.COMPAT_WORKSTATION_PROFESSION.get(heldKey.toString())) != null) {
                PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: accepted {} via COMPAT mapping -> {}", (Object)heldKey, (Object)mapped);
                return true;
            }
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("isWorkstationCandidate: COMPAT check failed", t);
        }
        try {
            class_2378 poiRegistry = class_7923.field_41128;
            if (poiRegistry == null) {
                PocketVillagersMod.LOGGER.error("isWorkstationCandidate: POI registry is NULL!");
                return false;
            }
            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: POI registry has {} entries", (Object)poiRegistry.method_10204());
            int checkedPois = 0;
            for (Map.Entry entry : poiRegistry.method_29722()) {
                ++checkedPois;
                Object poiType = entry.getValue();
                try {
                    HashSet<class_2680> matchingStates = null;
                    Method[] methods = poiType.getClass().getMethods();
                    for (Method m : methods) {
                        Class<?> returnType;
                        if (m.getParameterCount() > 0 || !Set.class.isAssignableFrom(returnType = m.getReturnType()) && !Collection.class.isAssignableFrom(returnType)) continue;
                        try {
                            Object first;
                            Collection col;
                            Object ret = m.invoke(poiType, new Object[0]);
                            if (!(ret instanceof Collection) || (col = (Collection)ret).isEmpty() || !((first = col.iterator().next()) instanceof class_2680)) continue;
                            matchingStates = new HashSet<class_2680>();
                            for (Object o : col) {
                                if (!(o instanceof class_2680)) continue;
                                class_2680 bs = (class_2680)o;
                                matchingStates.add(bs);
                            }
                            if (checkedPois > 3) break;
                            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: Found BlockState collection via method {} in POI {}", (Object)m.getName(), (Object)((class_5321)entry.getKey()).method_29177());
                            break;
                        }
                        catch (Throwable ret) {
                            // empty catch block
                        }
                    }
                    if (matchingStates == null) {
                        Field[] fields;
                        for (Field f : fields = poiType.getClass().getDeclaredFields()) {
                            Class<?> fieldType = f.getType();
                            if (!Set.class.isAssignableFrom(fieldType) && !Collection.class.isAssignableFrom(fieldType)) continue;
                            try {
                                Object first;
                                Collection col;
                                f.setAccessible(true);
                                Object val = f.get(poiType);
                                if (!(val instanceof Collection) || (col = (Collection)val).isEmpty() || !((first = col.iterator().next()) instanceof class_2680)) continue;
                                matchingStates = new HashSet();
                                for (Object o : col) {
                                    if (!(o instanceof class_2680)) continue;
                                    class_2680 bs = (class_2680)o;
                                    matchingStates.add(bs);
                                }
                                if (checkedPois > 3) break;
                                PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: Found BlockState collection via field {} in POI {}", (Object)f.getName(), (Object)((class_5321)entry.getKey()).method_29177());
                                break;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (matchingStates == null) continue;
                    for (class_2680 bs : matchingStates) {
                        block29: {
                            if (!bs.equals((Object)state)) continue;
                            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: \u2713 MATCHED POI {} for block {}", (Object)((class_5321)entry.getKey()).method_29177(), (Object)heldKey);
                            try {
                                String poiKeyStr = ((class_5321)entry.getKey()).method_29177().toString();
                                if (POI_TO_PROFESSION_CACHE.containsKey(poiKeyStr)) break block29;
                                try {
                                    String prof = PocketCubeBlock.workstationToProfession(stack, level);
                                    if (prof == null) break block29;
                                    POI_TO_PROFESSION_CACHE.put(poiKeyStr, prof);
                                    try {
                                        PROFESSION_WORKSTATIONS.computeIfAbsent(prof, k -> new HashSet()).add(heldKey);
                                        PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: cached POI {} -> profession {}", (Object)poiKeyStr, (Object)prof);
                                        try {
                                            PocketVillagersMod.saveDiscoveredPoiMapping(poiKeyStr, prof);
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                }
                catch (Throwable t) {
                    if (checkedPois >= 5) continue;
                    PocketVillagersMod.LOGGER.warn("isWorkstationCandidate: error checking POI {}: {}", (Object)((class_5321)entry.getKey()).method_29177(), (Object)t.getMessage());
                }
            }
            PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: checked {} POIs, no match found for {}", (Object)checkedPois, (Object)heldKey);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("isWorkstationCandidate: POI registry iteration failed", t);
        }
        PocketVillagersMod.LOGGER.debug("isWorkstationCandidate: \u2717 FAILED - {} is not a valid workstation", (Object)heldKey);
        return false;
    }

    private static String prettifyProfession(String professionId) {
        if (professionId == null) {
            return "Villager";
        }
        String[] parts = professionId.split(":");
        String name = parts.length > 1 ? parts[1] : parts[0];
        name = name.replace('_', ' ');
        StringBuilder sb = new StringBuilder();
        for (String w : name.split(" ")) {
            if (w.isEmpty()) continue;
            sb.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    private static String prettifyResourceLocation(class_2960 rl) {
        if (rl == null) {
            return "";
        }
        String path = rl.method_12832();
        path = path.replace('_', ' ');
        StringBuilder sb = new StringBuilder();
        for (String w : path.split(" ")) {
            if (w.isEmpty()) continue;
            sb.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    private static boolean workstationMatchesProfession(class_1799 workstation, class_1937 level, String professionId) {
        if (workstation == null || workstation.method_7960()) {
            return false;
        }
        try {
            class_7922 profReg;
            Object ret2;
            class_2680 heldState;
            class_2248 heldBlock;
            block56: {
                class_1792 k;
                String heldBlockKeyStr = "<none>";
                heldBlock = null;
                heldState = null;
                try {
                    class_1792 class_17922 = workstation.method_7909();
                    if (class_17922 instanceof class_1747) {
                        class_1747 bi = (class_1747)class_17922;
                        heldBlock = bi.method_7711();
                        heldState = heldBlock.method_9564();
                        k = class_7923.field_41175.method_10221((Object)heldBlock);
                        heldBlockKeyStr = k == null ? heldBlock.toString() : k.toString();
                    }
                }
                catch (Throwable bi) {
                    // empty catch block
                }
                PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: checking {} vs profession {}", (Object)heldBlockKeyStr, (Object)professionId);
                if (heldState == null) {
                    PocketVillagersMod.LOGGER.warn("workstationMatchesProfession: could not extract block state from workstation");
                    return false;
                }
                try {
                    String mapped;
                    class_2960 heldKey;
                    k = workstation.method_7909();
                    if (k instanceof class_1747 && (heldKey = class_7923.field_41175.method_10221((Object)(bi = (class_1747)k).method_7711())) != null && (mapped = PocketVillagersMod.COMPAT_WORKSTATION_PROFESSION.get(heldKey.toString())) != null && mapped.equals(professionId)) {
                        PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: \u2713 matched via COMPAT mapping");
                        return true;
                    }
                }
                catch (Throwable bi) {
                    // empty catch block
                }
                try {
                    class_2378 poiRegistry = class_7923.field_41128;
                    if (poiRegistry == null) break block56;
                    HashSet<String> seenPois = new HashSet<String>();
                    for (Map.Entry entry : poiRegistry.method_29722()) {
                        try {
                            Object first;
                            Object poiType = entry.getValue();
                            Method[] poiMethods = poiType.getClass().getMethods();
                            Collection states = null;
                            for (Method m : poiMethods) {
                                Class<?> rt;
                                if (m.getParameterCount() > 0 || !Set.class.isAssignableFrom(rt = m.getReturnType()) && !Collection.class.isAssignableFrom(rt)) continue;
                                try {
                                    ret2 = m.invoke(poiType, new Object[0]);
                                    if (ret2 instanceof Collection) {
                                        states = (Collection)ret2;
                                    }
                                }
                                catch (Throwable ret2) {
                                    // empty catch block
                                }
                                if (states != null) break;
                            }
                            if (states == null) {
                                Field[] fields;
                                for (Field f : fields = poiType.getClass().getDeclaredFields()) {
                                    try {
                                        f.setAccessible(true);
                                        Object val = f.get(poiType);
                                        if (!(val instanceof Collection)) continue;
                                        states = (Collection)val;
                                        break;
                                    }
                                    catch (Throwable val) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (states == null || states.isEmpty() || !((first = states.iterator().next()) instanceof class_2680)) continue;
                            for (Object o : states) {
                                String poiKeyStr;
                                block57: {
                                    class_2680 bs;
                                    if (!(o instanceof class_2680) || !(bs = (class_2680)o).equals((Object)heldState)) continue;
                                    poiKeyStr = ((class_5321)entry.getKey()).method_29177().toString();
                                    String cached = POI_TO_PROFESSION_CACHE.get(poiKeyStr);
                                    if (cached != null) {
                                        PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: cache hit {} -> {}", (Object)poiKeyStr, (Object)cached);
                                        if (cached.equals(professionId)) {
                                            return true;
                                        }
                                    } else {
                                        try {
                                            String resolved = PocketCubeBlock.workstationToProfession(workstation, level);
                                            if (resolved == null) break block57;
                                            POI_TO_PROFESSION_CACHE.put(poiKeyStr, resolved);
                                            try {
                                                PocketVillagersMod.saveDiscoveredPoiMapping(poiKeyStr, resolved);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: cached POI {} -> {}", (Object)poiKeyStr, (Object)resolved);
                                            if (resolved.equals(professionId)) {
                                                return true;
                                            }
                                        }
                                        catch (Throwable resolved) {
                                            // empty catch block
                                        }
                                    }
                                }
                                seenPois.add(poiKeyStr);
                            }
                        }
                        catch (Throwable poiType) {}
                    }
                }
                catch (Throwable poiRegistry) {
                    // empty catch block
                }
            }
            if ((profReg = class_7923.field_41195) == null) {
                PocketVillagersMod.LOGGER.error("workstationMatchesProfession: profession registry is null");
                return false;
            }
            class_2960 profKey = class_2960.method_60654((String)professionId);
            Optional profession = profReg.method_10223(profKey);
            if (profession == null) {
                PocketVillagersMod.LOGGER.warn("workstationMatchesProfession: profession {} not found in registry", (Object)professionId);
                return false;
            }
            Object profPoiHolder = null;
            Method[] methods = profession.getClass().getMethods();
            for (Method m : methods) {
                if (m.getParameterCount() != 0 || m.getReturnType().isPrimitive()) continue;
                try {
                    String resultClassName;
                    Object result = m.invoke((Object)profession, new Object[0]);
                    if (result == null || !(resultClassName = result.getClass().getName()).contains("Holder") && !resultClassName.contains("poi") && !resultClassName.contains("PointOfInterest") && !resultClassName.contains("Reference")) continue;
                    profPoiHolder = result;
                    PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: found POI holder via method {} -> {}", (Object)m.getName(), (Object)resultClassName);
                    break;
                }
                catch (Throwable result) {
                    // empty catch block
                }
            }
            if (profPoiHolder == null) {
                Field[] fields;
                for (Field f : fields = profession.getClass().getDeclaredFields()) {
                    try {
                        String resultClassName;
                        f.setAccessible(true);
                        Object result = f.get(profession);
                        if (result == null || !(resultClassName = result.getClass().getName()).contains("Holder") && !resultClassName.contains("poi") && !resultClassName.contains("PointOfInterest") && !resultClassName.contains("Reference")) continue;
                        profPoiHolder = result;
                        PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: found POI holder via field {} -> {}", (Object)f.getName(), (Object)resultClassName);
                        break;
                    }
                    catch (Throwable result) {
                        // empty catch block
                    }
                }
            }
            if (profPoiHolder == null) {
                PocketVillagersMod.LOGGER.warn("workstationMatchesProfession: could not extract POI holder from profession");
                return PocketCubeBlock.checkHardcodedMap(workstation, professionId, heldBlock);
            }
            Object actualPoiType = profPoiHolder;
            try {
                Method valueMethod = actualPoiType.getClass().getMethod("value", new Class[0]);
                Object unwrapped = valueMethod.invoke(actualPoiType, new Object[0]);
                if (unwrapped != null) {
                    actualPoiType = unwrapped;
                    PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: unwrapped via value() -> {}", (Object)actualPoiType.getClass().getName());
                }
            }
            catch (Throwable valueMethod) {
                // empty catch block
            }
            HashSet<class_2680> matchingStates = null;
            for (Method m : methods = actualPoiType.getClass().getMethods()) {
                Class<?> returnType;
                if (m.getParameterCount() != 0 || !Set.class.isAssignableFrom(returnType = m.getReturnType()) && !Collection.class.isAssignableFrom(returnType)) continue;
                try {
                    Object first;
                    Collection col;
                    ret2 = m.invoke(actualPoiType, new Object[0]);
                    if (!(ret2 instanceof Collection) || (col = (Collection)ret2).isEmpty() || !((first = col.iterator().next()) instanceof class_2680)) continue;
                    matchingStates = new HashSet<class_2680>();
                    for (Object o : col) {
                        if (!(o instanceof class_2680)) continue;
                        class_2680 bs = (class_2680)o;
                        matchingStates.add(bs);
                    }
                    PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: found {} matching states via method {}", (Object)matchingStates.size(), (Object)m.getName());
                    break;
                }
                catch (Throwable ret3) {
                    // empty catch block
                }
            }
            if (matchingStates == null) {
                Field[] fields;
                for (Field f : fields = actualPoiType.getClass().getDeclaredFields()) {
                    Class<?> fieldType = f.getType();
                    if (!Set.class.isAssignableFrom(fieldType) && !Collection.class.isAssignableFrom(fieldType)) continue;
                    try {
                        Object first;
                        Collection col;
                        f.setAccessible(true);
                        Object val = f.get(actualPoiType);
                        if (!(val instanceof Collection) || (col = (Collection)val).isEmpty() || !((first = col.iterator().next()) instanceof class_2680)) continue;
                        matchingStates = new HashSet();
                        for (Object o : col) {
                            if (!(o instanceof class_2680)) continue;
                            class_2680 bs = (class_2680)o;
                            matchingStates.add(bs);
                        }
                        PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: found {} matching states via field {}", (Object)matchingStates.size(), (Object)f.getName());
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (matchingStates != null) {
                for (class_2680 bs : matchingStates) {
                    if (!bs.equals((Object)heldState)) continue;
                    PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: \u2713 MATCHED via reflection!");
                    return true;
                }
                PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: extracted {} states but none matched held block", (Object)matchingStates.size());
            }
            PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: falling back to hardcoded map");
            return PocketCubeBlock.checkHardcodedMap(workstation, professionId, heldBlock);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("workstationMatchesProfession: exception", t);
            return false;
        }
    }

    private static boolean checkHardcodedMap(class_1799 workstation, String professionId, class_2248 heldBlock) {
        try {
            class_1792 class_17922;
            Set<class_2960> wl = PROFESSION_WORKSTATIONS.get(professionId);
            if (wl != null && !wl.isEmpty() && (class_17922 = workstation.method_7909()) instanceof class_1747) {
                class_1747 bitem = (class_1747)class_17922;
                class_2960 key = class_7923.field_41175.method_10221((Object)(heldBlock != null ? heldBlock : bitem.method_7711()));
                if (key != null && wl.contains(key)) {
                    PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: \u2713 matched via hardcoded map");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PocketVillagersMod.LOGGER.debug("workstationMatchesProfession: \u2717 no match found");
        return false;
    }

    static {
        BiConsumer<String, String> putOne = (prof, block) -> PROFESSION_WORKSTATIONS.computeIfAbsent((String)prof, k -> new HashSet()).add(class_2960.method_60654((String)block));
        putOne.accept("minecraft:librarian", "minecraft:lectern");
        putOne.accept("minecraft:farmer", "minecraft:composter");
        putOne.accept("minecraft:cleric", "minecraft:brewing_stand");
        putOne.accept("minecraft:fletcher", "minecraft:fletching_table");
        putOne.accept("minecraft:fisherman", "minecraft:barrel");
        putOne.accept("minecraft:mason", "minecraft:stonecutter");
        putOne.accept("minecraft:armorer", "minecraft:blast_furnace");
        putOne.accept("minecraft:butcher", "minecraft:smoker");
        putOne.accept("minecraft:leatherworker", "minecraft:cauldron");
        putOne.accept("minecraft:toolsmith", "minecraft:smithing_table");
        putOne.accept("minecraft:weaponsmith", "minecraft:grindstone");
        putOne.accept("minecraft:cartographer", "minecraft:cartography_table");
        POI_TO_PROFESSION_CACHE = new ConcurrentHashMap<String, String>();
    }
}

