/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.AutoTraderPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncNearbyCubesPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalFuelPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.mcreator.pocketvillagers.world.inventory.PocketTerminalGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PocketTerminalBlockEntity
extends class_2621
implements class_1278,
ExtendedScreenHandlerFactory<class_2338> {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private static final int FUEL_SLOT = 0;
    private static final int FUEL_PER_CONSUMPTION = 1;
    private int tickCounter = 0;
    private boolean isPowered = false;

    private static int getScanRadius() {
        try {
            return PocketVillagersConfig.getInstance().terminalMaxRange;
        }
        catch (Exception e) {
            return 20;
        }
    }

    private static int getFuelConsumptionInterval() {
        try {
            return PocketVillagersConfig.getInstance().getFuelDurationTicks();
        }
        catch (Exception e) {
            return 6000;
        }
    }

    public PocketTerminalBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.POCKET_TERMINAL, position, state);
    }

    public boolean isPowered() {
        if (!PocketVillagersConfig.getInstance().isRequireFuelSlot()) {
            return true;
        }
        return this.isPowered;
    }

    public int getFuelTimer() {
        return this.isPowered ? this.tickCounter : 0;
    }

    public int getMaxFuelTimer() {
        return PocketTerminalBlockEntity.getFuelConsumptionInterval();
    }

    private void updatePowerState() {
        this.isPowered = this.tickCounter < PocketTerminalBlockEntity.getFuelConsumptionInterval();
    }

    private boolean isFuelItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8687);
    }

    public void tick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_1799 fuelStack = (class_1799)this.stacks.get(0);
        if (!fuelStack.method_7960() && this.isFuelItem(fuelStack)) {
            if (this.tickCounter >= PocketTerminalBlockEntity.getFuelConsumptionInterval()) {
                this.consumeFuel();
                this.tickCounter = 0;
                this.isPowered = true;
            } else if (this.tickCounter == 0 && !this.isPowered) {
                this.consumeFuel();
                this.tickCounter = 0;
                this.isPowered = true;
            }
        }
        if (this.tickCounter < PocketTerminalBlockEntity.getFuelConsumptionInterval() && this.tickCounter >= 0) {
            this.isPowered = true;
        } else if (fuelStack.method_7960() || !this.isFuelItem(fuelStack)) {
            this.isPowered = false;
        }
        if (!PocketVillagersConfig.getInstance().isRequireFuelSlot()) {
            this.isPowered = true;
        }
        if (this.isPowered) {
            ++this.tickCounter;
            if (this.tickCounter >= PocketTerminalBlockEntity.getFuelConsumptionInterval() && (fuelStack.method_7960() || !this.isFuelItem(fuelStack)) && PocketVillagersConfig.getInstance().isRequireFuelSlot()) {
                this.isPowered = false;
            }
        }
        if (this.field_11863.method_8510() % 5L == 0L) {
            this.syncFuelToViewers();
        }
    }

    private void syncFuelToViewers() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        for (class_3222 player : this.field_11863.method_8503().method_3760().method_14571()) {
            class_1703 class_17032 = player.field_7512;
            if (!(class_17032 instanceof PocketTerminalGUIMenu)) continue;
            PocketTerminalGUIMenu menu = (PocketTerminalGUIMenu)class_17032;
            if (menu.x != this.field_11867.method_10263() || menu.y != this.field_11867.method_10264() || menu.z != this.field_11867.method_10260()) continue;
            SyncTerminalFuelPayload.sendToPlayer(player, this.getFuelTimer(), this.getMaxFuelTimer(), this.isPowered());
        }
    }

    private void consumeFuel() {
        class_1799 fuelStack = (class_1799)this.stacks.get(0);
        if (!fuelStack.method_7960() && this.isFuelItem(fuelStack)) {
            fuelStack.method_7934(1);
            if (fuelStack.method_7960()) {
                this.stacks.set(0, (Object)class_1799.field_8037);
            }
            this.method_5431();
            this.updatePowerState();
        }
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_11368)valueInput, this.stacks);
        this.tickCounter = valueInput.method_71424("TickCounter", 0);
        this.updatePowerState();
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.stacks);
        }
        valueOutput.method_71465("TickCounter", this.tickCounter);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        return this.method_38242(lookupProvider);
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"pocket_terminal");
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        return new PocketTerminalGUIMenu(id, inventory, this);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new PocketTerminalGUIMenu(id, inventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Pocket Terminal");
    }

    public List<SyncNearbyCubesPayload.CubeInfo> scanNearbyCubes() {
        ArrayList<SyncNearbyCubesPayload.CubeInfo> cubes = new ArrayList<SyncNearbyCubesPayload.CubeInfo>();
        HashSet<class_2338> foundPositions = new HashSet<class_2338>();
        if (this.field_11863 == null) {
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] scanNearbyCubes: level is null!");
            return cubes;
        }
        class_2338 center = this.method_11016();
        int radius = PocketTerminalBlockEntity.getScanRadius();
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Scanning for cubes around {} with radius {}", (Object)center, (Object)radius);
        int scanned = 0;
        int found = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2586 be;
                    class_2338 checkPos = center.method_10069(x, y, z);
                    ++scanned;
                    if (foundPositions.contains(checkPos) || (be = this.field_11863.method_8321(checkPos)) == null) continue;
                    String type = null;
                    String displayName = null;
                    if (be instanceof BreederPocketCubeBlockEntity) {
                        type = "breeder";
                        displayName = "Breeder Cube";
                    } else if (be instanceof ConverterPocketCubeBlockEntity) {
                        type = "converter";
                        displayName = "Converter Cube";
                    } else if (be instanceof AutoTraderPocketCubeBlockEntity) {
                        type = "auto_trader";
                        displayName = "Auto Trader Cube";
                    } else if (be instanceof IronFarmPocketCubeBlockEntity) {
                        type = "iron_farm";
                        displayName = "Iron Farm Cube";
                    } else if (be instanceof StoragePocketCubeBlockEntity) {
                        type = "storage";
                        displayName = "Storage Cube";
                    } else if (be instanceof FarmingPocketCubeBlockEntity) {
                        type = "farming";
                        displayName = "Farming Cube";
                    } else if (be instanceof MiningPocketCubeBlockEntity) {
                        type = "mining";
                        displayName = "Mining Cube";
                    } else if (be instanceof FishingPocketCubeBlockEntity) {
                        type = "fishing";
                        displayName = "Fishing Cube";
                    } else if (be instanceof PocketCubeBlockEntity) {
                        type = "pocket_cube";
                        displayName = "Pocket Cube";
                    }
                    if (type == null) continue;
                    ++found;
                    foundPositions.add(checkPos);
                    if (type.equals("storage") && be instanceof StoragePocketCubeBlockEntity) {
                        StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)be;
                        int count = storage.getStoredVillagers().size();
                        int capacity = 10;
                        cubes.add(new SyncNearbyCubesPayload.CubeInfo(checkPos, type, displayName, count, capacity));
                    } else {
                        cubes.add(new SyncNearbyCubesPayload.CubeInfo(checkPos, type, displayName));
                    }
                    PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Found {} at {}", (Object)type, (Object)checkPos);
                }
            }
        }
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Scan complete: scanned {} positions, found {} cubes (radius={})", (Object)scanned, (Object)found, (Object)radius);
        return cubes;
    }

    public List<SyncTerminalVillagersPayload.CubeVillagerData> scanCubeVillagers() {
        ArrayList<SyncTerminalVillagersPayload.CubeVillagerData> result = new ArrayList<SyncTerminalVillagersPayload.CubeVillagerData>();
        List<SyncNearbyCubesPayload.CubeInfo> cubes = this.scanNearbyCubes();
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] scanCubeVillagers: Found {} cubes to check", (Object)cubes.size());
        for (SyncNearbyCubesPayload.CubeInfo cube : cubes) {
            class_2586 be = this.field_11863.method_8321(cube.pos);
            ArrayList<SyncTerminalVillagersPayload.VillagerSlot> villagers = new ArrayList<SyncTerminalVillagersPayload.VillagerSlot>();
            if (be instanceof StoragePocketCubeBlockEntity) {
                StoragePocketCubeBlockEntity storageEntity = (StoragePocketCubeBlockEntity)be;
                List<class_2487> storedVillagers = storageEntity.getStoredVillagers();
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Storage cube at {} has {} stored villagers", (Object)cube.pos, (Object)storedVillagers.size());
                for (int i = 0; i < storedVillagers.size(); ++i) {
                    class_2487 villagerData = storedVillagers.get(i);
                    if (villagerData == null || villagerData.method_33133()) continue;
                    villagers.add(new SyncTerminalVillagersPayload.VillagerSlot(i, villagerData));
                }
            } else if (be instanceof BreederPocketCubeBlockEntity) {
                BreederPocketCubeBlockEntity breederEntity = (BreederPocketCubeBlockEntity)be;
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Checking Breeder cube at {}", (Object)cube.pos);
                for (int i = 1; i <= 2; ++i) {
                    class_2487 villagerData;
                    if (!breederEntity.hasVillager(i) || (villagerData = breederEntity.getVillagerData(i)) == null || villagerData.method_33133()) continue;
                    villagers.add(new SyncTerminalVillagersPayload.VillagerSlot(i, villagerData));
                    PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Added Breeder villager slot {}", (Object)i);
                }
            } else if (be instanceof IronFarmPocketCubeBlockEntity) {
                IronFarmPocketCubeBlockEntity ironFarmEntity = (IronFarmPocketCubeBlockEntity)be;
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Checking Iron Farm cube at {}", (Object)cube.pos);
                for (int i = 1; i <= 3; ++i) {
                    class_2487 villagerData;
                    if (!ironFarmEntity.hasVillager(i) || (villagerData = ironFarmEntity.getVillagerData(i)) == null || villagerData.method_33133()) continue;
                    villagers.add(new SyncTerminalVillagersPayload.VillagerSlot(i, villagerData));
                    PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Added Iron Farm villager slot {}", (Object)i);
                }
            } else if (be instanceof ConverterPocketCubeBlockEntity) {
                ConverterPocketCubeBlockEntity converterEntity = (ConverterPocketCubeBlockEntity)be;
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Checking Converter cube at {}", (Object)cube.pos);
                if (converterEntity.hasVillager() && (villagerData = converterEntity.getVillagerData()) != null && !villagerData.method_33133()) {
                    villagers.add(new SyncTerminalVillagersPayload.VillagerSlot(0, villagerData));
                    PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Added Converter villager");
                }
            } else if (be instanceof PocketCubeBlockEntity) {
                PocketCubeBlockEntity pocketCube = (PocketCubeBlockEntity)be;
                villagerData = pocketCube.getVillagerData();
                boolean hasData = villagerData != null && !villagerData.method_33133();
                boolean hasVillagerFlag = pocketCube.hasVillager();
                CubeVillager realVillager = pocketCube.getRealVillager();
                boolean hasRealVillager = realVillager != null && !realVillager.method_31481();
                PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Cube at {} hasData: {}, hasFlag: {}, hasRealVillager: {}", (Object)cube.pos, (Object)hasData, (Object)hasVillagerFlag, (Object)hasRealVillager);
                if (hasData) {
                    villagers.add(new SyncTerminalVillagersPayload.VillagerSlot(0, villagerData));
                    PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Added villager from NBT data");
                }
            }
            if (villagers.isEmpty()) continue;
            PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] Adding cube {} with {} villagers", (Object)cube.type, (Object)villagers.size());
            result.add(new SyncTerminalVillagersPayload.CubeVillagerData(cube.pos, cube.type, cube.displayName, villagers));
        }
        PocketVillagersMod.LOGGER.debug("[POCKET TERMINAL] scanCubeVillagers complete: Returning {} cubes with villagers", (Object)result.size());
        return result;
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            return this.isFuelItem(stack);
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemstack);
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return false;
    }
}

