/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.client.HologramToggle;
import net.mcreator.pocketvillagers.client.VillagerRendererManager;
import net.mcreator.pocketvillagers.client.gui.TerminalTabHelper;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModScreens;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.mcreator.pocketvillagers.world.inventory.ConverterPocketCubeGUIMenu;
import net.minecraft.class_10799;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8942;

public class ConverterPocketCubeScreen
extends class_465<ConverterPocketCubeGUIMenu>
implements PocketVillagersModScreens.FabricScreenAccessor {
    private final class_1937 world;
    private final int x;
    private final int y;
    private final int z;
    private ConverterPocketCubeBlockEntity blockEntity;
    private int clientConversionStage = 0;
    private int clientConversionProgress = 0;
    private int clientDiscountCount = 0;
    private long clientConversionLastUpdateMs = 0L;
    private class_4185 releaseButton;
    private int releaseX;
    private int releaseY;
    private int releaseW;
    private int releaseH;
    private static final class_2960 texture = class_2960.method_60654((String)"pocket_villagers:textures/screens/converter_pocket_cube_gui.png");
    private static final int CURING_LEFT_HOLO_SHIFT = 45;

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        block11: {
            try {
                if (elementType == 2 && "conversionProgress".equals(name) && elementState instanceof Number) {
                    Number n = (Number)elementState;
                    this.clientConversionProgress = (int)Math.round(n.doubleValue());
                    this.clientConversionLastUpdateMs = System.currentTimeMillis();
                    break block11;
                }
                if (elementType == 1 && "conversionStage".equals(name)) {
                    try {
                        this.clientConversionStage = (Integer)elementState;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.clientConversionLastUpdateMs = System.currentTimeMillis();
                    this.updateReleaseButtonState();
                    break block11;
                }
                if (elementType == 2 && "discountCount".equals(name) && elementState instanceof Number) {
                    Number n2 = (Number)elementState;
                    this.clientDiscountCount = (int)Math.round(n2.doubleValue());
                    break block11;
                }
                if (elementType != 0 || !"villagerData".equals(name) || !(elementState instanceof String)) break block11;
                String s = (String)elementState;
                try {
                    class_2487 parsed = class_2522.method_67315((String)s);
                    if (this.blockEntity == null && this.world != null) {
                        this.blockEntity = (ConverterPocketCubeBlockEntity)this.world.method_8321(new class_2338(this.x, this.y, this.z));
                    }
                    if (this.blockEntity != null) {
                        this.blockEntity.setVillagerData(parsed);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.updateReleaseButtonState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void updateReleaseButtonState() {
        try {
            if (this.releaseButton != null) {
                boolean isCuring;
                boolean hasVillager = this.blockEntity != null && this.blockEntity.hasVillager();
                boolean bl = isCuring = this.clientConversionStage == ConverterPocketCubeBlockEntity.ConversionStage.CURING.ordinal();
                if (!hasVillager) {
                    this.releaseButton.field_22763 = false;
                    try {
                        this.releaseButton.method_25350(1.0f);
                    }
                    catch (Throwable throwable) {}
                } else if (isCuring) {
                    this.releaseButton.field_22763 = false;
                    try {
                        this.releaseButton.method_25350(1.0f);
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.releaseButton.field_22763 = true;
                    try {
                        this.releaseButton.method_25350(1.0f);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private GuiPreviewAdjust getGuiPreviewForStage(int stage, int zombifyPct, int curingPct) {
        switch (stage) {
            case 1: {
                return new GuiPreviewAdjust(0, 65, 0, 0, true, 0.0f, 10);
            }
            case 2: {
                return new GuiPreviewAdjust(0, 36, 0, 0, true, 0.0f, 39);
            }
            case 3: {
                return new GuiPreviewAdjust(0, 65, 0, 0, false, 0.0f, 10);
            }
        }
        return new GuiPreviewAdjust(0, 0, 0, 0, false, 0.0f, 0);
    }

    public ConverterPocketCubeScreen(ConverterPocketCubeGUIMenu container, class_1661 inventory, class_2561 component) {
        super((class_1703)container, inventory, component);
        class_2586 be;
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.field_2792 = 192;
        this.field_2779 = 152;
        if (this.world != null && (be = this.world.method_8321(new class_2338(this.x, this.y, this.z))) instanceof ConverterPocketCubeBlockEntity) {
            this.blockEntity = (ConverterPocketCubeBlockEntity)be;
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        try {
            boolean leftShouldBeZombie;
            int modelY = this.field_2800 + 82;
            int leftModelX = this.field_2776 + 34;
            int rightModelX = this.field_2776 + this.field_2792 - 36;
            class_2487 vtag = this.blockEntity == null ? null : this.blockEntity.getVillagerData();
            int stage = this.clientConversionStage;
            try {
                if (this.blockEntity != null) {
                    stage = this.blockEntity.getConversionStage().ordinal();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int predictedProgress = this.clientConversionProgress;
            try {
                if (this.clientConversionLastUpdateMs > 0L) {
                    long now = System.currentTimeMillis();
                    long elapsedMs = Math.max(0L, now - this.clientConversionLastUpdateMs);
                    int elapsedTicks = (int)(elapsedMs / 50L);
                    int totalTicks = 1;
                    if (stage == ConverterPocketCubeBlockEntity.ConversionStage.ZOMBIFYING.ordinal()) {
                        totalTicks = Math.max(1, PocketVillagersConfigCache.getConverterZombifyTime());
                    } else if (stage == ConverterPocketCubeBlockEntity.ConversionStage.CURING.ordinal()) {
                        totalTicks = Math.max(1, PocketVillagersConfigCache.getConverterCureTime());
                    }
                    if (totalTicks > 0) {
                        double pctAdd = (double)elapsedTicks / (double)totalTicks * 100.0;
                        predictedProgress = (int)Math.min(100L, Math.round((double)this.clientConversionProgress + pctAdd));
                    }
                }
            }
            catch (Throwable now) {
                // empty catch block
            }
            int zombifyPct = 0;
            int curingPct = 0;
            switch (stage) {
                case 0: {
                    zombifyPct = 0;
                    curingPct = 0;
                    break;
                }
                case 1: {
                    zombifyPct = predictedProgress;
                    curingPct = 0;
                    break;
                }
                case 2: {
                    zombifyPct = 100;
                    curingPct = predictedProgress;
                    break;
                }
                case 3: {
                    zombifyPct = 100;
                    curingPct = 100;
                    break;
                }
                default: {
                    zombifyPct = 0;
                    curingPct = 0;
                }
            }
            boolean leftRenderAsZombieVillager = leftShouldBeZombie = stage == 2;
            if (vtag != null && !vtag.method_33133()) {
                int leftY = modelY;
                boolean leftTintRed = stage == ConverterPocketCubeBlockEntity.ConversionStage.ZOMBIFYING.ordinal();
                GuiPreviewAdjust adj = this.getGuiPreviewForStage(stage, zombifyPct, curingPct);
                int useLeftX = leftModelX + adj.leftXOffset;
                int useRightX = rightModelX + adj.rightXOffset;
                int useLeftY = leftY + adj.leftYOffset;
                int useRightY = modelY + adj.rightYOffset + 4;
                boolean useLeftTint = leftTintRed || adj.tintLeftRed;
                float useScaleLeft = adj.scale > 0.0f ? adj.scale : 32.0f;
                float useScaleRight = adj.scale > 0.0f ? adj.scale : 32.0f;
                this.renderEntityModel(guiGraphics, vtag, useLeftX, useLeftY, useScaleLeft, leftShouldBeZombie, leftRenderAsZombieVillager, useLeftTint, adj.holoTopShift, partialTicks);
                this.renderEntityModel(guiGraphics, vtag, useRightX, useRightY, useScaleRight, true, false, false, 0, partialTicks);
            } else {
                if (leftShouldBeZombie) {
                    boolean leftTintRed2 = stage == ConverterPocketCubeBlockEntity.ConversionStage.ZOMBIFYING.ordinal();
                    GuiPreviewAdjust adj = this.getGuiPreviewForStage(stage, zombifyPct, curingPct);
                    int useLeftX = leftModelX + adj.leftXOffset;
                    int useLeftY = modelY - 1 + adj.leftYOffset;
                    float useScale = adj.scale > 0.0f ? adj.scale : 32.0f;
                    this.renderEntityModel(guiGraphics, null, useLeftX, useLeftY, useScale, true, leftRenderAsZombieVillager, leftTintRed2 || adj.tintLeftRed, adj.holoTopShift, partialTicks);
                }
                GuiPreviewAdjust adjElse = this.getGuiPreviewForStage(stage, zombifyPct, curingPct);
                int useRightXElse = rightModelX + adjElse.rightXOffset;
                int useRightYElse = modelY - 1 + adjElse.rightYOffset + 4;
                float useScaleElse = adjElse.scale > 0.0f ? adjElse.scale : 32.0f;
                this.renderEntityModel(guiGraphics, null, useRightXElse, useRightYElse, useScaleElse, true, false, false, 0, partialTicks);
            }
        }
        catch (Throwable modelY) {
            // empty catch block
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
        TerminalTabHelper.renderTerminalTabTooltip(this.field_22787, guiGraphics, this.field_2776, this.field_2800, mouseX, mouseY);
        try {
            String tooltip = "Release Villager";
            if (this.releaseButton != null) {
                int rx = this.releaseX;
                int ry = this.releaseY;
                int rw = this.releaseW;
                int rh = this.releaseH;
                if (mouseX >= rx && mouseX < rx + rw && mouseY >= ry && mouseY < ry + rh) {
                    this.drawCyanTooltip(guiGraphics, tooltip, mouseX, mouseY);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderEntityModel(class_332 guiGraphics, class_2487 villagerData, int centerX, int centerY, float scale, boolean renderZombie, boolean renderZombieVillager, boolean tintRed, int holoTopShift, float partialTicks) {
        try {
            class_4587 pose;
            block61: {
                class_1641 entity;
                class_310 mc;
                block60: {
                    mc = class_310.method_1551();
                    class_638 level = mc.field_1687;
                    if (level == null) {
                        return;
                    }
                    entity = null;
                    if (renderZombie) {
                        try {
                            if (renderZombieVillager && villagerData != null && !villagerData.method_33133()) {
                                try {
                                    entity = new class_1641(class_1299.field_6054, (class_1937)level);
                                    if (entity != null) {
                                        try {
                                            class_2487 entityNbt = VillagerDataHandler.toEntityNbt(villagerData);
                                            class_11368 vi = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)level.method_30349(), (class_2487)entityNbt);
                                            entity.method_5651(vi);
                                        }
                                        catch (Throwable entityNbt) {}
                                    }
                                }
                                catch (Throwable ignored) {
                                    entity = null;
                                }
                            }
                            if (entity == null) {
                                if (renderZombieVillager) {
                                    try {
                                        entity = new class_1641(class_1299.field_6054, (class_1937)level);
                                    }
                                    catch (Throwable ignored) {
                                        entity = null;
                                    }
                                } else {
                                    try {
                                        entity = new class_1642(class_1299.field_6051, (class_1937)level);
                                    }
                                    catch (Throwable ignored) {
                                        entity = null;
                                    }
                                }
                            }
                            entity.method_5773();
                            entity.method_5814(0.0, 0.0, 0.0);
                            entity.method_18799(class_243.field_1353);
                            entity.field_5960 = true;
                            if (!(entity instanceof class_1314)) break block60;
                            class_1314 pm = (class_1314)entity;
                            try {
                                pm.method_5977(true);
                            }
                            catch (Throwable vi) {
                                // empty catch block
                            }
                            try {
                                pm.method_5803(true);
                            }
                            catch (Throwable vi) {
                            }
                        }
                        catch (Throwable pm) {}
                    } else {
                        try {
                            class_2338 pos = this.blockEntity != null ? this.blockEntity.method_11016() : new class_2338(this.x, this.y, this.z);
                            entity = VillagerRendererManager.getOrCreate((class_1937)level, pos, 1, villagerData == null ? new class_2487() : villagerData);
                            if (entity != null) {
                                try {
                                    entity.method_5648(false);
                                }
                                catch (Throwable vi) {}
                            }
                        }
                        catch (Throwable pos) {
                            // empty catch block
                        }
                    }
                }
                if (entity == null) {
                    return;
                }
                pose = new class_4587();
                pose.method_22903();
                double zDepth = 100.0;
                pose.method_22904((double)centerX, (double)centerY, zDepth);
                float scaleFactor = 0.22f;
                pose.method_22905(scaleFactor, scaleFactor, scaleFactor);
                float yaw = 180.0f;
                try {
                    if (entity instanceof class_1309) {
                        class_1309 le = (class_1309)entity;
                        le.method_36456(yaw);
                        le.method_5847(yaw);
                    }
                }
                catch (Throwable le) {
                    // empty catch block
                }
                try {
                    mc.method_22940().method_23000().method_37104();
                    if (!(entity instanceof class_1309)) break block61;
                    class_1309 living = (class_1309)entity;
                    int areaLeft = centerX - 16;
                    boolean isLeftPreview = centerX < this.field_2776 + this.field_2792 / 2;
                    int areaTop = centerY - (isLeftPreview ? 112 : 48);
                    int areaRight = centerX + 16;
                    int areaBottom = centerY + 40;
                    int scaledSize = Math.max(16, Math.round(scale));
                    float yOffset = 0.0625f;
                    class_1324 tmpScaleAttr = null;
                    double tmpOldScale = 0.0;
                    try {
                        try {
                            if ((living.getClass().getName().endsWith("CubeVillager") || living instanceof CubeVillager) && (tmpScaleAttr = living.method_5996(class_5134.field_47760)) != null) {
                                tmpOldScale = tmpScaleAttr.method_6201();
                                tmpScaleAttr.method_6192(1.0);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            class_490.method_2486((class_332)guiGraphics, (int)areaLeft, (int)areaTop, (int)areaRight, (int)areaBottom, (int)scaledSize, (float)yOffset, (float)centerX, (float)centerY, (class_1309)living);
                        }
                        catch (Throwable ignored3) {
                            try {
                                class_490.method_2486((class_332)guiGraphics, (int)areaLeft, (int)areaTop, (int)areaRight, (int)areaBottom, (int)scaledSize, (float)yOffset, (float)0.0f, (float)0.0f, (class_1309)living);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        try {
                            if (tmpScaleAttr != null) {
                                tmpScaleAttr.method_6192(tmpOldScale);
                            }
                        }
                        catch (Throwable ignored3) {}
                    }
                    mc.method_22940().method_23000().method_37104();
                    try {
                        int bottomOv;
                        int topOv;
                        boolean holoOn = true;
                        try {
                            holoOn = HologramToggle.HOLOGRAM_ENABLED;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!holoOn) break block61;
                        long t = System.currentTimeMillis();
                        int baseAlpha = 40 + (int)((Math.sin((double)t * 0.006) + 1.0) * 20.0);
                        int baseColor = baseAlpha << 24 | 0xD0FF;
                        int halfW = 20;
                        int halfH = 36;
                        int leftOv = Math.max(areaLeft, centerX - halfW);
                        int rightOv = Math.min(areaRight, centerX + halfW);
                        if (isLeftPreview) {
                            topOv = areaTop + 0 + holoTopShift;
                            int fallbackBottom = areaBottom - 4;
                            int releaseLimit = this.releaseY > 0 ? this.releaseY - 8 : fallbackBottom;
                            int candidateBottom = Math.min(fallbackBottom, releaseLimit) + 7;
                            bottomOv = Math.min(candidateBottom, areaBottom - 2);
                        } else {
                            topOv = Math.max(areaTop, centerY - halfH) - 6;
                            bottomOv = Math.min(areaBottom, centerY + halfH) - 5;
                        }
                        guiGraphics.method_25294(leftOv, topOv, rightOv, bottomOv, baseColor);
                        for (int yy = topOv; yy < bottomOv; yy += 3) {
                            double phase = Math.sin((double)t * 0.01 + (double)yy * 0.2);
                            int alpha = (int)(8.0 + (phase + 1.0) * 12.0);
                            int col = alpha << 24 | 0xD0FF;
                            guiGraphics.method_25294(leftOv, yy, rightOv, yy + 1, col);
                        }
                        try {
                            if (tintRed) {
                                int tintAlpha = 68;
                                int tintColor = tintAlpha << 24 | 0xFF0000;
                                guiGraphics.method_25294(leftOv, topOv, rightOv, bottomOv, tintColor);
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            pose.method_22909();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (TerminalTabHelper.handleTerminalTabClick(this.field_22787, this.field_2776, this.field_2800, (int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.method_25290(class_10799.field_56883, texture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        try {
            if (this.world != null) {
                this.blockEntity = (ConverterPocketCubeBlockEntity)this.world.method_8321(new class_2338(this.x, this.y, this.z));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.blockEntity == null) {
            guiGraphics.method_51433(this.field_22793, "No villager stored", 8, 8, -12829636, false);
            return;
        }
        String title = "Converter Pocket Cube";
        int titleX = this.field_2792 / 2 - this.field_22793.method_1727(title) / 2;
        guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), titleX, 8, -12829636, false);
        class_2487 villagerData = this.blockEntity.getVillagerData();
        if (villagerData != null && !villagerData.method_33133()) {
            Object professionLabel = "Unemployed";
            try {
                String profId = "minecraft:none";
                try {
                    if (villagerData.method_10545("VillagerData")) {
                        class_2487 vd = villagerData.method_10562("VillagerData").orElse(new class_2487());
                        profId = vd.method_10558("profession").orElse(profId);
                    } else {
                        profId = villagerData.method_10558("VillagerData.profession").orElse(profId);
                    }
                }
                catch (Throwable vd) {
                    // empty catch block
                }
                if (profId != null) {
                    String prof = profId;
                    if (prof.contains(":")) {
                        prof = prof.split(":")[1];
                    }
                    professionLabel = !prof.isBlank() && !prof.equalsIgnoreCase("none") ? prof.substring(0, 1).toUpperCase() + prof.substring(1) : "Unemployed";
                }
            }
            catch (Throwable profId) {
                // empty catch block
            }
            int level = 1;
            try {
                level = villagerData.method_10550("VillagerData.level").orElse(1);
            }
            catch (Throwable prof) {
                // empty catch block
            }
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7b" + (String)professionLabel + " Lv" + level)), 8, 35, -1, false);
        }
        try {
            int centerX = this.field_2792 / 2;
            int barWidth = 88;
            int barHeight = 6;
            int zombifyPct = 0;
            int curingPct = 0;
            int stage2 = this.clientConversionStage;
            try {
                if (this.blockEntity != null) {
                    stage2 = this.blockEntity.getConversionStage().ordinal();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int predictedProgress = this.clientConversionProgress;
            try {
                if (this.clientConversionLastUpdateMs > 0L) {
                    long now = System.currentTimeMillis();
                    long elapsedMs = Math.max(0L, now - this.clientConversionLastUpdateMs);
                    int elapsedTicks = (int)(elapsedMs / 50L);
                    int totalTicks = 1;
                    if (stage2 == ConverterPocketCubeBlockEntity.ConversionStage.ZOMBIFYING.ordinal()) {
                        totalTicks = Math.max(1, PocketVillagersConfigCache.getConverterZombifyTime());
                    } else if (stage2 == ConverterPocketCubeBlockEntity.ConversionStage.CURING.ordinal()) {
                        totalTicks = Math.max(1, PocketVillagersConfigCache.getConverterCureTime());
                    }
                    if (totalTicks > 0) {
                        double pctAdd = (double)elapsedTicks / (double)totalTicks * 100.0;
                        predictedProgress = (int)Math.min(100L, Math.round((double)this.clientConversionProgress + pctAdd));
                    }
                }
            }
            catch (Throwable now) {
                // empty catch block
            }
            int stageProgress = predictedProgress;
            switch (stage2) {
                case 0: {
                    zombifyPct = 0;
                    curingPct = 0;
                    break;
                }
                case 1: {
                    zombifyPct = stageProgress;
                    curingPct = 0;
                    break;
                }
                case 2: {
                    zombifyPct = 100;
                    curingPct = stageProgress;
                    break;
                }
                case 3: {
                    zombifyPct = 100;
                    curingPct = 100;
                    break;
                }
                default: {
                    zombifyPct = 0;
                    curingPct = 0;
                }
            }
            int barX = centerX - barWidth / 2 - 1;
            int barBase = 78;
            int topOffset = 14;
            int barYTop = barBase - topOffset;
            int barYBottom = barBase + 12;
            int cyan = -1442775041;
            int bg = 0x66000000;
            int outline = -1996488705;
            guiGraphics.method_25294(barX, barYTop, barX + barWidth, barYTop + barHeight, bg);
            int filledTop = (int)Math.round((double)barWidth * ((double)zombifyPct / 100.0));
            if (filledTop > 0) {
                guiGraphics.method_25294(barX, barYTop, barX + filledTop, barYTop + barHeight, cyan);
            }
            guiGraphics.method_25294(barX, barYTop - 1, barX + barWidth, barYTop, outline);
            guiGraphics.method_25294(barX, barYTop + barHeight, barX + barWidth, barYTop + barHeight + 1, outline);
            guiGraphics.method_25294(barX - 1, barYTop, barX, barYTop + barHeight, outline);
            guiGraphics.method_25294(barX + barWidth, barYTop, barX + barWidth + 1, barYTop + barHeight, outline);
            guiGraphics.method_25294(barX, barYBottom, barX + barWidth, barYBottom + barHeight, bg);
            int filledBottom = (int)Math.round((double)barWidth * ((double)curingPct / 100.0));
            if (filledBottom > 0) {
                guiGraphics.method_25294(barX, barYBottom, barX + filledBottom, barYBottom + barHeight, cyan);
            }
            guiGraphics.method_25294(barX, barYBottom - 1, barX + barWidth, barYBottom, outline);
            guiGraphics.method_25294(barX, barYBottom + barHeight, barX + barWidth, barYBottom + barHeight + 1, outline);
            guiGraphics.method_25294(barX - 1, barYBottom, barX, barYBottom + barHeight, outline);
            guiGraphics.method_25294(barX + barWidth, barYBottom, barX + barWidth + 1, barYBottom + barHeight, outline);
            String zPrefix = "Status: Zombifying";
            String cPrefix = "Status: Curing";
            String zPct = zombifyPct + "%";
            String cPct = curingPct + "%";
            int zTextX = barX + (barWidth - this.field_22793.method_1727(zPrefix)) / 2;
            Objects.requireNonNull(this.field_22793);
            int zTextY = barYTop - 9 - 2;
            int zPctX = barX + (barWidth - this.field_22793.method_1727(zPct)) / 2;
            Objects.requireNonNull(this.field_22793);
            int zPctY = barYTop - 9 / 2 + barHeight / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7b" + zPrefix)), zTextX, zTextY, -1, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)zPct), zPctX + 1, zPctY + 1, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)zPct), zPctX, zPctY, -1, false);
            int zPctRightX = barX + barWidth + 6;
            Objects.requireNonNull(this.field_22793);
            int n = zPctY - 9 / 2;
            Objects.requireNonNull(this.field_22793);
            int zPctRightY = n + 9 / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)zPct), zPctRightX + 1, zPctRightY + 1, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)zPct), zPctRightX, zPctRightY, 0xFFFFFF, false);
            int cTextX = barX + (barWidth - this.field_22793.method_1727(cPrefix)) / 2;
            Objects.requireNonNull(this.field_22793);
            int cTextY = barYBottom - 9 - 2;
            int cPctX = barX + (barWidth - this.field_22793.method_1727(cPct)) / 2;
            Objects.requireNonNull(this.field_22793);
            int cPctY = barYBottom - 9 / 2 + barHeight / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)("\u00a7b" + cPrefix)), cTextX, cTextY, -1, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cPct), cPctX + 1, cPctY + 1, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cPct), cPctX, cPctY, -1, false);
            int cPctRightX = barX + barWidth + 6;
            Objects.requireNonNull(this.field_22793);
            int n2 = cPctY - 9 / 2;
            Objects.requireNonNull(this.field_22793);
            int cPctRightY = n2 + 9 / 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cPct), cPctRightX + 1, cPctRightY + 1, 0, false);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)cPct), cPctRightX, cPctRightY, 0xFFFFFF, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean method_25404(int key, int b, int c) {
        if (key == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return super.method_25404(key, b, c);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.execute(() -> this.field_22787.execute(() -> {
            if (this.field_22787.field_1755 == null && TerminalTabHelper.isViewingFromTerminal()) {
                TerminalTabHelper.clearViewingFromTerminal();
            }
        }));
    }

    public void method_25426() {
        super.method_25426();
        PocketVillagersMod.LOGGER.debug("ConverterPocketCubeScreen.init() - terminal flag is: {}", TerminalTabHelper.isViewingFromTerminal() ? TerminalTabHelper.getTerminalPosition() : "not set");
        try {
            String buttonLabel = "Release";
            int btnW = 56;
            int btnH = 13;
            int leftModelX = this.field_2776 + 34;
            int modelY = this.field_2800 + 82;
            int btnX = leftModelX - 28 + 1;
            int btnY = modelY + 35;
            this.releaseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), btn -> {
                try {
                    class_2338 p = new class_2338(this.x, this.y, this.z);
                    ClientPlayNetworking.send((class_8710)new ReleaseStorageVillagerPacket(p, 1));
                    btn.method_25350(0.8f);
                    try {
                        if (this.world != null) {
                            VillagerRendererManager.remove(this.world, new class_2338(this.x, this.y, this.z), 1);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (this.blockEntity != null) {
                            this.blockEntity.setVillagerData(new class_2487());
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }).method_46434(btnX, btnY, 56, 13).method_46431();
            this.releaseX = btnX;
            this.releaseY = btnY;
            this.releaseW = 56;
            this.releaseH = 13;
            try {
                boolean hasVillagerInit;
                this.releaseButton.field_22763 = hasVillagerInit = this.blockEntity != null && this.blockEntity.hasVillager();
                try {
                    this.releaseButton.method_25350(1.0f);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.method_37063((class_364)this.releaseButton);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void drawCyanTooltip(class_332 guiGraphics, String text, int mouseX, int mouseY) {
        try {
            int pad = 6;
            int lineW = this.field_22793.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(this.field_22793);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > this.field_22789 - 4) {
                x = this.field_22789 - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
            int textX = x + pad;
            int textY = y + pad - 2;
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)text), textX, textY, -1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class GuiPreviewAdjust {
        final int leftXOffset;
        final int leftYOffset;
        final int rightXOffset;
        final int rightYOffset;
        final boolean tintLeftRed;
        final float scale;
        final int holoTopShift;

        GuiPreviewAdjust(int lx, int ly, int rx, int ry, boolean tintLeftRed, float scale, int holoTopShift) {
            this.leftXOffset = lx;
            this.leftYOffset = ly;
            this.rightXOffset = rx;
            this.rightYOffset = ry;
            this.tintLeftRed = tintLeftRed;
            this.scale = scale;
            this.holoTopShift = holoTopShift;
        }
    }
}

