/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client.gui;

import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.network.ReopenTerminalPayload;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8710;

public class TerminalTabHelper {
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 28;
    private static final int BG_COLOR = -16109761;
    private static final int BORDER_COLOR = -16711681;
    private static class_2338 viewingFromTerminal = null;
    private static long viewingFromTerminalSetTime = 0L;

    public static void setViewingFromTerminal(class_2338 terminalPos) {
        if (!PocketVillagersConfig.getInstance().enableTerminalTab) {
            PocketVillagersMod.LOGGER.debug("CLIENT: TerminalTabHelper.setViewingFromTerminal - terminal tab disabled in config, not setting flag");
            return;
        }
        viewingFromTerminal = terminalPos;
        viewingFromTerminalSetTime = System.currentTimeMillis();
        PocketVillagersMod.LOGGER.debug("CLIENT: TerminalTabHelper.setViewingFromTerminal - flag SET to {} at {}", (Object)terminalPos, (Object)viewingFromTerminalSetTime);
    }

    public static void clearViewingFromTerminal() {
        class_2338 oldPos = viewingFromTerminal;
        viewingFromTerminal = null;
        viewingFromTerminalSetTime = 0L;
        PocketVillagersMod.LOGGER.debug("CLIENT: TerminalTabHelper.clearViewingFromTerminal - flag CLEARED (was {})", (Object)oldPos);
    }

    public static boolean isViewingFromTerminal() {
        long timeout;
        if (!PocketVillagersConfig.getInstance().enableTerminalTab) {
            return false;
        }
        if (viewingFromTerminal == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long age = now - viewingFromTerminalSetTime;
        if (age > (timeout = (long)PocketVillagersConfig.getInstance().terminalTabTimeout)) {
            PocketVillagersMod.LOGGER.debug("CLIENT: TerminalTabHelper.isViewingFromTerminal - flag EXPIRED (age={}ms, limit={}ms), auto-clearing", (Object)age, (Object)timeout);
            TerminalTabHelper.clearViewingFromTerminal();
            return false;
        }
        return true;
    }

    public static class_2338 getTerminalPosition() {
        return viewingFromTerminal;
    }

    public static void renderTerminalTab(class_332 guiGraphics, int leftPos, int topPos, int mouseX, int mouseY) {
        boolean shouldRender = TerminalTabHelper.isViewingFromTerminal();
        if (shouldRender && System.currentTimeMillis() % 1000L < 50L) {
            PocketVillagersMod.LOGGER.debug("CLIENT: TerminalTabHelper.renderTerminalTab - RENDERING tab (flag={}, terminalPos={})", (Object)shouldRender, (Object)viewingFromTerminal);
        }
        if (!shouldRender) {
            return;
        }
        int tabX = leftPos - 28;
        int tabY = topPos;
        guiGraphics.method_25294(tabX, tabY, tabX + 28, tabY + 28, -16109761);
        guiGraphics.method_25294(tabX, tabY, tabX + 28, tabY + 1, -16711681);
        guiGraphics.method_25294(tabX, tabY + 28 - 1, tabX + 28, tabY + 28, -16711681);
        guiGraphics.method_25294(tabX, tabY, tabX + 1, tabY + 28, -16711681);
        guiGraphics.method_25294(tabX + 28 - 1, tabY, tabX + 28, tabY + 28, -16711681);
        class_1799 terminalItem = new class_1799((class_1935)PocketVillagersModBlocks.POCKET_TERMINAL);
        if (!terminalItem.method_7960()) {
            int iconX = tabX + 6;
            int iconY = tabY + 6;
            guiGraphics.method_51427(terminalItem, iconX, iconY);
        }
    }

    public static void renderTerminalTabTooltip(class_310 minecraft, class_332 guiGraphics, int leftPos, int topPos, int mouseX, int mouseY) {
        if (!TerminalTabHelper.isViewingFromTerminal()) {
            return;
        }
        TerminalTabHelper.renderTerminalTab(guiGraphics, leftPos, topPos, mouseX, mouseY);
        int tabX = leftPos - 28;
        int tabY = topPos;
        if (mouseX >= tabX && mouseX < tabX + 28 && mouseY >= tabY && mouseY < tabY + 28) {
            String text = "Back to Terminal";
            int pad = 6;
            int lineW = minecraft.field_1772.method_1727(text);
            int boxW = lineW + pad * 2;
            Objects.requireNonNull(minecraft.field_1772);
            int lineHeight = 9;
            int boxH = lineHeight + pad * 2 - 4;
            int x = mouseX + 6;
            int y = mouseY - boxH - 6;
            if (x + boxW > minecraft.method_22683().method_4486() - 4) {
                x = minecraft.method_22683().method_4486() - boxW - 4;
            }
            if (y < 4) {
                y = mouseY + 12;
            }
            int bg = -871747777;
            int border = -16711681;
            int shadow = -2147467184;
            guiGraphics.method_25294(x + 2, y + 2, x + boxW + 2, y + boxH + 2, shadow);
            guiGraphics.method_25294(x, y, x + boxW, y + boxH, bg);
            guiGraphics.method_25294(x, y, x + boxW, y + 1, border);
            guiGraphics.method_25294(x, y + boxH - 1, x + boxW, y + boxH, border);
            int textX = x + pad;
            int textY = y + pad - 2;
            guiGraphics.method_51439(minecraft.field_1772, (class_2561)class_2561.method_43470((String)text), textX, textY, -1, false);
        }
    }

    public static boolean handleTerminalTabClick(class_310 minecraft, int leftPos, int topPos, int mouseX, int mouseY) {
        class_2338 terminalPos;
        if (!TerminalTabHelper.isViewingFromTerminal()) {
            return false;
        }
        int tabX = leftPos - 28;
        int tabY = topPos;
        if (mouseX >= tabX && mouseX < tabX + 28 && mouseY >= tabY && mouseY < tabY + 28 && (terminalPos = TerminalTabHelper.getTerminalPosition()) != null) {
            ClientPlayNetworking.send((class_8710)new ReopenTerminalPayload(terminalPos));
            if (minecraft.field_1724 != null) {
                minecraft.field_1724.method_7346();
            }
            return true;
        }
        return false;
    }
}

