/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;

public class PocketVillagersConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("pocket_villagers.json");
    public int farmingTickInterval = 6000;
    public int miningTickInterval = 6000;
    public int fishingTickInterval = 3600;
    public int ironFarmTickInterval = 6000;
    public int converterZombifyTime = 24000;
    public int converterCureTime = 24000;
    public boolean requireFuelSlot = true;
    public int fuelDurationTicks = 6000;
    public boolean enableEfficiency = true;
    public double efficiencySpeedBonus = 0.1;
    public boolean enableFortune = true;
    public boolean enableTerminalTab = true;
    public int terminalTabTimeout = 300000;
    public int terminalMaxRange = 64;
    public boolean enableVillagerHolograms = true;
    public double villagerRenderDistance = 64.0;
    public int breederBreedingCooldown = 12000;
    public int breederBabyGrowthTime = 24000;
    private static PocketVillagersConfig INSTANCE = null;

    public static PocketVillagersConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = PocketVillagersConfig.load();
        }
        return INSTANCE;
    }

    public static PocketVillagersConfig load() {
        PocketVillagersConfig config = new PocketVillagersConfig();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                PocketVillagersConfig loaded = (PocketVillagersConfig)GSON.fromJson(json, PocketVillagersConfig.class);
                if (loaded != null) {
                    config = loaded;
                }
            }
            catch (IOException e) {
                PocketVillagersMod.LOGGER.warn("[Pocket Villagers] Failed to load config, using defaults: {}", (Object)e.getMessage());
            }
        }
        config.save();
        try {
            PocketVillagersConfigCache.refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            PocketVillagersMod.LOGGER.error("[Pocket Villagers] Failed to save config: {}", (Object)e.getMessage());
        }
        try {
            PocketVillagersConfigCache.refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getFarmingTickInterval() {
        return Math.max(1, this.farmingTickInterval);
    }

    public int getFishingTickInterval() {
        return Math.max(1, this.fishingTickInterval);
    }

    public int getMiningTickInterval() {
        return Math.max(1, this.miningTickInterval);
    }

    public int getIronFarmTickInterval() {
        return Math.max(1, this.ironFarmTickInterval);
    }

    public int getBreederBreedingCooldown() {
        return Math.max(1, this.breederBreedingCooldown);
    }

    public int getBreederBabyGrowthTime() {
        return Math.max(1, this.breederBabyGrowthTime);
    }

    public int getConverterCureTime() {
        return Math.max(1, this.converterCureTime);
    }

    public int getConverterZombifyTime() {
        return Math.max(1, this.converterZombifyTime);
    }

    public boolean isRequireFuelSlot() {
        return this.requireFuelSlot;
    }

    public int getFuelDurationTicks() {
        return Math.max(1, this.fuelDurationTicks);
    }

    public static void reload() {
        INSTANCE = null;
        PocketVillagersConfig.load();
        try {
            PocketVillagersConfigCache.refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

