/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.mixin;

import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1646.class})
public abstract class VillagerTradingMixin {
    @Inject(method={"setTradingPlayer"}, at={@At(value="HEAD")})
    private void onTradingPlayerSet(class_1657 player, CallbackInfo ci) {
        if (player == null) {
            return;
        }
        class_1646 villager = (class_1646)this;
        int conversions = 0;
        for (String tag : villager.method_5752()) {
            if (tag == null || !tag.startsWith("PocketVillagers.Conversions=")) continue;
            try {
                String numPart = tag.substring("PocketVillagers.Conversions=".length());
                conversions = Integer.parseInt(numPart);
                break;
            }
            catch (NumberFormatException numPart) {
            }
        }
        if (conversions > 0) {
            PocketVillagersMod.LOGGER.debug("VillagerTradingMixin: Detected cured villager (conversions={}), reapplying discounts", (Object)conversions);
            class_1916 offers = villager.method_8264();
            if (offers != null && !offers.isEmpty()) {
                for (class_1914 offer : offers) {
                    int baseCost = offer.method_8246().method_7947();
                    int discount = (int)Math.floor((double)baseCost * 0.9);
                    int currentSpecial = offer.method_19277();
                    if (currentSpecial != 0 && currentSpecial <= -discount) continue;
                    offer.method_8245(-discount - currentSpecial);
                    PocketVillagersMod.LOGGER.debug("VillagerTradingMixin: Applied 90% discount to offer - baseCost: {}, discount: {}, was: {}, now: {}", (Object)baseCost, (Object)discount, (Object)currentSpecial, (Object)offer.method_19277());
                }
            }
        }
    }
}

