/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.AutoTraderPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketTerminalBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.network.SetTerminalViewPayload;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record OpenRemoteCubePayload(class_2338 cubePos) implements class_8710
{
    public static final class_8710.class_9154<OpenRemoteCubePayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"open_remote_cube"));
    public static final class_9139<class_2540, OpenRemoteCubePayload> CODEC = class_9139.method_56437((buf, payload) -> buf.method_10807(payload.cubePos), buf -> new OpenRemoteCubePayload(buf.method_10811()));

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void send(class_3222 player, class_2338 cubePos) {
        class_2338 terminalPos = OpenRemoteCubePayload.findNearbyPoweredTerminal(player, cubePos);
        if (terminalPos == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo powered Pocket Terminal found nearby!"));
            return;
        }
        class_2586 terminalBE = player.method_51469().method_8321(terminalPos);
        if (!(terminalBE instanceof PocketTerminalBlockEntity)) {
            return;
        }
        PocketTerminalBlockEntity terminal = (PocketTerminalBlockEntity)terminalBE;
        if (PocketVillagersConfig.getInstance().enableTerminalTab) {
            SetTerminalViewPayload.sendToPlayer(player, terminalPos);
        }
        List<SyncTerminalVillagersPayload.CubeVillagerData> villagers = terminal.scanCubeVillagers();
        SyncTerminalVillagersPayload.sendToPlayer(player, villagers);
        class_2586 be = player.method_51469().method_8321(cubePos);
        if (be instanceof AutoTraderPocketCubeBlockEntity || be instanceof BreederPocketCubeBlockEntity || be instanceof ConverterPocketCubeBlockEntity || be instanceof FarmingPocketCubeBlockEntity || be instanceof FishingPocketCubeBlockEntity || be instanceof IronFarmPocketCubeBlockEntity || be instanceof MiningPocketCubeBlockEntity || be instanceof StoragePocketCubeBlockEntity) {
            if (be instanceof class_3908) {
                class_3908 menuProvider = (class_3908)be;
                player.method_17355(menuProvider);
            }
            return;
        }
        if (be instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity pocketCube = (PocketCubeBlockEntity)be;
            if (!pocketCube.hasVillager()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager stored in this Pocket Cube!"));
                return;
            }
            try {
                CubeVillager cubeVillager = pocketCube.getOrCreateCachedVillager();
                if (cubeVillager != null) {
                    cubeVillager.setPocketCubePos(cubePos);
                    int villagerLevel = cubeVillager.method_7231().comp_3522();
                    int villagerXp = cubeVillager.method_19269();
                    SyncPocketCubePayload.send(player, cubePos, true, villagerLevel, villagerXp);
                    cubeVillager.method_8259((class_1657)player);
                    cubeVillager.method_17449((class_1657)player, (class_2561)class_2561.method_43470((String)"Pocket Cube"), villagerLevel);
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cFailed to load villager data!"));
                }
            }
            catch (Throwable t) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cError opening trading menu!"));
                PocketVillagersMod.LOGGER.error("Failed to open PocketCube trading from terminal", t);
            }
            return;
        }
        if (be instanceof class_3908) {
            class_3908 menuProvider = (class_3908)be;
            player.method_17355(menuProvider);
        }
    }

    private static class_2338 findNearbyPoweredTerminal(class_3222 player, class_2338 cubePos) {
        PocketVillagersConfig cfg = PocketVillagersConfig.getInstance();
        int SCAN_RADIUS = Math.max(0, cfg.terminalMaxRange);
        class_2338 center = cubePos;
        for (int x = -SCAN_RADIUS; x <= SCAN_RADIUS; ++x) {
            for (int y = -SCAN_RADIUS; y <= SCAN_RADIUS; ++y) {
                for (int z = -SCAN_RADIUS; z <= SCAN_RADIUS; ++z) {
                    PocketTerminalBlockEntity terminal;
                    class_2338 checkPos = center.method_10069(x, y, z);
                    class_2586 be = player.method_51469().method_8321(checkPos);
                    if (!(be instanceof PocketTerminalBlockEntity) || !(terminal = (PocketTerminalBlockEntity)be).isPowered() && cfg.isRequireFuelSlot()) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.player().method_5682().execute(() -> OpenRemoteCubePayload.send(context.player(), payload.cubePos)));
    }
}

