/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Method;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record ReleasePocketVillagerPacket(class_2338 pos) implements class_8710
{
    public static final class_8710.class_9154<ReleasePocketVillagerPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"release_villager"));
    public static final class_2960 ID = class_2960.method_60655((String)"pocket_villagers", (String)"release_villager");
    public static final class_9139<class_2540, ReleasePocketVillagerPacket> CODEC = class_9139.method_56434((class_9139)class_2338.field_48404, ReleasePocketVillagerPacket::pos, ReleasePocketVillagerPacket::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(TYPE, (packet, context) -> {
            class_3222 player = context.player();
            class_2338 pos = packet.pos();
            context.server().execute(() -> ReleasePocketVillagerPacket.performRelease(player, pos));
        });
    }

    private static void performRelease(class_3222 player, class_2338 pos) {
        block35: {
            try {
                PocketCubeBlockEntity cubeEntity;
                block38: {
                    block36: {
                        PocketVillagersMod.LOGGER.debug("PocketCube: Received ReleaseVillagerPacket from {} at {}", (Object)(player == null ? "<null>" : player.method_5477().getString()), (Object)pos);
                        if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                            return;
                        }
                        class_2586 blockEntity = player.method_51469().method_8321(pos);
                        if (!(blockEntity instanceof PocketCubeBlockEntity) || !(cubeEntity = (PocketCubeBlockEntity)blockEntity).hasVillager()) break block35;
                        try {
                            if (!cubeEntity.hasWorkstation()) break block36;
                            class_1799 ws = cubeEntity.getWorkstation();
                            if (ws != null && !ws.method_7960()) {
                                class_1542 drop = new class_1542((class_1937)player.method_51469(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, ws.method_7972());
                                player.method_51469().method_8649((class_1297)drop);
                            }
                            cubeEntity.clearWorkstation();
                            try {
                                cubeEntity.method_5431();
                            }
                            catch (Throwable drop) {
                                // empty catch block
                            }
                            try {
                                player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                            }
                            catch (Throwable drop) {}
                        }
                        catch (Throwable ws) {
                            // empty catch block
                        }
                    }
                    try {
                        CubeVillager realVillager = cubeEntity.getRealVillager();
                        if (realVillager instanceof CubeVillager) {
                            CubeVillager cv = realVillager;
                            cv.forceSaveToCube();
                        }
                    }
                    catch (Throwable realVillager) {
                        // empty catch block
                    }
                    class_2487 villagerData = cubeEntity.getVillagerData();
                    try {
                        String prof = villagerData != null && villagerData.method_10545("VillagerData.profession") ? villagerData.method_10558("VillagerData.profession").orElse("unknown") : "no_data";
                        int xp = villagerData != null && villagerData.method_10545("Xp") ? villagerData.method_10550("Xp").orElse(0) : 0;
                        int lvl = villagerData != null && villagerData.method_10545("VillagerData.level") ? villagerData.method_10550("VillagerData.level").orElse(1) : 1;
                        PocketVillagersMod.LOGGER.debug("=== RELEASING VILLAGER ===");
                        PocketVillagersMod.LOGGER.debug("ReleaseVillagerPacket: Releasing villager - profession={} level={} xp={}", (Object)prof, (Object)lvl, (Object)xp);
                        PocketVillagersMod.LOGGER.debug("=== END RELEASE INFO ===");
                    }
                    catch (Throwable prof) {
                        // empty catch block
                    }
                    class_2487 releaseData = null;
                    if (villagerData != null) {
                        block37: {
                            releaseData = villagerData.method_10553();
                            try {
                                if (releaseData.method_10545("VillagerData.type")) break block37;
                                class_2487 stored = cubeEntity.getVillagerData();
                                if (stored != null && stored.method_10545("VillagerData.type")) {
                                    releaseData.method_10582("VillagerData.type", stored.method_10558("VillagerData.type").orElse("minecraft:plains"));
                                    PocketVillagersMod.LOGGER.debug("ReleasePocketVillagerPacket: Recovered VillagerData.type from cubeEntity stored data");
                                    break block37;
                                }
                                try {
                                    CubeVillager rv;
                                    String t;
                                    CubeVillager real = cubeEntity.getRealVillager();
                                    if (real instanceof class_1646 && (t = (String)(rv = real).method_7231().comp_3520().method_40230().map(k -> k.method_29177().toString()).orElse(null)) != null) {
                                        releaseData.method_10582("VillagerData.type", t);
                                    }
                                }
                                catch (Throwable real) {}
                            }
                            catch (Throwable stored) {
                                // empty catch block
                            }
                        }
                        try {
                            String type = releaseData.method_10545("VillagerData.type") ? releaseData.method_10558("VillagerData.type").orElse("<none>") : "<none>";
                            String prof = releaseData.method_10545("VillagerData.profession") ? releaseData.method_10558("VillagerData.profession").orElse("<none>") : "<none>";
                            int conversions = releaseData.method_10545("PocketVillagers.Conversions") ? releaseData.method_10550("PocketVillagers.Conversions").orElse(0) : 0;
                            int conversionTime = releaseData.method_10545("ConversionTime") ? releaseData.method_10550("ConversionTime").orElse(0) : 0;
                            PocketVillagersMod.LOGGER.debug("ReleasePocketVillagerPacket: releaseData type={} profession={} conversions={} conversionTime={} fullTag={}", (Object)type, (Object)prof, (Object)conversions, (Object)conversionTime, (Object)releaseData.toString());
                        }
                        catch (Throwable type) {
                            // empty catch block
                        }
                    }
                    class_1646 spawned = VillagerDataHandler.spawnVillagerFromData((class_1937)player.method_51469(), pos.method_10084(), releaseData);
                    try {
                        boolean hasOffers;
                        if (spawned == null) break block38;
                        boolean bl = hasOffers = releaseData != null && releaseData.method_10545("Offers");
                        if (!hasOffers) {
                            try {
                                Method updateTradesMethod = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                                updateTradesMethod.setAccessible(true);
                                updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                PocketVillagersMod.LOGGER.debug("ReleaseVillagerPacket: No saved offers, called updateTrades to generate fresh ones");
                            }
                            catch (NoSuchMethodException nsm) {
                                try {
                                    Method updateTradesMethod = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                                    updateTradesMethod.setAccessible(true);
                                    updateTradesMethod.invoke((Object)spawned, new Object[0]);
                                    break block38;
                                }
                                catch (Throwable e2) {
                                    PocketVillagersMod.LOGGER.warn("ReleaseVillagerPacket: Could not call updateTrades: {}", (Object)e2.getMessage());
                                }
                            }
                            break block38;
                        }
                        PocketVillagersMod.LOGGER.debug("ReleaseVillagerPacket: Saved offers found, preserving them (NOT calling updateTrades)");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                cubeEntity.clearVillager();
                try {
                    cubeEntity.method_5431();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    player.method_51469().method_8413(pos, player.method_51469().method_8320(pos), player.method_51469().method_8320(pos), 3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                player.method_7346();
                player.method_7353((class_2561)class_2561.method_43470((String)"Villager Released!"), true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

