/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.stream.IntStream;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3850;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PocketCubeBlockEntity
extends class_2621
implements class_1278 {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_2487 villagerData = new class_2487();
    private boolean hasVillager = false;
    private float facingYaw = 0.0f;
    private class_1799 workstation = class_1799.field_8037;
    private boolean workstationPersisted = false;
    private class_2371<class_1799> workstationList = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private transient CubeVillager cachedVillager = null;
    private transient CubeVillager realVillager = null;

    public PocketCubeBlockEntity(class_2338 position, class_2680 state) {
        this(PocketVillagersModBlockEntities.POCKET_CUBE, position, state);
    }

    protected PocketCubeBlockEntity(class_2591<?> type, class_2338 position, class_2680 state) {
        super(type, position, state);
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_11368)valueInput, this.stacks);
        this.hasVillager = valueInput.method_71433("HasVillager", false);
        if (this.hasVillager) {
            valueInput.method_71426("VillagerData", class_2487.field_25128).ifPresent(tag -> {
                this.villagerData = tag.method_10553();
            });
        } else {
            this.villagerData = new class_2487();
        }
        this.workstationList = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)valueInput, this.workstationList);
        this.workstation = (class_1799)this.workstationList.get(0);
        try {
            this.workstationPersisted = valueInput.method_71433("WorkstationPersisted", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.facingYaw = valueInput.method_71423("FacingYaw", 0.0f);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.stacks);
        }
        valueOutput.method_71472("HasVillager", this.hasVillager);
        if (this.hasVillager && this.villagerData != null && !this.villagerData.method_33133()) {
            valueOutput.method_71468("VillagerData", class_2487.field_25128, (Object)this.villagerData.method_10553());
        }
        this.workstationList = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        if (this.workstation != null && !this.workstation.method_7960()) {
            this.workstationList.set(0, (Object)this.workstation);
        } else {
            this.workstationList.set(0, (Object)class_1799.field_8037);
        }
        class_1262.method_5426((class_11372)valueOutput, this.workstationList);
        try {
            valueOutput.method_71472("WorkstationPersisted", this.workstationPersisted);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        valueOutput.method_71464("FacingYaw", this.facingYaw);
    }

    public void load(class_2487 tag, class_7225.class_7874 registries) {
        this.hasVillager = tag.method_10577("HasVillager").orElse(false);
        if (this.hasVillager && tag.method_10545("VillagerData")) {
            this.villagerData = tag.method_10562("VillagerData").orElse(new class_2487());
        }
        this.workstation = class_1799.field_8037;
        if (tag.method_10545("WorkstationItemId")) {
            try {
                String id = tag.method_10558("WorkstationItemId").orElse("");
                int cnt = tag.method_10550("WorkstationCount").orElse(1);
                class_2960 rl = class_2960.method_60654((String)id);
                Optional itemRef = class_7923.field_41178.method_10223(rl);
                if (itemRef != null && itemRef.isPresent()) {
                    class_6880.class_6883 holder = (class_6880.class_6883)itemRef.get();
                    this.workstation = new class_1799((class_6880)holder, cnt);
                }
            }
            catch (Exception e) {
                this.workstation = class_1799.field_8037;
            }
        }
        try {
            this.facingYaw = tag.method_10545("FacingYaw") ? tag.method_10583("FacingYaw").orElse(Float.valueOf(0.0f)).floatValue() : 0.0f;
        }
        catch (Exception e) {
            this.facingYaw = 0.0f;
        }
        try {
            this.workstationPersisted = tag.method_10577("WorkstationPersisted").orElse(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void saveAdditional(class_2487 tag, class_7225.class_7874 registries) {
        if (this.hasVillager && this.villagerData != null && !this.villagerData.method_33133()) {
            tag.method_10566("VillagerData", (class_2520)this.villagerData.method_10553());
            tag.method_10556("HasVillager", true);
        }
        if (this.workstation != null && !this.workstation.method_7960()) {
            class_1792 item = this.workstation.method_7909();
            try {
                class_2960 key = class_7923.field_41178.method_10221((Object)item);
                if (key != null) {
                    tag.method_10582("WorkstationItemId", key.toString());
                    tag.method_10569("WorkstationCount", this.workstation.method_7947());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            tag.method_10548("FacingYaw", this.facingYaw);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tag.method_10556("WorkstationPersisted", this.workstationPersisted);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(class_2487 tag) {
        block11: {
            try {
                this.hasVillager = tag.method_10577("HasVillager").orElse(false);
                this.villagerData = this.hasVillager && tag.method_10562("VillagerData").isPresent() ? tag.method_10562("VillagerData").orElse(new class_2487()) : new class_2487();
            }
            catch (Throwable ignored) {
                this.villagerData = new class_2487();
                this.hasVillager = false;
            }
            try {
                this.workstation = class_1799.field_8037;
                if (!tag.method_10558("WorkstationItemId").isPresent()) break block11;
                try {
                    String id = tag.method_10558("WorkstationItemId").orElse("");
                    int cnt = tag.method_10550("WorkstationCount").orElse(1);
                    class_2960 rl = class_2960.method_60654((String)id);
                    Optional itemRef = class_7923.field_41178.method_10223(rl);
                    if (itemRef != null && itemRef.isPresent()) {
                        class_6880.class_6883 holder = (class_6880.class_6883)itemRef.get();
                        this.workstation = new class_1799((class_6880)holder, cnt);
                    }
                }
                catch (Throwable ignored) {
                    this.workstation = class_1799.field_8037;
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        try {
            this.facingYaw = tag.method_10583("FacingYaw").orElse(Float.valueOf(0.0f)).floatValue();
        }
        catch (Throwable ignored) {
            this.facingYaw = 0.0f;
        }
        try {
            this.workstationPersisted = tag.method_10577("WorkstationPersisted").orElse(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public CubeVillager getOrCreateCachedVillager() {
        try {
            if (this.field_11863 == null || this.field_11863.field_9236) {
                return null;
            }
            if (this.realVillager != null && !this.realVillager.method_31481()) {
                return this.realVillager;
            }
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_2487 vd = this.villagerData != null ? this.villagerData : new class_2487();
                this.realVillager = VillagerDataHandler.createTradingVillager((class_1937)serverLevel, this.method_11016(), vd);
                if (this.realVillager != null) {
                    PocketVillagersMod.LOGGER.debug("PocketCube: created CubeVillager with {} offers", (Object)(this.realVillager.method_8264() == null ? 0 : this.realVillager.method_8264().size()));
                }
            }
            return this.realVillager;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("PocketCube: failed to create CubeVillager", t);
            return null;
        }
    }

    public CubeVillager getRealVillager() {
        return this.realVillager;
    }

    public void clearCachedVillager() {
        if (this.realVillager != null && !this.realVillager.method_31481()) {
            this.realVillager.method_5650(class_1297.class_5529.field_26999);
        }
        this.realVillager = null;
        this.cachedVillager = null;
    }

    protected void saveAdditional(class_2487 tag) {
        block10: {
            try {
                if (this.hasVillager && this.villagerData != null && !this.villagerData.method_33133()) {
                    tag.method_10566("VillagerData", (class_2520)this.villagerData.method_10553());
                    tag.method_10556("HasVillager", true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.workstation == null || this.workstation.method_7960()) break block10;
                class_1792 item = this.workstation.method_7909();
                try {
                    class_2960 key = class_7923.field_41178.method_10221((Object)item);
                    if (key != null) {
                        tag.method_10582("WorkstationItemId", key.toString());
                        tag.method_10569("WorkstationCount", this.workstation.method_7947());
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            tag.method_10548("FacingYaw", this.facingYaw);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean hasWorkstation() {
        return this.workstation != null && !this.workstation.method_7960();
    }

    public class_1799 getWorkstation() {
        return this.workstation == null ? class_1799.field_8037 : this.workstation;
    }

    public void setWorkstation(class_1799 stack) {
        this.workstation = stack == null ? class_1799.field_8037 : stack.method_7972();
        try {
            this.workstationPersisted = this.field_11863 != null && !this.field_11863.field_9236 && this.workstation != null && !this.workstation.method_7960();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_5431();
        this.syncToClient();
    }

    public boolean hasPersistedWorkstation() {
        return this.workstationPersisted;
    }

    public void clearWorkstation() {
        block10: {
            this.workstation = class_1799.field_8037;
            try {
                int xp = 0;
                try {
                    if (this.villagerData != null && this.villagerData.method_10545("Xp")) {
                        xp = this.villagerData.method_10550("Xp").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (xp > 0) break block10;
                try {
                    class_2487 minimal = new class_2487();
                    minimal.method_10582("id", "minecraft:villager");
                    minimal.method_10582("VillagerData.profession", "minecraft:none");
                    String storedType = "minecraft:plains";
                    try {
                        if (this.villagerData != null && this.villagerData.method_10545("VillagerData.type")) {
                            storedType = this.villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                        }
                    }
                    catch (Throwable ignoredType) {
                        storedType = "minecraft:plains";
                    }
                    minimal.method_10582("VillagerData.type", storedType);
                    minimal.method_10569("VillagerData.level", 1);
                    minimal.method_10569("Xp", 0);
                    this.setVillagerData(minimal);
                    return;
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.method_5431();
        this.syncToClient();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10556("HasVillager", this.hasVillager);
            if (this.hasVillager && this.villagerData != null && !this.villagerData.method_33133()) {
                tag.method_10566("VillagerData", (class_2520)this.villagerData.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void syncToClient() {
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.method_5431();
                try {
                    this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"pocket_cube");
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Pocket Cube");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemstack);
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        return true;
    }

    public boolean hasVillager() {
        return this.hasVillager;
    }

    public class_2487 getVillagerData() {
        return this.villagerData;
    }

    public void setVillagerData(class_2487 data) {
        block21: {
            this.villagerData = data != null ? data : new class_2487();
            this.hasVillager = data != null && !data.method_33133();
            PocketVillagersMod.LOGGER.debug("setVillagerData called! hasVillager={}, dataEmpty={}", (Object)this.hasVillager, (Object)this.villagerData.method_33133());
            try {
                if (this.cachedVillager == null) break block21;
                try {
                    block22: {
                        try {
                            if (this.villagerData == null || !this.villagerData.method_10545("VillagerData.profession")) break block22;
                            String professionStr = this.villagerData.method_10558("VillagerData.profession").orElse("minecraft:none");
                            String typeStr = this.villagerData.method_10558("VillagerData.type").orElse("minecraft:plains");
                            int villagerLevel = this.villagerData.method_10550("VillagerData.level").orElse(1);
                            try {
                                class_2960 profRl = class_2960.method_60654((String)professionStr);
                                class_2960 typeRl = class_2960.method_60654((String)typeStr);
                                Optional profOpt = class_7923.field_41195.method_10223(profRl);
                                Optional typeOpt = class_7923.field_41194.method_10223(typeRl);
                                if (profOpt != null && profOpt.isPresent() && typeOpt != null && typeOpt.isPresent()) {
                                    class_3850 current = this.cachedVillager.method_7231();
                                    class_3850 newData = current.method_16921((class_6880)profOpt.get()).method_16922((class_6880)typeOpt.get()).method_16920(villagerLevel);
                                    this.cachedVillager.method_7195(newData);
                                }
                            }
                            catch (Throwable profRl) {}
                        }
                        catch (Throwable professionStr) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.villagerData != null && this.villagerData.method_10545("Xp")) {
                            int xp = this.villagerData.method_10550("Xp").orElse(0);
                            this.cachedVillager.method_19625(xp);
                        }
                    }
                    catch (Throwable xp) {
                        // empty catch block
                    }
                    try {
                        class_6903 registryOps;
                        DataResult parsed;
                        class_2520 offersTag;
                        class_2487 vd;
                        class_2487 class_24872 = vd = this.villagerData != null ? this.villagerData : new class_2487();
                        if (vd.method_10545("Offers") && (offersTag = vd.method_10580("Offers")) != null && (parsed = class_1916.field_48850.parse((DynamicOps)(registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.field_11863.method_30349())), (Object)offersTag)).result().isPresent()) {
                            class_1916 allOffers = (class_1916)parsed.result().get();
                            try {
                                this.cachedVillager.method_16917(allOffers);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable vd) {
                    }
                }
                catch (Throwable t) {
                    try {
                        this.clearCachedVillager();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable ignored) {
                try {
                    this.clearCachedVillager();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.method_5431();
        this.syncToClient();
    }

    public float getFacingYaw() {
        return this.facingYaw;
    }

    public void setFacingYaw(float yaw) {
        this.facingYaw = yaw;
        this.method_5431();
    }

    public class_238 getRenderBoundingBox() {
        class_2338 pos = this.method_11016();
        return new class_238((double)(pos.method_10263() - 2), (double)(pos.method_10264() - 2), (double)(pos.method_10260() - 2), (double)(pos.method_10263() + 3), (double)(pos.method_10264() + 3), (double)(pos.method_10260() + 3));
    }

    public void clearVillager() {
        this.hasVillager = false;
        try {
            this.clearCachedVillager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.method_5431();
        this.syncToClient();
    }

    public void method_11012() {
        try {
            this.clearCachedVillager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.method_11012();
    }
}

