/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.world.inventory.StoragePocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class StoragePocketCubeBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int MAX_VILLAGERS = 10;
    private List<class_2487> storedVillagers = new ArrayList<class_2487>();
    private boolean hologramEnabled = true;

    public StoragePocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.STORAGE_POCKET_CUBE, position, state);
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.storedVillagers.clear();
        int count = valueInput.method_71424("VillagerCount", 0);
        for (int i = 0; i < count && i < 10; ++i) {
            String key = "Villager" + i;
            valueInput.method_71426(key, class_2487.field_25128).ifPresent(tag -> {
                if (!tag.method_33133()) {
                    this.storedVillagers.add(tag.method_10553());
                }
            });
        }
        try {
            this.hologramEnabled = valueInput.method_71433("HologramEnabled", this.hologramEnabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71465("VillagerCount", this.storedVillagers.size());
        for (int i = 0; i < this.storedVillagers.size(); ++i) {
            class_2487 villagerData = this.storedVillagers.get(i);
            if (villagerData == null || villagerData.method_33133()) continue;
            valueOutput.method_71468("Villager" + i, class_2487.field_25128, (Object)villagerData.method_10553());
        }
        try {
            valueOutput.method_71472("HologramEnabled", this.hologramEnabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10556("HologramEnabled", this.hologramEnabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void handleUpdateTag(class_2487 tag) {
        block5: {
            try {
                if (tag == null) break block5;
                try {
                    if (tag.method_10545("HologramEnabled")) {
                        this.hologramEnabled = tag.method_10577("HologramEnabled").orElse(this.hologramEnabled);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void saveAdditional(class_2487 tag) {
        try {
            tag.method_10556("HologramEnabled", this.hologramEnabled);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(class_2487 tag) {
        try {
            if (tag.method_10545("HologramEnabled")) {
                this.hologramEnabled = tag.method_10577("HologramEnabled").orElse(this.hologramEnabled);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43469((String)"container.pocket_villagers.storage_cube", (Object[])new Object[]{this.storedVillagers.size(), 10});
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new StoragePocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public boolean addVillager(class_2487 villagerData) {
        if (this.storedVillagers.size() >= 10) {
            return false;
        }
        if (villagerData == null || villagerData.method_33133()) {
            return false;
        }
        this.storedVillagers.add(villagerData.method_10553());
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        return true;
    }

    @Nullable
    public class_2487 removeVillager(int index) {
        if (index < 0 || index >= this.storedVillagers.size()) {
            return null;
        }
        class_2487 removed = this.storedVillagers.remove(index);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        return removed;
    }

    @Nullable
    public class_2487 getVillager(int index) {
        if (index < 0 || index >= this.storedVillagers.size()) {
            return null;
        }
        return this.storedVillagers.get(index);
    }

    public int getVillagerCount() {
        return this.storedVillagers.size();
    }

    public boolean isFull() {
        return this.storedVillagers.size() >= 10;
    }

    public List<class_2487> getStoredVillagers() {
        return new ArrayList<class_2487>(this.storedVillagers);
    }

    public boolean isHologramEnabled() {
        return this.hologramEnabled;
    }

    public void setHologramEnabled(boolean enabled) {
        this.hologramEnabled = enabled;
        this.method_5431();
        try {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getMaxVillagers() {
        return 10;
    }
}

