/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.config;

import java.awt.Desktop;
import java.io.File;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.client.HologramToggle;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class PocketVillagersConfigScreen
extends class_437 {
    private final class_437 parent;
    private final PocketVillagersConfig config;
    private static final String CONFIG_PATH = "config/pocket_villagers.json";
    private class_342 miningIntervalBox;
    private class_342 farmingIntervalBox;
    private class_342 fishingIntervalBox;
    private class_342 ironFarmIntervalBox;
    private class_342 converterCureTimeBox;
    private class_342 converterZombifyTimeBox;
    private class_342 fuelDurationTicksBox;
    private class_342 efficiencySpeedBonusBox;
    private class_342 terminalTabTimeoutBox;
    private class_342 terminalMaxRangeBox;
    private class_342 villagerRenderDistanceBox;
    private class_342 breederBreedingCooldownBox;
    private class_342 breederBabyGrowthTimeBox;
    private class_4185 saveButton;
    private class_4185 requireFuelButton;
    private class_4185 enableEfficiencyButton;
    private class_4185 enableFortuneButton;
    private class_4185 enableTerminalTabButton;
    private class_4185 enableHologramsButton;
    private String statusMessage = null;
    private int statusTicks = 0;
    private boolean editable = true;
    private int scrollOffset = 0;
    private static final int MAX_SCROLL = 2000;

    public PocketVillagersConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Pocket Villagers Configuration"));
        this.parent = parent;
        this.config = PocketVillagersConfig.getInstance();
    }

    protected void method_25426() {
        super.method_25426();
        try {
            this.editable = this.field_22787 != null && this.field_22787.method_1542();
        }
        catch (Throwable t) {
            this.editable = true;
        }
        int leftCol = 20;
        int startY = 45;
        int rowHeight = 20;
        int labelWidth = 210;
        int fieldWidth = 60;
        int y = startY + 14;
        this.farmingIntervalBox = new class_342(this.field_22793, leftCol + labelWidth, y, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Farming"));
        this.farmingIntervalBox.method_1852(String.valueOf(this.config.farmingTickInterval));
        this.farmingIntervalBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.farmingIntervalBox);
        this.miningIntervalBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Mining"));
        this.miningIntervalBox.method_1852(String.valueOf(this.config.miningTickInterval));
        this.miningIntervalBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.miningIntervalBox);
        this.fishingIntervalBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Fishing"));
        this.fishingIntervalBox.method_1852(String.valueOf(this.config.fishingTickInterval));
        this.fishingIntervalBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.fishingIntervalBox);
        this.ironFarmIntervalBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Iron Farm"));
        this.ironFarmIntervalBox.method_1852(String.valueOf(this.config.ironFarmTickInterval));
        this.ironFarmIntervalBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.ironFarmIntervalBox);
        this.converterZombifyTimeBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Converter Zombify"));
        this.converterZombifyTimeBox.method_1852(String.valueOf(this.config.converterZombifyTime));
        this.converterZombifyTimeBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.converterZombifyTimeBox);
        this.converterCureTimeBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Converter Cure"));
        this.converterCureTimeBox.method_1852(String.valueOf(this.config.converterCureTime));
        this.converterCureTimeBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.converterCureTimeBox);
        y += rowHeight;
        y += 8;
        y += 14;
        this.fuelDurationTicksBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight + 4, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Fuel Duration"));
        this.fuelDurationTicksBox.method_1852(String.valueOf(this.config.fuelDurationTicks));
        this.fuelDurationTicksBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.fuelDurationTicksBox);
        y += rowHeight;
        y += 14;
        this.efficiencySpeedBonusBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Eff Speed"));
        this.efficiencySpeedBonusBox.method_1852(String.valueOf((int)(this.config.efficiencySpeedBonus * 100.0)));
        this.efficiencySpeedBonusBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.efficiencySpeedBonusBox);
        y += rowHeight;
        y += rowHeight;
        y += 4;
        y += 14;
        this.terminalTabTimeoutBox = new class_342(this.field_22793, leftCol + labelWidth, (y += rowHeight) - rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Tab Timeout"));
        this.terminalTabTimeoutBox.method_1852(String.valueOf(this.config.terminalTabTimeout));
        this.terminalTabTimeoutBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.terminalTabTimeoutBox);
        this.terminalMaxRangeBox = new class_342(this.field_22793, leftCol + labelWidth, (y += rowHeight) - rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Max Range"));
        this.terminalMaxRangeBox.method_1852(String.valueOf(this.config.terminalMaxRange));
        this.terminalMaxRangeBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.terminalMaxRangeBox);
        y += rowHeight + 4;
        y += 14;
        this.villagerRenderDistanceBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Render Dist"));
        this.villagerRenderDistanceBox.method_1852(String.valueOf(this.config.villagerRenderDistance));
        this.villagerRenderDistanceBox.method_1890(s -> s.matches("\\d*\\.?\\d*"));
        this.method_37063((class_364)this.villagerRenderDistanceBox);
        y += rowHeight;
        this.breederBreedingCooldownBox = new class_342(this.field_22793, leftCol + labelWidth, y += 14, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Breed Cooldown"));
        this.breederBreedingCooldownBox.method_1852(String.valueOf(this.config.breederBreedingCooldown));
        this.breederBreedingCooldownBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.breederBreedingCooldownBox);
        this.breederBabyGrowthTimeBox = new class_342(this.field_22793, leftCol + labelWidth, y += rowHeight, fieldWidth, 18, (class_2561)class_2561.method_43470((String)"Baby Growth Time"));
        this.breederBabyGrowthTimeBox.method_1852(String.valueOf(this.config.breederBabyGrowthTime));
        this.breederBabyGrowthTimeBox.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.breederBabyGrowthTimeBox);
        int buttonWidth = 100;
        int buttonHeight = 20;
        int spacing = 5;
        int totalWidth = buttonWidth * 4 + spacing * 3;
        int startX = (this.field_22789 - totalWidth) / 2;
        int buttonY = this.field_22790 - 30;
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            if (!this.editable) {
                this.statusMessage = "Server-authoritative config: cannot save from this client.";
                this.statusTicks = 100;
                return;
            }
            try {
                this.config.miningTickInterval = Integer.parseInt(this.miningIntervalBox.method_1882().trim());
                this.config.farmingTickInterval = Integer.parseInt(this.farmingIntervalBox.method_1882().trim());
                this.config.fishingTickInterval = Integer.parseInt(this.fishingIntervalBox.method_1882().trim());
                this.config.ironFarmTickInterval = Integer.parseInt(this.ironFarmIntervalBox.method_1882().trim());
                this.config.converterZombifyTime = Integer.parseInt(this.converterZombifyTimeBox.method_1882().trim());
                this.config.converterCureTime = Integer.parseInt(this.converterCureTimeBox.method_1882().trim());
                this.config.fuelDurationTicks = Integer.parseInt(this.fuelDurationTicksBox.method_1882().trim());
                this.config.efficiencySpeedBonus = Double.parseDouble(this.efficiencySpeedBonusBox.method_1882().trim()) / 100.0;
                this.config.terminalTabTimeout = Integer.parseInt(this.terminalTabTimeoutBox.method_1882().trim());
                this.config.terminalMaxRange = Integer.parseInt(this.terminalMaxRangeBox.method_1882().trim());
                this.config.villagerRenderDistance = Double.parseDouble(this.villagerRenderDistanceBox.method_1882().trim());
                this.config.breederBreedingCooldown = Integer.parseInt(this.breederBreedingCooldownBox.method_1882().trim());
                this.config.breederBabyGrowthTime = Integer.parseInt(this.breederBabyGrowthTimeBox.method_1882().trim());
                this.config.save();
                this.statusMessage = "Saved successfully!";
                this.statusTicks = 100;
            }
            catch (NumberFormatException e) {
                this.statusMessage = "Invalid number format!";
                this.statusTicks = 100;
            }
        }).method_46434(startX, buttonY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Config"), button -> {
            try {
                File alt;
                String userDir;
                File f = new File(CONFIG_PATH);
                if (!f.exists() && (userDir = System.getProperty("user.dir")) != null && !userDir.isEmpty() && (alt = new File(userDir, CONFIG_PATH)).exists()) {
                    f = alt;
                }
                boolean opened = false;
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(f);
                        opened = true;
                    }
                    catch (Exception ex) {
                        opened = false;
                    }
                }
                if (!opened) {
                    String pathToOpen = f.getAbsolutePath();
                    String os = System.getProperty("os.name", "").toLowerCase();
                    try {
                        if (os.contains("win")) {
                            new ProcessBuilder("cmd", "/c", "start", "", pathToOpen).start();
                        } else if (os.contains("mac")) {
                            new ProcessBuilder("open", pathToOpen).start();
                        } else {
                            new ProcessBuilder("xdg-open", pathToOpen).start();
                        }
                        opened = true;
                    }
                    catch (Exception ex) {
                        opened = false;
                    }
                }
                if (!opened) {
                    PocketVillagersMod.LOGGER.error("Failed to open config file on this platform");
                } else if (!this.editable) {
                    this.statusMessage = "Opened local config: changes will NOT affect the server. Ask the host to edit server config.";
                    this.statusTicks = 160;
                }
            }
            catch (Exception e) {
                PocketVillagersMod.LOGGER.error("Failed to open config file: {}", (Object)e.getMessage());
            }
        }).method_46434(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Default"), button -> {
            if (!this.editable) {
                this.statusMessage = "Server-authoritative config: cannot reset defaults from this client.";
                this.statusTicks = 120;
                return;
            }
            this.config.miningTickInterval = 6000;
            this.config.farmingTickInterval = 6000;
            this.config.fishingTickInterval = 3600;
            this.config.ironFarmTickInterval = 6000;
            this.config.converterZombifyTime = 24000;
            this.config.converterCureTime = 24000;
            this.config.requireFuelSlot = true;
            this.config.enableEfficiency = true;
            this.config.efficiencySpeedBonus = 0.2;
            this.config.enableFortune = true;
            this.config.enableTerminalTab = true;
            this.config.terminalTabTimeout = 300000;
            this.config.terminalMaxRange = 64;
            this.config.enableVillagerHolograms = true;
            this.config.villagerRenderDistance = 64.0;
            this.config.breederBreedingCooldown = 12000;
            this.config.breederBabyGrowthTime = 24000;
            this.config.save();
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new PocketVillagersConfigScreen(this.parent));
            }
        }).method_46434(startX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, buttonHeight).method_46431());
        int buttonYPos = startY;
        int buttonX = leftCol + labelWidth;
        buttonYPos += 14;
        buttonYPos += rowHeight * 4 + 8;
        buttonYPos += rowHeight;
        this.requireFuelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.requireFuelSlot ? "Yes" : "No")), button -> {
            if (!this.editable) {
                return;
            }
            this.config.requireFuelSlot = !this.config.requireFuelSlot;
            this.requireFuelButton.method_25355((class_2561)class_2561.method_43470((String)(this.config.requireFuelSlot ? "Yes" : "No")));
        }).method_46434(buttonX, buttonYPos += 14, 40, 18).method_46431();
        this.method_37063((class_364)this.requireFuelButton);
        buttonYPos += rowHeight + 4;
        this.enableEfficiencyButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.enableEfficiency ? "Yes" : "No")), button -> {
            if (!this.editable) {
                return;
            }
            this.config.enableEfficiency = !this.config.enableEfficiency;
            this.enableEfficiencyButton.method_25355((class_2561)class_2561.method_43470((String)(this.config.enableEfficiency ? "Yes" : "No")));
        }).method_46434(buttonX, buttonYPos += 14, 40, 18).method_46431();
        this.method_37063((class_364)this.enableEfficiencyButton);
        buttonYPos += rowHeight;
        this.enableFortuneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.enableFortune ? "Yes" : "No")), button -> {
            if (!this.editable) {
                return;
            }
            this.config.enableFortune = !this.config.enableFortune;
            this.enableFortuneButton.method_25355((class_2561)class_2561.method_43470((String)(this.config.enableFortune ? "Yes" : "No")));
        }).method_46434(buttonX, buttonYPos += rowHeight, 40, 18).method_46431();
        this.method_37063((class_364)this.enableFortuneButton);
        buttonYPos += rowHeight;
        buttonYPos += rowHeight + 4;
        this.enableTerminalTabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.enableTerminalTab ? "Yes" : "No")), button -> {
            if (!this.editable) {
                return;
            }
            this.config.enableTerminalTab = !this.config.enableTerminalTab;
            this.enableTerminalTabButton.method_25355((class_2561)class_2561.method_43470((String)(this.config.enableTerminalTab ? "Yes" : "No")));
        }).method_46434(buttonX, buttonYPos += 14, 40, 18).method_46431();
        this.method_37063((class_364)this.enableTerminalTabButton);
        buttonYPos += rowHeight;
        buttonYPos += rowHeight;
        buttonYPos += rowHeight + 4;
        boolean hologramState = this.editable ? this.config.enableVillagerHolograms : HologramToggle.isHologramEnabled();
        this.enableHologramsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(hologramState ? "Yes" : "No")), button -> {
            if (this.editable) {
                this.config.enableVillagerHolograms = !this.config.enableVillagerHolograms;
                this.enableHologramsButton.method_25355((class_2561)class_2561.method_43470((String)(this.config.enableVillagerHolograms ? "Yes" : "No")));
            } else {
                boolean now = !HologramToggle.isHologramEnabled();
                HologramToggle.setHologramEnabled(now);
                this.enableHologramsButton.method_25355((class_2561)class_2561.method_43470((String)(now ? "Yes" : "No")));
            }
        }).method_46434(buttonX, buttonYPos += 14, 40, 18).method_46431();
        this.method_37063((class_364)this.enableHologramsButton);
        buttonYPos += rowHeight;
        buttonYPos += rowHeight;
        this.repositionEditBoxes();
        if (!this.editable) {
            if (this.miningIntervalBox != null) {
                this.miningIntervalBox.method_1888(false);
            }
            if (this.farmingIntervalBox != null) {
                this.farmingIntervalBox.method_1888(false);
            }
            if (this.fishingIntervalBox != null) {
                this.fishingIntervalBox.method_1888(false);
            }
            if (this.ironFarmIntervalBox != null) {
                this.ironFarmIntervalBox.method_1888(false);
            }
            if (this.converterZombifyTimeBox != null) {
                this.converterZombifyTimeBox.method_1888(false);
            }
            if (this.converterCureTimeBox != null) {
                this.converterCureTimeBox.method_1888(false);
            }
            if (this.fuelDurationTicksBox != null) {
                this.fuelDurationTicksBox.method_1888(false);
            }
            if (this.efficiencySpeedBonusBox != null) {
                this.efficiencySpeedBonusBox.method_1888(false);
            }
            if (this.terminalTabTimeoutBox != null) {
                this.terminalTabTimeoutBox.method_1888(false);
            }
            if (this.terminalMaxRangeBox != null) {
                this.terminalMaxRangeBox.method_1888(false);
            }
            if (this.villagerRenderDistanceBox != null) {
                this.villagerRenderDistanceBox.method_1888(false);
            }
            if (this.breederBreedingCooldownBox != null) {
                this.breederBreedingCooldownBox.method_1888(false);
            }
            if (this.breederBabyGrowthTimeBox != null) {
                this.breederBabyGrowthTimeBox.method_1888(false);
            }
            if (this.saveButton != null) {
                this.saveButton.field_22763 = false;
            }
            for (class_364 w : this.method_25396()) {
                class_4185 b;
                class_2561 msg;
                if (!(w instanceof class_4185) || (msg = (b = (class_4185)w).method_25369()) == null || !msg.getString().equals("Default")) continue;
                b.field_22763 = false;
            }
            if (this.requireFuelButton != null) {
                this.requireFuelButton.field_22763 = false;
            }
            if (this.enableEfficiencyButton != null) {
                this.enableEfficiencyButton.field_22763 = false;
            }
            if (this.enableFortuneButton != null) {
                this.enableFortuneButton.field_22763 = false;
            }
            if (this.enableTerminalTabButton != null) {
                this.enableTerminalTabButton.field_22763 = false;
            }
        }
    }

    private void repositionEditBoxes() {
        int startY = 45 - this.scrollOffset;
        int rowHeight = 20;
        int y = startY;
        y += 14;
        if (this.farmingIntervalBox != null) {
            this.farmingIntervalBox.method_46419(y);
        }
        y += rowHeight;
        if (this.miningIntervalBox != null) {
            this.miningIntervalBox.method_46419(y);
        }
        y += rowHeight;
        if (this.fishingIntervalBox != null) {
            this.fishingIntervalBox.method_46419(y);
        }
        y += rowHeight;
        if (this.ironFarmIntervalBox != null) {
            this.ironFarmIntervalBox.method_46419(y);
        }
        y += rowHeight;
        if (this.converterZombifyTimeBox != null) {
            this.converterZombifyTimeBox.method_46419(y);
        }
        y += rowHeight;
        if (this.converterCureTimeBox != null) {
            this.converterCureTimeBox.method_46419(y);
        }
        y += rowHeight;
        y += 8;
        y += 14;
        y += rowHeight;
        if (this.requireFuelButton != null) {
            this.requireFuelButton.method_46419(y);
        }
        y += rowHeight + 4;
        if (this.fuelDurationTicksBox != null) {
            this.fuelDurationTicksBox.method_46419(y);
        }
        y += rowHeight;
        y += 14;
        if (this.enableEfficiencyButton != null) {
            this.enableEfficiencyButton.method_46419(y);
        }
        y += rowHeight;
        if (this.efficiencySpeedBonusBox != null) {
            this.efficiencySpeedBonusBox.method_46419(y);
        }
        y += rowHeight;
        if (this.enableFortuneButton != null) {
            this.enableFortuneButton.method_46419(y);
        }
        y += rowHeight;
        y += 4;
        y += rowHeight + 4;
        y += 14;
        if (this.enableTerminalTabButton != null) {
            this.enableTerminalTabButton.method_46419(y);
        }
        y += rowHeight;
        if (this.terminalTabTimeoutBox != null) {
            this.terminalTabTimeoutBox.method_46419(y);
        }
        y += rowHeight;
        if (this.terminalMaxRangeBox != null) {
            this.terminalMaxRangeBox.method_46419(y);
        }
        y += rowHeight + 4;
        y += 14;
        if (this.enableHologramsButton != null) {
            this.enableHologramsButton.method_46419(y);
        }
        y += rowHeight;
        if (this.villagerRenderDistanceBox != null) {
            this.villagerRenderDistanceBox.method_46419(y);
        }
        y += rowHeight;
        y += 14;
        if (this.breederBreedingCooldownBox != null) {
            this.breederBreedingCooldownBox.method_46419(y);
        }
        y += rowHeight;
        if (this.breederBabyGrowthTimeBox != null) {
            this.breederBabyGrowthTimeBox.method_46419(y);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollOffset = Math.max(0, Math.min(2000, this.scrollOffset - (int)(scrollY * 10.0)));
        this.repositionEditBoxes();
        return true;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        guiGraphics.method_25300(this.field_22793, "Edit values and click Save (Scroll for more)", this.field_22789 / 2, 22, -7829368);
        int clipTop = 45;
        int clipBottom = this.field_22790 - 60;
        guiGraphics.method_25294(0, clipTop, this.field_22789, clipTop + 1, -11184811);
        guiGraphics.method_25294(0, clipBottom - 1, this.field_22789, clipBottom, -11184811);
        guiGraphics.method_44379(0, clipTop, this.field_22789, clipBottom);
        int leftCol = 20;
        int startY = 50 - this.scrollOffset;
        int rowHeight = 20;
        int y = startY;
        guiGraphics.method_51433(this.field_22793, "Automation Timings:", leftCol, y, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Farming Interval (ticks):", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Mining Interval (ticks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Fishing Interval (ticks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Iron Farm Interval (ticks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Converter Zombify Time (ticks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Converter Cure Time (ticks):", leftCol, y += rowHeight, -3355444, false);
        y += rowHeight;
        guiGraphics.method_51433(this.field_22793, "Fuel:", leftCol, y += rowHeight + 8, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Require Fuel:", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Fuel Duration (ticks):", leftCol, y += rowHeight + 4, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "Enchantments:", leftCol, y += rowHeight, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Efficiency:", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Speed Bonus (% per level):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Fortune:", leftCol, y += rowHeight, -3355444, false);
        y += rowHeight;
        guiGraphics.method_51433(this.field_22793, "Terminal:", leftCol, y += rowHeight + 4, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Enable Tab:", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Tab Timeout (ms):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Max Range (blocks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "Visual:", leftCol, y += rowHeight + 4, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Holograms:", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Hologram Distance (blocks):", leftCol, y += rowHeight, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "Breeder:", leftCol, y += rowHeight, -22016, false);
        guiGraphics.method_51433(this.field_22793, "  Breeding Cooldown (ticks):", leftCol, y += 14, -3355444, false);
        guiGraphics.method_51433(this.field_22793, "  Baby Growth Time (ticks):", leftCol, y += rowHeight, -3355444, false);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_44380();
        for (class_364 widget : this.method_25396()) {
            if (!(widget instanceof class_4185) || !(widget instanceof class_4068)) continue;
            class_4068 renderable = (class_4068)widget;
            if (widget == this.requireFuelButton || widget == this.enableEfficiencyButton || widget == this.enableFortuneButton || widget == this.enableTerminalTabButton || widget == this.enableHologramsButton) continue;
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.statusMessage != null && this.statusTicks > 0) {
            int msgY = this.field_22790 - 55;
            guiGraphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, msgY, this.statusMessage.contains("success") ? -16711936 : -65536);
            --this.statusTicks;
            if (this.statusTicks <= 0) {
                this.statusMessage = null;
            }
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

