/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.mixin.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.accessor.MerchantMenuAccessor;
import net.mcreator.pocketvillagers.accessor.TradeOfferButtonAccessor;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_492;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(targets={"net.minecraft.client.gui.screens.inventory.MerchantScreen$TradeOfferButton"})
public abstract class TradeOfferButtonPressMixin {
    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true, require=0, remap=false)
    private void pocketVillagers$onTradeButtonPress(CallbackInfo ci) {
        try {
            class_1728 menu2;
            int calcIndex;
            class_492 screen;
            block32: {
                TradeOfferButtonPressMixin self = this;
                int localIdx = 0;
                try {
                    localIdx = ((TradeOfferButtonAccessor)((Object)self)).getIndex();
                }
                catch (Throwable t) {
                    try {
                        Field f = self.getClass().getDeclaredField("index");
                        f.setAccessible(true);
                        localIdx = f.getInt(self);
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                }
                Object screenObj = null;
                try {
                    Field outer = self.getClass().getDeclaredField("this$0");
                    outer.setAccessible(true);
                    screenObj = outer.get(self);
                }
                catch (Throwable t) {
                    try {
                        class_310 mc = class_310.method_1551();
                        if (mc != null) {
                            screenObj = mc.field_1755;
                        }
                    }
                    catch (Throwable mc) {
                        // empty catch block
                    }
                }
                if (!(screenObj instanceof class_492)) {
                    return;
                }
                screen = (class_492)screenObj;
                int scrollOff = 0;
                try {
                    Field f = screen.getClass().getDeclaredField("scrollOff");
                    f.setAccessible(true);
                    scrollOff = f.getInt(screen);
                }
                catch (Throwable t) {
                    try {
                        for (Class<?> sc = screen.getClass(); sc != null; sc = sc.getSuperclass()) {
                            try {
                                Field f = sc.getDeclaredField("scrollOff");
                                f.setAccessible(true);
                                scrollOff = f.getInt(screen);
                            }
                            catch (Throwable f) {
                                continue;
                            }
                        }
                    }
                    catch (Throwable sc) {
                        // empty catch block
                    }
                }
                calcIndex = localIdx + scrollOff;
                try {
                    PocketVillagersMod.LOGGER.info("TradeOfferButtonPressMixin: onPress detected localIdx={} scrollOff={} calcIndex={}", (Object)localIdx, (Object)scrollOff, (Object)calcIndex);
                }
                catch (Throwable sc) {
                    // empty catch block
                }
                try {
                    class_1914 offer;
                    menu2 = (class_1728)screen.method_17577();
                    class_1916 offers = menu2.method_17438();
                    if (offers == null || calcIndex < 0 || calcIndex >= offers.size() || !(offer = (class_1914)offers.get(calcIndex)).method_8250().method_31574(class_1802.field_8077)) break block32;
                    try {
                        PocketVillagersMod.LOGGER.info("TradeOfferButtonPressMixin: blocked press - future offer (BARRIER) at calcIndex={}", (Object)calcIndex);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ci.cancel();
                    return;
                }
                catch (Throwable menu2) {
                    // empty catch block
                }
            }
            try {
                menu2 = (class_1728)screen.method_17577();
                try {
                    Method setSelectionHint = menu2.getClass().getMethod("setSelectionHint", Integer.TYPE);
                    setSelectionHint.setAccessible(true);
                    if (menu2 instanceof MerchantMenuAccessor) {
                        MerchantMenuAccessor acc = (MerchantMenuAccessor)menu2;
                        acc.pocketVillagers$setAllowSelectionHint(true);
                    }
                    setSelectionHint.invoke((Object)menu2, calcIndex);
                    PocketVillagersMod.LOGGER.info("TradeOfferButtonPressMixin: manually set selection to calcIndex={}", (Object)calcIndex);
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("TradeOfferButtonPressMixin: failed to set selection: {}", (Object)t.getMessage());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                PocketVillagersMod.LOGGER.info("TradeOfferButtonPressMixin: trade allowed, letting vanilla execute calcIndex={}", (Object)calcIndex);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performClientTrade(class_492 screen, int tradeIndex) {
        try {
            class_1728 menu = (class_1728)screen.method_17577();
            class_1916 offers = menu.method_17438();
            if (offers == null || tradeIndex < 0 || tradeIndex >= offers.size()) {
                return;
            }
            class_1914 recipe = (class_1914)offers.get(tradeIndex);
            int safeguard = 0;
            if (!this.inputSlotsAreEmpty((class_1703)menu)) return;
            if (!this.hasEnoughItemsInInventory((class_1703)menu, recipe) || !this.canReceiveOutput((class_1703)menu, recipe)) return;
            this.transact((class_1703)menu, recipe);
            if (++safeguard <= 50) return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean inputSlotsAreEmpty(class_1703 menu) {
        try {
            return menu.method_7611(0).method_7677().method_7960() && menu.method_7611(1).method_7677().method_7960() && menu.method_7611(2).method_7677().method_7960();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean hasEnoughItemsInInventory(class_1703 menu, Object recipe) {
        try {
            class_1799 first = this.getOfferItem(recipe, "getDisplayedFirstBuyItem", "getFirstBuyItem", "getFirstBuyItemStack", "getBuyItem");
            class_1799 second = this.getOfferItem(recipe, "getDisplayedSecondBuyItem", "getSecondBuyItem", "getSecondBuyItemStack", "getSecondBuyItem");
            if (first != null && !first.method_7960() && !this.hasEnoughItemsInInventory(first)) {
                return false;
            }
            return second == null || second.method_7960() || this.hasEnoughItemsInInventory(second);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean hasEnoughItemsInInventory(class_1799 stack) {
        try {
            int remaining = stack.method_7947();
            class_1703 menu = class_310.method_1551().field_1724.field_7512;
            for (int i = menu.field_7761.size() - 36; i < menu.field_7761.size(); ++i) {
                class_1799 invstack = menu.method_7611(i).method_7677();
                if (invstack == null) continue;
                if (this.areItemStacksMergable(stack, invstack)) {
                    remaining -= invstack.method_7947();
                }
                if (remaining > 0) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean canReceiveOutput(class_1703 menu, Object recipe) {
        try {
            class_1799 stack = this.getOfferItem(recipe, "getSellItem", "getResult", "getResultItem", "getSellItemStack");
            if (stack == null || stack.method_7960()) {
                return true;
            }
            int remaining = stack.method_7947();
            for (int i = menu.field_7761.size() - 36; i < menu.field_7761.size(); ++i) {
                class_1799 invstack = menu.method_7611(i).method_7677();
                if (invstack == null || invstack.method_7960()) {
                    return true;
                }
                if (this.areItemStacksMergable(stack, invstack) && stack.method_7914() >= stack.method_7947() + invstack.method_7947()) {
                    remaining -= invstack.method_7914() - invstack.method_7947();
                }
                if (remaining > 0) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void transact(class_1703 menu, Object recipe) {
        try {
            class_1799 first = this.getOfferItem(recipe, "getDisplayedFirstBuyItem", "getFirstBuyItem", "getFirstBuyItemStack", "getBuyItem");
            class_1799 second = this.getOfferItem(recipe, "getDisplayedSecondBuyItem", "getSecondBuyItem", "getSecondBuyItemStack", "getSecondBuyItem");
            class_1799 result = this.getOfferItem(recipe, "getSellItem", "getResult", "getResultItem", "getSellItemStack");
            int putback0 = this.fillSlot(menu, 0, first == null ? class_1799.field_8037 : first);
            int putback1 = this.fillSlot(menu, 1, second == null ? class_1799.field_8037 : second);
            this.getslot(menu, 2, result == null ? class_1799.field_8037 : result, putback0, putback1);
            if (putback0 != -1) {
                this.slotClick(menu, 0);
                this.slotClick(menu, putback0);
            }
            if (putback1 != -1) {
                this.slotClick(menu, 1);
                this.slotClick(menu, putback1);
            }
            try {
                this.onMouseClickHack(menu, 0, 99, "SWAP");
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int fillSlot(class_1703 menu, int slot, class_1799 stack) {
        try {
            int remaining = stack.method_7947();
            for (int i = menu.field_7761.size() - 36; i < menu.field_7761.size(); ++i) {
                class_1799 invstack = menu.method_7611(i).method_7677();
                if (invstack == null) continue;
                boolean needPutBack = false;
                if (this.areItemStacksMergable(stack, invstack)) {
                    if (stack.method_7947() + invstack.method_7947() > stack.method_7914()) {
                        needPutBack = true;
                    }
                    remaining -= invstack.method_7947();
                    this.slotClick(menu, i);
                    this.slotClick(menu, slot);
                }
                if (needPutBack) {
                    this.slotClick(menu, i);
                }
                if (remaining > 0) continue;
                return remaining < 0 ? i : -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    private boolean areItemStacksMergable(class_1799 a, class_1799 b) {
        if (a == null || b == null) {
            return false;
        }
        try {
            String[] tryMethods;
            if (a.method_7909() != b.method_7909()) {
                return false;
            }
            Object at = null;
            Object bt = null;
            for (String mname : tryMethods = new String[]{"getTag", "getNbt", "getOrCreateTag", "save", "toTag"}) {
                try {
                    Method ma = a.getClass().getMethod(mname, new Class[0]);
                    at = ma.invoke((Object)a, new Object[0]);
                }
                catch (Throwable ma) {
                    // empty catch block
                }
                try {
                    Method mb = b.getClass().getMethod(mname, new Class[0]);
                    bt = mb.invoke((Object)b, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (at != null || bt != null) break;
            }
            if (at == null && bt == null) {
                return true;
            }
            return at != null && at.equals(bt);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void getslot(class_1703 menu, int slot, class_1799 stack, int ... forbidden) {
        try {
            int i;
            int remaining = stack.method_7947();
            this.slotClick(menu, slot);
            for (i = menu.field_7761.size() - 36; i < menu.field_7761.size(); ++i) {
                class_1799 invstack = menu.method_7611(i).method_7677();
                if (invstack == null || invstack.method_7960()) continue;
                if (this.areItemStacksMergable(stack, invstack) && invstack.method_7947() < invstack.method_7914()) {
                    remaining -= invstack.method_7914() - invstack.method_7947();
                    this.slotClick(menu, i);
                }
                if (remaining > 0) continue;
                return;
            }
            for (i = menu.field_7761.size() - 36; i < menu.field_7761.size(); ++i) {
                class_1799 invstack;
                boolean isForbidden = false;
                for (int f : forbidden) {
                    if (i != f) continue;
                    isForbidden = true;
                }
                if (isForbidden || (invstack = menu.method_7611(i).method_7677()) != null && !invstack.method_7960()) continue;
                this.slotClick(menu, i);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class_1799 getOfferItem(Object recipe, String ... candidateNames) {
        Object res;
        Method m2;
        if (recipe == null) {
            return class_1799.field_8037;
        }
        for (String name : candidateNames) {
            try {
                m2 = recipe.getClass().getMethod(name, new Class[0]);
                if (m2 == null || !((res = m2.invoke(recipe, new Object[0])) instanceof class_1799)) continue;
                return (class_1799)res;
            }
            catch (Throwable m2) {
                // empty catch block
            }
        }
        for (String name : candidateNames) {
            try {
                Optional opt;
                m2 = recipe.getClass().getMethod(name, new Class[0]);
                if (m2 == null || !((res = m2.invoke(recipe, new Object[0])) instanceof Optional) || !(opt = (Optional)res).isPresent() || !(opt.get() instanceof class_1799)) continue;
                return (class_1799)opt.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return class_1799.field_8037;
    }

    private void slotClick(class_1703 menu, int slot) {
        try {
            this.onMouseClickHack(menu, slot, 0, "PICKUP");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void onMouseClickHack(class_1703 menu, int slot, int clickData, Object action) {
        try {
            Method[] methods;
            class_437 screen = class_310.method_1551().field_1755;
            if (screen == null) {
                return;
            }
            for (Method m : methods = screen.getClass().getMethods()) {
                Class<?> lastParam;
                Class<?>[] params;
                if (!m.getName().equals("onMouseClick") || (params = m.getParameterTypes()).length < 3 || !(lastParam = params[params.length - 1]).isEnum()) continue;
                try {
                    Object enumValue = null;
                    if (action != null && lastParam.isInstance(action)) {
                        enumValue = action;
                    } else {
                        String name = action == null ? "PICKUP" : action.toString();
                        Class<?> enumClass = lastParam;
                        enumValue = Enum.valueOf(enumClass, name);
                    }
                    Object[] args = new Object[params.length];
                    if (params.length == 4) {
                        args[0] = null;
                        args[1] = slot;
                        args[2] = clickData;
                        args[3] = enumValue;
                    } else if (params.length == 3) {
                        args[0] = slot;
                        args[1] = clickData;
                        args[2] = enumValue;
                    } else {
                        int offset = params.length - 3;
                        args[offset] = slot;
                        args[offset + 1] = clickData;
                        args[offset + 2] = enumValue;
                    }
                    m.setAccessible(true);
                    m.invoke((Object)screen, args);
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            PocketVillagersMod.LOGGER.info("pv: TradeOfferButtonPressMixin class loaded");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

