/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.AutoTraderPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.PocketTerminalBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.network.OpenStorageFromTerminalPayload;
import net.mcreator.pocketvillagers.network.RequestStorageContentsPayload;
import net.mcreator.pocketvillagers.network.StoreVillagerToStoragePayload;
import net.mcreator.pocketvillagers.network.SyncNearbyCubesPayload;
import net.mcreator.pocketvillagers.network.SyncStorageContentsPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerPayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class PocketTerminalPacketHandlers {
    public static void registerServerHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestStorageContentsPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 storagePos = payload.storagePos();
            context.server().execute(() -> PocketTerminalPacketHandlers.handleStorageContentsRequest(player, storagePos));
        });
        ServerPlayNetworking.registerGlobalReceiver(TransferVillagerPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> PocketTerminalPacketHandlers.handleVillagerTransfer(player, payload.fromPos(), payload.slotIndex(), payload.toPos(), payload.spawn()));
        });
        ServerPlayNetworking.registerGlobalReceiver(OpenStorageFromTerminalPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> PocketTerminalPacketHandlers.handleOpenStorageFromTerminal(player, payload.storagePos(), payload.terminalPos()));
        });
        ServerPlayNetworking.registerGlobalReceiver(StoreVillagerToStoragePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            context.server().execute(() -> PocketTerminalPacketHandlers.handleStoreVillagerToStorage(player, payload.activeCubePos(), payload.storagePos(), payload.slotIndex()));
        });
    }

    private static void handleStorageContentsRequest(class_3222 player, class_2338 storagePos) {
        class_3218 serverLevel = player.method_51469();
        class_2586 be = serverLevel.method_8321(storagePos);
        if (!(be instanceof StoragePocketCubeBlockEntity)) {
            PocketVillagersMod.LOGGER.warn("Player {} requested contents of non-storage block at {}", (Object)player.method_5477().getString(), (Object)storagePos);
            return;
        }
        StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)be;
        if (!PocketTerminalPacketHandlers.hasNearbyPoweredTerminal(player, serverLevel)) {
            PocketVillagersMod.LOGGER.warn("Player {} tried to access storage without powered terminal", (Object)player.method_5477().getString());
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cPocket Terminal requires fuel (Emerald)!"));
            return;
        }
        ArrayList<SyncStorageContentsPayload.VillagerSlotData> slotData = new ArrayList<SyncStorageContentsPayload.VillagerSlotData>();
        int maxSlots = storage.getMaxVillagers();
        for (int i = 0; i < maxSlots; ++i) {
            class_2487 villagerNBT = storage.getVillager(i);
            if (villagerNBT == null || villagerNBT.method_33133()) {
                slotData.add(new SyncStorageContentsPayload.VillagerSlotData(i, true, "", "", 0, 0, 0, null));
                continue;
            }
            String profession = villagerNBT.method_10558("VillagerData.profession").orElse("minecraft:none");
            int villagerLevel = villagerNBT.method_10550("VillagerData.level").orElse(1);
            int xp = villagerNBT.method_10550("Xp").orElse(0);
            int conversions = villagerNBT.method_10550("PocketVillagers.Conversions").orElse(0);
            Object professionName = profession.replace("minecraft:", "");
            professionName = ((String)professionName).substring(0, 1).toUpperCase() + ((String)professionName).substring(1);
            String displayName = (String)professionName + " (Lv" + villagerLevel + ")";
            slotData.add(new SyncStorageContentsPayload.VillagerSlotData(i, false, profession, displayName, villagerLevel, xp, conversions, villagerNBT.method_10553()));
        }
        SyncStorageContentsPayload.sendToPlayer(player, storagePos, slotData);
        PocketVillagersMod.LOGGER.debug("Sent storage contents to {}: {} villagers at {}", (Object)player.method_5477().getString(), (Object)storage.getVillagerCount(), (Object)storagePos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handleVillagerTransfer(class_3222 player, class_2338 fromPos, int slotIndex, class_2338 toPos, boolean spawn) {
        BreederPocketCubeBlockEntity breederCube;
        class_3218 serverLevel = player.method_51469();
        if (!PocketTerminalPacketHandlers.hasNearbyPoweredTerminal(player, serverLevel)) {
            PocketVillagersMod.LOGGER.warn("Player {} tried to transfer without powered terminal", (Object)player.method_5477().getString());
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cPocket Terminal requires fuel (Emerald)!"));
            return;
        }
        class_2586 fromBE = serverLevel.method_8321(fromPos);
        class_2487 villagerNBT = null;
        if (fromBE instanceof StoragePocketCubeBlockEntity) {
            StoragePocketCubeBlockEntity fromStorage = (StoragePocketCubeBlockEntity)fromBE;
            villagerNBT = fromStorage.removeVillager(slotIndex);
            if (villagerNBT == null || villagerNBT.method_33133()) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: no villager at slot {} in storage {}", (Object)slotIndex, (Object)fromPos);
                return;
            }
        } else if (fromBE instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarmCube = (IronFarmPocketCubeBlockEntity)fromBE;
            villagerNBT = ironFarmCube.getVillagerData(slotIndex);
            PocketVillagersMod.LOGGER.debug("Transfer from Iron Farm cube slot {}: villagerData empty={}", (Object)slotIndex, (Object)(villagerNBT == null || villagerNBT.method_33133() ? 1 : 0));
            if (villagerNBT == null || villagerNBT.method_33133()) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: no villager data in Iron Farm cube slot {} at {}", (Object)slotIndex, (Object)fromPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager data found in Iron Farm cube slot!"));
                return;
            }
            ironFarmCube.setVillagerData(slotIndex, new class_2487());
            ironFarmCube.method_5431();
            serverLevel.method_8413(fromPos, ironFarmCube.method_11010(), ironFarmCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Removed villager from Iron Farm cube slot {} at {}", (Object)slotIndex, (Object)fromPos);
        } else if (fromBE instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converterCube = (ConverterPocketCubeBlockEntity)fromBE;
            PocketVillagersMod.LOGGER.debug("[DEBUG] Transfer handler: Handling converter cube transfer from {}", (Object)fromPos);
            villagerNBT = converterCube.getVillagerData();
            PocketVillagersMod.LOGGER.debug("Transfer from Converter cube: villagerData empty={}", (Object)(villagerNBT == null || villagerNBT.method_33133() ? 1 : 0));
            if (villagerNBT == null || villagerNBT.method_33133()) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: no villager data in Converter cube at {}", (Object)fromPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager data found in Converter cube!"));
                return;
            }
            PocketVillagersMod.LOGGER.debug("[DEBUG] Transfer handler: Clearing villager data from converter cube");
            converterCube.setVillagerData(new class_2487());
            converterCube.method_5431();
            serverLevel.method_8413(fromPos, converterCube.method_11010(), converterCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Removed villager from Converter cube at {}", (Object)fromPos);
        } else if (fromBE instanceof BreederPocketCubeBlockEntity) {
            breederCube = (BreederPocketCubeBlockEntity)fromBE;
            villagerNBT = breederCube.getVillagerData(slotIndex);
            PocketVillagersMod.LOGGER.debug("Transfer from Breeder cube slot {}: villagerData empty={}", (Object)slotIndex, (Object)(villagerNBT == null || villagerNBT.method_33133() ? 1 : 0));
            if (villagerNBT == null || villagerNBT.method_33133()) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: no villager data in Breeder cube slot {} at {}", (Object)slotIndex, (Object)fromPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager data found in Breeder cube slot!"));
                return;
            }
            breederCube.setVillagerData(slotIndex, new class_2487());
            breederCube.method_5431();
            serverLevel.method_8413(fromPos, breederCube.method_11010(), breederCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Removed villager from Breeder cube slot {} at {}", (Object)slotIndex, (Object)fromPos);
        } else {
            class_1799 workstation;
            if (!(fromBE instanceof PocketCubeBlockEntity)) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: source at {} is not a valid cube", (Object)fromPos);
                return;
            }
            PocketCubeBlockEntity activeCube = (PocketCubeBlockEntity)fromBE;
            villagerNBT = activeCube.getVillagerData();
            PocketVillagersMod.LOGGER.debug("Transfer from active cube: villagerData empty={}, hasVillager={}", (Object)villagerNBT.method_33133(), (Object)activeCube.hasVillager());
            if (villagerNBT == null || villagerNBT.method_33133()) {
                PocketVillagersMod.LOGGER.warn("Transfer failed: no villager data in active cube at {}", (Object)fromPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager data found in cube!"));
                return;
            }
            if (activeCube.hasWorkstation() && !(workstation = activeCube.getWorkstation()).method_7960()) {
                class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)fromPos.method_10263() + 0.5, (double)fromPos.method_10264() + 1.0, (double)fromPos.method_10260() + 0.5, workstation.method_7972());
                serverLevel.method_8649((class_1297)itemEntity);
                PocketVillagersMod.LOGGER.debug("Dropped workstation {} from cube at {}", (Object)workstation.method_7909(), (Object)fromPos);
                activeCube.setWorkstation(class_1799.field_8037);
            }
            activeCube.setVillagerData(new class_2487());
            activeCube.method_5431();
            serverLevel.method_8413(fromPos, activeCube.method_11010(), activeCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Removed villager from active cube at {}", (Object)fromPos);
        }
        if (spawn) {
            VillagerDataHandler.spawnVillagerFromData((class_1937)serverLevel, toPos, villagerNBT, (class_1657)player);
            PocketVillagersMod.LOGGER.debug("Spawned villager from storage {} slot {} at {}", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager summoned from storage"));
            return;
        }
        class_2586 toBE = serverLevel.method_8321(toPos);
        if (!PocketTerminalPacketHandlers.canTransferToCube(villagerNBT, toBE, player)) {
            PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
            PocketVillagersMod.LOGGER.warn("Transfer validation failed: villager from {} slot {} cannot be transferred to {} at {}", (Object)fromPos, (Object)slotIndex, (Object)toBE.getClass().getSimpleName(), (Object)toPos);
            return;
        }
        if (toBE instanceof StoragePocketCubeBlockEntity) {
            StoragePocketCubeBlockEntity toStorage = (StoragePocketCubeBlockEntity)toBE;
            if (toStorage.isFull()) {
                PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
                PocketVillagersMod.LOGGER.warn("Transfer failed: destination storage at {} is full", (Object)toPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cDestination storage is full!"));
                return;
            }
            toStorage.addVillager(villagerNBT);
            PocketVillagersMod.LOGGER.debug("Transferred villager from {} slot {} to storage {}", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to storage"));
            PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
            return;
        }
        if (toBE instanceof BreederPocketCubeBlockEntity) {
            breederCube = (BreederPocketCubeBlockEntity)toBE;
            class_2487 v1 = breederCube.getVillagerData(1);
            class_2487 v2 = breederCube.getVillagerData(2);
            if (v1 == null || v1.method_33133()) {
                breederCube.setVillagerData(1, villagerNBT.method_10553());
                breederCube.method_5431();
                serverLevel.method_8413(toPos, breederCube.method_11010(), breederCube.method_11010(), 3);
                PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Breeder cube {} slot 1", (Object)fromPos, (Object)slotIndex, (Object)toPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Breeder Cube (Slot 1)"));
                PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
                return;
            }
            if (v2 != null && !v2.method_33133()) {
                PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cBreeder cube is full!"));
                return;
            }
            breederCube.setVillagerData(2, villagerNBT.method_10553());
            breederCube.method_5431();
            serverLevel.method_8413(toPos, breederCube.method_11010(), breederCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Breeder cube {} slot 2", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Breeder Cube (Slot 2)"));
            PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
            return;
        }
        if (toBE instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarmCube = (IronFarmPocketCubeBlockEntity)toBE;
            class_2487 v1 = ironFarmCube.getVillagerData(1);
            class_2487 v2 = ironFarmCube.getVillagerData(2);
            class_2487 v3 = ironFarmCube.getVillagerData(3);
            if (v1 == null || v1.method_33133()) {
                class_2487 capturedVillagerNBT = villagerNBT.method_10553();
                capturedVillagerNBT.method_10556("PocketVillagers.Captured", true);
                ironFarmCube.setVillagerData(1, capturedVillagerNBT);
                ironFarmCube.method_5431();
                serverLevel.method_8413(toPos, ironFarmCube.method_11010(), ironFarmCube.method_11010(), 3);
                PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Iron Farm cube {} slot 1 (marked as captured)", (Object)fromPos, (Object)slotIndex, (Object)toPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Iron Farm Cube (Slot 1)"));
                PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
                return;
            }
            if (v2 == null || v2.method_33133()) {
                class_2487 capturedVillagerNBT = villagerNBT.method_10553();
                capturedVillagerNBT.method_10556("PocketVillagers.Captured", true);
                ironFarmCube.setVillagerData(2, capturedVillagerNBT);
                ironFarmCube.method_5431();
                serverLevel.method_8413(toPos, ironFarmCube.method_11010(), ironFarmCube.method_11010(), 3);
                PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Iron Farm cube {} slot 2 (marked as captured)", (Object)fromPos, (Object)slotIndex, (Object)toPos);
                player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Iron Farm Cube (Slot 2)"));
                PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
                return;
            }
            if (v3 != null && !v3.method_33133()) {
                PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cIron Farm cube is full!"));
                return;
            }
            class_2487 capturedVillagerNBT = villagerNBT.method_10553();
            capturedVillagerNBT.method_10556("PocketVillagers.Captured", true);
            ironFarmCube.setVillagerData(3, capturedVillagerNBT);
            ironFarmCube.method_5431();
            serverLevel.method_8413(toPos, ironFarmCube.method_11010(), ironFarmCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Iron Farm cube {} slot 3 (marked as captured)", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Iron Farm Cube (Slot 3)"));
            PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
            return;
        }
        if (toBE instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converterCube = (ConverterPocketCubeBlockEntity)toBE;
            class_2487 existingVillager = converterCube.getVillagerData();
            if (existingVillager != null && !existingVillager.method_33133()) {
                PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cConverter cube already has a villager!"));
                return;
            }
            converterCube.setVillagerData(villagerNBT.method_10553());
            converterCube.method_5431();
            serverLevel.method_8413(toPos, converterCube.method_11010(), converterCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to Converter cube {}", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to Converter Cube"));
            PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
            return;
        }
        if (!(toBE instanceof PocketCubeBlockEntity)) {
            PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
            PocketVillagersMod.LOGGER.warn("Transfer failed: destination at {} is not a valid cube", (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cInvalid destination!"));
            return;
        }
        PocketCubeBlockEntity toCube = (PocketCubeBlockEntity)toBE;
        try {
            Field hasVillagerField = PocketCubeBlockEntity.class.getDeclaredField("hasVillager");
            hasVillagerField.setAccessible(true);
            boolean hasVillager = hasVillagerField.getBoolean((Object)toCube);
            if (hasVillager) {
                PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cTarget cube already has a villager!"));
                return;
            }
            Field villagerDataField = PocketCubeBlockEntity.class.getDeclaredField("villagerData");
            villagerDataField.setAccessible(true);
            villagerDataField.set((Object)toCube, villagerNBT.method_10553());
            hasVillagerField.setBoolean((Object)toCube, true);
            toCube.method_5431();
            serverLevel.method_8413(toPos, toCube.method_11010(), toCube.method_11010(), 3);
            PocketVillagersMod.LOGGER.debug("Transferred villager from storage {} slot {} to active cube {}", (Object)fromPos, (Object)slotIndex, (Object)toPos);
            player.method_64398((class_2561)class_2561.method_43470((String)"Villager transferred to cube"));
            PocketTerminalPacketHandlers.syncTerminalData(player, serverLevel);
            return;
        }
        catch (Exception e) {
            PocketTerminalPacketHandlers.putVillagerBack(fromBE, slotIndex, villagerNBT);
            PocketVillagersMod.LOGGER.error("Transfer failed due to reflection error", (Throwable)e);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cTransfer failed!"));
            return;
        }
    }

    private static boolean canTransferToCube(class_2487 villagerNBT, class_2586 targetBE, class_3222 player) {
        boolean hasJob;
        String profession = villagerNBT.method_10558("VillagerData.profession").orElse("minecraft:none");
        boolean isUnemployed = profession.equals("minecraft:none");
        boolean bl = hasJob = !isUnemployed;
        if (targetBE instanceof StoragePocketCubeBlockEntity) {
            return true;
        }
        if (!(!(targetBE instanceof PocketCubeBlockEntity) || targetBE instanceof MiningPocketCubeBlockEntity || targetBE instanceof FishingPocketCubeBlockEntity || targetBE instanceof FarmingPocketCubeBlockEntity || targetBE instanceof AutoTraderPocketCubeBlockEntity)) {
            return true;
        }
        if (targetBE instanceof MiningPocketCubeBlockEntity) {
            if (!profession.equals("minecraft:armorer")) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cMining Cube only accepts Armorers!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof FishingPocketCubeBlockEntity) {
            if (!profession.equals("minecraft:fisherman")) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cFishing Cube only accepts Fishermen!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof FarmingPocketCubeBlockEntity) {
            if (!profession.equals("minecraft:farmer")) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cFarming Cube only accepts Farmers!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof IronFarmPocketCubeBlockEntity) {
            if (!isUnemployed) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cIron Farm Cube only accepts Unemployed villagers!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof BreederPocketCubeBlockEntity) {
            if (!isUnemployed) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cBreeder Cube only accepts Unemployed villagers!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof AutoTraderPocketCubeBlockEntity) {
            if (!hasJob) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cAuto Trader Cube only accepts villagers with professions!"));
                return false;
            }
            return true;
        }
        if (targetBE instanceof ConverterPocketCubeBlockEntity) {
            int conversions = villagerNBT.method_10550("PocketVillagers.Conversions").orElse(0);
            PocketVillagersMod.LOGGER.debug("Converter transfer validation: villager has {} conversions", (Object)conversions);
            if (conversions > 0) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cConverter Cube only accepts unconverted villagers!"));
                return false;
            }
            return true;
        }
        return true;
    }

    private static void putVillagerBack(class_2586 sourceBE, int slotIndex, class_2487 villagerNBT) {
        if (sourceBE instanceof StoragePocketCubeBlockEntity) {
            StoragePocketCubeBlockEntity storageCube = (StoragePocketCubeBlockEntity)sourceBE;
            storageCube.addVillager(villagerNBT);
        } else if (sourceBE instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarmCube = (IronFarmPocketCubeBlockEntity)sourceBE;
            ironFarmCube.setVillagerData(slotIndex, villagerNBT);
            ironFarmCube.method_5431();
        } else if (sourceBE instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converterCube = (ConverterPocketCubeBlockEntity)sourceBE;
            converterCube.setVillagerData(villagerNBT);
            converterCube.method_5431();
        } else if (sourceBE instanceof BreederPocketCubeBlockEntity) {
            BreederPocketCubeBlockEntity breederCube = (BreederPocketCubeBlockEntity)sourceBE;
            breederCube.setVillagerData(slotIndex, villagerNBT);
            breederCube.method_5431();
        } else if (sourceBE instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity activeCube = (PocketCubeBlockEntity)sourceBE;
            activeCube.setVillagerData(villagerNBT);
            activeCube.method_5431();
        }
    }

    private static boolean hasNearbyPoweredTerminal(class_3222 player, class_3218 level) {
        PocketVillagersConfig cfg = PocketVillagersConfig.getInstance();
        class_2338 playerPos = player.method_24515();
        int radius = Math.max(0, cfg.terminalMaxRange);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    PocketTerminalBlockEntity terminal;
                    class_2338 checkPos = playerPos.method_10069(x, y, z);
                    class_2586 be = level.method_8321(checkPos);
                    if (!(be instanceof PocketTerminalBlockEntity) || !(terminal = (PocketTerminalBlockEntity)be).isPowered() && cfg.isRequireFuelSlot()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void syncTerminalData(class_3222 player, class_3218 level) {
        PocketTerminalBlockEntity terminal = PocketTerminalPacketHandlers.findNearbyPoweredTerminal(player, level);
        if (terminal == null) {
            PocketVillagersMod.LOGGER.warn("Could not find powered terminal for sync after transfer");
            return;
        }
        List<SyncNearbyCubesPayload.CubeInfo> cubes = terminal.scanNearbyCubes();
        SyncNearbyCubesPayload.sendToPlayer(player, cubes);
        List<SyncTerminalVillagersPayload.CubeVillagerData> villagers = terminal.scanCubeVillagers();
        SyncTerminalVillagersPayload.sendToPlayer(player, villagers);
        PocketVillagersMod.LOGGER.debug("Synced terminal data to player {} after transfer", (Object)player.method_5477().getString());
    }

    private static PocketTerminalBlockEntity findNearbyPoweredTerminal(class_3222 player, class_3218 level) {
        PocketVillagersConfig cfg = PocketVillagersConfig.getInstance();
        class_2338 playerPos = player.method_24515();
        int radius = Math.max(0, cfg.terminalMaxRange);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    PocketTerminalBlockEntity terminal;
                    class_2338 checkPos = playerPos.method_10069(x, y, z);
                    class_2586 be = level.method_8321(checkPos);
                    if (!(be instanceof PocketTerminalBlockEntity) || !(terminal = (PocketTerminalBlockEntity)be).isPowered() && cfg.isRequireFuelSlot()) continue;
                    return terminal;
                }
            }
        }
        return null;
    }

    private static void handleOpenStorageFromTerminal(class_3222 player, class_2338 storagePos, class_2338 terminalPos) {
        class_3218 level = player.method_51469();
        class_2586 terminalBE = level.method_8321(terminalPos);
        if (!(terminalBE instanceof PocketTerminalBlockEntity)) {
            PocketVillagersMod.LOGGER.warn("Player {} tried to open storage from non-terminal at {}", (Object)player.method_5477().getString(), (Object)terminalPos);
            return;
        }
        PocketTerminalBlockEntity terminal = (PocketTerminalBlockEntity)terminalBE;
        if (!terminal.isPowered() && PocketVillagersConfig.getInstance().isRequireFuelSlot()) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cPocket Terminal requires fuel (Emerald)!"));
            return;
        }
        class_2586 storageBE = level.method_8321(storagePos);
        if (!(storageBE instanceof StoragePocketCubeBlockEntity)) {
            PocketVillagersMod.LOGGER.warn("Player {} tried to open non-storage at {}", (Object)player.method_5477().getString(), (Object)storagePos);
            return;
        }
        StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)storageBE;
        List<class_2338> nearbyCubes = PocketTerminalPacketHandlers.scanForNearbyCubes(level, terminalPos);
        player.method_17355((class_3908)storage);
        PocketVillagersMod.LOGGER.debug("Player {} opened storage at {} from terminal at {} (found {} nearby cubes)", (Object)player.method_5477().getString(), (Object)storagePos, (Object)terminalPos, (Object)nearbyCubes.size());
    }

    private static List<class_2338> scanForNearbyCubes(class_3218 level, class_2338 center) {
        ArrayList<class_2338> cubes = new ArrayList<class_2338>();
        int radius = Math.max(0, PocketVillagersConfig.getInstance().terminalMaxRange);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 checkPos = center.method_10069(x, y, z);
                    class_2586 be = level.method_8321(checkPos);
                    if (!(be instanceof PocketCubeBlockEntity) && !(be instanceof BreederPocketCubeBlockEntity) && !(be instanceof ConverterPocketCubeBlockEntity) && !(be instanceof AutoTraderPocketCubeBlockEntity) && !(be instanceof IronFarmPocketCubeBlockEntity) && !(be instanceof StoragePocketCubeBlockEntity) && !(be instanceof FarmingPocketCubeBlockEntity) && !(be instanceof MiningPocketCubeBlockEntity) && !(be instanceof FishingPocketCubeBlockEntity)) continue;
                    cubes.add(checkPos);
                }
            }
        }
        return cubes;
    }

    private static void handleStoreVillagerToStorage(class_3222 player, class_2338 activeCubePos, class_2338 preferredStoragePos, int slotIndex) {
        boolean isValidActiveCube;
        PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Called for cube at {} slot {}", (Object)activeCubePos, (Object)slotIndex);
        class_3218 level = player.method_51469();
        if (!PocketTerminalPacketHandlers.hasNearbyPoweredTerminal(player, level)) {
            PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] No powered terminal found");
            PocketVillagersMod.LOGGER.warn("Player {} tried to store without powered terminal", (Object)player.method_5477().getString());
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cPocket Terminal requires fuel (Emerald)!"));
            return;
        }
        class_2586 activeBE = level.method_8321(activeCubePos);
        PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Active BE type: {}", (Object)(activeBE != null ? activeBE.getClass().getSimpleName() : "null"));
        boolean bl = isValidActiveCube = activeBE instanceof BreederPocketCubeBlockEntity || activeBE instanceof ConverterPocketCubeBlockEntity || activeBE instanceof AutoTraderPocketCubeBlockEntity || activeBE instanceof FarmingPocketCubeBlockEntity || activeBE instanceof MiningPocketCubeBlockEntity || activeBE instanceof FishingPocketCubeBlockEntity || activeBE instanceof IronFarmPocketCubeBlockEntity || activeBE instanceof PocketCubeBlockEntity;
        if (!isValidActiveCube) {
            PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Not a valid active cube type");
            PocketVillagersMod.LOGGER.warn("Store failed: source at {} is not an active cube", (Object)activeCubePos);
            return;
        }
        class_2487 villagerNBT = null;
        if (activeBE instanceof BreederPocketCubeBlockEntity) {
            BreederPocketCubeBlockEntity breeder = (BreederPocketCubeBlockEntity)activeBE;
            PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Handling Breeder cube, extracting villager {}", (Object)slotIndex);
            villagerNBT = breeder.getVillagerData(slotIndex);
            if (villagerNBT == null || villagerNBT.method_33133()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager in that slot!"));
                return;
            }
            villagerNBT = villagerNBT.method_10553();
            breeder.setVillagerData(slotIndex, new class_2487());
            breeder.method_5431();
        } else if (activeBE instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarm = (IronFarmPocketCubeBlockEntity)activeBE;
            PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Handling Iron Farm cube, extracting villager {}", (Object)slotIndex);
            villagerNBT = ironFarm.getVillagerData(slotIndex);
            if (villagerNBT == null || villagerNBT.method_33133()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager in that slot!"));
                return;
            }
            villagerNBT = villagerNBT.method_10553();
            ironFarm.setVillagerData(slotIndex, new class_2487());
            ironFarm.method_5431();
        } else if (activeBE instanceof ConverterPocketCubeBlockEntity) {
            ConverterPocketCubeBlockEntity converter = (ConverterPocketCubeBlockEntity)activeBE;
            PocketVillagersMod.LOGGER.debug("[STORE VILLAGER] Handling Converter cube");
            villagerNBT = converter.getVillagerData();
            if (villagerNBT == null || villagerNBT.method_33133()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo villager in this cube!"));
                return;
            }
            villagerNBT = villagerNBT.method_10553();
            try {
                Field villagerDataField = ((Object)((Object)converter)).getClass().getDeclaredField("villagerData");
                villagerDataField.setAccessible(true);
                villagerDataField.set((Object)converter, new class_2487());
                Field hasVillagerField = ((Object)((Object)converter)).getClass().getDeclaredField("hasVillager");
                hasVillagerField.setAccessible(true);
                hasVillagerField.setBoolean((Object)converter, false);
                converter.method_5431();
            }
            catch (Exception e) {
                PocketVillagersMod.LOGGER.error("Failed to clear converter villager", (Throwable)e);
            }
        } else {
            try {
                Field hasVillagerField = activeBE.getClass().getDeclaredField("hasVillager");
                hasVillagerField.setAccessible(true);
                boolean hasVillager = hasVillagerField.getBoolean(activeBE);
                if (!hasVillager) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cCube has no villager to store!"));
                    return;
                }
                Field villagerDataField = activeBE.getClass().getDeclaredField("villagerData");
                villagerDataField.setAccessible(true);
                villagerNBT = (class_2487)villagerDataField.get(activeBE);
                if (villagerNBT == null || villagerNBT.method_33133()) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cCube villager data is empty!"));
                    return;
                }
                villagerNBT = villagerNBT.method_10553();
                villagerDataField.set(activeBE, new class_2487());
                hasVillagerField.setBoolean(activeBE, false);
                if (activeBE instanceof class_2586) {
                    class_2586 be = activeBE;
                    be.method_5431();
                }
            }
            catch (Exception e) {
                PocketVillagersMod.LOGGER.error("Store failed due to reflection error", (Throwable)e);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cFailed to extract villager!"));
                return;
            }
        }
        class_2338 storagePos = PocketTerminalPacketHandlers.findNearestStorageCube(level, activeCubePos, preferredStoragePos);
        if (storagePos == null) {
            PocketTerminalPacketHandlers.returnVillagerToCube(activeBE, slotIndex, villagerNBT);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cNo nearby storage cube found!"));
            return;
        }
        class_2586 storageBE = level.method_8321(storagePos);
        if (!(storageBE instanceof StoragePocketCubeBlockEntity)) {
            PocketTerminalPacketHandlers.returnVillagerToCube(activeBE, slotIndex, villagerNBT);
            PocketVillagersMod.LOGGER.warn("Store failed: {} is not a storage cube", (Object)storagePos);
            return;
        }
        StoragePocketCubeBlockEntity storage = (StoragePocketCubeBlockEntity)storageBE;
        if (storage.isFull()) {
            PocketTerminalPacketHandlers.returnVillagerToCube(activeBE, slotIndex, villagerNBT);
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cStorage cube is full!"));
            return;
        }
        storage.addVillager(villagerNBT);
        PocketVillagersMod.LOGGER.debug("Stored villager from active cube {} to storage {}", (Object)activeCubePos, (Object)storagePos);
        player.method_64398((class_2561)class_2561.method_43470((String)"Villager stored successfully"));
    }

    private static class_2338 findNearestStorageCube(class_3218 level, class_2338 center, class_2338 preferredPos) {
        StoragePocketCubeBlockEntity storage;
        class_2586 be;
        if (preferredPos != null && (be = level.method_8321(preferredPos)) instanceof StoragePocketCubeBlockEntity && !(storage = (StoragePocketCubeBlockEntity)be).isFull()) {
            return preferredPos;
        }
        class_2338 nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        int radius = Math.max(0, PocketVillagersConfig.getInstance().terminalMaxRange);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distance;
                    StoragePocketCubeBlockEntity storage2;
                    class_2338 checkPos = center.method_10069(x, y, z);
                    class_2586 be2 = level.method_8321(checkPos);
                    if (!(be2 instanceof StoragePocketCubeBlockEntity) || (storage2 = (StoragePocketCubeBlockEntity)be2).isFull() || !((distance = center.method_10262((class_2382)checkPos)) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = checkPos;
                }
            }
        }
        return nearest;
    }

    private static void returnVillagerToCube(class_2586 cube, int slotIndex, class_2487 villagerNBT) {
        if (cube instanceof BreederPocketCubeBlockEntity) {
            BreederPocketCubeBlockEntity breeder = (BreederPocketCubeBlockEntity)cube;
            breeder.setVillagerData(slotIndex, villagerNBT);
            breeder.method_5431();
            class_1937 class_19372 = cube.method_10997();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_8413(cube.method_11016(), cube.method_11010(), cube.method_11010(), 3);
            }
        } else if (cube instanceof IronFarmPocketCubeBlockEntity) {
            IronFarmPocketCubeBlockEntity ironFarm = (IronFarmPocketCubeBlockEntity)cube;
            ironFarm.setVillagerData(slotIndex, villagerNBT);
            ironFarm.method_5431();
            class_1937 class_19373 = cube.method_10997();
            if (class_19373 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19373;
                serverLevel.method_8413(cube.method_11016(), cube.method_11010(), cube.method_11010(), 3);
            }
        } else {
            try {
                Field villagerDataField = cube.getClass().getDeclaredField("villagerData");
                villagerDataField.setAccessible(true);
                villagerDataField.set(cube, villagerNBT);
                Field hasVillagerField = cube.getClass().getDeclaredField("hasVillager");
                hasVillagerField.setAccessible(true);
                hasVillagerField.setBoolean(cube, true);
                cube.method_5431();
                class_1937 class_19374 = cube.method_10997();
                if (class_19374 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19374;
                    serverLevel.method_8413(cube.method_11016(), cube.method_11010(), cube.method_11010(), 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

