/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.client.gui.PocketTerminalScreen;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record SyncTerminalVillagersPayload(List<CubeVillagerData> cubeVillagers) implements class_8710
{
    @Environment(value=EnvType.CLIENT)
    private static List<CubeVillagerData> cachedVillagers = new ArrayList<CubeVillagerData>();
    public static final class_8710.class_9154<SyncTerminalVillagersPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"sync_terminal_villagers"));
    public static final class_9139<class_2540, SyncTerminalVillagersPayload> CODEC = class_9139.method_56437((buf, payload) -> {
        buf.method_53002(payload.cubeVillagers.size());
        for (CubeVillagerData data : payload.cubeVillagers) {
            buf.method_10807(data.cubePos);
            buf.method_10814(data.cubeType);
            buf.method_10814(data.cubeName);
            buf.method_53002(data.villagers.size());
            for (VillagerSlot villager : data.villagers) {
                buf.method_53002(villager.slotIndex);
                buf.method_10794((class_2520)villager.villagerData);
            }
        }
    }, buf -> {
        int cubeCount = buf.readInt();
        ArrayList<CubeVillagerData> cubeVillagers = new ArrayList<CubeVillagerData>();
        for (int i = 0; i < cubeCount; ++i) {
            class_2338 cubePos = buf.method_10811();
            String cubeType = buf.method_19772();
            String cubeName = buf.method_19772();
            int villagerCount = buf.readInt();
            ArrayList<VillagerSlot> villagers = new ArrayList<VillagerSlot>();
            for (int j = 0; j < villagerCount; ++j) {
                int slotIndex = buf.readInt();
                class_2487 villagerData = buf.method_10798();
                villagers.add(new VillagerSlot(slotIndex, villagerData));
            }
            cubeVillagers.add(new CubeVillagerData(cubePos, cubeType, cubeName, villagers));
        }
        return new SyncTerminalVillagersPayload(cubeVillagers);
    });

    @Environment(value=EnvType.CLIENT)
    public static List<CubeVillagerData> getCachedVillagers() {
        return cachedVillagers;
    }

    @Environment(value=EnvType.CLIENT)
    public static void clearCache() {
        cachedVillagers.clear();
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void sendToPlayer(class_3222 player, List<CubeVillagerData> cubeVillagers) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncTerminalVillagersPayload(cubeVillagers));
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.client().execute(() -> {
            cachedVillagers = new ArrayList<CubeVillagerData>(payload.cubeVillagers());
            class_437 patt0$temp = context.client().field_1755;
            if (patt0$temp instanceof PocketTerminalScreen) {
                PocketTerminalScreen terminalScreen = (PocketTerminalScreen)patt0$temp;
                terminalScreen.updateVillagerList(payload.cubeVillagers());
            }
        }));
    }

    public static class VillagerSlot {
        public final int slotIndex;
        public final class_2487 villagerData;

        public VillagerSlot(int slotIndex, class_2487 villagerData) {
            this.slotIndex = slotIndex;
            this.villagerData = villagerData;
        }
    }

    public static class CubeVillagerData {
        public final class_2338 cubePos;
        public final String cubeType;
        public final String cubeName;
        public final List<VillagerSlot> villagers;

        public CubeVillagerData(class_2338 cubePos, String cubeType, String cubeName, List<VillagerSlot> villagers) {
            this.cubePos = cubePos;
            this.cubeType = cubeType;
            this.cubeName = cubeName;
            this.villagers = villagers;
        }
    }
}

