/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.mcreator.pocketvillagers.block.PocketCubeBlock;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.handler.InfiniteTradesHandler;
import net.mcreator.pocketvillagers.handler.VillagerCaptureHandler;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.init.PocketVillagersModItems;
import net.mcreator.pocketvillagers.init.PocketVillagersModMenus;
import net.mcreator.pocketvillagers.init.PocketVillagersModTabs;
import net.mcreator.pocketvillagers.network.ClearAutoTraderCachePayload;
import net.mcreator.pocketvillagers.network.ClearIronFarmPreviewPayload;
import net.mcreator.pocketvillagers.network.EjectWorkstationPacket;
import net.mcreator.pocketvillagers.network.MenuStateUpdateC2SPacket;
import net.mcreator.pocketvillagers.network.OpenRemoteCubePayload;
import net.mcreator.pocketvillagers.network.OpenStorageFromTerminalPayload;
import net.mcreator.pocketvillagers.network.PocketTerminalPacketHandlers;
import net.mcreator.pocketvillagers.network.RefreshTradesPacket;
import net.mcreator.pocketvillagers.network.ReleasePocketVillagerPacket;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.network.ReopenTerminalPayload;
import net.mcreator.pocketvillagers.network.RequestStorageContentsPayload;
import net.mcreator.pocketvillagers.network.SetTerminalViewPayload;
import net.mcreator.pocketvillagers.network.StartIronFarmHologramPayload;
import net.mcreator.pocketvillagers.network.StoreVillagerToStoragePayload;
import net.mcreator.pocketvillagers.network.SyncAutoTraderOffersPayload;
import net.mcreator.pocketvillagers.network.SyncBreederMenuPayload;
import net.mcreator.pocketvillagers.network.SyncConverterMenuPayload;
import net.mcreator.pocketvillagers.network.SyncFacingYawPayload;
import net.mcreator.pocketvillagers.network.SyncFarmingMenuPayload;
import net.mcreator.pocketvillagers.network.SyncFishingMenuPayload;
import net.mcreator.pocketvillagers.network.SyncIronFarmMenuPayload;
import net.mcreator.pocketvillagers.network.SyncMiningMenuPayload;
import net.mcreator.pocketvillagers.network.SyncNearbyCubesPayload;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.network.SyncStorageContentsPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalFuelPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerBetweenCubesPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerPayload;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PocketVillagersMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(PocketVillagersMod.class);
    public static final String MODID = "pocket_villagers";
    public static final Map<String, String> COMPAT_WORKSTATION_PROFESSION = new ConcurrentHashMap<String, String>();
    private static final Collection<class_3545<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<class_3545<Runnable, Integer>>();
    private static Object minecraft;
    private static MethodHandle playerHandle;

    public void onInitialize() {
        LOGGER.debug("Initializing PocketVillagersMod");
        PocketVillagersConfig.getInstance();
        PocketVillagersMod.loadCompatMappings();
        PocketVillagersMod.loadDiscoveredPoiCache();
        LOGGER.debug("Config & Mappings loaded");
        this.registerContent();
        this.registerNetwork();
        this.registerEventHandlers();
        this.initServerTick();
    }

    private void registerContent() {
        PocketVillagersModTabs.load();
        PocketVillagersModBlocks.load();
        PocketVillagersModBlockEntities.load();
        PocketVillagersModItems.load();
        PocketVillagersModMenus.load();
    }

    private void registerNetwork() {
        PayloadTypeRegistry reg;
        try {
            reg = PayloadTypeRegistry.playC2S();
            reg.register(ReleasePocketVillagerPacket.TYPE, ReleasePocketVillagerPacket.CODEC);
            reg.register(ReleaseStorageVillagerPacket.TYPE, ReleaseStorageVillagerPacket.CODEC);
            reg.register(EjectWorkstationPacket.TYPE, EjectWorkstationPacket.CODEC);
            reg.register(RefreshTradesPacket.TYPE, RefreshTradesPacket.CODEC);
            reg.register(OpenRemoteCubePayload.ID, OpenRemoteCubePayload.CODEC);
            reg.register(ReopenTerminalPayload.ID, ReopenTerminalPayload.CODEC);
            reg.register(TransferVillagerBetweenCubesPayload.ID, TransferVillagerBetweenCubesPayload.CODEC);
            reg.register(MenuStateUpdateC2SPacket.TYPE, MenuStateUpdateC2SPacket.CODEC);
            reg.register(RequestStorageContentsPayload.ID, RequestStorageContentsPayload.CODEC);
            reg.register(TransferVillagerPayload.ID, TransferVillagerPayload.CODEC);
            reg.register(OpenStorageFromTerminalPayload.ID, OpenStorageFromTerminalPayload.STREAM_CODEC);
            reg.register(StoreVillagerToStoragePayload.ID, StoreVillagerToStoragePayload.STREAM_CODEC);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register C2S payloads", t);
        }
        ReleasePocketVillagerPacket.register();
        ReleaseStorageVillagerPacket.register();
        EjectWorkstationPacket.register();
        RefreshTradesPacket.register();
        OpenRemoteCubePayload.register();
        ReopenTerminalPayload.register();
        TransferVillagerBetweenCubesPayload.registerServerReceiver();
        MenuStateUpdateC2SPacket.register();
        PocketTerminalPacketHandlers.registerServerHandlers();
        try {
            reg = PayloadTypeRegistry.playS2C();
            reg.register(SyncPocketCubePayload.TYPE, SyncPocketCubePayload.CODEC);
            reg.register(StartIronFarmHologramPayload.TYPE, StartIronFarmHologramPayload.CODEC);
            reg.register(ClearIronFarmPreviewPayload.TYPE, ClearIronFarmPreviewPayload.CODEC);
            reg.register(SyncBreederMenuPayload.TYPE, SyncBreederMenuPayload.CODEC);
            reg.register(SyncIronFarmMenuPayload.TYPE, SyncIronFarmMenuPayload.CODEC);
            reg.register(SyncConverterMenuPayload.TYPE, SyncConverterMenuPayload.CODEC);
            reg.register(SyncMiningMenuPayload.TYPE, SyncMiningMenuPayload.CODEC);
            reg.register(SyncFishingMenuPayload.TYPE, SyncFishingMenuPayload.CODEC);
            reg.register(SyncFarmingMenuPayload.TYPE, SyncFarmingMenuPayload.CODEC);
            reg.register(SyncFacingYawPayload.TYPE, SyncFacingYawPayload.CODEC);
            reg.register(SyncNearbyCubesPayload.ID, SyncNearbyCubesPayload.CODEC);
            reg.register(SyncTerminalVillagersPayload.ID, SyncTerminalVillagersPayload.CODEC);
            reg.register(SyncStorageContentsPayload.ID, SyncStorageContentsPayload.CODEC);
            reg.register(SyncTerminalFuelPayload.ID, SyncTerminalFuelPayload.CODEC);
            reg.register(SetTerminalViewPayload.ID, SetTerminalViewPayload.CODEC);
            reg.register(SyncAutoTraderOffersPayload.TYPE, SyncAutoTraderOffersPayload.CODEC);
            reg.register(ClearAutoTraderCachePayload.ID, ClearAutoTraderCachePayload.CODEC);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register S2C payloads", t);
        }
    }

    private void registerEventHandlers() {
        VillagerCaptureHandler.register();
        InfiniteTradesHandler.register();
        try {
            UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
                try {
                    class_2338 pos = hitResult.method_17777();
                    class_2680 bs = world.method_8320(pos);
                    String id = "<unknown>";
                    try {
                        id = class_7923.field_41175.method_10221((Object)bs.method_26204()).toString();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LOGGER.debug("UseBlockCallback: player={} pos={} block={} clientSide={}", (Object)(player == null ? "<null>" : player.method_5477().getString()), (Object)pos, (Object)id, (Object)world.method_8608());
                }
                catch (Throwable e) {
                    LOGGER.error("Error in UseBlockCallback", e);
                }
                return class_1269.field_5811;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void loadCompatMappings() {
        try {
            String text;
            JsonObject obj;
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("compat_workstation_profession.json");
            if (!Files.exists(cfgFile, new LinkOption[0])) {
                try (InputStream in2 = PocketVillagersMod.class.getResourceAsStream("/config/pocket_villagers/compat_workstation_profession.json");){
                    if (in2 != null) {
                        Files.copy(in2, cfgFile, new CopyOption[0]);
                    } else {
                        JsonObject example = new JsonObject();
                        example.addProperty("morevillagers:gardening_table", "morevillagers:florist");
                        Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)example), new OpenOption[0]);
                    }
                }
                catch (Throwable in2) {
                    // empty catch block
                }
            }
            if ((obj = (JsonObject)new Gson().fromJson(text = Files.readString(cfgFile), JsonObject.class)) != null) {
                for (Map.Entry e : obj.entrySet()) {
                    try {
                        COMPAT_WORKSTATION_PROFESSION.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            LOGGER.debug("Loaded {} workstation->profession entries", (Object)COMPAT_WORKSTATION_PROFESSION.size());
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to load compat mappings: {}", (Object)t.toString());
        }
    }

    private static void loadDiscoveredPoiCache() {
        try {
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("discovered_poi_professions.json");
            if (!Files.exists(cfgFile, new LinkOption[0])) {
                Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)new JsonObject()), new OpenOption[0]);
                return;
            }
            String text = Files.readString(cfgFile);
            JsonObject obj = (JsonObject)new Gson().fromJson(text, JsonObject.class);
            HashMap<String, String> map = new HashMap<String, String>();
            if (obj != null) {
                for (Map.Entry e : obj.entrySet()) {
                    try {
                        map.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (!map.isEmpty()) {
                LOGGER.debug("Loaded {} discovered POI->profession entries", (Object)map.size());
                PocketCubeBlock.loadPoiCache(map);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void saveCompatMapping(String blockId, String professionId) {
        PocketVillagersMod.saveJsonMapping("compat_workstation_profession.json", blockId, professionId, COMPAT_WORKSTATION_PROFESSION);
    }

    public static synchronized void saveDiscoveredPoiMapping(String poiKey, String professionId) {
        PocketVillagersMod.saveJsonMapping("discovered_poi_professions.json", poiKey, professionId, null);
    }

    private static void saveJsonMapping(String filename, String key, String value, Map<String, String> cacheToUpdate) {
        try {
            if (key == null || value == null) {
                return;
            }
            if (cacheToUpdate != null) {
                cacheToUpdate.put(key, value);
            }
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve(filename);
            JsonObject obj = new JsonObject();
            if (Files.exists(cfgFile, new LinkOption[0])) {
                try {
                    String existing = Files.readString(cfgFile);
                    JsonObject ex = (JsonObject)new Gson().fromJson(existing, JsonObject.class);
                    if (ex != null) {
                        obj = ex;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            obj.addProperty(key, value);
            Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)obj), new OpenOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add((class_3545<Runnable, Integer>)new class_3545((Object)action, (Object)tick));
    }

    private void initServerTick() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.method_34965((Object)((Integer)work.method_15441() - 1));
                if ((Integer)work.method_15441() <= 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.method_15442()).run());
            workQueue.removeAll(actions);
        });
    }

    @Nullable
    public static class_1657 clientPlayer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            try {
                if (minecraft == null || playerHandle == null) {
                    Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft");
                    minecraft = MethodHandles.publicLookup().findStatic(minecraftClass, "getInstance", MethodType.methodType(minecraftClass)).invoke();
                    playerHandle = MethodHandles.publicLookup().findGetter(minecraftClass, "player", Class.forName("net.minecraft.client.player.LocalPlayer"));
                }
                return playerHandle.invoke(minecraft);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to get client player", e);
                return null;
            }
        }
        return null;
    }

    public static void clientLoad() {
    }
}

