/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3850;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class PocketCubeBlock
extends class_2383
implements class_2343 {
    private static final MapCodec<PocketCubeBlock> CODEC = MapCodec.unit(() -> new PocketCubeBlock(class_4970.class_2251.method_9637()));
    private static final ThreadLocal<class_2487> breakingVillagerData = new ThreadLocal();
    private static final Map<String, String> POI_TO_PROFESSION_CACHE = new ConcurrentHashMap<String, String>();

    public MapCodec<PocketCubeBlock> method_53969() {
        return CODEC;
    }

    public static void loadPoiCache(Map<String, String> discovered) {
        if (discovered != null) {
            POI_TO_PROFESSION_CACHE.putAll(discovered);
        }
    }

    public PocketCubeBlock(class_4970.class_2251 properties) {
        super(properties.method_9626(class_2498.field_11533).method_9629(0.5f, 290.0f).method_9631(s -> 15).method_50012(class_3619.field_15975));
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    public class_1269 use(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean holdingBlockItem;
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 held = player.method_5998(hand);
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof PocketCubeBlockEntity)) {
            return class_1269.field_5811;
        }
        PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)blockEntity;
        boolean bl = holdingBlockItem = held != null && !held.method_7960() && held.method_7909() instanceof class_1747;
        if (cubeEntity.hasWorkstation()) {
            if (!level.method_8608() && cubeEntity.hasVillager() && player instanceof class_3222) {
                CubeVillager cv;
                class_3222 serverPlayer = (class_3222)player;
                class_2487 villagerData = cubeEntity.getVillagerData();
                if (villagerData != null && !villagerData.method_10545("Offers")) {
                    try {
                        class_1916 offers = VillagerDataHandler.generateOffers(level, villagerData, pos);
                        if (offers != null && !offers.isEmpty()) {
                            class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_3218)level).method_30349());
                            villagerData.method_10566("Offers", (class_2520)class_1916.field_48850.encodeStart((DynamicOps)ops, (Object)offers).getOrThrow());
                            cubeEntity.setVillagerData(villagerData);
                        }
                    }
                    catch (Throwable offers) {
                        // empty catch block
                    }
                }
                if ((cv = cubeEntity.getOrCreateCachedVillager()) != null) {
                    try {
                        class_1916 offers = cv.method_8264();
                        if (offers != null && !offers.isEmpty()) {
                            for (class_1914 offer : offers) {
                                if (offer == null || offer.method_8249() <= 0) continue;
                                offer.method_19275();
                            }
                        }
                    }
                    catch (Throwable offers) {
                        // empty catch block
                    }
                    class_2487 debugData = cubeEntity.getVillagerData();
                    PocketVillagersMod.LOGGER.debug("=== OPENING TRADING GUI ===");
                    try {
                        PocketVillagersMod.LOGGER.debug("Block Entity Villager Data XP: {}", (Object)debugData.method_10550("Xp"));
                        PocketVillagersMod.LOGGER.debug("Block Entity Villager Data Level: {}", (Object)debugData.method_10550("VillagerData.level"));
                        PocketVillagersMod.LOGGER.debug("Block Entity Has Offers Tag: {}", (Object)debugData.method_10545("Offers"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        PocketVillagersMod.LOGGER.debug("CubeVillager Entity XP: {}", (Object)cv.method_19269());
                        PocketVillagersMod.LOGGER.debug("CubeVillager Entity Level: {}", (Object)cv.method_7231().method_16925());
                        PocketVillagersMod.LOGGER.debug("CubeVillager Offer Count: {}", (Object)(cv.method_8264() != null ? cv.method_8264().size() : 0));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    cv.setPocketCubePos(pos);
                    int lvl = cv.method_7231().method_16925();
                    SyncPocketCubePayload.send(serverPlayer, pos, true, lvl, cv.method_19269());
                    cv.method_8259((class_1657)serverPlayer);
                    cv.method_17449((class_1657)serverPlayer, (class_2561)class_2561.method_43470((String)"Pocket Cube"), lvl);
                }
            }
            return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
        }
        if (holdingBlockItem && cubeEntity.hasVillager() && !cubeEntity.hasWorkstation()) {
            boolean isJobbed;
            String prof;
            if (!PocketCubeBlock.isWorkstationCandidate(held, level)) {
                if (!level.method_8608()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"This block is not a valid workstation"), true);
                }
                return class_1269.field_21466;
            }
            class_2487 vd = cubeEntity.getVillagerData();
            String string = prof = vd != null && vd.method_10545("VillagerData.profession") ? vd.method_10558("VillagerData.profession") : "minecraft:none";
            if (prof == null || prof.trim().isEmpty()) {
                prof = "minecraft:none";
            }
            boolean bl2 = isJobbed = !"minecraft:none".equals(prof) && !"none".equals(prof);
            if (isJobbed && !PocketCubeBlock.workstationMatchesProfession(held, level, prof)) {
                if (!level.method_8608()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Workstation does not match profession!"), true);
                }
                return class_1269.field_21466;
            }
            if (!level.method_8608()) {
                String newProf;
                class_1799 toInsert = held.method_7972();
                toInsert.method_7939(1);
                cubeEntity.setWorkstation(toInsert);
                if (!isJobbed && (newProf = PocketCubeBlock.workstationToProfession(toInsert, level)) != null) {
                    class_2487 updated = vd.method_10553();
                    updated.method_10582("VillagerData.profession", newProf);
                    if (!updated.method_10545("VillagerData.level")) {
                        updated.method_10569("VillagerData.level", 1);
                    }
                    if (!updated.method_10545("Xp")) {
                        updated.method_10569("Xp", 0);
                    }
                    if (!updated.method_10545("VillagerData.type")) {
                        if (vd.method_10573("VillagerData", 10) && vd.method_10562("VillagerData").method_10545("type")) {
                            updated.method_10582("VillagerData.type", vd.method_10562("VillagerData").method_10558("type"));
                        } else {
                            updated.method_10582("VillagerData.type", "minecraft:plains");
                        }
                    }
                    if (!updated.method_10545("Offers")) {
                        class_1916 offers = VillagerDataHandler.generateOffers(level, updated, pos);
                        if (offers != null && !offers.isEmpty()) {
                            class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_3218)level).method_30349());
                            DataResult encoded = class_1916.field_48850.encodeStart((DynamicOps)ops, (Object)offers);
                            if (encoded.result().isPresent()) {
                                updated.method_10566("Offers", (class_2520)encoded.getOrThrow());
                                PocketVillagersMod.LOGGER.debug("PocketCubeBlock: Generated and stored {} offers for workstation insertion", (Object)offers.size());
                            } else {
                                PocketVillagersMod.LOGGER.warn("PocketCubeBlock: Failed to encode offers: {}", encoded.error().orElse(null));
                            }
                        } else {
                            PocketVillagersMod.LOGGER.warn("PocketCubeBlock: generateOffers returned null or empty");
                        }
                    }
                    cubeEntity.setVillagerData(updated);
                    PocketVillagersMod.LOGGER.debug("PocketCubeBlock: After setVillagerData, NBT has Offers={}", (Object)updated.method_10545("Offers"));
                }
                if (!player.method_7337()) {
                    held.method_7934(1);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"Workstation inserted!"), true);
            }
            return level.method_8608() ? class_1269.field_5812 : class_1269.field_21466;
        }
        if (!cubeEntity.hasVillager()) {
            if (!level.method_8608()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Capture a villager first!"), true);
            }
            return class_1269.field_21466;
        }
        if (!cubeEntity.hasWorkstation()) {
            if (!level.method_8608()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Insert a workstation to begin trading"), true);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public static void saveVillagerDataToCube(class_1937 level, class_2338 pos, CubeVillager villager) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof PocketCubeBlockEntity) {
            String storedType;
            class_2487 existingData;
            int currentLevel;
            PocketCubeBlockEntity cubeEntity = (PocketCubeBlockEntity)blockEntity;
            class_2487 newData = new class_2487();
            int currentXp = villager.method_19269();
            int calculatedLevel = currentLevel = villager.method_7231().method_16925();
            if (currentLevel < 5) {
                if (currentLevel == 1 && currentXp >= 10) {
                    calculatedLevel = 2;
                } else if (currentLevel == 2 && currentXp >= 70) {
                    calculatedLevel = 3;
                } else if (currentLevel == 3 && currentXp >= 150) {
                    calculatedLevel = 4;
                } else if (currentLevel == 4 && currentXp >= 250) {
                    calculatedLevel = 5;
                }
            }
            if (calculatedLevel > currentLevel) {
                class_3850 oldData = villager.method_7231();
                villager.method_7195(oldData.method_16920(calculatedLevel));
            }
            newData.method_10569("Xp", currentXp);
            newData.method_10582("VillagerData.profession", class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924()).toString());
            newData.method_10569("VillagerData.level", calculatedLevel);
            newData.method_10556("ProfessionLocked", currentXp > 0);
            String typeStr = class_7923.field_41194.method_10221((Object)villager.method_7231().method_16919()).toString();
            if ("minecraft:plains".equals(typeStr) && (existingData = cubeEntity.getVillagerData()) != null && existingData.method_10545("VillagerData.type") && (storedType = existingData.method_10558("VillagerData.type")) != null && !storedType.isEmpty() && !"minecraft:plains".equals(storedType)) {
                typeStr = storedType;
            }
            newData.method_10582("VillagerData.type", typeStr);
            if (villager.method_8264() != null && !villager.method_8264().isEmpty()) {
                try {
                    class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_3218)level).method_30349());
                    newData.method_10566("Offers", (class_2520)class_1916.field_48850.encodeStart((DynamicOps)ops, (Object)villager.method_8264()).getOrThrow());
                }
                catch (Throwable ops) {
                    // empty catch block
                }
            }
            if ((existingData = cubeEntity.getVillagerData()) != null && existingData.method_10545("PocketVillagers.Conversions")) {
                newData.method_10569("PocketVillagers.Conversions", existingData.method_10550("PocketVillagers.Conversions"));
            }
            cubeEntity.setVillagerData(newData);
        }
    }

    public static String workstationToProfession(class_1799 workstation, class_1937 level) {
        if (workstation.method_7960()) {
            return null;
        }
        class_1792 item = workstation.method_7909();
        if (item == class_1802.field_16306) {
            return "minecraft:armorer";
        }
        if (item == class_1802.field_16309) {
            return "minecraft:butcher";
        }
        if (item == class_1802.field_16313) {
            return "minecraft:cartographer";
        }
        if (item == class_1802.field_8740) {
            return "minecraft:cleric";
        }
        if (item == class_1802.field_17530) {
            return "minecraft:farmer";
        }
        if (item == class_1802.field_16307) {
            return "minecraft:fisherman";
        }
        if (item == class_1802.field_16310) {
            return "minecraft:fletcher";
        }
        if (item == class_1802.field_8638) {
            return "minecraft:leatherworker";
        }
        if (item == class_1802.field_16312) {
            return "minecraft:librarian";
        }
        if (item == class_1802.field_16305) {
            return "minecraft:mason";
        }
        if (item == class_1802.field_8772) {
            return "minecraft:shepherd";
        }
        if (item == class_1802.field_16308) {
            return "minecraft:toolsmith";
        }
        if (item == class_1802.field_16311) {
            return "minecraft:weaponsmith";
        }
        return null;
    }

    private static boolean isWorkstationCandidate(class_1799 stack, class_1937 level) {
        return PocketCubeBlock.workstationToProfession(stack, level) != null;
    }

    private static boolean workstationMatchesProfession(class_1799 stack, class_1937 level, String profession) {
        String p = PocketCubeBlock.workstationToProfession(stack, level);
        return p != null && p.equals(profession);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return PocketCubeBlock.method_9541((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public boolean propagatesSkylightDown(class_2680 state) {
        return true;
    }

    public class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PocketCubeBlockEntity(pos, state);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        class_2586 be;
        super.method_9567(level, pos, state, placer, stack);
        if (!level.field_9236 && (be = level.method_8321(pos)) instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
            if (VillagerDataHandler.hasVillager(stack)) {
                cube.setVillagerData(VillagerDataHandler.getVillagerData(stack));
                VillagerDataHandler.clearVillagerData(stack);
            }
            try {
                class_2487 tag = ((class_9279)stack.method_57824(class_9334.field_49628)).method_57461();
                if (tag.method_10545("WorkstationItemId")) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)tag.method_10558("WorkstationItemId")));
                    cube.setWorkstation(new class_1799((class_1935)item, tag.method_10550("WorkstationCount")));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 be;
        if (!level.method_8608() && (be = level.method_8321(pos)) instanceof PocketCubeBlockEntity) {
            PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
            class_1799 drop = new class_1799((class_1935)PocketVillagersModBlocks.POCKET_CUBE.method_8389());
            class_2487 tag = new class_2487();
            if (cube.hasVillager()) {
                tag.method_10566("VillagerData", (class_2520)cube.getVillagerData());
                tag.method_10556("HasVillager", true);
            }
            if (cube.hasWorkstation()) {
                class_1799 ws = cube.getWorkstation();
                tag.method_10582("WorkstationItemId", class_7923.field_41178.method_10221((Object)ws.method_7909()).toString());
                tag.method_10569("WorkstationCount", ws.method_7947());
            }
            drop.method_57365(class_9323.method_57827().method_57840(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag)).method_57838());
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)drop);
            level.method_8650(pos, false);
            return class_2246.field_10124.method_9564();
        }
        return super.method_9576(level, pos, state, player);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        return this.use(state, level, pos, player, class_1268.field_5808, hit);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.use(state, level, pos, player, hand, hit) == class_1269.field_21466 ? class_9062.field_47729 : class_9062.field_47733;
    }
}

