/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.mcreator.pocketvillagers.PocketVillagersMod;

public class ClientHologramConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("pocket_villagers_client.json");
    public boolean enableVillagerHolograms = true;
    private static ClientHologramConfig INSTANCE = null;

    public static ClientHologramConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ClientHologramConfig.load();
        }
        return INSTANCE;
    }

    public static ClientHologramConfig load() {
        ClientHologramConfig cfg = new ClientHologramConfig();
        try {
            String json;
            ClientHologramConfig loaded;
            if (Files.exists(CONFIG_PATH, new LinkOption[0]) && (loaded = (ClientHologramConfig)GSON.fromJson(json = Files.readString(CONFIG_PATH), ClientHologramConfig.class)) != null) {
                cfg = loaded;
            }
        }
        catch (IOException e) {
            PocketVillagersMod.LOGGER.warn("[Pocket Villagers] Failed to load client hologram config, using defaults: {}", (Object)e.getMessage());
        }
        cfg.save();
        return cfg;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            PocketVillagersMod.LOGGER.error("[Pocket Villagers] Failed to save client hologram config: {}", (Object)e.getMessage());
        }
    }

    public static void reload() {
        INSTANCE = null;
        ClientHologramConfig.load();
    }
}

