/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.client;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public final class PocketCubeClient {
    private static volatile class_2338 cachedPos = null;
    private static volatile boolean hasWorkstation = false;
    private static final ConcurrentHashMap<class_2338, Integer> unlockedCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2338, Integer> scrollCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2338, Integer> xpCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2338, Integer> levelCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2338, List<Integer>> offerXpCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_2338, List<OfferInfo>> offerInfoCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, class_2338> entityIdToPosCache = new ConcurrentHashMap();
    public static boolean VERBOSE_OFFER_DIAG = true;

    public static void setCachedScroll(class_2338 pos, int scroll) {
        if (pos == null) {
            return;
        }
        scrollCache.put(pos, scroll);
    }

    public static Integer getCachedScroll(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        return scrollCache.get(pos);
    }

    public static Integer getCachedUnlocked(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        return unlockedCache.get(pos);
    }

    public static void setCachedUnlocked(class_2338 pos, int unlocked) {
        if (pos == null) {
            return;
        }
        unlockedCache.put(pos, unlocked);
    }

    public static void setCachedEntityPos(int entityId, class_2338 pos) {
        if (pos == null) {
            return;
        }
        entityIdToPosCache.put(entityId, pos);
    }

    public static class_2338 getCachedEntityPos(int entityId) {
        return entityIdToPosCache.get(entityId);
    }

    public static void setCachedLevelAndXp(class_2338 pos, int level, int xp) {
        if (pos == null) {
            return;
        }
        levelCache.put(pos, level);
        xpCache.put(pos, xp);
        try {
            PocketVillagersMod.LOGGER.debug("PocketCubeClient: setCachedLevelAndXp pos={} level={} xp={}", (Object)pos, (Object)level, (Object)xp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Integer getCachedXp(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        return xpCache.get(pos);
    }

    public static Integer getCachedLevel(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        return levelCache.get(pos);
    }

    public static void setCachedOfferXp(class_2338 pos, List<Integer> xps) {
        if (pos == null || xps == null) {
            return;
        }
        offerXpCache.put(pos, new ArrayList<Integer>(xps));
    }

    public static void setCachedOfferInfo(class_2338 pos, List<OfferInfo> infos) {
        if (pos == null || infos == null) {
            return;
        }
        offerInfoCache.put(pos, new ArrayList<OfferInfo>(infos));
    }

    public static String fingerprintOfOffer(class_1914 mo) {
        if (mo == null) {
            return "<null>";
        }
        try {
            StringBuilder sb = new StringBuilder();
            try {
                class_1799 ca = mo.method_19272();
                if (ca != null) {
                    sb.append(PocketCubeClient.describeStack(ca));
                } else {
                    sb.append("-null-");
                }
            }
            catch (Throwable ignored) {
                sb.append("-caerr-");
            }
            sb.append('|');
            try {
                class_1799 cb = mo.method_8247();
                if (cb != null) {
                    sb.append(PocketCubeClient.describeStack(cb));
                } else {
                    sb.append("-null-");
                }
            }
            catch (Throwable ignored) {
                sb.append("-cberr-");
            }
            sb.append("->");
            try {
                class_1799 res = mo.method_8250();
                if (res != null) {
                    sb.append(PocketCubeClient.describeStack(res));
                } else {
                    sb.append("-null-");
                }
            }
            catch (Throwable ignored) {
                sb.append("-reserr-");
            }
            return sb.toString();
        }
        catch (Throwable t) {
            return "<err>";
        }
    }

    private static String describeStack(class_1799 s) {
        try {
            if (s == null) {
                return "<null>";
            }
            String id = "?";
            try {
                class_2960 key = class_7923.field_41178.method_10221((Object)s.method_7909());
                if (key != null) {
                    id = key.toString();
                }
            }
            catch (Throwable ignored) {
                try {
                    id = s.method_7909().toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            int cnt = 0;
            try {
                cnt = s.method_7947();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object tag = "";
            try {
                Object tagObj = null;
                try {
                    Method m = s.getClass().getMethod("getTag", new Class[0]);
                    tagObj = m.invoke((Object)s, new Object[0]);
                }
                catch (Throwable ignored3) {
                    try {
                        Method m2 = s.getClass().getMethod("getNbt", new Class[0]);
                        tagObj = m2.invoke((Object)s, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (tagObj != null) {
                    tag = "#" + Integer.toHexString(tagObj.hashCode());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return id + ":" + cnt + (String)tag;
        }
        catch (Throwable t) {
            return "<err>";
        }
    }

    public static Integer getCachedOfferXp(class_2338 pos, int index) {
        if (pos == null) {
            return null;
        }
        List<Integer> list = offerXpCache.get(pos);
        if (list == null) {
            return null;
        }
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public static Integer getCachedOfferXpByFingerprint(class_2338 pos, String fingerprint) {
        if (pos == null || fingerprint == null) {
            return null;
        }
        List<OfferInfo> infos = offerInfoCache.get(pos);
        if (infos != null) {
            for (OfferInfo oi : infos) {
                try {
                    if (!fingerprint.equals(oi.fingerprint)) continue;
                    return oi.xp;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }

    public static List<OfferInfo> getCachedOfferInfos(class_2338 pos) {
        if (pos == null) {
            return null;
        }
        List<OfferInfo> l = offerInfoCache.get(pos);
        if (l == null) {
            return null;
        }
        return new ArrayList<OfferInfo>(l);
    }

    private PocketCubeClient() {
    }

    public static void setCachedPocketCubeData(class_2338 pos, boolean has) {
        cachedPos = pos;
        hasWorkstation = has;
        try {
            PocketVillagersMod.LOGGER.debug("PocketCubeClient: setCachedPocketCubeData pos={} hasWorkstation={}", (Object)pos, (Object)has);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearBlockEntityCachedVillager(class_2338 pos) {
        try {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return;
            }
            class_638 lvl = mc.field_1687;
            if (lvl == null) {
                return;
            }
            class_2586 be = lvl.method_8321(pos);
            if (be instanceof PocketCubeBlockEntity) {
                PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
                try {
                    cube.clearCachedVillager();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class_2338 getCachedPos() {
        return cachedPos;
    }

    public static boolean clientHasWorkstation() {
        return hasWorkstation;
    }

    public static void clearCached() {
        cachedPos = null;
    }

    public static void clearCachesFor(class_2338 pos) {
        if (pos == null) {
            return;
        }
        if (pos.equals((Object)cachedPos)) {
            cachedPos = null;
        }
    }

    public static void setAwaitingSync(class_2338 pos) {
    }

    public static class OfferInfo {
        public final String fingerprint;
        public final int xp;
        public final String diag;

        public OfferInfo(String fingerprint, int xp) {
            this(fingerprint, xp, "");
        }

        public OfferInfo(String fingerprint, int xp, String diag) {
            this.fingerprint = fingerprint;
            this.xp = xp;
            this.diag = diag == null ? "" : diag;
        }

        public String toString() {
            return "OfferInfo[f=" + this.fingerprint + " xp=" + this.xp + " diag=" + this.diag + "]";
        }
    }
}

