/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Method;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RefreshTradesPacket(class_2338 pos, boolean silent, int desiredCount) implements class_8710
{
    public static final class_9139<class_2540, RefreshTradesPacket> CODEC = class_9139.method_56436((class_9139)class_2338.field_48404, RefreshTradesPacket::pos, (class_9139)class_9135.field_48547, RefreshTradesPacket::silent, (class_9139)class_9135.field_49675, RefreshTradesPacket::desiredCount, RefreshTradesPacket::new);
    public static final class_8710.class_9154<RefreshTradesPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"refresh_trades"));

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(TYPE, (packet, context) -> {
            class_3222 player = context.player();
            class_2338 pos = packet.pos();
            context.server().execute(() -> {
                String typeStr;
                class_1937 world = player.method_37908();
                if (world == null) {
                    return;
                }
                class_2586 be = world.method_8321(pos);
                if (!(be instanceof PocketCubeBlockEntity)) {
                    return;
                }
                PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
                if (!cube.hasVillager()) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"No villager data to refresh"));
                    return;
                }
                class_2487 originalData = cube.getVillagerData();
                class_3852 originalProfession = class_3852.field_17051;
                class_3854 originalType = class_3854.field_17073;
                if (originalData.method_10573("VillagerData", 10)) {
                    class_2487 vdTag = originalData.method_10562("VillagerData");
                    if (vdTag.method_10545("profession")) {
                        originalProfession = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)vdTag.method_10558("profession")));
                    }
                    if (vdTag.method_10545("type")) {
                        originalType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)vdTag.method_10558("type")));
                    }
                }
                if (originalProfession == class_3852.field_17051 && originalData.method_10545("VillagerData.profession")) {
                    originalProfession = (class_3852)class_7923.field_41195.method_10223(class_2960.method_60654((String)originalData.method_10558("VillagerData.profession")));
                }
                if (originalData.method_10545("VillagerData.type") && !"minecraft:none".equals(typeStr = originalData.method_10558("VillagerData.type"))) {
                    originalType = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)typeStr));
                }
                int xp = originalData.method_10545("Xp") ? originalData.method_10550("Xp") : 0;
                int level = 1;
                if (originalData.method_10573("VillagerData", 10)) {
                    class_2487 vdTag = originalData.method_10562("VillagerData");
                    if (vdTag.method_10545("level")) {
                        level = vdTag.method_10550("level");
                    }
                } else if (originalData.method_10545("VillagerData.level")) {
                    level = originalData.method_10550("VillagerData.level");
                }
                if (xp > 0 || level > 1) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cCannot refresh: villager has progressed."));
                    return;
                }
                try {
                    class_1916 offers;
                    class_2487 freshVillagerData = originalData.method_10553();
                    freshVillagerData.method_10551("Offers");
                    class_2487 nestedVD = new class_2487();
                    nestedVD.method_10582("profession", class_7923.field_41195.method_10221((Object)originalProfession).toString());
                    nestedVD.method_10582("type", class_7923.field_41194.method_10221((Object)originalType).toString());
                    nestedVD.method_10569("level", 1);
                    freshVillagerData.method_10566("VillagerData", (class_2520)nestedVD);
                    class_1646 refreshedVillager = VillagerDataHandler.regenerateBaseOffers((class_3218)player.method_37908(), pos, freshVillagerData, packet.desiredCount());
                    if (refreshedVillager == null) {
                        player.method_43496((class_2561)class_2561.method_43470((String)"Failed to refresh trades."));
                        return;
                    }
                    class_3850 currentData = refreshedVillager.method_7231();
                    boolean changed = false;
                    if (currentData.method_16924() != originalProfession) {
                        currentData = currentData.method_16921(originalProfession);
                        changed = true;
                    }
                    if (currentData.method_16919() != originalType) {
                        currentData = currentData.method_16922(originalType);
                        changed = true;
                    }
                    if (changed) {
                        refreshedVillager.method_7195(currentData);
                        if (refreshedVillager instanceof CubeVillager) {
                            CubeVillager cv = (CubeVillager)refreshedVillager;
                            if (refreshedVillager.method_8264().isEmpty()) {
                                cv.method_7237();
                            }
                        }
                    }
                    if ((offers = refreshedVillager.method_8264()) == null || offers.isEmpty()) {
                        player.method_43496((class_2561)class_2561.method_43470((String)"No trades available."));
                        return;
                    }
                    if (refreshedVillager instanceof CubeVillager) {
                        CubeVillager cv = (CubeVillager)refreshedVillager;
                        if (originalData.method_10545("PocketVillagers.Conversions")) {
                            cv.setConversionCount(originalData.method_10550("PocketVillagers.Conversions"));
                        }
                    }
                    class_2487 finalNbt = new class_2487();
                    finalNbt.method_10569("Xp", refreshedVillager.method_19269());
                    if (originalData.method_10545("PocketVillagers.Conversions")) {
                        finalNbt.method_10569("PocketVillagers.Conversions", originalData.method_10550("PocketVillagers.Conversions"));
                    }
                    class_2487 vd = new class_2487();
                    vd.method_10582("profession", class_7923.field_41195.method_10221((Object)refreshedVillager.method_7231().method_16924()).toString());
                    vd.method_10582("type", class_7923.field_41194.method_10221((Object)refreshedVillager.method_7231().method_16919()).toString());
                    vd.method_10569("level", refreshedVillager.method_7231().method_16925());
                    finalNbt.method_10566("VillagerData", (class_2520)vd);
                    try {
                        class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_3218)player.method_37908()).method_30349());
                        finalNbt.method_10566("Offers", (class_2520)class_1916.field_48850.encodeStart((DynamicOps)ops, (Object)offers).getOrThrow());
                    }
                    catch (Throwable ops) {
                        // empty catch block
                    }
                    cube.setVillagerData(finalNbt);
                    int xpNow = refreshedVillager.method_19269();
                    int levelNum = refreshedVillager.method_7231().method_16925();
                    class_1916 offersToSend = offers;
                    try {
                        Class<?> villagerDuckClass = Class.forName("net.ramixin.visibletraders.ducks.VillagerDuck");
                        if (villagerDuckClass.isInstance(refreshedVillager)) {
                            Method regenerateMethod = villagerDuckClass.getMethod("visibleTrades$regenerateTrades", new Class[0]);
                            regenerateMethod.invoke((Object)refreshedVillager, new Object[0]);
                            Method getCombinedMethod = villagerDuckClass.getMethod("visibleTraders$getCombinedOffers", new Class[0]);
                            Object combined = getCombinedMethod.invoke((Object)refreshedVillager, new Object[0]);
                            if (combined instanceof class_1916) {
                                offersToSend = (class_1916)combined;
                            }
                        }
                    }
                    catch (Throwable villagerDuckClass) {
                        // empty catch block
                    }
                    int containerId = player.field_7512 != null ? player.field_7512.field_7763 : -1;
                    int packedLevel = 0 | levelNum & 0xFF;
                    try {
                        SyncPocketCubePayload.send(player, pos, cube.hasWorkstation(), levelNum, xpNow);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (player.field_7512 != null) {
                        try {
                            player.field_7512.method_34245(2, class_1799.field_8037);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    player.method_17354(containerId, offersToSend, packedLevel, xpNow, true, false);
                    if (!packet.silent()) {
                        player.method_43496((class_2561)class_2561.method_43470((String)"Trades refreshed."));
                    }
                }
                catch (Throwable t) {
                    PocketVillagersMod.LOGGER.warn("RefreshTradesPacket: regeneration failed: {}", (Object)t.toString());
                    player.method_43496((class_2561)class_2561.method_43470((String)"Failed to regenerate trades."));
                }
            });
        });
    }
}

