/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.lang.reflect.Method;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.BreederPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.ConverterPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FarmingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.FishingPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.IronFarmPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.MiningPocketCubeBlockEntity;
import net.mcreator.pocketvillagers.block.entity.StoragePocketCubeBlockEntity;
import net.mcreator.pocketvillagers.network.ClearIronFarmPreviewPayload;
import net.mcreator.pocketvillagers.network.SyncBreederMenuPayload;
import net.mcreator.pocketvillagers.util.VillagerDataHandler;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record ReleaseStorageVillagerPacket(class_2338 pos, int villagerIndex) implements class_8710
{
    public static final class_8710.class_9154<ReleaseStorageVillagerPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"release_storage_villager"));
    public static final class_2960 ID = class_2960.method_60655((String)"pocket_villagers", (String)"release_storage_villager");
    public static final class_9139<class_2540, ReleaseStorageVillagerPacket> CODEC = new class_9139<class_2540, ReleaseStorageVillagerPacket>(){

        public ReleaseStorageVillagerPacket decode(class_2540 buf) {
            class_2338 pos = (class_2338)class_2338.field_48404.decode((Object)buf);
            int villagerIndex = buf.readInt();
            return new ReleaseStorageVillagerPacket(pos, villagerIndex);
        }

        public void encode(class_2540 buf, ReleaseStorageVillagerPacket packet) {
            class_2338.field_48404.encode((Object)buf, (Object)packet.pos);
            buf.method_53002(packet.villagerIndex);
        }
    };

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void register() {
        ServerPlayNetworking.registerGlobalReceiver(TYPE, (packet, context) -> {
            class_3222 player = context.player();
            class_2338 pos = packet.pos();
            int villagerIndex = packet.villagerIndex();
            context.server().execute(() -> ReleaseStorageVillagerPacket.performRelease(player, pos, villagerIndex));
        });
    }

    private static void performRelease(class_3222 player, class_2338 pos, int villagerIndex) {
        try {
            FishingPocketCubeBlockEntity fishing;
            FarmingPocketCubeBlockEntity farming;
            MiningPocketCubeBlockEntity mining;
            if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                return;
            }
            class_2586 blockEntity = player.method_37908().method_8321(pos);
            if (blockEntity instanceof IronFarmPocketCubeBlockEntity) {
                class_2487 data;
                IronFarmPocketCubeBlockEntity ironFarm = (IronFarmPocketCubeBlockEntity)blockEntity;
                if (villagerIndex >= 1 && villagerIndex <= 3 && ironFarm.hasVillager(villagerIndex) && (data = ironFarm.getVillagerData(villagerIndex)) != null && !data.method_33133()) {
                    ReleaseStorageVillagerPacket.spawnVillager(player, pos, data.method_10553());
                    ironFarm.setVillagerData(villagerIndex, new class_2487());
                    ironFarm.method_5431();
                    ironFarm.sendMenuStateUpdateToViewers();
                    player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                    int mask = 0;
                    if (ironFarm.hasVillager(1)) {
                        mask |= 1;
                    }
                    if (ironFarm.hasVillager(2)) {
                        mask |= 2;
                    }
                    if (ironFarm.hasVillager(3)) {
                        mask |= 4;
                    }
                    if (mask == 0) {
                        try {
                            ClearIronFarmPreviewPayload.send(player, pos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"Villager Released!"), true);
                }
                return;
            }
            if (blockEntity instanceof ConverterPocketCubeBlockEntity) {
                ConverterPocketCubeBlockEntity converter = (ConverterPocketCubeBlockEntity)blockEntity;
                try {
                    if (converter.getConversionStage() == ConverterPocketCubeBlockEntity.ConversionStage.CURING) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"Cannot release while curing"), true);
                        return;
                    }
                }
                catch (Throwable data) {
                    // empty catch block
                }
                if (!converter.hasVillager()) {
                    return;
                }
                ReleaseStorageVillagerPacket.spawnVillager(player, pos, converter.getVillagerData().method_10553());
                converter.setVillagerData(new class_2487());
                converter.method_5431();
                player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                player.method_7346();
                return;
            }
            if (blockEntity instanceof StoragePocketCubeBlockEntity) {
                StoragePocketCubeBlockEntity cubeEntity = (StoragePocketCubeBlockEntity)blockEntity;
                if (villagerIndex < 0 || villagerIndex >= cubeEntity.getVillagerCount()) {
                    return;
                }
                class_2487 data = cubeEntity.getVillager(villagerIndex);
                if (data != null) {
                    ReleaseStorageVillagerPacket.spawnVillager(player, pos, data.method_10553());
                    cubeEntity.removeVillager(villagerIndex);
                    cubeEntity.method_5431();
                    player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                    player.method_7346();
                }
                return;
            }
            if (blockEntity instanceof BreederPocketCubeBlockEntity) {
                BreederPocketCubeBlockEntity breeder = (BreederPocketCubeBlockEntity)blockEntity;
                if (villagerIndex >= 100) {
                    int babyIdx = villagerIndex - 100;
                    if (breeder.hasBaby(babyIdx) && breeder.getBabyGrowthPercent(babyIdx) >= 100) {
                        breeder.releaseGrownBabyToWorld(player.method_37908(), pos.method_10084(), babyIdx);
                        breeder.method_5431();
                        player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                        player.method_7346();
                    }
                    return;
                }
                if ((villagerIndex == 1 || villagerIndex == 2) && breeder.hasVillager(villagerIndex)) {
                    ReleaseStorageVillagerPacket.spawnVillager(player, pos, breeder.getVillagerData(villagerIndex).method_10553());
                    breeder.setVillagerData(villagerIndex, new class_2487());
                    breeder.method_5431();
                    player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                    try {
                        SyncBreederMenuPayload.send(player, pos, 0, breeder.getBedCount(), 0, breeder.getBreedIntervalTicks(), breeder.hasVillager(1), breeder.hasVillager(2), false, false, false, 0.0, 0.0, 0.0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    player.method_7346();
                }
                return;
            }
            if (blockEntity instanceof MiningPocketCubeBlockEntity && (mining = (MiningPocketCubeBlockEntity)blockEntity).hasVillager()) {
                ReleaseStorageVillagerPacket.spawnVillager(player, pos, mining.getVillagerData().method_10553());
                mining.setVillagerData(new class_2487());
                mining.method_5431();
                player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                player.method_7346();
                return;
            }
            if (blockEntity instanceof FarmingPocketCubeBlockEntity && (farming = (FarmingPocketCubeBlockEntity)blockEntity).hasVillager()) {
                ReleaseStorageVillagerPacket.spawnVillager(player, pos, farming.getVillagerData().method_10553());
                farming.setVillagerData(new class_2487());
                farming.method_5431();
                player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                player.method_7346();
                return;
            }
            if (blockEntity instanceof FishingPocketCubeBlockEntity && (fishing = (FishingPocketCubeBlockEntity)blockEntity).hasVillager()) {
                ReleaseStorageVillagerPacket.spawnVillager(player, pos, fishing.getVillagerData().method_10553());
                fishing.setVillagerData(new class_2487());
                fishing.method_5431();
                player.method_37908().method_8413(pos, player.method_37908().method_8320(pos), player.method_37908().method_8320(pos), 3);
                player.method_7346();
                return;
            }
        }
        catch (Throwable e) {
            PocketVillagersMod.LOGGER.error("ReleaseStorageVillagerPacket Error", e);
        }
    }

    private static void spawnVillager(class_3222 player, class_2338 pos, class_2487 data) {
        try {
            VillagerDataHandler.sanitizeVillagerDataProfession(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_1646 spawned = VillagerDataHandler.spawnVillagerFromData(player.method_37908(), pos.method_10084(), data, (class_1657)player);
        if (spawned != null && !data.method_10545("Offers")) {
            try {
                Method m = class_1646.class.getDeclaredMethod("m_35463_", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)spawned, new Object[0]);
            }
            catch (Throwable t) {
                try {
                    Method m2 = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                    m2.setAccessible(true);
                    m2.invoke((Object)spawned, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

