/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.network;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.client.gui.PocketTerminalScreen;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record SyncNearbyCubesPayload(List<CubeInfo> cubes) implements class_8710
{
    @Environment(value=EnvType.CLIENT)
    private static List<CubeInfo> cachedCubes = new ArrayList<CubeInfo>();
    public static final class_8710.class_9154<SyncNearbyCubesPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"pocket_villagers", (String)"sync_nearby_cubes"));
    public static final class_9139<class_2540, SyncNearbyCubesPayload> CODEC = class_9139.method_56437((buf, payload) -> {
        buf.method_53002(payload.cubes.size());
        for (CubeInfo cube : payload.cubes) {
            buf.method_10807(cube.pos);
            buf.method_10814(cube.type);
            buf.method_10814(cube.displayName);
            buf.method_53002(cube.storageCount);
            buf.method_53002(cube.storageCapacity);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<CubeInfo> cubes = new ArrayList<CubeInfo>();
        for (int i = 0; i < size; ++i) {
            class_2338 pos = buf.method_10811();
            String type = buf.method_19772();
            String displayName = buf.method_19772();
            int storageCount = buf.readInt();
            int storageCapacity = buf.readInt();
            cubes.add(new CubeInfo(pos, type, displayName, storageCount, storageCapacity));
        }
        return new SyncNearbyCubesPayload(cubes);
    });

    @Environment(value=EnvType.CLIENT)
    public static List<CubeInfo> getCachedCubes() {
        return cachedCubes;
    }

    @Environment(value=EnvType.CLIENT)
    public static void clearCache() {
        cachedCubes.clear();
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void sendToPlayer(class_3222 player, List<CubeInfo> cubes) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncNearbyCubesPayload(cubes));
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> context.client().execute(() -> {
            cachedCubes = new ArrayList<CubeInfo>(payload.cubes());
            PocketVillagersMod.LOGGER.debug("[SYNC NEARBY CUBES] Received packet with {} cubes, cached", (Object)payload.cubes().size());
            class_437 patt0$temp = context.client().field_1755;
            if (patt0$temp instanceof PocketTerminalScreen) {
                PocketTerminalScreen terminalScreen = (PocketTerminalScreen)patt0$temp;
                PocketVillagersMod.LOGGER.debug("[SYNC NEARBY CUBES] Updating terminal screen immediately");
                terminalScreen.updateNearbyCubes(payload.cubes());
            } else {
                PocketVillagersMod.LOGGER.debug("[SYNC NEARBY CUBES] Screen not ready, data cached for later");
            }
        }));
    }

    public static class CubeInfo {
        public final class_2338 pos;
        public final String type;
        public final String displayName;
        public final int storageCount;
        public final int storageCapacity;

        public CubeInfo(class_2338 pos, String type, String displayName) {
            this(pos, type, displayName, 0, 0);
        }

        public CubeInfo(class_2338 pos, String type, String displayName, int storageCount, int storageCapacity) {
            this.pos = pos;
            this.type = type;
            this.displayName = displayName;
            this.storageCount = storageCount;
            this.storageCapacity = storageCapacity;
        }

        public boolean hasSpace() {
            return this.storageCount < this.storageCapacity;
        }
    }
}

