/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.util.VillagerDataCompat;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class VillagerDataHandler {
    private static final String VILLAGER_DATA_KEY = "VillagerData";
    private static final String HAS_VILLAGER_KEY = "HasVillager";

    private static String extractProfession(class_2487 data) {
        class_2487 nested;
        if (data == null) {
            return "minecraft:none";
        }
        if (data.method_10573(VILLAGER_DATA_KEY, 10) && (nested = data.method_10562(VILLAGER_DATA_KEY)).method_10545("profession")) {
            return nested.method_10558("profession");
        }
        if (data.method_10545("PocketVillagers.SavedProfession")) {
            return data.method_10558("PocketVillagers.SavedProfession");
        }
        if (data.method_10545("VillagerData.profession")) {
            return data.method_10558("VillagerData.profession");
        }
        return "minecraft:none";
    }

    private static String extractType(class_2487 data) {
        class_2487 nested;
        if (data == null) {
            return "minecraft:plains";
        }
        if (data.method_10573(VILLAGER_DATA_KEY, 10) && (nested = data.method_10562(VILLAGER_DATA_KEY)).method_10545("type")) {
            return nested.method_10558("type");
        }
        if (data.method_10545("VillagerData.type")) {
            return data.method_10558("VillagerData.type");
        }
        return "minecraft:plains";
    }

    private static int extractLevel(class_2487 data) {
        class_2487 nested;
        if (data == null) {
            return 1;
        }
        if (data.method_10573(VILLAGER_DATA_KEY, 10) && (nested = data.method_10562(VILLAGER_DATA_KEY)).method_10545("level")) {
            return nested.method_10550("level");
        }
        if (data.method_10545("VillagerData.level")) {
            return data.method_10550("VillagerData.level");
        }
        return 1;
    }

    public static class_1916 generateOffers(class_1937 level, class_2487 villagerData, class_2338 pos) {
        return VillagerDataHandler.generateOffers(level, villagerData, 2);
    }

    public static class_1916 generateOffers(class_1937 level, class_2487 villagerData, int desiredCount) {
        try {
            VillagerDataHandler.sanitizeVillagerDataType(villagerData);
            if (!(level instanceof class_3218) || villagerData == null) {
                return new class_1916();
            }
            class_3218 slevel = (class_3218)level;
            class_2338 spawnPos = slevel.method_43126();
            class_1646 temp = new class_1646(class_1299.field_6077, (class_1937)slevel);
            temp.method_5814((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5);
            String professionStr = VillagerDataHandler.extractProfession(villagerData);
            String typeStr = VillagerDataHandler.extractType(villagerData);
            int levelVal = VillagerDataHandler.extractLevel(villagerData);
            PocketVillagersMod.LOGGER.debug("generateOffers: profession={}, type={}, level={}", (Object)professionStr, (Object)typeStr, (Object)levelVal);
            if (!"minecraft:none".equals(professionStr)) {
                class_2960 profRl = class_2960.method_60654((String)professionStr);
                class_3852 prof = (class_3852)class_7923.field_41195.method_10223(profRl);
                class_2960 typeRl = class_2960.method_60654((String)typeStr);
                class_3854 type = (class_3854)class_7923.field_41194.method_10223(typeRl);
                if (prof != null && type != null) {
                    temp.method_7195(VillagerDataCompat.withType(VillagerDataCompat.withProfession(temp.method_7231(), prof), type));
                    try {
                        class_4208 gp = class_4208.method_19443((class_5321)slevel.method_27983(), (class_2338)spawnPos);
                        temp.method_18868().method_24525(class_4140.field_18439, (Object)gp, 999999999L);
                    }
                    catch (Throwable gp) {
                        // empty catch block
                    }
                }
                temp.method_7195(temp.method_7231().method_16920(levelVal));
                temp.method_19625(0);
            }
            slevel.method_8649((class_1297)temp);
            try {
                Method m = class_1646.class.getDeclaredMethod("updateTrades", new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)temp, new Object[0]);
            }
            catch (Throwable t) {
                PocketVillagersMod.LOGGER.warn("generateOffers: updateTrades failed: {}", (Object)t.getMessage());
            }
            class_1916 out = new class_1916();
            class_1916 got = temp.method_8264();
            PocketVillagersMod.LOGGER.debug("generateOffers: temp villager has {} offers after updateTrades", (Object)(got != null ? got.size() : 0));
            if (got != null && !got.isEmpty()) {
                int take = Math.min(desiredCount, got.size());
                for (int i = 0; i < take; ++i) {
                    class_1914 o = (class_1914)got.get(i);
                    if (o == null) continue;
                    out.add((Object)o);
                }
            }
            if (out.isEmpty() && !"minecraft:none".equals(professionStr)) {
                PocketVillagersMod.LOGGER.debug("generateOffers: Using fallback VillagerTrades.TRADES map");
                Map tradesMap = class_3853.field_17067;
                block7: for (Map.Entry entry : tradesMap.entrySet()) {
                    class_2960 key = class_7923.field_41195.method_10221((Object)((class_3852)entry.getKey()));
                    if (key == null || !key.toString().equals(professionStr)) continue;
                    class_3853.class_1652[] levelTradesArray = (class_3853.class_1652[])((Int2ObjectMap)entry.getValue()).get(levelVal);
                    if (levelTradesArray == null) break;
                    ArrayList<class_3853.class_1652> shuffledList = new ArrayList<class_3853.class_1652>(Arrays.asList(levelTradesArray));
                    Collections.shuffle(shuffledList, new Random(slevel.method_8409().method_43055()));
                    for (class_3853.class_1652 factory : shuffledList) {
                        if (out.size() >= desiredCount) break block7;
                        class_1914 offer = factory.method_7246((class_1297)temp, slevel.method_8409());
                        if (offer == null) continue;
                        out.add((Object)offer);
                    }
                }
            }
            temp.method_5650(class_1297.class_5529.field_26999);
            PocketVillagersMod.LOGGER.debug("generateOffers: returning {} offers", (Object)out.size());
            return out;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("generateOffers failed: {}", (Object)t.getMessage());
            return new class_1916();
        }
    }

    public static class_1646 regenerateBaseOffers(class_3218 level, class_2338 pos, class_2487 villagerData, int desiredCount) {
        if (level == null || villagerData == null) {
            return null;
        }
        try {
            class_1916 offers;
            int conversions;
            CubeVillager cubeVillager = new CubeVillager((class_1937)level);
            cubeVillager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            String professionStr = VillagerDataHandler.extractProfession(villagerData);
            String typeStr = VillagerDataHandler.extractType(villagerData);
            int levelVal = VillagerDataHandler.extractLevel(villagerData);
            if (!"minecraft:none".equals(professionStr)) {
                try {
                    class_2960 profRl = class_2960.method_60654((String)professionStr);
                    class_3852 prof = (class_3852)class_7923.field_41195.method_10223(profRl);
                    class_2960 typeRl = class_2960.method_60654((String)typeStr);
                    class_3854 type = (class_3854)class_7923.field_41194.method_10223(typeRl);
                    if (prof != null && type != null) {
                        class_3850 currentData = cubeVillager.method_7231();
                        cubeVillager.method_7195(currentData.method_16922(type).method_16921(prof).method_16920(levelVal));
                        try {
                            Field lastValidProfField = CubeVillager.class.getDeclaredField("lastValidProfession");
                            lastValidProfField.setAccessible(true);
                            lastValidProfField.set((Object)cubeVillager, prof);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable profRl) {
                    // empty catch block
                }
                int xp = villagerData.method_10545("Xp") ? villagerData.method_10550("Xp") : 0;
                cubeVillager.method_19625(xp);
            }
            cubeVillager.method_5977(true);
            if (villagerData.method_10545("PocketVillagers.Conversions") && (conversions = villagerData.method_10550("PocketVillagers.Conversions")) > 0) {
                cubeVillager.setConversionCount(conversions);
                PocketVillagersMod.LOGGER.debug("regenerateBaseOffers: Set conversionCount={} on new CubeVillager", (Object)conversions);
            }
            if ((offers = VillagerDataHandler.generateOffers((class_1937)level, villagerData, desiredCount)) != null) {
                cubeVillager.method_16917(offers);
            }
            return cubeVillager;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.error("regenerateBaseOffers failed: {}", (Object)t.getMessage());
            return null;
        }
    }

    public static void saveVillagerDataToCube(class_1937 level, class_2338 pos, CubeVillager villager) {
        if (level == null || pos == null || villager == null) {
            return;
        }
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof PocketCubeBlockEntity)) {
            return;
        }
        PocketCubeBlockEntity cube = (PocketCubeBlockEntity)be;
        class_2487 existingData = cube.getVillagerData();
        String existingType = null;
        if (existingData != null) {
            class_2487 vd;
            if (existingData.method_10545("VillagerData.type")) {
                existingType = existingData.method_10558("VillagerData.type");
            } else if (existingData.method_10573(VILLAGER_DATA_KEY, 10) && (vd = existingData.method_10562(VILLAGER_DATA_KEY)).method_10545("type")) {
                existingType = vd.method_10558("type");
            }
        }
        class_2487 villagerData = new class_2487();
        villagerData.method_10582("id", "minecraft:villager");
        try {
            boolean existingTypeValid;
            class_2487 vdTag;
            String validProf;
            class_3852 hardenedProf = villager.getHardenedProfession();
            String professionKey = "minecraft:none";
            if (hardenedProf != null && hardenedProf != class_3852.field_17051) {
                class_2960 key = class_7923.field_41195.method_10221((Object)hardenedProf);
                if (key != null) {
                    professionKey = key.toString();
                }
            } else {
                professionKey = VillagerDataCompat.professionToKeyString(villager.method_7231());
            }
            if (professionKey == null || professionKey.isEmpty() || professionKey.contains("Direct{null}")) {
                professionKey = "minecraft:none";
            }
            String string = validProf = professionKey != null && !professionKey.isEmpty() ? professionKey : "minecraft:none";
            if (villagerData.method_10573(VILLAGER_DATA_KEY, 10)) {
                vdTag = villagerData.method_10562(VILLAGER_DATA_KEY);
            } else {
                vdTag = new class_2487();
                villagerData.method_10566(VILLAGER_DATA_KEY, (class_2520)vdTag);
            }
            vdTag.method_10582("profession", validProf);
            String type = null;
            try {
                class_2960 typeKey;
                class_3854 villagerType = villager.method_7231().method_16919();
                if (villagerType != null && (typeKey = class_7923.field_41194.method_10221((Object)villagerType)) != null) {
                    type = typeKey.toString();
                }
            }
            catch (Throwable t2) {
                type = VillagerDataCompat.typeToKeyString(villager.method_7231());
            }
            boolean entityTypeInvalid = type == null || type.isEmpty() || "minecraft:none".equals(type) || "minecraft:plains".equals(type);
            boolean bl = existingTypeValid = existingType != null && !existingType.isEmpty() && !"minecraft:none".equals(existingType) && !"minecraft:plains".equals(existingType);
            if (entityTypeInvalid && existingTypeValid) {
                PocketVillagersMod.LOGGER.debug("saveVillagerDataToCube: Entity type was {} but preserving existing type: {}", (Object)type, (Object)existingType);
                type = existingType;
            }
            if (type == null || type.isEmpty() || "minecraft:none".equals(type)) {
                type = "minecraft:plains";
            }
            vdTag.method_10582("type", type);
            vdTag.method_10569("level", villager.method_7231().method_16925());
            villagerData.method_10582("VillagerData.profession", validProf);
            villagerData.method_10582("VillagerData.type", type);
            villagerData.method_10569("VillagerData.level", villager.method_7231().method_16925());
            villagerData.method_10569("Xp", villager.method_19269());
            villagerData.method_10582("PocketVillagers.SavedProfession", validProf);
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("saveVillagerDataToCube: Error saving hardened data: {}", (Object)t.getMessage());
        }
        class_1916 entityOffers = villager.method_8264();
        if (entityOffers != null && !entityOffers.isEmpty()) {
            VillagerDataHandler.saveOffersToTag(entityOffers, villagerData, level);
        } else {
            try {
                class_2487 existing = cube.getVillagerData();
                if (existing != null && existing.method_10545("Offers")) {
                    villagerData.method_10566("Offers", existing.method_10580("Offers").method_10707());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (villager.getConversionCount() > 0) {
                villagerData.method_10569("PocketVillagers.Conversions", villager.getConversionCount());
            }
            if (villager.getConversionTime() > 0) {
                villagerData.method_10569("ConversionTime", villager.getConversionTime());
            }
            if (villager.isFrozen()) {
                villagerData.method_10556("Frozen", true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cube.setVillagerData(villagerData);
        cube.method_5431();
        try {
            level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void saveOffersToTag(class_1916 offers, class_2487 tag, class_1937 level) {
        if (offers != null && !offers.isEmpty() && level != null) {
            try {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)level.method_30349());
                DataResult result = class_1916.field_48850.encodeStart((DynamicOps)registryOps, (Object)offers);
                result.result().ifPresent(encoded -> tag.method_10566("Offers", encoded));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean hasVillager(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            return tag.method_10545(HAS_VILLAGER_KEY) || tag.method_10545("Villager0") || tag.method_10545(VILLAGER_DATA_KEY);
        }
        return false;
    }

    public static class_2487 getVillagerData(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            if (tag.method_10545(VILLAGER_DATA_KEY)) {
                return tag.method_10562(VILLAGER_DATA_KEY).method_10553();
            }
            if (tag.method_10545("Villager0")) {
                return tag.method_10562("Villager0").method_10553();
            }
        }
        return new class_2487();
    }

    public static void clearVillagerData(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData != null) {
            class_2487 tag = customData.method_57461();
            tag.method_10551(VILLAGER_DATA_KEY);
            tag.method_10551(HAS_VILLAGER_KEY);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        }
    }

    public static void storeVillagerInItem(class_1799 stack, class_1646 villager, class_1937 level) {
        if (stack == null || villager == null) {
            return;
        }
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        class_2487 tag = customData != null ? customData.method_57461() : new class_2487();
        try {
            CubeVillager cv;
            int conversions;
            class_3850 vd;
            class_2487 full = new class_2487();
            villager.method_5647(full);
            if (!full.method_10545(VILLAGER_DATA_KEY)) {
                PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInItem: VillagerData missing, adding manually");
                vd = villager.method_7231();
                class_2960 profKey = class_7923.field_41195.method_10221((Object)vd.method_16924());
                class_2960 typeKey = class_7923.field_41194.method_10221((Object)vd.method_16919());
                String profession = profKey != null ? profKey.toString() : "minecraft:none";
                String type = typeKey != null ? typeKey.toString() : "minecraft:plains";
                int lvl = vd.method_16925();
                class_2487 vdTag = new class_2487();
                vdTag.method_10582("profession", profession);
                vdTag.method_10582("type", type);
                vdTag.method_10569("level", lvl);
                full.method_10566(VILLAGER_DATA_KEY, (class_2520)vdTag);
            }
            if (full.method_10545(VILLAGER_DATA_KEY)) {
                class_2487 vdTag = full.method_10562(VILLAGER_DATA_KEY);
                full.method_10582("VillagerData.profession", vdTag.method_10558("profession"));
                full.method_10582("VillagerData.type", vdTag.method_10558("type"));
                full.method_10569("VillagerData.level", vdTag.method_10550("level"));
            }
            if (!full.method_10545("Xp") || full.method_10550("Xp") == 0) {
                full.method_10569("Xp", villager.method_19269());
            }
            if (!full.method_10545("PocketVillagers.Conversions")) {
                for (String tag2 : villager.method_5752()) {
                    if (tag2 == null || !tag2.startsWith("PocketVillagers.Conversions=")) continue;
                    try {
                        int conversions2 = Integer.parseInt(tag2.substring("PocketVillagers.Conversions=".length()));
                        if (conversions2 <= 0) break;
                        full.method_10569("PocketVillagers.Conversions", conversions2);
                        PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInItem: Preserved conversion count {} from entity tag", (Object)conversions2);
                    }
                    catch (NumberFormatException conversions2) {}
                    break;
                }
            }
            if (!full.method_10545("PocketVillagers.Conversions") && villager instanceof CubeVillager && (conversions = (cv = (CubeVillager)villager).getConversionCount()) > 0) {
                full.method_10569("PocketVillagers.Conversions", conversions);
                PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInItem: Preserved conversion count {} from CubeVillager", (Object)conversions);
            }
            PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInItem: Final data:");
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has Offers: {}", (Object)full.method_10545("Offers"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has VillagerData: {}", (Object)full.method_10545(VILLAGER_DATA_KEY));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Xp: {}", (Object)full.method_10550("Xp"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - PocketVillagers.Conversions: {}", full.method_10545("PocketVillagers.Conversions") ? Integer.valueOf(full.method_10550("PocketVillagers.Conversions")) : "NOT PRESENT");
            if (full.method_10545(VILLAGER_DATA_KEY)) {
                vd = full.method_10562(VILLAGER_DATA_KEY);
                PocketVillagersMod.LOGGER.debug("[DEBUG]   - VillagerData.profession: {}", (Object)vd.method_10558("profession"));
                PocketVillagersMod.LOGGER.debug("[DEBUG]   - VillagerData.level: {}", (Object)vd.method_10550("level"));
            }
            tag.method_10566(VILLAGER_DATA_KEY, (class_2520)full);
            tag.method_10556(HAS_VILLAGER_KEY, true);
            tag.method_10551("WorkstationCount");
            tag.method_10551("FacingYaw");
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            return;
        }
        catch (Throwable t) {
            PocketVillagersMod.LOGGER.warn("[DEBUG] storeVillagerInItem: saveWithoutId FAILED, using fallback!", t);
            class_2487 villagerData = new class_2487();
            villagerData.method_10582("id", "minecraft:villager");
            try {
                class_3850 vd = villager.method_7231();
                class_2960 profKey = class_7923.field_41195.method_10221((Object)vd.method_16924());
                class_2960 typeKey = class_7923.field_41194.method_10221((Object)vd.method_16919());
                String profession = profKey != null ? profKey.toString() : "minecraft:none";
                String type = typeKey != null ? typeKey.toString() : "minecraft:plains";
                int lvl = vd.method_16925();
                class_2487 vdTag = new class_2487();
                vdTag.method_10582("profession", profession);
                vdTag.method_10582("type", type);
                vdTag.method_10569("level", lvl);
                villagerData.method_10566(VILLAGER_DATA_KEY, (class_2520)vdTag);
                villagerData.method_10582("VillagerData.profession", profession);
                villagerData.method_10582("VillagerData.type", type);
                villagerData.method_10569("VillagerData.level", lvl);
                villagerData.method_10569("Xp", villager.method_19269());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            VillagerDataHandler.saveOffersToTag(villager.method_8264(), villagerData, level);
            tag.method_10566(VILLAGER_DATA_KEY, (class_2520)villagerData);
            tag.method_10556(HAS_VILLAGER_KEY, true);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            return;
        }
    }

    public static boolean hasVillager(class_2487 blockEntityTag) {
        if (blockEntityTag == null) {
            return false;
        }
        return blockEntityTag.method_10545(HAS_VILLAGER_KEY) || blockEntityTag.method_10545(VILLAGER_DATA_KEY);
    }

    public static class_2487 getVillagerData(class_2487 blockEntityTag) {
        if (blockEntityTag == null) {
            return new class_2487();
        }
        if (blockEntityTag.method_10545(VILLAGER_DATA_KEY)) {
            return blockEntityTag.method_10562(VILLAGER_DATA_KEY).method_10553();
        }
        return new class_2487();
    }

    public static void storeVillagerInBlockEntity(class_2487 blockEntityTag, class_1646 villager, class_1937 level) {
        if (blockEntityTag == null || villager == null) {
            return;
        }
        try {
            CubeVillager cv;
            int conversions;
            class_2487 full = new class_2487();
            villager.method_5647(full);
            if (!full.method_10545(VILLAGER_DATA_KEY)) {
                PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInBlockEntity: VillagerData missing, adding manually");
                class_3850 vd = villager.method_7231();
                class_2960 profKey = class_7923.field_41195.method_10221((Object)vd.method_16924());
                class_2960 typeKey = class_7923.field_41194.method_10221((Object)vd.method_16919());
                String profession = profKey != null ? profKey.toString() : "minecraft:none";
                String type = typeKey != null ? typeKey.toString() : "minecraft:plains";
                int lvl = vd.method_16925();
                class_2487 vdTag = new class_2487();
                vdTag.method_10582("profession", profession);
                vdTag.method_10582("type", type);
                vdTag.method_10569("level", lvl);
                full.method_10566(VILLAGER_DATA_KEY, (class_2520)vdTag);
            }
            if (full.method_10545(VILLAGER_DATA_KEY)) {
                class_2487 vdTag = full.method_10562(VILLAGER_DATA_KEY);
                full.method_10582("VillagerData.profession", vdTag.method_10558("profession"));
                full.method_10582("VillagerData.type", vdTag.method_10558("type"));
                full.method_10569("VillagerData.level", vdTag.method_10550("level"));
            }
            if (!full.method_10545("Xp") || full.method_10550("Xp") == 0) {
                full.method_10569("Xp", villager.method_19269());
            }
            if (!full.method_10545("PocketVillagers.Conversions")) {
                for (String tag : villager.method_5752()) {
                    if (tag == null || !tag.startsWith("PocketVillagers.Conversions=")) continue;
                    try {
                        int conversions2 = Integer.parseInt(tag.substring("PocketVillagers.Conversions=".length()));
                        if (conversions2 <= 0) break;
                        full.method_10569("PocketVillagers.Conversions", conversions2);
                        PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInBlockEntity: Preserved conversion count {} from entity tag", (Object)conversions2);
                    }
                    catch (NumberFormatException conversions2) {}
                    break;
                }
            }
            if (!full.method_10545("PocketVillagers.Conversions") && villager instanceof CubeVillager && (conversions = (cv = (CubeVillager)villager).getConversionCount()) > 0) {
                full.method_10569("PocketVillagers.Conversions", conversions);
                PocketVillagersMod.LOGGER.debug("[DEBUG] storeVillagerInBlockEntity: Preserved conversion count {} from CubeVillager", (Object)conversions);
            }
            blockEntityTag.method_10566(VILLAGER_DATA_KEY, (class_2520)full);
            blockEntityTag.method_10556(HAS_VILLAGER_KEY, true);
            return;
        }
        catch (Throwable full) {
            class_2487 villagerData = new class_2487();
            villagerData.method_10582("id", "minecraft:villager");
            try {
                class_3850 vd = villager.method_7231();
                class_2960 profKey = class_7923.field_41195.method_10221((Object)vd.method_16924());
                class_2960 typeKey = class_7923.field_41194.method_10221((Object)vd.method_16919());
                String profession = profKey != null ? profKey.toString() : "minecraft:none";
                String type = typeKey != null ? typeKey.toString() : "minecraft:plains";
                class_2487 vdTag = new class_2487();
                vdTag.method_10582("profession", profession);
                vdTag.method_10582("type", type);
                vdTag.method_10569("level", vd.method_16925());
                villagerData.method_10566(VILLAGER_DATA_KEY, (class_2520)vdTag);
                villagerData.method_10582("VillagerData.profession", profession);
                villagerData.method_10582("VillagerData.type", type);
                villagerData.method_10569("VillagerData.level", vd.method_16925());
                villagerData.method_10569("Xp", villager.method_19269());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            VillagerDataHandler.saveOffersToTag(villager.method_8264(), villagerData, level);
            blockEntityTag.method_10566(VILLAGER_DATA_KEY, (class_2520)villagerData);
            blockEntityTag.method_10556(HAS_VILLAGER_KEY, true);
            return;
        }
    }

    public static class_1646 spawnVillagerFromData(class_1937 level, class_2338 pos, class_2487 villagerData, class_1657 player) {
        if (level == null || pos == null || villagerData == null) {
            return null;
        }
        PocketVillagersMod.LOGGER.debug("[DEBUG] spawnVillagerFromData: Incoming NBT:");
        PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has Offers: {}", (Object)villagerData.method_10545("Offers"));
        PocketVillagersMod.LOGGER.debug("[DEBUG]   - Has VillagerData: {}", (Object)villagerData.method_10545(VILLAGER_DATA_KEY));
        PocketVillagersMod.LOGGER.debug("[DEBUG]   - Xp: {}", (Object)villagerData.method_10550("Xp"));
        if (villagerData.method_10545(VILLAGER_DATA_KEY)) {
            class_2487 vd = villagerData.method_10562(VILLAGER_DATA_KEY);
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - VillagerData.profession: {}", (Object)vd.method_10558("profession"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - VillagerData.type: {}", (Object)vd.method_10558("type"));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - VillagerData.level: {}", (Object)vd.method_10550("level"));
        }
        if (villagerData.method_10545("VillagerData.type")) {
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Flat VillagerData.type: {}", (Object)villagerData.method_10558("VillagerData.type"));
        }
        PocketVillagersMod.LOGGER.debug("[DEBUG]   - Top-level keys: {}", (Object)villagerData.method_10541());
        VillagerDataHandler.sanitizeVillagerDataProfession(villagerData);
        VillagerDataHandler.sanitizeVillagerDataType(villagerData);
        try {
            int conversions;
            class_1646 villager = new class_1646(class_1299.field_6077, level);
            villager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
            class_2487 spawnTag = villagerData.method_10553();
            spawnTag.method_10551("Pos");
            spawnTag.method_10551("Motion");
            villager.method_5651(spawnTag);
            try {
                class_3854 type;
                String typeStr = null;
                if (villagerData.method_10545("VillagerData.type")) {
                    typeStr = villagerData.method_10558("VillagerData.type");
                } else if (villagerData.method_10545(VILLAGER_DATA_KEY) && villagerData.method_10562(VILLAGER_DATA_KEY).method_10545("type")) {
                    typeStr = villagerData.method_10562(VILLAGER_DATA_KEY).method_10558("type");
                }
                if (typeStr != null && !typeStr.isEmpty() && !"minecraft:plains".equals(typeStr) && (type = (class_3854)class_7923.field_41194.method_10223(class_2960.method_60654((String)typeStr))) != null && villager.method_7231().method_16919() != type) {
                    villager.method_7195(villager.method_7231().method_16922(type));
                    PocketVillagersMod.LOGGER.debug("[DEBUG] spawnVillagerFromData: Restored villager type to {}", (Object)typeStr);
                }
            }
            catch (Throwable typeStr) {
                // empty catch block
            }
            PocketVillagersMod.LOGGER.debug("[DEBUG] spawnVillagerFromData: After villager.load():");
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Villager Xp: {}", (Object)villager.method_19269());
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Villager Level: {}", (Object)villager.method_7231().method_16925());
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Villager Type: {}", (Object)class_7923.field_41194.method_10221((Object)villager.method_7231().method_16919()));
            PocketVillagersMod.LOGGER.debug("[DEBUG]   - Villager Offers count: {}", (Object)(villager.method_8264() != null ? villager.method_8264().size() : 0));
            if (villagerData.method_10545("PocketVillagers.Conversions") && (conversions = villagerData.method_10550("PocketVillagers.Conversions")) > 0) {
                villager.method_5752().removeIf(t -> t.startsWith("PocketVillagers.Conversions="));
                villager.method_5780("PocketVillagers.Conversions=" + conversions);
                PocketVillagersMod.LOGGER.debug("[DEBUG] spawnVillagerFromData: Added conversion tag PocketVillagers.Conversions={}", (Object)conversions);
            }
            villager.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
            villager.method_18799(class_243.field_1353);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                try {
                    String profStr = VillagerDataHandler.extractProfession(villagerData);
                    if (!"minecraft:none".equals(profStr)) {
                        class_4208 gp = class_4208.method_19443((class_5321)serverLevel.method_27983(), (class_2338)pos);
                        villager.method_18868().method_24525(class_4140.field_18439, (Object)gp, 999999999L);
                    }
                }
                catch (Throwable profStr) {
                    // empty catch block
                }
                try {
                    Method refreshBrain = class_1646.class.getDeclaredMethod("refreshBrain", class_3218.class);
                    refreshBrain.setAccessible(true);
                    refreshBrain.invoke((Object)villager, serverLevel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                villager.method_5943((class_5425)serverLevel, serverLevel.method_8404(pos), class_3730.field_16462, null);
                serverLevel.method_8649((class_1297)villager);
            } else {
                level.method_8649((class_1297)villager);
            }
            return villager;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    public static class_1646 spawnVillagerFromData(class_1937 level, class_2338 pos, class_2487 villagerData) {
        return VillagerDataHandler.spawnVillagerFromData(level, pos, villagerData, null);
    }

    public static CubeVillager createTradingVillager(class_1937 level, class_2338 pos, class_2487 villagerData) {
        VillagerDataHandler.sanitizeVillagerDataProfession(villagerData);
        try {
            PocketVillagersMod.LOGGER.debug("createTradingVillager called:");
            PocketVillagersMod.LOGGER.debug("  - Input NBT XP: {}", (Object)(villagerData != null ? villagerData.method_10550("Xp") : 0));
            PocketVillagersMod.LOGGER.debug("  - Input NBT Level: {}", (Object)(villagerData != null ? villagerData.method_10550("VillagerData.level") : 0));
            PocketVillagersMod.LOGGER.debug("  - Input NBT Has Offers: {}", (Object)(villagerData != null ? villagerData.method_10545("Offers") : false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CubeVillager cube = new CubeVillager(level);
        cube.setPocketCubePos(pos);
        try {
            cube.method_5977(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            cube.method_5803(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (villagerData != null) {
            cube.reloadDataFromNBT(villagerData);
            try {
                PocketVillagersMod.LOGGER.debug("  - After reloadDataFromNBT:");
                PocketVillagersMod.LOGGER.debug("    - Entity XP: {}", (Object)cube.method_19269());
                PocketVillagersMod.LOGGER.debug("    - Entity Level: {}", (Object)cube.method_7231().method_16925());
                PocketVillagersMod.LOGGER.debug("    - Entity Offer Count: {}", (Object)(cube.method_8264() != null ? cube.method_8264().size() : 0));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (level != null && level.field_9236) {
            try {
                cube.method_5977(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cube;
    }

    public static String toRegistryKeyString(Object candidate) {
        try {
            class_3852 villagerProfession;
            class_3854 villagerType;
            class_2960 key;
            if (candidate == null) {
                return "minecraft:none";
            }
            if (candidate instanceof class_2960) {
                return candidate.toString();
            }
            if (candidate instanceof class_3854 && (key = class_7923.field_41194.method_10221((Object)(villagerType = (class_3854)candidate))) != null) {
                return key.toString();
            }
            if (candidate instanceof class_3852 && (key = class_7923.field_41195.method_10221((Object)(villagerProfession = (class_3852)candidate))) != null) {
                return key.toString();
            }
            try {
                class_2960 key2;
                Method valueMethod = candidate.getClass().getMethod("value", new Class[0]);
                Object value = valueMethod.invoke(candidate, new Object[0]);
                if (value instanceof class_3852 && (key2 = class_7923.field_41195.method_10221((Object)((class_3852)value))) != null) {
                    return key2.toString();
                }
                if (value instanceof class_3854 && (key2 = class_7923.field_41194.method_10221((Object)((class_3854)value))) != null) {
                    return key2.toString();
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "minecraft:none";
    }

    public static void sanitizeVillagerDataProfession(class_2487 villagerData) {
        if (villagerData == null) {
            return;
        }
        String prof = VillagerDataHandler.extractProfession(villagerData);
        if (prof.startsWith("ResourceKey[")) {
            try {
                String path = prof.substring(prof.indexOf(47) + 1, prof.lastIndexOf(93)).trim();
                if (villagerData.method_10573(VILLAGER_DATA_KEY, 10)) {
                    villagerData.method_10562(VILLAGER_DATA_KEY).method_10582("profession", path);
                }
                if (villagerData.method_10545("VillagerData.profession")) {
                    villagerData.method_10582("VillagerData.profession", path);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void sanitizeVillagerDataType(class_2487 villagerData) {
        if (villagerData == null) {
            return;
        }
        String type = VillagerDataHandler.extractType(villagerData);
        if (type == null || type.isEmpty()) {
            if (villagerData.method_10573(VILLAGER_DATA_KEY, 10)) {
                villagerData.method_10562(VILLAGER_DATA_KEY).method_10582("type", "minecraft:plains");
            }
            villagerData.method_10582("VillagerData.type", "minecraft:plains");
        }
    }

    public static boolean isConvertedEntity(class_1646 villager) {
        if (villager == null) {
            return false;
        }
        for (String tag : villager.method_5752()) {
            if (!tag.startsWith("PocketVillagers.Conversions=")) continue;
            return true;
        }
        return false;
    }

    public static class_2487 toEntityNbt(class_2487 villagerData) {
        if (villagerData == null) {
            return new class_2487();
        }
        class_2487 entityNbt = new class_2487();
        entityNbt.method_10582("id", "minecraft:villager");
        for (String key : villagerData.method_10541()) {
            entityNbt.method_10566(key, villagerData.method_10580(key).method_10707());
        }
        return entityNbt;
    }
}

