/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.mcreator.pocketvillagers.block.PocketCubeBlock;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.handler.InfiniteTradesHandler;
import net.mcreator.pocketvillagers.handler.VillagerCaptureHandler;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlocks;
import net.mcreator.pocketvillagers.init.PocketVillagersModItems;
import net.mcreator.pocketvillagers.init.PocketVillagersModMenus;
import net.mcreator.pocketvillagers.init.PocketVillagersModTabs;
import net.mcreator.pocketvillagers.network.ClearIronFarmPreviewPayload;
import net.mcreator.pocketvillagers.network.EjectWorkstationPacket;
import net.mcreator.pocketvillagers.network.MenuStateUpdateC2SPacket;
import net.mcreator.pocketvillagers.network.OpenRemoteCubePayload;
import net.mcreator.pocketvillagers.network.OpenStorageFromTerminalPayload;
import net.mcreator.pocketvillagers.network.PocketTerminalPacketHandlers;
import net.mcreator.pocketvillagers.network.RefreshTradesPacket;
import net.mcreator.pocketvillagers.network.ReleasePocketVillagerPacket;
import net.mcreator.pocketvillagers.network.ReleaseStorageVillagerPacket;
import net.mcreator.pocketvillagers.network.ReopenTerminalPayload;
import net.mcreator.pocketvillagers.network.RequestStorageContentsPayload;
import net.mcreator.pocketvillagers.network.SetTerminalViewPayload;
import net.mcreator.pocketvillagers.network.StartIronFarmHologramPayload;
import net.mcreator.pocketvillagers.network.StoreVillagerToStoragePayload;
import net.mcreator.pocketvillagers.network.SyncAutoTraderOffersPayload;
import net.mcreator.pocketvillagers.network.SyncBreederMenuPayload;
import net.mcreator.pocketvillagers.network.SyncConverterMenuPayload;
import net.mcreator.pocketvillagers.network.SyncFacingYawPayload;
import net.mcreator.pocketvillagers.network.SyncFarmingMenuPayload;
import net.mcreator.pocketvillagers.network.SyncFishingMenuPayload;
import net.mcreator.pocketvillagers.network.SyncIronFarmMenuPayload;
import net.mcreator.pocketvillagers.network.SyncMiningMenuPayload;
import net.mcreator.pocketvillagers.network.SyncNearbyCubesPayload;
import net.mcreator.pocketvillagers.network.SyncPocketCubePayload;
import net.mcreator.pocketvillagers.network.SyncStorageContentsPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalFuelPayload;
import net.mcreator.pocketvillagers.network.SyncTerminalVillagersPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerBetweenCubesPayload;
import net.mcreator.pocketvillagers.network.TransferVillagerPayload;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PocketVillagersMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(PocketVillagersMod.class);
    public static final String MODID = "pocket_villagers";
    public static final Map<String, String> COMPAT_WORKSTATION_PROFESSION = new ConcurrentHashMap<String, String>();
    private static final Collection<class_3545<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<class_3545<Runnable, Integer>>();
    private static Object minecraft;
    private static MethodHandle playerHandle;

    public void onInitialize() {
        LOGGER.info("Initializing PocketVillagersMod");
        PocketVillagersConfig.getInstance();
        LOGGER.info("Config loaded");
        PocketVillagersModTabs.load();
        PocketVillagersModBlocks.load();
        PocketVillagersModBlockEntities.load();
        PocketVillagersModItems.load();
        PocketVillagersModMenus.load();
        PocketVillagersMod.loadCompatMappings();
        VillagerCaptureHandler.register();
        InfiniteTradesHandler.register();
        try {
            Map<String, String> discovered = PocketVillagersMod.loadDiscoveredPoiCache();
            if (discovered != null && !discovered.isEmpty()) {
                LOGGER.debug("Loaded {} discovered POI->profession entries", (Object)discovered.size());
                PocketCubeBlock.loadPoiCache(discovered);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
                try {
                    class_2338 pos = hitResult.method_17777();
                    class_2680 bs = world.method_8320(pos);
                    String id = "<unknown>";
                    try {
                        id = class_7923.field_41175.method_10221((Object)bs.method_26204()).toString();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LOGGER.debug("UseBlockCallback: player={} pos={} block={} clientSide={}", (Object)(player == null ? "<null>" : player.method_5477().getString()), (Object)pos, (Object)id, (Object)world.method_8608());
                }
                catch (Throwable e) {
                    LOGGER.error("Error in UseBlockCallback", e);
                }
                return class_1269.field_5811;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playC2S().register(ReleasePocketVillagerPacket.TYPE, ReleasePocketVillagerPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(ReleaseStorageVillagerPacket.TYPE, ReleaseStorageVillagerPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(EjectWorkstationPacket.TYPE, EjectWorkstationPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(RefreshTradesPacket.TYPE, RefreshTradesPacket.CODEC);
            PayloadTypeRegistry.playC2S().register(OpenRemoteCubePayload.ID, OpenRemoteCubePayload.CODEC);
            PayloadTypeRegistry.playC2S().register(ReopenTerminalPayload.ID, ReopenTerminalPayload.CODEC);
            PayloadTypeRegistry.playC2S().register(TransferVillagerBetweenCubesPayload.ID, TransferVillagerBetweenCubesPayload.CODEC);
            try {
                PayloadTypeRegistry.playC2S().register(MenuStateUpdateC2SPacket.TYPE, MenuStateUpdateC2SPacket.CODEC);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ReleasePocketVillagerPacket.register();
        ReleaseStorageVillagerPacket.register();
        EjectWorkstationPacket.register();
        RefreshTradesPacket.register();
        OpenRemoteCubePayload.register();
        ReopenTerminalPayload.register();
        TransferVillagerBetweenCubesPayload.registerServerReceiver();
        MenuStateUpdateC2SPacket.register();
        try {
            PayloadTypeRegistry.playS2C().register(SyncPocketCubePayload.TYPE, SyncPocketCubePayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(StartIronFarmHologramPayload.TYPE, StartIronFarmHologramPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(ClearIronFarmPreviewPayload.TYPE, ClearIronFarmPreviewPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncBreederMenuPayload.TYPE, SyncBreederMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncIronFarmMenuPayload.TYPE, SyncIronFarmMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncConverterMenuPayload.TYPE, SyncConverterMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncMiningMenuPayload.TYPE, SyncMiningMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncFishingMenuPayload.TYPE, SyncFishingMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncFarmingMenuPayload.TYPE, SyncFarmingMenuPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncFacingYawPayload.TYPE, SyncFacingYawPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncNearbyCubesPayload.ID, SyncNearbyCubesPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncTerminalVillagersPayload.ID, SyncTerminalVillagersPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncStorageContentsPayload.ID, SyncStorageContentsPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SyncTerminalFuelPayload.ID, SyncTerminalFuelPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playS2C().register(SetTerminalViewPayload.ID, SetTerminalViewPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playC2S().register(RequestStorageContentsPayload.ID, RequestStorageContentsPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playC2S().register(TransferVillagerPayload.ID, TransferVillagerPayload.CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playC2S().register(OpenStorageFromTerminalPayload.ID, OpenStorageFromTerminalPayload.STREAM_CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PayloadTypeRegistry.playC2S().register(StoreVillagerToStoragePayload.ID, StoreVillagerToStoragePayload.STREAM_CODEC);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PocketTerminalPacketHandlers.registerServerHandlers();
        PayloadTypeRegistry.playS2C().register(SyncAutoTraderOffersPayload.TYPE, SyncAutoTraderOffersPayload.CODEC);
    }

    private static void loadCompatMappings() {
        try {
            String text;
            JsonObject obj;
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("compat_workstation_profession.json");
            if (!Files.exists(cfgFile, new LinkOption[0])) {
                JsonObject example2;
                try (InputStream in = PocketVillagersMod.class.getResourceAsStream("/config/pocket_villagers/compat_workstation_profession.json");){
                    if (in != null) {
                        Files.copy(in, cfgFile, new CopyOption[0]);
                        LOGGER.info("Wrote default compat mappings from packaged resource to {}", (Object)cfgFile.toString());
                    } else {
                        example2 = new JsonObject();
                        example2.addProperty("morevillagers:gardening_table", "morevillagers:florist");
                        Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)example2), new OpenOption[0]);
                        LOGGER.info("Wrote example compat mappings to {}", (Object)cfgFile.toString());
                    }
                }
                catch (Throwable t) {
                    try {
                        example2 = new JsonObject();
                        example2.addProperty("morevillagers:gardening_table", "morevillagers:florist");
                        Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)example2), new OpenOption[0]);
                        LOGGER.warn("Failed to copy packaged compat file, wrote example instead: {}", (Object)t.toString());
                    }
                    catch (Throwable example2) {
                        // empty catch block
                    }
                }
            }
            if ((obj = (JsonObject)new Gson().fromJson(text = Files.readString(cfgFile), JsonObject.class)) != null) {
                for (Map.Entry e : obj.entrySet()) {
                    try {
                        COMPAT_WORKSTATION_PROFESSION.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            LOGGER.info("Loaded {} workstation->profession compatibility entries", (Object)COMPAT_WORKSTATION_PROFESSION.size());
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to load compat mappings: {}", (Object)t.toString());
        }
    }

    public static synchronized void saveCompatMapping(String blockId, String professionId) {
        try {
            if (blockId == null || professionId == null) {
                return;
            }
            COMPAT_WORKSTATION_PROFESSION.put(blockId, professionId);
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("compat_workstation_profession.json");
            JsonObject obj = new JsonObject();
            for (Map.Entry<String, String> e : COMPAT_WORKSTATION_PROFESSION.entrySet()) {
                try {
                    obj.addProperty(e.getKey(), e.getValue());
                }
                catch (Throwable throwable) {}
            }
            Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)obj), new OpenOption[0]);
            LOGGER.info("Saved compat mapping {} -> {}", (Object)blockId, (Object)professionId);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to save compat mapping {} -> {}: {}", (Object)blockId, (Object)professionId, (Object)t.toString());
        }
    }

    public static synchronized Map<String, String> loadDiscoveredPoiCache() {
        try {
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("discovered_poi_professions.json");
            if (!Files.exists(cfgFile, new LinkOption[0])) {
                try (InputStream in = PocketVillagersMod.class.getResourceAsStream("/config/pocket_villagers/discovered_poi_professions.json");){
                    if (in != null) {
                        Files.copy(in, cfgFile, new CopyOption[0]);
                        LOGGER.info("Wrote default discovered POI mappings from packaged resource to {}", (Object)cfgFile.toString());
                    } else {
                        Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)new JsonObject()), new OpenOption[0]);
                        LOGGER.info("Wrote empty discovered POI mappings to {}", (Object)cfgFile.toString());
                    }
                }
                catch (Throwable t) {
                    try {
                        Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)new JsonObject()), new OpenOption[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            String text = Files.readString(cfgFile);
            JsonObject obj = (JsonObject)new Gson().fromJson(text, JsonObject.class);
            HashMap<String, String> map = new HashMap<String, String>();
            if (obj != null) {
                for (Map.Entry e : obj.entrySet()) {
                    try {
                        map.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                    catch (Throwable throwable) {}
                }
            }
            return map;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to load discovered POI cache: {}", (Object)t.toString());
            return new HashMap<String, String>();
        }
    }

    public static synchronized void saveDiscoveredPoiMapping(String poiKey, String professionId) {
        try {
            if (poiKey == null || professionId == null) {
                return;
            }
            Path cfgDir = Path.of("config", MODID);
            Files.createDirectories(cfgDir, new FileAttribute[0]);
            Path cfgFile = cfgDir.resolve("discovered_poi_professions.json");
            JsonObject obj = new JsonObject();
            if (Files.exists(cfgFile, new LinkOption[0])) {
                try {
                    String existing = Files.readString(cfgFile);
                    JsonObject ex = (JsonObject)new Gson().fromJson(existing, JsonObject.class);
                    if (ex != null) {
                        obj = ex;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            obj.addProperty(poiKey, professionId);
            Files.writeString(cfgFile, (CharSequence)new Gson().toJson((JsonElement)obj), new OpenOption[0]);
            LOGGER.info("Saved discovered POI mapping {} -> {}", (Object)poiKey, (Object)professionId);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to save discovered POI mapping {} -> {}: {}", (Object)poiKey, (Object)professionId, (Object)t.toString());
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add((class_3545<Runnable, Integer>)new class_3545((Object)action, (Object)tick));
    }

    private void tick() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.method_34965((Object)((Integer)work.method_15441() - 1));
                if ((Integer)work.method_15441() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.method_15442()).run());
            workQueue.removeAll(actions);
        });
    }

    @Nullable
    public static class_1657 clientPlayer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            try {
                if (minecraft == null || playerHandle == null) {
                    Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft");
                    minecraft = MethodHandles.publicLookup().findStatic(minecraftClass, "getInstance", MethodType.methodType(minecraftClass)).invoke();
                    playerHandle = MethodHandles.publicLookup().findGetter(minecraftClass, "player", Class.forName("net.minecraft.client.player.LocalPlayer"));
                }
                return playerHandle.invoke(minecraft);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to get client player", e);
                return null;
            }
        }
        return null;
    }
}

