/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.entity.CubeVillager;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.AutoTraderOffersCache;
import net.mcreator.pocketvillagers.network.SyncAutoTraderOffersPayload;
import net.mcreator.pocketvillagers.world.inventory.AutoTraderPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2325;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3708;
import net.minecraft.class_7225;

public class AutoTraderPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private class_2371<class_1799> tradeSlots = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private int selectedTradeIndex = -1;
    private boolean autoTradeEnabled = false;
    private int tradeCooldown = 0;
    private int inputCooldown = 0;
    private int outputCooldown = 0;
    private static final int TRADE_COOLDOWN_TICKS = 40;
    private static final int INPUT_OUTPUT_COOLDOWN = 20;

    public AutoTraderPocketCubeBlockEntity(class_2338 pos, class_2680 state) {
        super(PocketVillagersModBlockEntities.AUTO_TRADER_POCKET_CUBE, pos, state);
    }

    @Override
    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.tradeSlots = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)valueInput, this.tradeSlots);
        this.selectedTradeIndex = valueInput.method_71424("SelectedTradeIndex", -1);
        this.autoTradeEnabled = valueInput.method_71433("AutoTradeEnabled", false);
        this.tradeCooldown = valueInput.method_71424("TradeCooldown", 0);
        this.inputCooldown = valueInput.method_71424("InputCooldown", 0);
        this.outputCooldown = valueInput.method_71424("OutputCooldown", 0);
    }

    @Override
    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        class_1262.method_5426((class_11372)valueOutput, this.tradeSlots);
        valueOutput.method_71465("SelectedTradeIndex", this.selectedTradeIndex);
        valueOutput.method_71472("AutoTradeEnabled", this.autoTradeEnabled);
        valueOutput.method_71465("TradeCooldown", this.tradeCooldown);
        valueOutput.method_71465("InputCooldown", this.inputCooldown);
        valueOutput.method_71465("OutputCooldown", this.outputCooldown);
    }

    @Override
    public void load(class_2487 tag) {
        super.load(tag);
        this.selectedTradeIndex = tag.method_10550("SelectedTradeIndex").orElse(-1);
        this.autoTradeEnabled = tag.method_10577("AutoTradeEnabled").orElse(false);
        this.tradeCooldown = tag.method_10550("TradeCooldown").orElse(0);
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        tag.method_10556("AutoTradeEnabled", this.autoTradeEnabled);
        tag.method_10569("SelectedTradeIndex", this.selectedTradeIndex);
        return tag;
    }

    @Override
    public void load(class_2487 tag, class_7225.class_7874 registries) {
        super.load(tag, registries);
        if (tag.method_10545("AutoTradeEnabled")) {
            this.autoTradeEnabled = tag.method_10577("AutoTradeEnabled").orElse(false);
        }
        if (tag.method_10545("SelectedTradeIndex")) {
            this.selectedTradeIndex = tag.method_10550("SelectedTradeIndex").orElse(-1);
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void serverTick(class_1937 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        if (this.tradeCooldown > 0) {
            --this.tradeCooldown;
        }
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
        }
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
        }
        if (this.inputCooldown <= 0) {
            this.pullItemsFromAbove(level);
            this.inputCooldown = 20;
        }
        if (this.outputCooldown <= 0) {
            this.pushItemsBelow(level);
            this.outputCooldown = 20;
        }
        if (this.autoTradeEnabled && this.tradeCooldown <= 0) {
            this.attemptAutoTrade(level);
            this.tradeCooldown = 40;
        }
    }

    private void attemptAutoTrade(class_1937 level) {
        if (!this.hasVillager()) {
            return;
        }
        if (this.selectedTradeIndex < 0) {
            return;
        }
        CubeVillager villager = this.getOrCreateCachedVillager(level);
        if (villager == null) {
            PocketVillagersMod.LOGGER.warn("AutoTrader: Failed to get villager entity");
            return;
        }
        class_1916 offers = villager.method_8264();
        if (this.selectedTradeIndex >= offers.size()) {
            PocketVillagersMod.LOGGER.warn("AutoTrader: Trade index {} out of bounds (size={})", (Object)this.selectedTradeIndex, (Object)offers.size());
            return;
        }
        class_1914 offer = (class_1914)offers.get(this.selectedTradeIndex);
        class_1799 ingredientStack1 = offer.method_19272();
        class_1799 ingredientStack2 = offer.method_8247();
        class_1799 resultStack = offer.method_8250();
        PocketVillagersMod.LOGGER.debug("AutoTrader: Attempting trade #{} - Cost1: {}x{}, Cost2: {}x{}, Result: {}x{}, SpecialPriceDiff: {}", (Object)this.selectedTradeIndex, (Object)ingredientStack1.method_7947(), (Object)ingredientStack1.method_7909().toString(), (Object)(ingredientStack2.method_7960() ? 0 : ingredientStack2.method_7947()), (Object)(ingredientStack2.method_7960() ? "none" : ingredientStack2.method_7909().toString()), (Object)resultStack.method_7947(), (Object)resultStack.method_7909().toString(), (Object)offer.method_19277());
        if (!this.canTakeIngredients(ingredientStack1, ingredientStack2)) {
            return;
        }
        if (!this.canPlaceResult(resultStack)) {
            return;
        }
        this.takeIngredients(ingredientStack1, ingredientStack2);
        this.placeResult(resultStack);
        this.method_5431();
    }

    private boolean canTakeIngredients(class_1799 ingredient1, class_1799 ingredient2) {
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 8; ++i) {
            class_1799 slot = (class_1799)this.tradeSlots.get(i);
            if (class_1799.method_7984((class_1799)slot, (class_1799)ingredient1)) {
                count1 += slot.method_7947();
            }
            if (ingredient2.method_7960() || !class_1799.method_7984((class_1799)slot, (class_1799)ingredient2)) continue;
            count2 += slot.method_7947();
        }
        return count1 >= ingredient1.method_7947() && (ingredient2.method_7960() || count2 >= ingredient2.method_7947());
    }

    private boolean canPlaceResult(class_1799 result) {
        for (int i = 8; i < 12; ++i) {
            class_1799 slot = (class_1799)this.tradeSlots.get(i);
            if (slot.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)slot, (class_1799)result) || slot.method_7947() + result.method_7947() > slot.method_7914()) continue;
            return true;
        }
        return false;
    }

    private void takeIngredients(class_1799 ingredient1, class_1799 ingredient2) {
        int needed1 = ingredient1.method_7947();
        int needed2 = ingredient2.method_7960() ? 0 : ingredient2.method_7947();
        for (int i = 0; i < 8 && (needed1 > 0 || needed2 > 0); ++i) {
            int taken;
            class_1799 slot = (class_1799)this.tradeSlots.get(i);
            if (slot.method_7960()) continue;
            if (needed1 > 0 && class_1799.method_7984((class_1799)slot, (class_1799)ingredient1)) {
                taken = Math.min(slot.method_7947(), needed1);
                slot.method_7934(taken);
                needed1 -= taken;
            }
            if (needed2 <= 0 || !class_1799.method_7984((class_1799)slot, (class_1799)ingredient2)) continue;
            taken = Math.min(slot.method_7947(), needed2);
            slot.method_7934(taken);
            needed2 -= taken;
        }
    }

    private void placeResult(class_1799 result) {
        class_1799 slot;
        int i;
        class_1799 resultCopy = result.method_7972();
        for (i = 8; i < 12 && !resultCopy.method_7960(); ++i) {
            int canAdd;
            slot = (class_1799)this.tradeSlots.get(i);
            if (slot.method_7960() || !class_1799.method_7984((class_1799)slot, (class_1799)resultCopy) || (canAdd = Math.min(resultCopy.method_7947(), slot.method_7914() - slot.method_7947())) <= 0) continue;
            slot.method_7933(canAdd);
            resultCopy.method_7934(canAdd);
        }
        for (i = 8; i < 12 && !resultCopy.method_7960(); ++i) {
            slot = (class_1799)this.tradeSlots.get(i);
            if (!slot.method_7960()) continue;
            this.tradeSlots.set(i, (Object)resultCopy.method_7972());
            resultCopy.method_7939(0);
            break;
        }
    }

    private CubeVillager getOrCreateCachedVillager(class_1937 level) {
        class_2487 data = this.getVillagerData();
        if (data == null || data.method_33133()) {
            PocketVillagersMod.LOGGER.warn("getOrCreateCachedVillager: villagerData is null or empty");
            return null;
        }
        try {
            CubeVillager villager = new CubeVillager(level);
            villager.reloadDataFromNBT(data);
            villager.setFrozen(true);
            return villager;
        }
        catch (Throwable e) {
            PocketVillagersMod.LOGGER.error("getOrCreateCachedVillager: Exception during villager creation/reload: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        AutoTraderPocketCubeGUIMenu menu = new AutoTraderPocketCubeGUIMenu(containerId, playerInventory, this);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.hasVillager() && !AutoTraderOffersCache.hasOffers(this.method_11016())) {
                this.syncOffersToPlayer(serverPlayer);
            }
        }
        return menu;
    }

    private void syncOffersToPlayer(class_3222 player) {
        try {
            class_1916 offers;
            CubeVillager villager = this.getOrCreateCachedVillager(this.field_11863);
            if (villager != null && (offers = villager.method_8264()) != null && !offers.isEmpty()) {
                SyncAutoTraderOffersPayload.sendToPlayer(player, this.method_11016(), offers, this.selectedTradeIndex);
            }
        }
        catch (Throwable e) {
            PocketVillagersMod.LOGGER.error("Failed to sync offers to player: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Auto Trader");
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    @Override
    public int method_5439() {
        return 12;
    }

    public class_1799 method_5438(int slot) {
        if (slot >= 0 && slot < 12) {
            return (class_1799)this.tradeSlots.get(slot);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack;
        if (slot >= 0 && slot < 12 && !(stack = (class_1799)this.tradeSlots.get(slot)).method_7960()) {
            class_1799 taken = stack.method_7971(amount);
            if (stack.method_7960()) {
                this.tradeSlots.set(slot, (Object)class_1799.field_8037);
            }
            this.method_5431();
            return taken;
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack;
        if (slot >= 0 && slot < 12 && !(stack = (class_1799)this.tradeSlots.get(slot)).method_7960()) {
            this.tradeSlots.set(slot, (Object)class_1799.field_8037);
            this.method_5431();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 0 && slot < 12) {
            this.tradeSlots.set(slot, (Object)stack);
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return slot >= 0 && slot <= 11;
    }

    public void method_5448() {
        this.tradeSlots.clear();
    }

    public class_2371<class_1799> getTradeSlots() {
        return this.tradeSlots;
    }

    public class_1799 getTradeSlot(int index) {
        if (index >= 0 && index < 12) {
            return (class_1799)this.tradeSlots.get(index);
        }
        return class_1799.field_8037;
    }

    public void setTradeSlot(int index, class_1799 stack) {
        if (index >= 0 && index < 12) {
            this.tradeSlots.set(index, (Object)stack);
            this.method_5431();
        }
    }

    public int getSelectedTradeIndex() {
        return this.selectedTradeIndex;
    }

    public void setSelectedTradeIndex(int index) {
        this.selectedTradeIndex = index;
        this.method_5431();
    }

    public CubeVillager getCachedVillager() {
        if (this.field_11863 == null) {
            return null;
        }
        return this.getOrCreateCachedVillager(this.field_11863);
    }

    @Override
    public boolean hasVillager() {
        return super.hasVillager();
    }

    @Override
    public class_2487 getVillagerData() {
        return super.getVillagerData();
    }

    @Override
    public void setVillagerData(class_2487 data) {
        boolean wasRemovingVillager = data == null || data.method_33133();
        super.setVillagerData(data);
        if (wasRemovingVillager) {
            this.selectedTradeIndex = -1;
            this.method_5431();
            PocketVillagersMod.LOGGER.debug("AutoTrader: Villager removed, cleared trade preview (selectedTradeIndex reset to -1)");
        } else {
            try {
                class_1916 offers;
                CubeVillager villager;
                if (this.selectedTradeIndex < 0 && this.hasVillager() && (villager = this.getCachedVillager()) != null && (offers = villager.method_8264()) != null && !offers.isEmpty()) {
                    this.selectedTradeIndex = 0;
                    this.method_5431();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isAutoTradeEnabled() {
        return this.autoTradeEnabled;
    }

    public void setAutoTradeEnabled(boolean enabled) {
        this.autoTradeEnabled = enabled;
        this.method_5431();
    }

    @Override
    public int[] method_5494(class_2350 side) {
        try {
            if (side == class_2350.field_11033) {
                return IntStream.range(8, 12).toArray();
            }
            if (this.hasInputSpace()) {
                return IntStream.range(0, 8).toArray();
            }
            return new int[0];
        }
        catch (Throwable ignored) {
            return IntStream.range(0, this.method_5439()).toArray();
        }
    }

    private boolean hasInputSpace() {
        try {
            for (int i = 0; i < 8; ++i) {
                class_1799 s = (class_1799)this.tradeSlots.get(i);
                if (s.method_7960()) {
                    return true;
                }
                if (s.method_7947() >= s.method_7914()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean method_5492(int index, class_1799 stack, class_2350 direction) {
        return index >= 0 && index < 8;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        if (index >= 0 && index < 8) {
            return false;
        }
        return index >= 8 && index < 12;
    }

    public int getTradeCooldown() {
        return this.tradeCooldown;
    }

    public void setTradeCooldown(int cooldown) {
        this.tradeCooldown = cooldown;
    }

    private void pullItemsFromAbove(class_1937 level) {
        if (level == null) {
            return;
        }
        class_2338 abovePos = this.method_11016().method_10084();
        class_2680 aboveState = level.method_8320(abovePos);
        if (!(aboveState.method_26204() instanceof class_2343)) {
            return;
        }
        class_2586 blockEntity = level.method_8321(abovePos);
        if (blockEntity instanceof class_1263) {
            boolean isValidContainer;
            class_1263 container = (class_1263)blockEntity;
            boolean bl = isValidContainer = aboveState.method_26204() instanceof class_2281 || aboveState.method_26204() instanceof class_2377 || aboveState.method_26204() instanceof class_3708 || aboveState.method_26204() instanceof class_2480;
            if (!isValidContainer) {
                return;
            }
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 itemInContainer = container.method_5438(i);
                if (itemInContainer.method_7960()) continue;
                for (int inputSlot = 0; inputSlot < 8; ++inputSlot) {
                    int canAdd;
                    int toAdd;
                    class_1799 currentInput = (class_1799)this.tradeSlots.get(inputSlot);
                    if (currentInput.method_7960()) {
                        class_1799 taken = itemInContainer.method_7971(1);
                        this.tradeSlots.set(inputSlot, (Object)taken);
                        container.method_5447(i, itemInContainer);
                        container.method_5431();
                        this.method_5431();
                        return;
                    }
                    if (currentInput.method_7909() != itemInContainer.method_7909() || currentInput.method_7947() >= currentInput.method_7914() || (toAdd = Math.min(canAdd = currentInput.method_7914() - currentInput.method_7947(), itemInContainer.method_7947())) <= 0) continue;
                    toAdd = 1;
                    currentInput.method_7933(toAdd);
                    itemInContainer.method_7934(toAdd);
                    container.method_5447(i, itemInContainer);
                    container.method_5431();
                    this.method_5431();
                    return;
                }
            }
        }
    }

    private void pushItemsBelow(class_1937 level) {
        if (level == null) {
            return;
        }
        class_2338 belowPos = this.method_11016().method_10074();
        class_2680 belowState = level.method_8320(belowPos);
        if (!(belowState.method_26204() instanceof class_2343)) {
            return;
        }
        class_2586 blockEntity = level.method_8321(belowPos);
        if (blockEntity instanceof class_1263) {
            boolean isValidContainer;
            class_1263 container = (class_1263)blockEntity;
            boolean bl = isValidContainer = belowState.method_26204() instanceof class_2281 || belowState.method_26204() instanceof class_2377 || belowState.method_26204() instanceof class_3708 || belowState.method_26204() instanceof class_2480 || belowState.method_26204() instanceof class_2325 || belowState.method_26204() instanceof class_2315;
            if (!isValidContainer) {
                return;
            }
            for (int outputSlot = 8; outputSlot < 12; ++outputSlot) {
                class_1799 outputItem = (class_1799)this.tradeSlots.get(outputSlot);
                if (outputItem.method_7960()) continue;
                for (int i = 0; i < container.method_5439(); ++i) {
                    int canAdd;
                    class_1799 itemInContainer = container.method_5438(i);
                    if (itemInContainer.method_7960()) {
                        class_1799 toPlace = outputItem.method_7971(1);
                        container.method_5447(i, toPlace);
                        container.method_5431();
                        if (outputItem.method_7960()) {
                            this.tradeSlots.set(outputSlot, (Object)class_1799.field_8037);
                        }
                        this.method_5431();
                        return;
                    }
                    if (itemInContainer.method_7909() != outputItem.method_7909() || itemInContainer.method_7947() >= itemInContainer.method_7914() || (canAdd = itemInContainer.method_7914() - itemInContainer.method_7947()) <= 0) continue;
                    itemInContainer.method_7933(1);
                    outputItem.method_7934(1);
                    container.method_5431();
                    if (outputItem.method_7960()) {
                        this.tradeSlots.set(outputSlot, (Object)class_1799.field_8037);
                    }
                    this.method_5431();
                    return;
                }
            }
        }
    }
}

