/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncFarmingMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.FarmingPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class FarmingPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 15;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public void resetProgress() {
        try {
            this.progressTicks = 0;
            this.progressNeeded = 0;
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAutomationReady() {
        try {
            if (!this.hasVillager()) {
                return false;
            }
            class_2371<class_1799> items = this.method_11282();
            if (items == null || items.size() < 15) {
                return false;
            }
            class_1799 hoe = (class_1799)items.get(0);
            class_1799 axe = (class_1799)items.get(1);
            class_1799 input = (class_1799)items.get(2);
            if (input == null || input.method_7960()) {
                return false;
            }
            boolean isSapling = false;
            try {
                class_1747 bi;
                class_1792 it = input.method_7909();
                if (it instanceof class_1747 && (bi = (class_1747)it).method_7711() instanceof class_2473) {
                    isSapling = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isSapling) {
                return axe != null && !axe.method_7960();
            }
            return hoe != null && !hoe.method_7960();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public FarmingPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.FARMING_POCKET_CUBE, position, state);
        try {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)15, (Object)class_1799.field_8037));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)15, (Object)class_1799.field_8037));
        }
        class_1262.method_5429((class_11368)valueInput, this.method_11282());
    }

    @Override
    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.method_11282());
        }
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10569("ProgressTicks", this.progressTicks);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("ProgressNeeded", this.progressNeeded);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("CanAutomate", this.isAutomationReady());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void handleUpdateTag(class_2487 tag) {
        block8: {
            try {
                if (tag == null) break block8;
                try {
                    if (tag.method_10545("ProgressTicks")) {
                        this.progressTicks = tag.method_10550("ProgressTicks").orElse(this.progressTicks);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("ProgressNeeded")) {
                        this.progressNeeded = tag.method_10550("ProgressNeeded").orElse(this.progressNeeded);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public int method_5439() {
        return this.method_11282().size();
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"farming_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new FarmingPocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Farming Pocket Cube");
    }

    @Override
    protected class_2371<class_1799> method_11282() {
        return super.method_11282();
    }

    @Override
    protected void method_11281(class_2371<class_1799> stacks) {
        super.method_11281(stacks);
    }

    public void method_5447(int index, class_1799 stack) {
        try {
            class_1799 toSet;
            class_1799 class_17992 = toSet = stack == null ? class_1799.field_8037 : stack.method_7972();
            if (index == 2 && !toSet.method_7960() && toSet.method_7947() > 1) {
                toSet.method_7939(1);
            }
            if ((index == 0 || index == 1 || index == 2) && toSet.method_7960()) {
                this.resetProgress();
            }
            class_2371<class_1799> items = this.method_11282();
            if (index >= 0 && index < items.size()) {
                items.set(index, (Object)toSet);
                this.method_11281(items);
                this.method_5431();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public void serverTick(class_1937 level) {
        block46: {
            try {
                int needed;
                boolean isSapling;
                class_1799 input;
                class_1799 axe;
                class_1799 hoe;
                class_2371<class_1799> items;
                block45: {
                    if (level == null || level.method_8608()) {
                        return;
                    }
                    if (!this.hasVillager()) {
                        return;
                    }
                    try {
                        class_2487 vd = this.getVillagerData();
                        String prof = null;
                        try {
                            if (vd != null && vd.method_10545("VillagerData")) {
                                class_2487 nested = vd.method_10562("VillagerData").orElse(new class_2487());
                                prof = nested.method_10558("profession").orElse(null);
                            } else if (vd != null) {
                                prof = vd.method_10558("VillagerData.profession").orElse(null);
                            }
                        }
                        catch (Throwable nested) {
                            // empty catch block
                        }
                        if (prof == null || !prof.equalsIgnoreCase("minecraft:farmer")) {
                            return;
                        }
                    }
                    catch (Throwable ignored) {
                        return;
                    }
                    items = this.method_11282();
                    if (items == null || items.size() < 15) {
                        return;
                    }
                    hoe = (class_1799)items.get(0);
                    axe = (class_1799)items.get(1);
                    input = (class_1799)items.get(2);
                    if (input == null || input.method_7960()) {
                        return;
                    }
                    isSapling = false;
                    try {
                        class_1792 item = input.method_7909();
                        if (!(item instanceof class_1747)) break block45;
                        class_1747 bi = (class_1747)item;
                        try {
                            if (bi.method_7711() instanceof class_2473) {
                                isSapling = true;
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable item) {
                        // empty catch block
                    }
                }
                if (isSapling ? axe == null || axe.method_7960() : hoe == null || hoe.method_7960()) {
                    return;
                }
                int baseTicks = PocketVillagersConfigCache.getFarmingTickInterval();
                double mult = 1.0;
                if (hoe != null && !hoe.method_7960() && axe != null && !axe.method_7960()) {
                    mult = Math.min(this.getToolMultiplier(hoe), this.getToolMultiplier(axe));
                } else if (hoe != null && !hoe.method_7960()) {
                    mult = this.getToolMultiplier(hoe);
                } else if (axe != null && !axe.method_7960()) {
                    mult = this.getToolMultiplier(axe);
                }
                this.progressNeeded = needed = Math.max(1, (int)Math.round((double)baseTicks * mult));
                ++this.progressTicks;
                try {
                    if (this.progressTicks % 5 == 0) {
                        this.sendMenuStateUpdateToViewers();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.progressTicks < this.progressNeeded) {
                    return;
                }
                this.progressTicks = 0;
                List<Object> drops = new ArrayList<class_1799>();
                try {
                    if (input != null && !input.method_7960()) {
                        drops = this.sampleFarmingDropsFromInput(level.method_8409(), input, hoe, axe);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (drops == null || drops.isEmpty()) {
                    drops = new ArrayList();
                    drops.add(this.sampleFarmingDrop(level.method_8409()));
                }
                if (drops == null || drops.isEmpty()) break block46;
                this.sendMenuStateUpdateToViewers();
                boolean allInserted = true;
                for (class_1799 class_17992 : drops) {
                    boolean inserted;
                    if (class_17992 == null || class_17992.method_7960() || (inserted = this.insertIntoOutputs(class_17992))) continue;
                    allInserted = false;
                    break;
                }
                if (!allInserted) break block46;
                try {
                    if (input != null && !input.method_7960() && input.method_7947() != 1) {
                        input.method_7939(1);
                        items.set(2, (Object)input);
                        this.method_11281(items);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.method_5431();
                this.syncToClient();
                try {
                    for (class_1657 class_16572 : level.method_18456()) {
                        if (class_16572.method_73183() != level || !(class_16572.field_7512 instanceof FarmingPocketCubeGUIMenu)) continue;
                        FarmingPocketCubeGUIMenu menu = (FarmingPocketCubeGUIMenu)class_16572.field_7512;
                        if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                        try {
                            Map<Integer, class_1735> slots = menu.getSlots();
                            for (int i = 0; i < this.method_5439(); ++i) {
                                class_1735 slot = slots.get(i);
                                if (slot == null) continue;
                                slot.method_7673(this.method_5438(i) == null ? class_1799.field_8037 : this.method_5438(i).method_7972());
                            }
                            try {
                                menu.method_7623();
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class_1799 method_5434(int index, int count) {
        try {
            if (index == 0 || index == 1 || index == 2) {
                this.resetProgress();
            }
            class_1799 res = super.method_5434(index, count);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    public class_1799 method_5441(int index) {
        try {
            if (index == 0 || index == 1 || index == 2) {
                this.resetProgress();
            }
            class_1799 res = super.method_5441(index);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    public void sendMenuStateUpdateToViewers() {
        try {
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            int remaining = Math.max(0, this.progressNeeded - this.progressTicks);
            int interval = this.progressNeeded;
            boolean can = this.isAutomationReady();
            for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                try {
                    if (p.method_51469() != serverLevel || !(p.field_7512 instanceof FarmingPocketCubeGUIMenu)) continue;
                    FarmingPocketCubeGUIMenu menu = (FarmingPocketCubeGUIMenu)p.field_7512;
                    if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                    try {
                        SyncFarmingMenuPayload.send(p, this.method_11016(), remaining, interval, can);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<class_1799> sampleFarmingDropsFromInput(class_5819 rand, class_1799 input, class_1799 hoe, class_1799 axe) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        try {
            class_1792 item;
            block55: {
                block52: {
                    if (input == null || input.method_7960()) {
                        return drops;
                    }
                    item = input.method_7909();
                    if (item == class_1802.field_8317) {
                        drops.add(rand.method_43048(100) < 70 ? new class_1799((class_1935)class_1802.field_8861, 1) : new class_1799((class_1935)class_1802.field_8317, 1));
                        return drops;
                    }
                    if (item == class_1802.field_46250) {
                        drops.add(new class_1799((class_1935)class_1802.field_8497, 1));
                        return drops;
                    }
                    if (item == class_1802.field_46249) {
                        drops.add(new class_1799((class_1935)class_1802.field_17518, 1));
                        return drops;
                    }
                    if (item == class_1802.field_8309) {
                        drops.add(new class_1799((class_1935)class_1802.field_8186, 1));
                        return drops;
                    }
                    if (item == class_1802.field_8179) {
                        drops.add(new class_1799((class_1935)class_1802.field_8179, 1));
                        return drops;
                    }
                    if (item == class_1802.field_8567) {
                        if (rand.method_43048(40) == 0) {
                            drops.add(new class_1799((class_1935)class_1802.field_8635, 1));
                        } else {
                            drops.add(new class_1799((class_1935)class_1802.field_8567, 1));
                        }
                        return drops;
                    }
                    if (item == class_1802.field_16998) {
                        drops.add(new class_1799((class_1935)class_1802.field_16998, 1));
                        return drops;
                    }
                    try {
                        if (item == class_1802.field_42711) {
                            drops.add(new class_1799((class_1935)class_1802.field_42695, 1));
                            return drops;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (item instanceof class_1747) {
                        class_1747 bi = (class_1747)item;
                        try {
                            boolean isOak;
                            block53: {
                                class_2248 block = bi.method_7711();
                                if (!(block instanceof class_2473)) break block52;
                                class_2960 key = class_7923.field_41175.method_10221((Object)block);
                                isOak = key != null && key.method_12832().equals("oak_sapling");
                                int logCount = rand.method_43048(2) + 1;
                                try {
                                    class_1792 logItem;
                                    String name = key.method_12832();
                                    if (!name.endsWith("_sapling")) break block53;
                                    String string = name.substring(0, name.length() - "_sapling".length()) + "_log";
                                    class_2960 logRl = class_2960.method_60654((String)(key.method_12836() + ":" + string));
                                    Optional opt = class_7923.field_41175.method_17966(logRl);
                                    if (!opt.isPresent()) break block53;
                                    class_2248 logBlkObj = (class_2248)opt.get();
                                    class_2248 logBlk = null;
                                    if (logBlkObj instanceof class_6880) {
                                        try {
                                            Object v = ((class_6880)logBlkObj).comp_349();
                                            if (v instanceof class_2248) {
                                                logBlk = (class_2248)v;
                                            }
                                        }
                                        catch (Throwable v) {}
                                    } else if (logBlkObj instanceof class_2248) {
                                        logBlk = logBlkObj;
                                    }
                                    if (logBlk != null && (logItem = logBlk.method_8389()) != null) {
                                        drops.add(new class_1799((class_1935)logItem, logCount));
                                    }
                                }
                                catch (Throwable name) {
                                    // empty catch block
                                }
                            }
                            if (rand.method_43056()) {
                                int stickCount = rand.method_43048(2) + 1;
                                drops.add(new class_1799((class_1935)class_1802.field_8600, stickCount));
                            }
                            if (rand.method_43048(10) == 0) {
                                int saplingCount = rand.method_43048(2) + 1;
                                drops.add(new class_1799((class_1935)item, saplingCount));
                            }
                            if (isOak && rand.method_43048(20) == 0) {
                                drops.add(new class_1799((class_1935)class_1802.field_8279, 1));
                            }
                            if (drops.isEmpty()) {
                                drops.add(new class_1799((class_1935)bi, 1));
                            }
                            return drops;
                        }
                        catch (Throwable block) {
                            // empty catch block
                        }
                    }
                }
                try {
                    class_2960 key = class_7923.field_41178.method_10221((Object)item);
                    if (key == null) break block55;
                    String path = key.method_12832().toLowerCase(Locale.ROOT);
                    String ns = key.method_12836();
                    try {
                        if ("cobblemon".equals(ns)) {
                            if (path.endsWith("_berry")) {
                                drops.add(new class_1799((class_1935)item, 1));
                                return drops;
                            }
                            if (path.endsWith("_seed") || path.endsWith("_seeds")) {
                                String base = path.replaceAll("(_seeds|_seed)$", "");
                                ArrayList<Object> candidates = new ArrayList<Object>();
                                candidates.add(base);
                                candidates.add(base + "_item");
                                candidates.add(base + "s");
                                candidates.add(base + "_mint");
                                for (String string : candidates) {
                                    try {
                                        Object c;
                                        class_2960 rl = class_2960.method_60654((String)(ns + ":" + string));
                                        Optional oit = class_7923.field_41178.method_17966(rl);
                                        if (!oit.isPresent() || !((c = oit.get()) instanceof class_6880)) continue;
                                        try {
                                            Object v = ((class_6880)c).comp_349();
                                            if (!(v instanceof class_1792)) continue;
                                            drops.add(new class_1799((class_1935)((class_1792)v), 1));
                                            return drops;
                                        }
                                        catch (Throwable throwable) {
                                        }
                                    }
                                    catch (Throwable rl) {}
                                }
                                drops.add(new class_1799((class_1935)item, 1));
                                return drops;
                            }
                        }
                    }
                    catch (Throwable base) {
                        // empty catch block
                    }
                    if (path.contains("mint") || path.contains("mint_seed") || path.contains("mintseeds") || path.contains("mints")) {
                        ArrayList<class_2960> tryIds = new ArrayList<class_2960>();
                        tryIds.add(class_2960.method_60654((String)(ns + ":mint")));
                        tryIds.add(class_2960.method_60654((String)(ns + ":mint_item")));
                        tryIds.add(class_2960.method_60654((String)(ns + ":" + path.replace("_seeds", ""))));
                        for (class_2960 rl : tryIds) {
                            Object c;
                            Optional optional = class_7923.field_41178.method_17966(rl);
                            if (!optional.isPresent() || !((c = optional.get()) instanceof class_6880)) continue;
                            try {
                                Object v = ((class_6880)c).comp_349();
                                if (!(v instanceof class_1792)) continue;
                                drops.add(new class_1799((class_1935)((class_1792)v), 1));
                                return drops;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                    if (!path.contains("berry")) break block55;
                    try {
                        Object c;
                        Optional oit = class_7923.field_41178.method_17966(class_2960.method_60654((String)(ns + ":" + path)));
                        if (!oit.isPresent() || !((c = oit.get()) instanceof class_6880)) break block55;
                        try {
                            Object v = ((class_6880)c).comp_349();
                            if (v instanceof class_1792) {
                                drops.add(new class_1799((class_1935)((class_1792)v), 1));
                                return drops;
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            drops.add(new class_1799((class_1935)item, 1));
            return drops;
        }
        catch (Throwable throwable) {
            return drops;
        }
    }

    private double getToolMultiplier(class_1799 toolStack) {
        if (toolStack == null || toolStack.method_7960()) {
            return 1.0;
        }
        class_1792 it = toolStack.method_7909();
        double baseMult = 1.0;
        if (it == class_1802.field_22026 || it == class_1802.field_22025) {
            baseMult = 0.4;
        } else if (it == class_1802.field_8527 || it == class_1802.field_8556) {
            baseMult = 0.5;
        } else if (it == class_1802.field_8609 || it == class_1802.field_8475) {
            baseMult = 0.75;
        } else if (it == class_1802.field_8431 || it == class_1802.field_8062) {
            baseMult = 1.0;
        } else if (it == class_1802.field_8167 || it == class_1802.field_8303 || it == class_1802.field_8406 || it == class_1802.field_8825) {
            baseMult = 1.5;
        }
        int efficiencyLevel = this.getEfficiencyLevel(toolStack);
        try {
            if (efficiencyLevel > 0 && PocketVillagersConfigCache.getEnableEfficiency()) {
                double bonus = PocketVillagersConfigCache.getEfficiencySpeedBonus();
                if (bonus < 0.0) {
                    bonus = 0.0;
                }
                if (bonus >= 1.0) {
                    bonus = 0.99;
                }
                baseMult *= Math.pow(1.0 - bonus, efficiencyLevel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return baseMult;
    }

    private int getEfficiencyLevel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return 0;
        }
        try {
            class_9304 enchantments = tool.method_58657();
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                Optional key = ((class_6880)entry.getKey()).method_40230();
                if (!key.isPresent() || !((class_5321)key.get()).method_29177().method_12832().equals("efficiency")) continue;
                return entry.getIntValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private class_1799 sampleFarmingDrop(class_5819 rand) {
        int roll = rand.method_43048(100);
        if (roll < 25) {
            return new class_1799((class_1935)class_1802.field_8861, 1);
        }
        if (roll < 45) {
            return new class_1799((class_1935)class_1802.field_8179, 1);
        }
        if (roll < 65) {
            return new class_1799((class_1935)class_1802.field_8567, 1);
        }
        if (roll < 80) {
            return new class_1799((class_1935)class_1802.field_8186, 1);
        }
        if (roll < 90) {
            return new class_1799((class_1935)class_1802.field_8317, 1);
        }
        return new class_1799((class_1935)class_1802.field_8279, 1);
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        try {
            class_2371<class_1799> items = this.method_11282();
            for (int i = 3; i < 15; ++i) {
                boolean sameItem;
                class_1799 s = (class_1799)items.get(i);
                if (s.method_7960()) {
                    items.set(i, (Object)drop.method_7972());
                    this.method_11281(items);
                    return true;
                }
                boolean bl = sameItem = s.method_7909() == drop.method_7909();
                if (!sameItem || s.method_7947() >= s.method_7914()) continue;
                int can = Math.min(s.method_7914() - s.method_7947(), drop.method_7947());
                s.method_7933(can);
                drop.method_7934(can);
                items.set(i, (Object)s);
                this.method_11281(items);
                if (!drop.method_7960()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        try {
            int start = 2;
            int end = this.method_5439();
            return IntStream.range(start, end).toArray();
        }
        catch (Throwable ignored) {
            return IntStream.range(0, this.method_5439()).toArray();
        }
    }

    @Override
    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        try {
            if (index == 0 || index == 1) {
                return false;
            }
            if (index == 2) {
                if (itemstack == null || itemstack.method_7960()) {
                    return false;
                }
                class_1792 item = itemstack.method_7909();
                if (item == class_1802.field_8317 || item == class_1802.field_8309 || item == class_1802.field_8179 || item == class_1802.field_8567 || item == class_1802.field_16998) {
                    return true;
                }
                try {
                    if (item == class_1802.field_42711) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (item == class_1802.field_8790) {
                    return true;
                }
                if (item instanceof class_1747) {
                    class_1747 bi = (class_1747)item;
                    try {
                        class_2248 block = bi.method_7711();
                        if (block instanceof class_2473) {
                            return true;
                        }
                    }
                    catch (Throwable block) {
                        // empty catch block
                    }
                }
                try {
                    String path;
                    class_2960 key = class_7923.field_41178.method_10221((Object)item);
                    if (key != null && ((path = key.method_12832().toLowerCase(Locale.ROOT)).contains("seed") || path.contains("sapling") || path.contains("berry") || path.contains("mint"))) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return false;
            }
            if (index >= 3) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        try {
            return index >= 3 && index < this.method_5439();
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

