/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.block.entity.PocketCubeBlockEntity;
import net.mcreator.pocketvillagers.config.PocketVillagersConfig;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.SyncFishingMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.FishingPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class FishingPocketCubeBlockEntity
extends PocketCubeBlockEntity
implements ExtendedScreenHandlerFactory<class_2338> {
    private static final int TOTAL_SLOTS = 13;
    private int progressTicks = 0;
    private int progressNeeded = 0;

    public int getProgressTicks() {
        return this.progressTicks;
    }

    public int getProgressNeeded() {
        return this.progressNeeded;
    }

    public void resetProgress() {
        try {
            this.progressTicks = 0;
            this.progressNeeded = 0;
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetProgressTicks() {
        try {
            this.progressTicks = 0;
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void recomputeProgressNeededFromCurrentTool() {
        try {
            int needed;
            class_2371<class_1799> items = this.method_11282();
            if (items == null || items.size() == 0) {
                this.progressNeeded = 0;
                this.method_5431();
                this.syncToClient();
                return;
            }
            class_1799 tool = (class_1799)items.get(0);
            if (tool == null || tool.method_7960()) {
                this.progressNeeded = 0;
                this.method_5431();
                this.syncToClient();
                return;
            }
            int baseTicks = PocketVillagersConfigCache.getFishingTickInterval();
            double mult = this.getToolMultiplier(tool.method_7909());
            this.progressNeeded = needed = Math.max(1, (int)Math.round((double)baseTicks * mult));
            this.method_5431();
            this.syncToClient();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAutomationReady() {
        try {
            if (!this.hasVillager()) {
                return false;
            }
            class_2371<class_1799> items = this.method_11282();
            if (items == null || items.size() < 13) {
                return false;
            }
            class_1799 tool = (class_1799)items.get(0);
            return tool != null && !tool.method_7960();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public FishingPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.FISHING_POCKET_CUBE, position, state);
        try {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.method_11281((class_2371<class_1799>)class_2371.method_10213((int)13, (Object)class_1799.field_8037));
        }
        class_1262.method_5429((class_11368)valueInput, this.method_11282());
    }

    @Override
    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.method_11282());
        }
    }

    @Override
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10569("ProgressTicks", this.progressTicks);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("ProgressNeeded", this.progressNeeded);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("CanAutomate", this.isAutomationReady());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void handleUpdateTag(class_2487 tag) {
        block8: {
            try {
                if (tag == null) break block8;
                try {
                    if (tag.method_10545("ProgressTicks")) {
                        this.progressTicks = tag.method_10550("ProgressTicks").orElse(this.progressTicks);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("ProgressNeeded")) {
                        this.progressNeeded = tag.method_10550("ProgressNeeded").orElse(this.progressNeeded);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public int method_5439() {
        return this.method_11282().size();
    }

    @Override
    public boolean method_5442() {
        return super.method_5442();
    }

    @Override
    public class_2561 method_17823() {
        return class_2561.method_43470((String)"fishing_pocket_cube");
    }

    @Override
    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new FishingPocketCubeGUIMenu(containerId, playerInventory, this);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Fishing Pocket Cube");
    }

    @Override
    protected class_2371<class_1799> method_11282() {
        return super.method_11282();
    }

    @Override
    protected void method_11281(class_2371<class_1799> stacks) {
        super.method_11281(stacks);
    }

    public class_1799 method_5434(int index, int count) {
        try {
            class_1799 res = super.method_5434(index, count);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    public class_1799 method_5441(int index) {
        try {
            class_1799 res = super.method_5441(index);
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return res;
        }
        catch (Throwable ignored) {
            return class_1799.field_8037;
        }
    }

    @Override
    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public void serverTick(class_1937 level) {
        block23: {
            try {
                boolean inserted;
                int needed;
                if (level == null || level.method_8608()) {
                    return;
                }
                if (!this.hasVillager()) {
                    return;
                }
                class_2371<class_1799> items = this.method_11282();
                if (items == null || items.size() < 13) {
                    return;
                }
                class_1799 tool = (class_1799)items.get(0);
                if (tool == null || tool.method_7960()) {
                    return;
                }
                int baseTicks = PocketVillagersConfig.getInstance().getFishingTickInterval();
                int lureLevel = this.getLureLevel(tool);
                int lureReduction = lureLevel * 200;
                double mult = this.getToolMultiplier(tool.method_7909());
                this.progressNeeded = needed = Math.max(20, (int)Math.round((double)(baseTicks - lureReduction) * mult));
                ++this.progressTicks;
                try {
                    if (this.progressTicks % 5 == 0) {
                        this.sendMenuStateUpdateToViewers();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.progressTicks < this.progressNeeded) {
                    return;
                }
                this.progressTicks = 0;
                class_1799 drop = this.sampleFishingDrop(level, level.method_8409(), tool);
                if (drop == null || drop.method_7960() || !(inserted = this.insertIntoOutputs(drop))) break block23;
                this.method_5431();
                this.syncToClient();
                try {
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                            try {
                                if (p.method_51469() != serverLevel || !(p.field_7512 instanceof FishingPocketCubeGUIMenu)) continue;
                                FishingPocketCubeGUIMenu menu = (FishingPocketCubeGUIMenu)p.field_7512;
                                if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                                try {
                                    Map<Integer, class_1735> slots = menu.getSlots();
                                    for (int i = 0; i < this.method_5439(); ++i) {
                                        class_1735 slot = slots.get(i);
                                        if (slot == null) continue;
                                        slot.method_7673(this.method_5438(i) == null ? class_1799.field_8037 : this.method_5438(i).method_7972());
                                    }
                                    try {
                                        menu.method_7623();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                catch (Throwable throwable) {
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.sendMenuStateUpdateToViewers();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void sendMenuStateUpdateToViewers() {
        try {
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                int rem = Math.max(0, this.progressNeeded - this.progressTicks);
                for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                    try {
                        if (p.method_51469() != serverLevel || !(p.field_7512 instanceof FishingPocketCubeGUIMenu)) continue;
                        FishingPocketCubeGUIMenu menu = (FishingPocketCubeGUIMenu)p.field_7512;
                        if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                        try {
                            SyncFishingMenuPayload.send(p, this.method_11016(), rem, this.progressNeeded, this.isAutomationReady());
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private double getToolMultiplier(class_1792 it) {
        if (it == class_1802.field_8378) {
            return 1.0;
        }
        return 1.0;
    }

    private int getLuckLevel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return 0;
        }
        try {
            class_9304 enchantments = tool.method_58657();
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                Optional key = ((class_6880)entry.getKey()).method_40230();
                if (!key.isPresent() || !((class_5321)key.get()).method_29177().method_12832().equals("luck_of_the_sea")) continue;
                return entry.getIntValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private int getLureLevel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return 0;
        }
        try {
            class_9304 enchantments = tool.method_58657();
            for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                Optional key = ((class_6880)entry.getKey()).method_40230();
                if (!key.isPresent() || !((class_5321)key.get()).method_29177().method_12832().equals("lure")) continue;
                return entry.getIntValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private class_1799 sampleFishingDrop(class_1937 level, class_5819 rand, class_1799 fishingRod) {
        int luckLevel = this.getLuckLevel(fishingRod);
        int roll = rand.method_43048(1000);
        int treasureBonus = luckLevel * 25;
        int junkReduction = luckLevel * 15;
        int junkThreshold = 100 - junkReduction;
        int treasureThreshold = junkThreshold + 50 + treasureBonus;
        if (roll < junkThreshold) {
            int junkRoll = rand.method_43048(100);
            if (junkRoll < 20) {
                return new class_1799((class_1935)class_1802.field_17524, 1);
            }
            if (junkRoll < 40) {
                return new class_1799((class_1935)class_1802.field_8428, 1);
            }
            if (junkRoll < 60) {
                return new class_1799((class_1935)class_1802.field_8370, 1);
            }
            if (junkRoll < 80) {
                return new class_1799((class_1935)class_1802.field_8600, 1);
            }
            return new class_1799((class_1935)class_1802.field_8276, 1);
        }
        if (roll < treasureThreshold) {
            int treasureRoll = rand.method_43048(100);
            if (treasureRoll < 25) {
                return new class_1799((class_1935)class_1802.field_8448, 1);
            }
            if (treasureRoll < 50) {
                return new class_1799((class_1935)class_1802.field_8175, 1);
            }
            if (treasureRoll < 65) {
                return new class_1799((class_1935)class_1802.field_8102, 1);
            }
            if (treasureRoll < 80) {
                return new class_1799((class_1935)class_1802.field_8378, 1);
            }
            if (treasureRoll < 95) {
                return new class_1799((class_1935)class_1802.field_8864, 1);
            }
            class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598, 1);
            try {
                class_2378 enchantments = level.method_30349().method_30530(class_7924.field_41265);
                String[] possibleEnchantments = new String[]{"minecraft:sharpness", "minecraft:smite", "minecraft:bane_of_arthropods", "minecraft:sweeping_edge", "minecraft:knockback", "minecraft:fire_aspect", "minecraft:looting", "minecraft:protection", "minecraft:fire_protection", "minecraft:blast_protection", "minecraft:projectile_protection", "minecraft:thorns", "minecraft:respiration", "minecraft:aqua_affinity", "minecraft:depth_strider", "minecraft:frost_walker", "minecraft:efficiency", "minecraft:silk_touch", "minecraft:fortune", "minecraft:power", "minecraft:punch", "minecraft:flame", "minecraft:infinity", "minecraft:quick_charge", "minecraft:multishot", "minecraft:piercing", "minecraft:luck_of_the_sea", "minecraft:lure", "minecraft:loyalty", "minecraft:impaling", "minecraft:riptide", "minecraft:channeling", "minecraft:unbreaking", "minecraft:mending", "minecraft:curse_of_vanishing", "minecraft:curse_of_binding"};
                int numEnchantments = rand.method_43048(3) + 1;
                ArrayList<String> selectedEnchantments = new ArrayList<String>();
                for (int i = 0; i < numEnchantments && selectedEnchantments.size() < possibleEnchantments.length; ++i) {
                    String enchantId;
                    int attempts = 0;
                    while (selectedEnchantments.contains(enchantId = possibleEnchantments[rand.method_43048(possibleEnchantments.length)]) && ++attempts < 10) {
                    }
                    if (selectedEnchantments.contains(enchantId)) continue;
                    selectedEnchantments.add(enchantId);
                }
                for (String enchantId : selectedEnchantments) {
                    try {
                        Optional enchant = enchantments.method_10223(class_2960.method_60654((String)enchantId));
                        if (!enchant.isPresent()) continue;
                        int maxLevel = ((class_1887)((class_6880.class_6883)enchant.get()).comp_349()).method_8183();
                        int enchantLevel = rand.method_43057() < 0.3f ? maxLevel : (rand.method_43057() < 0.6f ? 1 : rand.method_43048(maxLevel) + 1);
                        enchantedBook.method_7978((class_6880)enchant.get(), enchantLevel);
                    }
                    catch (Throwable ignored2) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return enchantedBook;
        }
        int fishRoll = rand.method_43048(100);
        if (fishRoll < 40) {
            return new class_1799((class_1935)class_1802.field_8429, 1);
        }
        if (fishRoll < 70) {
            return new class_1799((class_1935)class_1802.field_8209, 1);
        }
        if (fishRoll < 85) {
            return new class_1799((class_1935)class_1802.field_8846, 1);
        }
        return new class_1799((class_1935)class_1802.field_8323, 1);
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        try {
            class_2371<class_1799> items = this.method_11282();
            for (int i = 1; i < 13; ++i) {
                boolean sameItem;
                class_1799 s = (class_1799)items.get(i);
                if (s.method_7960()) {
                    items.set(i, (Object)drop.method_7972());
                    this.method_11281(items);
                    return true;
                }
                boolean bl = sameItem = s.method_7909() == drop.method_7909();
                if (!sameItem || s.method_7947() >= s.method_7914()) continue;
                int can = Math.min(s.method_7914() - s.method_7947(), drop.method_7947());
                s.method_7933(can);
                drop.method_7934(can);
                items.set(i, (Object)s);
                this.method_11281(items);
                if (!drop.method_7960()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        try {
            int start = 1;
            int end = this.method_5439();
            return IntStream.range(start, end).toArray();
        }
        catch (Throwable ignored) {
            return IntStream.range(0, this.method_5439()).toArray();
        }
    }

    @Override
    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        try {
            if (index >= 1) {
                return false;
            }
            return this.method_5437(index, itemstack);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        try {
            return index >= 1 && index < this.method_5439();
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

