/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pocketvillagers.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.mcreator.pocketvillagers.PocketVillagersMod;
import net.mcreator.pocketvillagers.config.PocketVillagersConfigCache;
import net.mcreator.pocketvillagers.init.PocketVillagersModBlockEntities;
import net.mcreator.pocketvillagers.network.StartIronFarmHologramPayload;
import net.mcreator.pocketvillagers.network.SyncIronFarmMenuPayload;
import net.mcreator.pocketvillagers.world.inventory.IronFarmPocketCubeGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class IronFarmPocketCubeBlockEntity
extends class_2621
implements class_1278,
ExtendedScreenHandlerFactory<class_2338> {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private int spawnTickCounter = 0;
    private int spawnCooldownTicks = PocketVillagersConfigCache.getIronFarmTickInterval();
    private int hologramTicksRemaining = 0;
    private final int hologramDurationTicks = 80;
    private boolean spawning = false;
    private int spawnAnimationTick = 0;
    private final int spawnAnimationDuration = 40;
    private class_2487 villager1Data = new class_2487();
    private class_2487 villager2Data = new class_2487();
    private class_2487 villager3Data = new class_2487();
    private boolean villager1Captured = false;
    private boolean villager2Captured = false;
    private boolean villager3Captured = false;

    public IronFarmPocketCubeBlockEntity(class_2338 position, class_2680 state) {
        super(PocketVillagersModBlockEntities.IRON_FARM_POCKET_CUBE, position, state);
    }

    public boolean hasVillager(int index) {
        if (index == 1) {
            return this.villager1Data != null && !this.villager1Data.method_33133() && this.villager1Captured;
        }
        if (index == 2) {
            return this.villager2Data != null && !this.villager2Data.method_33133() && this.villager2Captured;
        }
        if (index == 3) {
            return this.villager3Data != null && !this.villager3Data.method_33133() && this.villager3Captured;
        }
        return false;
    }

    public boolean isFull() {
        return this.hasVillager(1) && this.hasVillager(2) && this.hasVillager(3);
    }

    public int getFirstEmptySlot() {
        if (!this.hasVillager(1)) {
            return 1;
        }
        if (!this.hasVillager(2)) {
            return 2;
        }
        if (!this.hasVillager(3)) {
            return 3;
        }
        return -1;
    }

    public void setVillagerData(int index, class_2487 data) {
        boolean captured = false;
        try {
            if (data != null && data.method_10545("PocketVillagers.Captured")) {
                captured = data.method_10577("PocketVillagers.Captured").orElse(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (index == 1) {
            this.villager1Data = data != null ? data : new class_2487();
            this.villager1Captured = captured;
        } else if (index == 2) {
            this.villager2Data = data != null ? data : new class_2487();
            this.villager2Captured = captured;
        } else if (index == 3) {
            this.villager3Data = data != null ? data : new class_2487();
            this.villager3Captured = captured;
        }
        this.method_5431();
        try {
            this.sendMenuStateUpdateToViewers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sendMenuStateUpdateToViewers() {
        try {
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverLevel = (class_3218)class_19372;
            int remaining = Math.max(0, this.spawnCooldownTicks - this.spawnTickCounter);
            int cooldown = this.spawnCooldownTicks;
            boolean sp = this.spawning;
            int anim = this.spawnAnimationTick;
            int mask = 0;
            try {
                if (this.hasVillager(1)) {
                    mask |= 1;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.hasVillager(2)) {
                    mask |= 2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.hasVillager(3)) {
                    mask |= 4;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (class_3222 p : serverLevel.method_8503().method_3760().method_14571()) {
                try {
                    if (p.method_51469() != serverLevel || !(p.field_7512 instanceof IronFarmPocketCubeGUIMenu)) continue;
                    IronFarmPocketCubeGUIMenu menu = (IronFarmPocketCubeGUIMenu)p.field_7512;
                    if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                    try {
                        SyncIronFarmMenuPayload.send(p, this.method_11016(), remaining, cooldown, sp, anim, mask);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isSpawning() {
        return this.spawning;
    }

    public int getSpawnAnimationTick() {
        return this.spawnAnimationTick;
    }

    public int getSpawnAnimationDuration() {
        return this.spawnAnimationDuration;
    }

    public int getSpawnTickCounter() {
        return this.spawnTickCounter;
    }

    public int getSpawnCooldownTicks() {
        return this.spawnCooldownTicks;
    }

    public int getHologramTicksRemaining() {
        return this.hologramTicksRemaining;
    }

    public class_2487 getVillagerData(int index) {
        if (index == 1) {
            return this.villager1Data;
        }
        if (index == 2) {
            return this.villager2Data;
        }
        if (index == 3) {
            return this.villager3Data;
        }
        return new class_2487();
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        valueInput.method_71426("Villager1Data", class_2487.field_25128).ifPresent(tag -> {
            this.villager1Data = tag.method_10553();
        });
        valueInput.method_71426("Villager2Data", class_2487.field_25128).ifPresent(tag -> {
            this.villager2Data = tag.method_10553();
        });
        valueInput.method_71426("Villager3Data", class_2487.field_25128).ifPresent(tag -> {
            this.villager3Data = tag.method_10553();
        });
        try {
            this.villager1Captured = valueInput.method_71433("Villager1Captured", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.villager2Captured = valueInput.method_71433("Villager2Captured", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.villager3Captured = valueInput.method_71433("Villager3Captured", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.method_54871(valueInput)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_11368)valueInput, this.stacks);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.villager1Data.method_33133()) {
            valueOutput.method_71468("Villager1Data", class_2487.field_25128, (Object)this.villager1Data.method_10553());
        }
        if (!this.villager2Data.method_33133()) {
            valueOutput.method_71468("Villager2Data", class_2487.field_25128, (Object)this.villager2Data.method_10553());
        }
        if (!this.villager3Data.method_33133()) {
            valueOutput.method_71468("Villager3Data", class_2487.field_25128, (Object)this.villager3Data.method_10553());
        }
        try {
            valueOutput.method_71472("Villager1Captured", this.villager1Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            valueOutput.method_71472("Villager2Captured", this.villager2Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            valueOutput.method_71472("Villager3Captured", this.villager3Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.stacks);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void sync() {
        try {
            class_3218 serverLevel;
            class_2818 chunk;
            class_2802 class_28022;
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218 && (class_28022 = (chunk = (serverLevel = (class_3218)class_19372).method_8500(this.method_11016())).method_12200().method_8398()) instanceof class_3215) {
                class_3215 chunkCache = (class_3215)class_28022;
                chunkCache.field_17254.method_17210(chunk.method_12004(), false).forEach(this::syncContents);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void syncContents(class_3222 player) {
        try {
            player.field_13987.method_14364((class_2596)this.getUpdatePacket());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        class_2487 tag = this.method_38242(lookupProvider);
        try {
            tag.method_10556("Spawning", this.spawning);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnAnimationTick", this.spawnAnimationTick);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnTickCounter", this.spawnTickCounter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnCooldownTicks", this.spawnCooldownTicks);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("HologramTicksRemaining", this.hologramTicksRemaining);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager1Captured", this.villager1Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager2Captured", this.villager2Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager3Captured", this.villager3Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag;
    }

    public void handleUpdateTag(class_2487 tag) {
        block26: {
            try {
                if (tag == null) break block26;
                try {
                    if (tag.method_10545("Spawning")) {
                        this.spawning = tag.method_10577("Spawning").orElse(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("SpawnAnimationTick")) {
                        this.spawnAnimationTick = tag.method_10550("SpawnAnimationTick").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("SpawnTickCounter")) {
                        this.spawnTickCounter = tag.method_10550("SpawnTickCounter").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("SpawnCooldownTicks")) {
                        this.spawnCooldownTicks = tag.method_10550("SpawnCooldownTicks").orElse(this.spawnCooldownTicks);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("HologramTicksRemaining")) {
                        this.hologramTicksRemaining = tag.method_10550("HologramTicksRemaining").orElse(0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("Villager1Captured")) {
                        this.villager1Captured = tag.method_10577("Villager1Captured").orElse(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("Villager2Captured")) {
                        this.villager2Captured = tag.method_10577("Villager2Captured").orElse(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (tag.method_10545("Villager3Captured")) {
                        this.villager3Captured = tag.method_10577("Villager3Captured").orElse(false);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void load(class_2487 tag) {
        try {
            if (tag.method_10545("Spawning")) {
                this.spawning = tag.method_10577("Spawning").orElse(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("SpawnAnimationTick")) {
                this.spawnAnimationTick = tag.method_10550("SpawnAnimationTick").orElse(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("SpawnTickCounter")) {
                this.spawnTickCounter = tag.method_10550("SpawnTickCounter").orElse(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("SpawnCooldownTicks")) {
                this.spawnCooldownTicks = tag.method_10550("SpawnCooldownTicks").orElse(this.spawnCooldownTicks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("HologramTicksRemaining")) {
                this.hologramTicksRemaining = tag.method_10550("HologramTicksRemaining").orElse(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager1Captured")) {
                this.villager1Captured = tag.method_10577("Villager1Captured").orElse(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager2Captured")) {
                this.villager2Captured = tag.method_10577("Villager2Captured").orElse(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager3Captured")) {
                this.villager3Captured = tag.method_10577("Villager3Captured").orElse(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager1Data")) {
                this.villager1Data = tag.method_10562("Villager1Data").orElse(new class_2487());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager2Data")) {
                this.villager2Data = tag.method_10562("Villager2Data").orElse(new class_2487());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (tag.method_10545("Villager3Data")) {
                this.villager3Data = tag.method_10562("Villager3Data").orElse(new class_2487());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void saveAdditional(class_2487 tag) {
        try {
            tag.method_10556("Spawning", this.spawning);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnAnimationTick", this.spawnAnimationTick);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnTickCounter", this.spawnTickCounter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("SpawnCooldownTicks", this.spawnCooldownTicks);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10569("HologramTicksRemaining", this.hologramTicksRemaining);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.villager1Data.method_33133()) {
                tag.method_10566("Villager1Data", (class_2520)this.villager1Data.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.villager2Data.method_33133()) {
                tag.method_10566("Villager2Data", (class_2520)this.villager2Data.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.villager3Data.method_33133()) {
                tag.method_10566("Villager3Data", (class_2520)this.villager3Data.method_10553());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager1Captured", this.villager1Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager2Captured", this.villager2Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tag.method_10556("Villager3Captured", this.villager3Captured);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(class_2487 tag, class_7225.class_7874 registries) {
        this.load(tag);
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public void serverTick(class_1937 level) {
        try {
            block90: {
                if (level == null || level.method_8608()) {
                    return;
                }
                try {
                    int cached = PocketVillagersConfigCache.getIronFarmTickInterval();
                    if (this.spawnCooldownTicks != cached) {
                        this.spawnCooldownTicks = cached;
                    }
                }
                catch (Throwable cached) {
                    // empty catch block
                }
                try {
                    PocketVillagersMod.LOGGER.debug("[IronFarm] serverTick @ {} flags: [{},{},{}] spawnTick={}", (Object)this.method_11016(), (Object)this.villager1Captured, (Object)this.villager2Captured, (Object)this.villager3Captured, (Object)this.spawnTickCounter);
                }
                catch (Throwable cached) {
                    // empty catch block
                }
                try {
                    if (this.spawnTickCounter % 20 == 0) {
                        boolean s1 = this.villager1Data != null && !this.villager1Data.method_33133();
                        boolean s2 = this.villager2Data != null && !this.villager2Data.method_33133();
                        boolean s3 = this.villager3Data != null && !this.villager3Data.method_33133();
                        PocketVillagersMod.LOGGER.debug("[IronFarm] {} villager slots present? v1={} v2={} v3={} captured? [{},{},{}]", (Object)this.method_11016(), (Object)s1, (Object)s2, (Object)s3, (Object)this.villager1Captured, (Object)this.villager2Captured, (Object)this.villager3Captured);
                    }
                }
                catch (Throwable s1) {
                    // empty catch block
                }
                if (this.hologramTicksRemaining > 0) {
                    --this.hologramTicksRemaining;
                    if (this.hologramTicksRemaining % 10 == 0) {
                        this.method_5431();
                        try {
                            this.sync();
                        }
                        catch (Throwable s1) {
                            // empty catch block
                        }
                    }
                    if (this.hologramTicksRemaining == 0) {
                        this.method_5431();
                        try {
                            this.sync();
                        }
                        catch (Throwable s1) {
                            // empty catch block
                        }
                    }
                }
                if (!this.isFull()) {
                    try {
                        PocketVillagersMod.LOGGER.debug("[IronFarm] {} is not full (requires 3 captured villagers). Captured flags={},{},{}", (Object)this.method_11016(), (Object)this.villager1Captured, (Object)this.villager2Captured, (Object)this.villager3Captured);
                    }
                    catch (Throwable s1) {
                        // empty catch block
                    }
                    return;
                }
                boolean space = false;
                for (int i = 0; i < this.method_5439(); ++i) {
                    class_1799 s = this.method_5438(i);
                    if (s == null || s.method_7960()) {
                        space = true;
                        break;
                    }
                    if (s.method_7909() != class_1802.field_8620 || s.method_7947() >= s.method_7914()) continue;
                    space = true;
                    break;
                }
                if (!space) {
                    try {
                        PocketVillagersMod.LOGGER.debug("[IronFarm] {} has no output space for drops; delaying spawn", (Object)this.method_11016());
                    }
                    catch (Throwable i) {
                        // empty catch block
                    }
                    return;
                }
                ++this.spawnTickCounter;
                try {
                    PocketVillagersMod.LOGGER.debug("[IronFarm] {} spawnTick -> {}", (Object)this.method_11016(), (Object)this.spawnTickCounter);
                }
                catch (Throwable i) {
                    // empty catch block
                }
                try {
                    if (this.spawnTickCounter % 20 == 0) {
                        int remaining = Math.max(0, this.spawnCooldownTicks - this.spawnTickCounter);
                        PocketVillagersMod.LOGGER.debug("[IronFarm] {} remainingTicks={} (cooldown={})", (Object)this.method_11016(), (Object)remaining, (Object)this.spawnCooldownTicks);
                    }
                }
                catch (Throwable remaining) {
                    // empty catch block
                }
                if (this.spawnTickCounter % 10 == 0) {
                    this.method_5431();
                    try {
                        this.sync();
                    }
                    catch (Throwable remaining) {
                        // empty catch block
                    }
                }
                try {
                    if (!(level instanceof class_3218)) break block90;
                    class_3218 serverLevel = (class_3218)level;
                    if (this.spawnTickCounter % 5 != 0) break block90;
                    int remaining = Math.max(0, this.spawnCooldownTicks - this.spawnTickCounter);
                    int cooldown = this.spawnCooldownTicks;
                    boolean sp = this.spawning;
                    int anim = this.spawnAnimationTick;
                    for (class_3222 p2 : serverLevel.method_8503().method_3760().method_14571()) {
                        try {
                            if (p2.method_51469() != serverLevel || !(p2.field_7512 instanceof IronFarmPocketCubeGUIMenu)) continue;
                            IronFarmPocketCubeGUIMenu menu = (IronFarmPocketCubeGUIMenu)p2.field_7512;
                            if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                            int mask2 = 0;
                            try {
                                if (this.hasVillager(1)) {
                                    mask2 |= 1;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                if (this.hasVillager(2)) {
                                    mask2 |= 2;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                if (this.hasVillager(3)) {
                                    mask2 |= 4;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                SyncIronFarmMenuPayload.send(p2, this.method_11016(), remaining, cooldown, sp, anim, mask2);
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable menu) {}
                    }
                }
                catch (Throwable serverLevel) {
                    // empty catch block
                }
            }
            if (this.spawnTickCounter < this.spawnCooldownTicks) {
                return;
            }
            this.hologramTicksRemaining = this.hologramDurationTicks;
            this.spawnTickCounter = 0;
            try {
                int beforeIron = 0;
                int beforePoppy = 0;
                try {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.method_5439(); ++i) {
                        class_1799 s = this.method_5438(i);
                        if (s == null || s.method_7960()) {
                            sb.append(String.format("[%d:EMPTY]", i));
                            continue;
                        }
                        sb.append(String.format("[%d:%s x%d]", i, s.method_7909().toString(), s.method_7947()));
                        if (s.method_7909() == class_1802.field_8620) {
                            beforeIron += s.method_7947();
                        }
                        if (s.method_7909() != class_1802.field_8880) continue;
                        beforePoppy += s.method_7947();
                    }
                    PocketVillagersMod.LOGGER.debug("[IronFarm] {} outputs before insert: {}", (Object)this.method_11016(), (Object)sb.toString());
                }
                catch (Throwable sb) {
                    // empty catch block
                }
                class_5819 rand = level.method_8409();
                List<class_1799> drops = this.sampleGolemDrops(rand);
                try {
                    StringBuilder ds = new StringBuilder();
                    for (class_1799 s : drops) {
                        ds.append(String.format("[%s x%d]", s.method_7909().toString(), s.method_7947()));
                    }
                    PocketVillagersMod.LOGGER.debug("[IronFarm] {} sampled drops to insert: {}", (Object)this.method_11016(), (Object)ds.toString());
                }
                catch (Throwable ds) {
                    // empty catch block
                }
                int insertedStacks = 0;
                for (class_1799 s : drops) {
                    if (this.insertIntoOutputs(s)) {
                        ++insertedStacks;
                        continue;
                    }
                    try {
                        PocketVillagersMod.LOGGER.debug("[IronFarm] {} failed to fully insert drop: {} x{} (remaining={})", (Object)this.method_11016(), (Object)s.method_7909().toString(), (Object)s.method_7947(), (Object)s.method_7947());
                    }
                    catch (Throwable menu) {}
                }
                int afterIron = 0;
                int afterPoppy = 0;
                try {
                    for (int i = 0; i < this.method_5439(); ++i) {
                        class_1799 s = this.method_5438(i);
                        if (s == null || s.method_7960()) continue;
                        if (s.method_7909() == class_1802.field_8620) {
                            afterIron += s.method_7947();
                        }
                        if (s.method_7909() != class_1802.field_8880) continue;
                        afterPoppy += s.method_7947();
                    }
                }
                catch (Throwable i) {
                    // empty catch block
                }
                int addedIron = Math.max(0, afterIron - beforeIron);
                int addedPoppy = Math.max(0, afterPoppy - beforePoppy);
                try {
                    PocketVillagersMod.LOGGER.debug("IronFarm at {} triggered hologram; inserted stacks={} (iron+={} poppy+={})", (Object)this.method_11016(), (Object)insertedStacks, (Object)addedIron, (Object)addedPoppy);
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable beforeIron) {
                // empty catch block
            }
            this.method_5431();
            try {
                this.sync();
            }
            catch (Throwable beforeIron) {
                // empty catch block
            }
            try {
                if (this.field_11863 != null) {
                    this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
                }
            }
            catch (Throwable beforeIron) {
                // empty catch block
            }
            try {
                class_3218 serverLevel;
                class_2818 chunk;
                class_2802 drops;
                class_1937 beforePoppy = this.field_11863;
                if (beforePoppy instanceof class_3218 && (drops = (chunk = (serverLevel = (class_3218)beforePoppy).method_8500(this.method_11016())).method_12200().method_8398()) instanceof class_3215) {
                    class_3215 chunkCache = (class_3215)drops;
                    chunkCache.field_17254.method_17210(chunk.method_12004(), false).forEach(p -> {
                        try {
                            if (p instanceof class_3222) {
                                class_3222 sp = p;
                                try {
                                    StartIronFarmHologramPayload.send(sp, this.method_11016(), this.hologramDurationTicks);
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Throwable serverLevel) {
                // empty catch block
            }
            try {
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    for (class_3222 p3 : serverLevel.method_8503().method_3760().method_14571()) {
                        try {
                            if (p3.method_51469() != serverLevel || !(p3.field_7512 instanceof IronFarmPocketCubeGUIMenu)) continue;
                            IronFarmPocketCubeGUIMenu menu = (IronFarmPocketCubeGUIMenu)p3.field_7512;
                            if (menu.x != this.method_11016().method_10263() || menu.y != this.method_11016().method_10264() || menu.z != this.method_11016().method_10260()) continue;
                            try {
                                Map<Integer, class_1735> slots = menu.getSlots();
                                for (int i = 0; i < this.method_5439(); ++i) {
                                    class_1735 slot = slots.get(i);
                                    if (slot == null) continue;
                                    slot.method_7673(this.method_5438(i) == null ? class_1799.field_8037 : this.method_5438(i).method_7972());
                                }
                                try {
                                    menu.method_7623();
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private List<class_1799> sampleGolemDrops(class_5819 rand) {
        ArrayList<class_1799> out = new ArrayList<class_1799>();
        out.add(new class_1799((class_1935)class_1802.field_8620, 3));
        int pop = rand.method_43048(3);
        if (pop > 0) {
            out.add(new class_1799((class_1935)class_1802.field_8880, pop));
        }
        return out;
    }

    private boolean insertIntoOutputs(class_1799 drop) {
        try {
            class_2371<class_1799> items = this.method_11282();
            for (int i = 0; i < items.size(); ++i) {
                class_1799 s = (class_1799)items.get(i);
                if (s == null || s.method_7960()) {
                    items.set(i, drop.method_7972());
                    this.method_11281(items);
                    return true;
                }
                if (s.method_7909() != drop.method_7909() || s.method_7947() >= s.method_7914()) continue;
                int can = Math.min(s.method_7914() - s.method_7947(), drop.method_7947());
                s.method_7933(can);
                drop.method_7934(can);
                items.set(i, s);
                this.method_11281(items);
                if (!drop.method_7960()) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"iron_farm_pocket_cube");
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        return class_1707.method_19248((int)id, (class_1661)inventory);
    }

    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        IronFarmPocketCubeGUIMenu menu = new IronFarmPocketCubeGUIMenu(containerId, playerInventory, this);
        try {
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                this.syncContents(sp);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return menu;
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.method_11016();
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Iron Farm Pocket Cube");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        try {
            return IntStream.range(0, this.method_5439()).toArray();
        }
        catch (Throwable ignored) {
            return new int[0];
        }
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return false;
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        try {
            return index >= 0 && index < this.method_5439();
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

